/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.JOGLPeerComponent;
import de.jreality.jogl.JOGLPeerGeometry;
import de.jreality.jogl.JOGLPeerNode;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.Lock;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.scene.event.AppearanceEvent;
import de.jreality.scene.event.AppearanceListener;
import de.jreality.scene.event.GeometryEvent;
import de.jreality.scene.event.GeometryListener;
import de.jreality.scene.event.LightEvent;
import de.jreality.scene.event.LightListener;
import de.jreality.scene.event.SceneGraphComponentEvent;
import de.jreality.scene.event.SceneGraphComponentListener;
import de.jreality.scene.event.TransformationEvent;
import de.jreality.scene.event.TransformationListener;
import de.jreality.util.LoggingSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoBetween
extends JOGLPeerNode
implements GeometryListener,
TransformationListener,
AppearanceListener,
SceneGraphComponentListener,
LightListener {
    SceneGraphComponent originalComponent;
    ArrayList<JOGLPeerComponent> peers = new ArrayList();
    JOGLPeerGeometry peerGeometry;
    Lock peersLock = new Lock();
    boolean singlePeer = false;
    protected static WeakHashMap<JOGLRenderer, HashMap> tableForJR = new WeakHashMap();
    static Class<? extends GoBetween> gbClass = GoBetween.class;
    protected static WeakHashMap<JOGLRenderer, HashMap<SceneGraphComponent, GoBetween>> rendererTable = new WeakHashMap();

    public static void setGoBetweenClass(Class<? extends GoBetween> c) {
        gbClass = c;
    }

    public static GoBetween goBetweenFor(JOGLRenderer jr, SceneGraphComponent sgc, boolean singlePeer) {
        GoBetween gb;
        if (sgc == null) {
            return null;
        }
        HashMap<SceneGraphComponent, GoBetween> gbt = rendererTable.get(jr);
        if (gbt == null) {
            gbt = new HashMap();
            rendererTable.put(jr, gbt);
        }
        if ((gb = gbt.get(sgc)) != null) {
            return gb;
        }
        try {
            gb = gbClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        gb.init(sgc, jr, singlePeer);
        gbt.put(sgc, gb);
        return gb;
    }

    protected GoBetween() {
    }

    protected GoBetween(SceneGraphComponent sgc, JOGLRenderer jr, boolean inheritSinglePeer) {
        this.init(sgc, jr, inheritSinglePeer);
    }

    public void init(SceneGraphComponent sgc, JOGLRenderer jr, boolean inheritSinglePeer) {
        this.jr = jr;
        this.originalComponent = sgc;
        if (this.originalComponent.getGeometry() != null) {
            this.peerGeometry = jr.geometryGB.getJOGLPeerGeometryFor(this.originalComponent.getGeometry());
            ++this.peerGeometry.refCount;
            this.originalComponent.getGeometry().addGeometryListener(this);
        } else {
            this.peerGeometry = null;
        }
        this.originalComponent.addSceneGraphComponentListener(this);
        this.singlePeer = inheritSinglePeer;
        if (this.originalComponent.getAppearance() != null) {
            this.originalComponent.getAppearance().addAppearanceListener(this);
        }
        if (this.originalComponent.getTransformation() != null) {
            this.originalComponent.getTransformation().addTransformationListener(this);
        }
        if (this.originalComponent.getLight() != null) {
            this.originalComponent.getLight().addLightListener(this);
        }
    }

    public void dispose() {
        this.originalComponent.removeSceneGraphComponentListener(this);
        if (this.originalComponent.getAppearance() != null) {
            this.originalComponent.getAppearance().removeAppearanceListener(this);
        }
        if (this.peerGeometry != null) {
            this.originalComponent.getGeometry().removeGeometryListener(this);
            this.peerGeometry.dispose();
        }
        if (this.originalComponent.getTransformation() != null) {
            this.originalComponent.getTransformation().removeTransformationListener(this);
        }
        if (this.originalComponent.getLight() != null) {
            this.originalComponent.getLight().removeLightListener(this);
        }
        if (rendererTable.get(this.jr).containsKey(this.originalComponent)) {
            rendererTable.get(this.jr).remove(this.originalComponent);
        }
    }

    public boolean isSinglePeer() {
        return this.singlePeer;
    }

    public JOGLPeerComponent getSinglePeer() {
        return this.peers.size() == 0 ? null : this.peers.get(0);
    }

    public void addJOGLPeer(JOGLPeerComponent jpc) {
        if (this.peers.contains(jpc)) {
            return;
        }
        this.peersLock.writeLock();
        this.peers.add(jpc);
        this.peersLock.writeUnlock();
    }

    public void removeJOGLPeer(JOGLPeerComponent jpc) {
        if (!this.peers.contains(jpc)) {
            return;
        }
        this.peersLock.writeLock();
        this.peers.remove(jpc);
        this.peersLock.writeUnlock();
        if (this.peers.size() == 0) {
            theLog.log(Level.FINE, "GoBetween for " + this.originalComponent.getName() + " has no peers left");
            HashMap<SceneGraphComponent, GoBetween> gbt = rendererTable.get(this.jr);
            gbt.remove(this.originalComponent);
            this.dispose();
        }
    }

    public JOGLPeerGeometry getPeerGeometry() {
        return this.peerGeometry;
    }

    @Override
    public void geometryChanged(GeometryEvent ev) {
        LoggingSystem.getLogger(this).fine("sgc " + this.originalComponent.getName() + " Geometry changed");
        for (JOGLPeerComponent peer : this.peers) {
            peer.setDisplayListDirty();
        }
    }

    @Override
    public void transformationMatrixChanged(TransformationEvent ev) {
        for (JOGLPeerComponent peer : this.peers) {
            peer.transformationMatrixChanged(ev);
        }
    }

    @Override
    public void appearanceChanged(AppearanceEvent ev) {
        String key = ev.getKey();
        LoggingSystem.getLogger(this).fine("sgc " + this.originalComponent.getName() + " Appearance changed " + key);
        int changed = 0;
        boolean propagates = true;
        if (key.indexOf("implodeFactor") != -1) {
            changed |= 4;
        } else if (key.indexOf("transparency") != -1) {
            changed |= 7;
        } else if (key.indexOf("smoothShading") != -1) {
            changed |= 7;
        } else if (key.indexOf("tubeRadius") != -1) {
            changed |= 2;
        } else if (key.indexOf("pointRadius") != -1) {
            changed |= 1;
        } else if (key.indexOf("anyDisplayLists") != -1) {
            changed |= 7;
        } else if (key.endsWith("Shader")) {
            changed |= 0x38;
        } else if (key.endsWith("Shadername")) {
            changed |= 0x38;
        } else if (key.indexOf("texture2d") != -1) {
            changed |= 4;
        }
        if (key.indexOf("pickable") != -1 || key.indexOf("backgroundColor") != -1 || key.indexOf("fog") != -1) {
            propagates = false;
        }
        for (JOGLPeerComponent peer : this.peers) {
            if (propagates) {
                peer.appearanceChanged(ev);
            }
            if (changed == 0) continue;
            peer.propagateGeometryChanged(changed);
        }
    }

    @Override
    public void childAdded(SceneGraphComponentEvent ev) {
        theLog.log(Level.FINE, "GoBetween: Container Child added to: " + this.originalComponent.getName());
        if (ev.getChildType() == 4) {
            if (this.peerGeometry != null) {
                ((Geometry)ev.getOldChildElement()).removeGeometryListener(this);
                this.peerGeometry.dispose();
                this.jr.geometryGB.geometryRemoved = true;
                theLog.log(Level.WARNING, "Adding geometry while old one still valid");
                this.peerGeometry = null;
            }
            if (this.originalComponent.getGeometry() != null) {
                this.peerGeometry = this.jr.geometryGB.getJOGLPeerGeometryFor(this.originalComponent.getGeometry());
                this.originalComponent.getGeometry().addGeometryListener(this);
                ++this.peerGeometry.refCount;
            }
        } else if (ev.getChildType() == 7) {
            if (this.originalComponent.getTransformation() != null) {
                this.originalComponent.getTransformation().addTransformationListener(this);
            }
        } else if (ev.getChildType() == 1 && this.originalComponent.getAppearance() != null) {
            this.originalComponent.getAppearance().addAppearanceListener(this);
        }
        this.peersLock.readLock();
        for (JOGLPeerComponent peer : this.peers) {
            peer.childAdded(ev);
        }
        this.peersLock.readUnlock();
    }

    @Override
    public void childRemoved(SceneGraphComponentEvent ev) {
        theLog.log(Level.FINE, "GoBetween: Container Child removed: " + this.originalComponent.getName());
        if (ev.getChildType() == 4) {
            if (this.peerGeometry != null) {
                ((Geometry)ev.getOldChildElement()).removeGeometryListener(this);
                this.peerGeometry.dispose();
                this.peerGeometry = null;
                this.jr.geometryGB.geometryRemoved = true;
            }
        } else if (ev.getChildType() == 7) {
            if (this.originalComponent.getTransformation() != null) {
                ((Transformation)ev.getOldChildElement()).removeTransformationListener(this);
            }
        } else if (ev.getChildType() == 1 && this.originalComponent.getAppearance() != null) {
            ((Appearance)ev.getOldChildElement()).removeAppearanceListener(this);
        }
        this.peersLock.readLock();
        for (JOGLPeerComponent peer : this.peers) {
            peer.childRemoved(ev);
        }
        this.peersLock.readUnlock();
    }

    @Override
    public void childReplaced(SceneGraphComponentEvent ev) {
        theLog.log(Level.FINE, "GoBetween: Container Child replaced: " + this.originalComponent.getName());
        if (ev.getChildType() == 4) {
            if (this.peerGeometry != null && this.peerGeometry.originalGeometry == this.originalComponent.getGeometry()) {
                return;
            }
            if (this.peerGeometry != null) {
                ((Geometry)ev.getOldChildElement()).removeGeometryListener(this);
                this.peerGeometry.dispose();
                this.jr.geometryGB.geometryRemoved = true;
                this.peerGeometry = null;
            }
            if (this.originalComponent.getGeometry() != null) {
                this.originalComponent.getGeometry().addGeometryListener(this);
                this.peerGeometry = this.jr.geometryGB.getJOGLPeerGeometryFor(this.originalComponent.getGeometry());
                ++this.peerGeometry.refCount;
            }
        } else if (ev.getChildType() == 7) {
            if (this.originalComponent.getTransformation() != null) {
                this.originalComponent.getTransformation().addTransformationListener(this);
            }
        } else if (ev.getChildType() == 1 && this.originalComponent.getAppearance() != null) {
            this.originalComponent.getAppearance().addAppearanceListener(this);
        }
        this.peersLock.readLock();
        for (JOGLPeerComponent peer : this.peers) {
            peer.childReplaced(ev);
        }
        this.peersLock.readUnlock();
    }

    @Override
    public void visibilityChanged(SceneGraphComponentEvent ev) {
        for (JOGLPeerComponent peer : this.peers) {
            peer.visibilityChanged(ev);
        }
    }

    @Override
    public void lightChanged(LightEvent ev) {
        this.jr.lightsChanged = true;
    }
}

