/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.AbstractCalculation;
import de.jreality.jogl.GpgpuUtility;
import de.jreality.jogl.shader.GlslLoader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.glu.GLU;

public class ClothCalculation2
extends AbstractCalculation {
    private static int NUM_ROWS;
    private static int NUM_COLS;
    private FloatBuffer positions;
    private FloatBuffer nulls;
    private int[] texIDsPositions;
    private int[] texIDsVelocities;
    private boolean hasData;
    private boolean dataChanged;
    private int pingPong;
    private int pongPing = 1;
    private double[] gravity = new double[]{0.0, 0.0, -1.0};
    private double damping = 0.01;
    private double factor = 1.0;
    private boolean hasValidVBO;
    private int[] vbo = new int[1];

    public ClothCalculation2(int rows, int columns) {
        NUM_ROWS = rows;
        NUM_COLS = columns;
        this.positions = ByteBuffer.allocateDirect(NUM_COLS * 4 * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.nulls = ByteBuffer.allocateDirect(NUM_COLS * 4 * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.nulls.clear();
        for (int i = 0; i < this.nulls.capacity(); ++i) {
            this.nulls.put(0.0f);
        }
        this.valueBuffer = ByteBuffer.allocateDirect(NUM_COLS * NUM_ROWS * 4 * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.texIDsPositions = new int[2];
        this.texIDsVelocities = new int[2];
    }

    protected String initSource() {
        return "uniform bool point; \nuniform vec3 gravity; \nuniform float damping; \nuniform float factor; \n \nuniform samplerRect prevPoint; \nuniform samplerRect prevVelocity; \n \nvoid main(void) { \n  vec2 pos = gl_TexCoord[0].st; \n  vec2 posUp = pos - vec2(0,1);  vec3 prevPos = textureRect(prevPoint, pos).xyz; \n  vec3 prevVel = textureRect(prevVelocity, pos).xyz; \n  vec3 upperPos = textureRect(prevPoint, posUp).xyz; \n  vec3 upperVel = textureRect(prevVelocity, posUp).xyz; \n \n vec3 up = upperPos + upperVel; vec3 dir = prevPos - up + factor*(damping*prevVel+gravity); \n dir = 0.1*normalize(dir);\n  if (point) {\n \n gl_FragColor =  vec4(up + dir, 1.);\n \n  } else {\n \n gl_FragColor = vec4(up + dir - prevPos, 1.); \n  }\n} \n";
    }

    protected void initViewport(GL gl, GLU glu) {
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluOrtho2D(0.0, (double)NUM_ROWS, 0.0, (double)NUM_COLS);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glViewport(0, 0, NUM_ROWS, NUM_COLS);
    }

    private void initVBO(GL gl) {
        if (this.vbo[0] == 0) {
            gl.glGenBuffersARB(1, this.vbo, 0);
            System.out.println("created VBO=" + this.vbo[0]);
            gl.glBindBufferARB(35051, this.vbo[0]);
            gl.glBufferDataARB(35051, 0x1000000, (Buffer)null, 35042);
            gl.glBindBufferARB(35051, 0);
            this.hasValidVBO = true;
        }
    }

    protected void renderQuad(GL gl) {
        gl.glColor3f(1.0f, 0.0f, 0.0f);
        gl.glPolygonMode(1028, 6914);
        gl.glBegin(7);
        gl.glTexCoord2d(0.0, 0.0);
        gl.glVertex2d(0.0, 0.0);
        gl.glTexCoord2d(this.isTex2D() ? 1.0 : (double)NUM_ROWS, 0.0);
        gl.glVertex2d((double)NUM_ROWS, 0.0);
        gl.glTexCoord2d(this.isTex2D() ? 1.0 : (double)NUM_ROWS, this.isTex2D() ? 1.0 : (double)NUM_COLS);
        gl.glVertex2d((double)NUM_ROWS, (double)NUM_COLS);
        gl.glTexCoord2d(0.0, this.isTex2D() ? 1.0 : (double)NUM_COLS);
        gl.glVertex2d(0.0, (double)NUM_COLS);
        gl.glEnd();
    }

    protected void transferFromTextureToVBO(GL gl) {
        gl.glBindBufferARB(35051, this.vbo[0]);
        gl.glReadBuffer(36064);
        gl.glReadPixels(0, 0, NUM_ROWS, NUM_COLS, TEX_FORMAT, 5126, (Buffer)null);
        gl.glBindBufferARB(35051, 0);
        this.hasValidVBO = true;
    }

    public void display(GLAutoDrawable drawable) {
        GL gl = drawable.getGL();
        GLU glu = new GLU();
        if (this.hasData && this.doIntegrate) {
            this.initPrograms(gl);
            this.initFBO(gl);
            this.initViewport(gl, glu);
            this.initDataTextures(gl);
            gl.glTexParameterf(3553, 10242, 33071.0f);
            gl.glTexParameterf(3553, 10243, 33071.0f);
            this.valueBuffer.clear();
            this.valueBuffer.put(this.positions);
            this.positions.clear();
            this.program.setUniform("gravity", this.gravity);
            this.program.setUniform("damping", this.damping);
            this.program.setUniform("factor", this.factor);
            gl.glEnable(this.TEX_TARGET);
            gl.glFramebufferTexture2DEXT(36160, 36064, this.TEX_TARGET, this.texIDsPositions[this.pingPong], 0);
            gl.glFramebufferTexture2DEXT(36160, 36065, this.TEX_TARGET, this.texIDsVelocities[this.pingPong], 0);
            GpgpuUtility.checkBuf(gl);
            gl.glDrawBuffer(36064);
            gl.glActiveTexture(33984);
            gl.glBindTexture(this.TEX_TARGET, this.texIDsPositions[this.pongPing]);
            this.program.setUniform("prevPoint", 0);
            gl.glActiveTexture(33985);
            gl.glBindTexture(this.TEX_TARGET, this.texIDsVelocities[this.pongPing]);
            this.program.setUniform("prevVelocity", 1);
            this.program.setUniform("point", true);
            GlslLoader.render(this.program, gl);
            this.renderQuad(gl);
            gl.glReadBuffer(36064);
            gl.glReadPixels(0, 0, NUM_ROWS, NUM_COLS, TEX_FORMAT, 5126, (Buffer)this.valueBuffer.slice());
            gl.glDrawBuffer(36065);
            this.program.setUniform("point", false);
            GlslLoader.render(this.program, gl);
            this.renderQuad(gl);
            gl.glDrawBuffer(0);
            int tmp = this.pingPong;
            this.pingPong = this.pongPing;
            this.pongPing = tmp;
            GlslLoader.postRender(this.program, gl);
            gl.glDisable(this.TEX_TARGET);
            gl.glBindFramebufferEXT(36160, 0);
            this.calculationFinished();
        }
    }

    protected void initDataTextures(GL gl) {
        if (this.texIDsPositions[0] == 0) {
            gl.glGenTextures(this.texIDsPositions.length, this.texIDsPositions, 0);
            gl.glGenTextures(this.texIDsVelocities.length, this.texIDsVelocities, 0);
            for (int i = 0; i < this.texIDsPositions.length; ++i) {
                this.setupTexture(gl, this.texIDsPositions[i], NUM_COLS * NUM_ROWS);
                this.setupTexture(gl, this.texIDsVelocities[i], NUM_COLS * NUM_ROWS);
            }
        }
        if (this.dataChanged) {
            this.transferToTexture(gl, this.positions, this.texIDsPositions[0], NUM_COLS, 1);
            this.transferToTexture(gl, this.positions, this.texIDsPositions[1], NUM_COLS, 1);
            this.transferToTexture(gl, this.nulls, this.texIDsVelocities[0], NUM_COLS, 1);
            this.transferToTexture(gl, this.nulls, this.texIDsVelocities[1], NUM_COLS, 1);
            this.dataChanged = false;
        }
    }

    protected void transferToTexture(GL gl, FloatBuffer buffer, int texID, int w, int h) {
        gl.glBindTexture(this.TEX_TARGET, texID);
        gl.glTexSubImage2D(this.TEX_TARGET, 0, 0, 0, w, h, TEX_FORMAT, 5126, (Buffer)buffer);
    }

    public void setPositions(double[] data) {
        this.positions.clear();
        assert (data.length * 4 == this.positions.capacity() * 3);
        for (int i = 0; i < data.length; ++i) {
            this.positions.put((float)data[i]);
            if (i % 3 != 2) continue;
            this.positions.put(1.0f);
        }
        this.positions.clear();
        this.hasData = true;
        this.dataChanged = true;
    }

    public void setPositions(float[] data) {
        this.positions.clear();
        assert (data.length == this.positions.capacity());
        this.positions.put(data);
        this.positions.clear();
        this.hasData = true;
        this.dataChanged = true;
    }

    public void triggerCalculation() {
        if (this.hasData) {
            super.triggerCalculation();
        }
    }

    public double getDamping() {
        return this.damping;
    }

    public void setDamping(double damping) {
        this.damping = damping;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }

    public double[] getGravity() {
        return this.gravity;
    }

    public void setGravity(double[] gravity) {
        this.gravity = gravity;
    }

    protected void calculationFinished() {
        this.measure();
    }

    public static void main(String[] args) {
        ClothCalculation2 cc = new ClothCalculation2(40, 64);
        float[] f = GpgpuUtility.makeGradient(8);
        GpgpuUtility.dumpData(f);
        cc.setPositions(f);
        cc.setDisplayTexture(false);
        cc.triggerCalculation();
        GpgpuUtility.run(cc);
    }
}

