/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.jogl;

import de.jreality.jogl.JOGLConfiguration;
import de.jreality.jogl.JOGLRenderer;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Camera;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.StereoViewer;
import de.jreality.scene.Transformation;
import de.jreality.scene.Viewer;
import de.jreality.util.CameraUtility;
import de.jreality.util.SceneGraphUtility;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import java.util.logging.Level;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;

public abstract class AbstractViewer
implements Viewer,
StereoViewer,
GLEventListener,
Runnable {
    protected SceneGraphComponent sceneRoot;
    SceneGraphComponent auxiliaryRoot;
    SceneGraphPath cameraPath;
    SceneGraphComponent cameraNode;
    protected GLAutoDrawable drawable;
    protected JOGLRenderer renderer;
    protected boolean disposed = false;
    protected boolean pendingUpdate;
    int metric;
    boolean isFlipped = false;
    public static WeakReference<GLContext> firstOne = new WeakReference<Object>(null);
    public static final int CROSS_EYED_STEREO = 0;
    public static final int RED_BLUE_STEREO = 1;
    public static final int RED_GREEN_STEREO = 2;
    public static final int RED_CYAN_STEREO = 3;
    public static final int HARDWARE_BUFFER_STEREO = 4;
    public static final int STEREO_TYPES = 5;
    public static final int LEFT_EYE_STEREO = 5;
    public static final int RIGHT_EYE_STEREO = 6;
    protected int stereoType = 0;
    protected boolean debug = false;
    Vector<RenderListener> listeners;
    public static Matrix[] cubeMapMatrices = new Matrix[6];
    public static Matrix[] textureMapMatrices = new Matrix[6];
    protected final Object renderLock = new Object();
    boolean autoSwapBuffers = true;

    abstract void initializeFrom(SceneGraphComponent var1, SceneGraphPath var2);

    public SceneGraphComponent getSceneRoot() {
        return this.sceneRoot;
    }

    public void setSceneRoot(SceneGraphComponent r) {
        if (r == null) {
            JOGLConfiguration.getLogger().log(Level.WARNING, "Null scene root, not setting.");
            return;
        }
        this.sceneRoot = r;
    }

    public SceneGraphComponent getAuxiliaryRoot() {
        return this.auxiliaryRoot;
    }

    public void setAuxiliaryRoot(SceneGraphComponent auxiliaryRoot) {
        this.auxiliaryRoot = auxiliaryRoot;
        if (this.renderer != null) {
            this.renderer.setAuxiliaryRoot(auxiliaryRoot);
        }
    }

    public SceneGraphPath getCameraPath() {
        return this.cameraPath;
    }

    public void setCameraPath(SceneGraphPath p) {
        this.cameraPath = p;
    }

    public abstract void renderAsync();

    public abstract boolean hasViewingComponent();

    public abstract GLAutoDrawable getDrawable();

    public void initializeFrom(Viewer v) {
        this.initializeFrom(v.getSceneRoot(), v.getCameraPath());
    }

    public void setStereoType(int type) {
        if (this.renderer != null) {
            this.renderer.setStereoType(type);
        }
        this.stereoType = type;
    }

    public int getStereoType() {
        return this.renderer.getStereoType();
    }

    public JOGLRenderer getRenderer() {
        return this.renderer;
    }

    public void addRenderListener(RenderListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (this.listeners.contains(l)) {
            return;
        }
        this.listeners.add(l);
    }

    public void removeRenderListener(RenderListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public void broadcastChange() {
        if (this.listeners == null) {
            return;
        }
        if (!this.listeners.isEmpty()) {
            EventObject e = new EventObject(this);
            for (int i = 0; i < this.listeners.size(); ++i) {
                RenderListener l = this.listeners.get(i);
                l.renderPerformed(e);
            }
        }
    }

    public void addAuxiliaryComponent(SceneGraphComponent aux) {
        if (this.auxiliaryRoot == null) {
            this.setAuxiliaryRoot(SceneGraphUtility.createFullSceneGraphComponent("AuxiliaryRoot"));
        }
        if (!this.auxiliaryRoot.isDirectAncestor(aux)) {
            this.auxiliaryRoot.addChild(aux);
        }
    }

    public void removeAuxiliaryComponent(SceneGraphComponent aux) {
        if (this.auxiliaryRoot == null) {
            return;
        }
        if (!this.auxiliaryRoot.isDirectAncestor(aux)) {
            return;
        }
        this.auxiliaryRoot.removeChild(aux);
    }

    public abstract BufferedImage renderOffscreen(int var1, int var2);

    public abstract void renderOffscreen(int var1, int var2, File var3);

    public BufferedImage[] renderCubeMap(int size) {
        BufferedImage[] cmp = new BufferedImage[6];
        Camera cam = CameraUtility.getCamera(this);
        double oldFOV = cam.getFieldOfView();
        cam.setFieldOfView(90.0);
        SceneGraphComponent camNode = CameraUtility.getCameraNode(this);
        if (camNode.getTransformation() == null) {
            camNode.setTransformation(new Transformation());
        }
        Matrix oldCamMat = new Matrix(camNode.getTransformation().getMatrix());
        for (int i = 0; i < 6; ++i) {
            Matrix newCamMat = new Matrix(oldCamMat);
            newCamMat.multiplyOnRight(cubeMapMatrices[i]);
            newCamMat.assignTo(camNode);
            cmp[i] = this.renderOffscreen(size, size);
        }
        cam.setFieldOfView(oldFOV);
        camNode.getTransformation().setMatrix(oldCamMat.getArray());
        return cmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRendering() {
        Object object = this.renderLock;
        synchronized (object) {
            return this.pendingUpdate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRenderFinish() {
        Object object = this.renderLock;
        synchronized (object) {
            while (this.pendingUpdate) {
                try {
                    this.renderLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public abstract void run();

    public abstract void setAutoSwapMode(boolean var1);

    public abstract void swapBuffers();

    public abstract boolean canRenderAsync();

    public abstract boolean supportsShaders();

    public abstract void render();

    public void dispose() {
        this.disposed = true;
        if (this.cameraPath != null) {
            this.cameraPath.clear();
        }
        this.cameraNode = null;
        this.setSceneRoot(null);
        this.setAuxiliaryRoot(null);
        if (this.listeners != null) {
            this.listeners.clear();
        }
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        this.renderer = null;
    }

    static {
        for (int i = 0; i < 6; ++i) {
            AbstractViewer.cubeMapMatrices[i] = new Matrix();
            AbstractViewer.textureMapMatrices[i] = new Matrix();
        }
        MatrixBuilder.euclidean().rotateY(-1.5707963267948966).assignTo(cubeMapMatrices[0]);
        MatrixBuilder.euclidean().rotateY(1.5707963267948966).assignTo(cubeMapMatrices[1]);
        MatrixBuilder.euclidean().rotateX(1.5707963267948966).assignTo(cubeMapMatrices[2]);
        MatrixBuilder.euclidean().rotateX(-1.5707963267948966).assignTo(cubeMapMatrices[3]);
        MatrixBuilder.euclidean().rotateY(Math.PI).assignTo(cubeMapMatrices[5]);
    }

    static class MultisampleChooser
    extends DefaultGLCapabilitiesChooser {
        MultisampleChooser() {
        }

        public int chooseCapabilities(GLCapabilities desired, GLCapabilities[] available, int windowSystemRecommendedChoice) {
            boolean anyHaveSampleBuffers = false;
            for (int i = 0; i < available.length; ++i) {
                GLCapabilities caps = available[i];
                if (caps == null || !caps.getSampleBuffers()) continue;
                anyHaveSampleBuffers = true;
                break;
            }
            int selection = super.chooseCapabilities(desired, available, windowSystemRecommendedChoice);
            if (!anyHaveSampleBuffers) {
                JOGLConfiguration.getLogger().log(Level.WARNING, "WARNING: antialiasing will be disabled because none of the available pixel formats had it to offer");
            } else if (!available[selection].getSampleBuffers()) {
                JOGLConfiguration.getLogger().log(Level.WARNING, "WARNING: antialiasing will be disabled because the DefaultGLCapabilitiesChooser didn't supply it");
            }
            return selection;
        }
    }

    public static interface RenderListener
    extends EventListener {
        public void renderPerformed(EventObject var1);
    }
}

