/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.io.jrs;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.LinkedList;

class StringArrayConverter
implements Converter {
    Mapper mapper;

    public StringArrayConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public boolean canConvert(Class type) {
        return type == String[].class;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        String[] data = (String[])source;
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            writer.startNode(this.mapper.serializedClass(String.class));
            if (data[i] != null) {
                context.convertAnother((Object)data[i]);
            }
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        LinkedList<String> ll = new LinkedList<String>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String str = (String)context.convertAnother(null, String.class);
            if (str == null) {
                System.out.println("null string read");
            }
            ll.add(str);
            reader.moveUp();
        }
        return ll.toArray(new String[ll.size()]);
    }
}

