/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.io.jrs;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import de.jreality.io.jrs.XStreamFactory;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.ClippingPlane;
import de.jreality.scene.Cylinder;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.Light;
import de.jreality.scene.PointLight;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Sphere;
import de.jreality.scene.SpotLight;
import de.jreality.scene.Transformation;
import de.jreality.scene.tool.Tool;
import de.jreality.util.LoggingSystem;
import java.util.Map;
import java.util.Set;

class NodeWriter
extends SceneGraphVisitor {
    private HierarchicalStreamWriter writer;
    private MarshallingContext context;
    private Mapper mapper;

    NodeWriter() {
    }

    public void setUp(HierarchicalStreamWriter writer, MarshallingContext context, Mapper mapper) {
        this.writer = writer;
        this.context = context;
        this.mapper = mapper;
    }

    public void visit(Appearance a) {
        this.copyAttr(a);
    }

    public void visit(Camera c) {
        this.copyAttr(c);
    }

    public void visit(Cylinder c) {
        this.copyAttr(c);
    }

    public void visit(DirectionalLight l) {
        this.writer.addAttribute("type", this.mapper.serializedClass(DirectionalLight.class));
        this.copyAttr(l);
    }

    public void visit(IndexedFaceSet i) {
        this.writer.addAttribute("type", this.mapper.serializedClass(IndexedFaceSet.class));
        this.copyAttr(i);
    }

    public void visit(IndexedLineSet ils) {
        this.writer.addAttribute("type", this.mapper.serializedClass(IndexedLineSet.class));
        this.copyAttr(ils);
    }

    public void visit(PointSet p) {
        this.writer.addAttribute("type", this.mapper.serializedClass(PointSet.class));
        this.copyAttr(p);
    }

    public void visit(SceneGraphComponent c) {
        this.copyAttr(c);
    }

    public void visit(Sphere s) {
        this.writer.addAttribute("type", this.mapper.serializedClass(Sphere.class));
        this.copyAttr(s);
    }

    public void visit(SpotLight l) {
        this.writer.addAttribute("type", this.mapper.serializedClass(DirectionalLight.class));
        this.copyAttr(l);
    }

    public void visit(ClippingPlane c) {
        this.writer.addAttribute("type", this.mapper.serializedClass(ClippingPlane.class));
        this.copyAttr(c);
    }

    public void visit(PointLight l) {
        this.writer.addAttribute("type", this.mapper.serializedClass(PointLight.class));
        this.copyAttr(l);
    }

    public void visit(Transformation t) {
        this.copyAttr(t);
    }

    public void visit(SceneGraphNode m) {
        throw new IllegalStateException(m.getClass() + " not handled by " + this.getClass().getName());
    }

    public void copyAttr(SceneGraphNode src) {
        this.write("name", src.getName());
    }

    public void copyAttr(SceneGraphComponent src) {
        this.copyAttr((SceneGraphNode)src);
        this.write("visible", src.isVisible());
        this.write("transformation", src.getTransformation());
        this.write("appearance", src.getAppearance());
        this.write("camera", src.getCamera());
        this.write("light", src.getLight());
        this.write("geometry", src.getGeometry());
        this.writer.startNode("children");
        for (int i = 0; i < src.getChildComponentCount(); ++i) {
            this.write("child", src.getChildComponent(i));
        }
        this.writer.endNode();
        this.writer.startNode("tools");
        for (Tool t : src.getTools()) {
            if (XStreamFactory.canWrite(t)) {
                this.writeUnknown(t);
                continue;
            }
            LoggingSystem.getLogger(this).warning("skipping Tool: [" + t.getClass() + "] not supported");
        }
        this.writer.endNode();
    }

    public void copyAttr(Appearance src) {
        this.copyAttr((SceneGraphNode)src);
        Set lst = src.getStoredAttributes();
        for (String aName : lst) {
            Object val = src.getAttribute(aName);
            if (XStreamFactory.canWrite(val)) {
                this.writer.startNode("attribute");
                this.writer.addAttribute("name", aName);
                this.writeUnknown(val);
                this.writer.endNode();
                continue;
            }
            LoggingSystem.getLogger(this).warning("skipping appearance attribute: " + aName + " [" + val.getClass() + "] not supported");
        }
    }

    public void copyAttr(Transformation src) {
        this.copyAttr((SceneGraphNode)src);
        this.write("matrix", src.getMatrix());
    }

    public void copyAttr(Light src) {
        this.copyAttr((SceneGraphNode)src);
        this.write("color", src.getColor());
        this.write("intensity", src.getIntensity());
    }

    public void copyAttr(PointLight src) {
        this.copyAttr((Light)src);
        this.write("falloffA0", src.getFalloffA0());
        this.write("falloffA1", src.getFalloffA1());
        this.write("falloffA2", src.getFalloffA2());
        this.write("useShadowMap", src.isUseShadowMap());
        this.write("shadowMapX", src.getShadowMapX());
        this.write("shadowMapY", src.getShadowMapY());
        this.write("shadowMap", src.getShadowMap());
    }

    public void copyAttr(SpotLight src) {
        this.copyAttr((PointLight)src);
        this.write("coneAngle", src.getConeAngle());
        this.write("coneDeltaAngle", src.getConeDeltaAngle());
        this.write("distribution", src.getDistribution());
    }

    public void copyAttr(Geometry src) {
        this.copyAttr((SceneGraphNode)src);
        this.writer.startNode("attributes");
        for (Map.Entry<String, Object> entry : src.getGeometryAttributes().entrySet()) {
            if (!XStreamFactory.canWrite(entry.getValue())) continue;
            this.writer.startNode("attribute");
            this.writer.addAttribute("name", entry.getKey());
            this.writeUnknown(entry.getValue());
            this.writer.endNode();
        }
        this.writer.endNode();
    }

    public void copyAttr(PointSet src) {
        this.copyAttr((Geometry)src);
        this.write("vertexAttributes", src.getVertexAttributes());
    }

    public void copyAttr(IndexedLineSet src) {
        this.copyAttr((PointSet)src);
        this.write("edgeAttributes", src.getEdgeAttributes());
    }

    public void copyAttr(IndexedFaceSet src) {
        this.copyAttr((IndexedLineSet)src);
        this.write("faceAttributes", src.getFaceAttributes());
    }

    public void copyAttr(Camera src) {
        this.copyAttr((SceneGraphNode)src);
        this.write("eyeSeparation", src.getEyeSeparation());
        this.write("far", src.getFar());
        this.write("fieldOfView", src.getFieldOfView());
        this.write("focus", src.getFocus());
        this.write("near", src.getNear());
        this.write("onAxis", src.isOnAxis());
        this.write("orientationMatrix", src.getOrientationMatrix());
        this.write("perspective", src.isPerspective());
        this.write("stereo", src.isStereo());
    }

    private void write(String name, double d) {
        this.write(name, new Double(d));
    }

    private void write(String name, int i) {
        this.write(name, new Integer(i));
    }

    private void write(String name, boolean b) {
        this.write(name, (Object)b);
    }

    private void write(String name, Object src) {
        this.writer.startNode(name);
        if (src != null) {
            this.context.convertAnother(src);
        }
        this.writer.endNode();
    }

    private void writeUnknown(Object src) {
        XStreamFactory.writeUnknown(src, this.writer, this.context, this.mapper);
    }
}

