/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.io.jrs;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import de.jreality.io.jrs.XStreamFactory;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.ClippingPlane;
import de.jreality.scene.Cylinder;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.Light;
import de.jreality.scene.PointLight;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Sphere;
import de.jreality.scene.SpotLight;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.DataListSet;
import de.jreality.scene.tool.Tool;
import java.awt.Color;
import java.util.NoSuchElementException;

class NodeReader
extends SceneGraphVisitor {
    private HierarchicalStreamReader reader;
    private UnmarshallingContext context;
    private Mapper mapper;

    NodeReader() {
    }

    public void setUp(HierarchicalStreamReader reader, UnmarshallingContext context, Mapper mapper) {
        this.reader = reader;
        this.context = context;
        this.mapper = mapper;
    }

    public void visit(Appearance a) {
        this.copyAttr(a);
    }

    public void visit(Camera c) {
        this.copyAttr(c);
    }

    public void visit(Cylinder c) {
        this.copyAttr(c);
    }

    public void visit(DirectionalLight l) {
        this.copyAttr(l);
    }

    public void visit(IndexedFaceSet i) {
        this.copyAttr(i);
    }

    public void visit(IndexedLineSet ils) {
        this.copyAttr(ils);
    }

    public void visit(PointSet p) {
        this.copyAttr(p);
    }

    public void visit(SceneGraphComponent c) {
        this.copyAttr(c);
    }

    public void visit(Sphere s) {
        this.copyAttr(s);
    }

    public void visit(SpotLight l) {
        this.copyAttr(l);
    }

    public void visit(ClippingPlane c) {
        this.copyAttr(c);
    }

    public void visit(PointLight l) {
        this.copyAttr(l);
    }

    public void visit(Transformation t) {
        this.copyAttr(t);
    }

    public void visit(SceneGraphNode m) {
        throw new IllegalStateException(m.getClass() + " not handled by " + this.getClass().getName());
    }

    public void copyAttr(SceneGraphNode src) {
        String name = (String)this.read(String.class);
        src.setName(name);
    }

    public void copyAttr(SceneGraphComponent src) {
        this.copyAttr((SceneGraphNode)src);
        src.setVisible(this.readBool());
        src.setTransformation((Transformation)this.read(Transformation.class));
        src.setAppearance((Appearance)this.read(Appearance.class));
        src.setCamera((Camera)this.read(Camera.class));
        src.setLight((Light)this.read(Light.class));
        src.setGeometry((Geometry)this.read(Geometry.class));
        this.reader.moveDown();
        while (this.reader.hasMoreChildren()) {
            src.addChild((SceneGraphComponent)this.read(SceneGraphComponent.class));
        }
        this.reader.moveUp();
        this.reader.moveDown();
        while (this.reader.hasMoreChildren()) {
            Tool tool = (Tool)this.readUnknown();
            if (tool == null) continue;
            src.addTool(tool);
        }
        this.reader.moveUp();
    }

    public void copyAttr(Appearance src) {
        this.copyAttr((SceneGraphNode)src);
        while (this.reader.hasMoreChildren()) {
            this.reader.moveDown();
            String aName = this.reader.getAttribute("name");
            Object val = this.readUnknown();
            src.setAttribute(aName, val);
            this.reader.moveUp();
        }
    }

    public void copyAttr(Transformation src) {
        this.copyAttr((SceneGraphNode)src);
        src.setMatrix((double[])this.read(double[].class));
    }

    public void copyAttr(Light src) {
        this.copyAttr((SceneGraphNode)src);
        src.setColor(this.readColor());
        src.setIntensity(this.readDouble());
    }

    public void copyAttr(PointLight src) {
        this.copyAttr((Light)src);
        src.setFalloffA0(this.readDouble());
        src.setFalloffA1(this.readDouble());
        src.setFalloffA2(this.readDouble());
        src.setUseShadowMap(this.readBool());
        src.setShadowMapX(this.readInt());
        src.setShadowMapY(this.readInt());
        src.setShadowMap((String)this.read(String.class));
    }

    public void copyAttr(SpotLight src) {
        this.copyAttr((PointLight)src);
        src.setConeAngle(this.readDouble());
        src.setConeDeltaAngle(this.readDouble());
        src.setDistribution(this.readDouble());
    }

    public void copyAttr(Geometry src) {
        this.copyAttr((SceneGraphNode)src);
        this.reader.moveDown();
        while (this.reader.hasMoreChildren()) {
            this.reader.moveDown();
            String name = this.reader.getAttribute("name");
            Object val = this.readUnknown();
            this.reader.moveUp();
            src.setGeometryAttributes(name, val);
        }
        this.reader.moveUp();
    }

    public void copyAttr(PointSet src) {
        this.copyAttr((Geometry)src);
        src.setVertexCountAndAttributes((DataListSet)this.read(DataListSet.class));
    }

    public void copyAttr(IndexedLineSet src) {
        this.copyAttr((PointSet)src);
        src.setEdgeCountAndAttributes((DataListSet)this.read(DataListSet.class));
    }

    public void copyAttr(IndexedFaceSet src) {
        this.copyAttr((IndexedLineSet)src);
        src.setFaceCountAndAttributes((DataListSet)this.read(DataListSet.class));
    }

    public void copyAttr(Camera src) {
        this.copyAttr((SceneGraphNode)src);
        src.setEyeSeparation(this.readDouble());
        src.setFar(this.readDouble());
        src.setFieldOfView(this.readDouble());
        src.setFocus(this.readDouble());
        src.setNear(this.readDouble());
        src.setOnAxis(this.readBool());
        src.setOrientationMatrix((double[])this.read(double[].class));
        src.setPerspective(this.readBool());
        src.setStereo(this.readBool());
    }

    private double readDouble() {
        return (Double)this.read(Double.class);
    }

    private int readInt() {
        return (Integer)this.read(Integer.class);
    }

    private boolean readBool() {
        return (Boolean)this.read(Boolean.class);
    }

    private Color readColor() {
        return (Color)this.read(Color.class);
    }

    private Object read(Class type) {
        Object ret = null;
        this.reader.moveDown();
        try {
            ret = this.context.convertAnother(null, type);
            this.reader.moveUp();
        }
        catch (ConversionException e) {
            if (e.getCause() instanceof NoSuchElementException) {
                this.reader.moveUp();
                return null;
            }
            throw e;
        }
        return ret;
    }

    private Object readUnknown() {
        return XStreamFactory.readUnknown(this.reader, this.context, this.mapper);
    }
}

