/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.io.jrs;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import de.jreality.io.JrScene;
import de.jreality.io.jrs.XStreamFactory;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.util.LoggingSystem;
import java.util.Map;

class JrSceneConverter
implements Converter {
    Mapper mapper;

    public JrSceneConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public boolean canConvert(Class type) {
        return type == JrScene.class;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        JrScene scene = (JrScene)source;
        writer.startNode("sceneRoot");
        context.convertAnother((Object)scene.getSceneRoot());
        writer.endNode();
        writer.startNode("scenePaths");
        for (Map.Entry<String, SceneGraphPath> entry : scene.getScenePaths().entrySet()) {
            writer.startNode("path");
            writer.addAttribute("name", entry.getKey());
            context.convertAnother((Object)entry.getValue());
            writer.endNode();
        }
        writer.endNode();
        writer.startNode("sceneAttributes");
        for (Map.Entry<String, Object> entry : scene.getSceneAttributes().entrySet()) {
            if (XStreamFactory.canWrite(entry.getValue())) {
                writer.startNode("attribute");
                writer.addAttribute("name", entry.getKey());
                XStreamFactory.writeUnknown(entry.getValue(), writer, context, this.mapper);
                writer.endNode();
                continue;
            }
            LoggingSystem.getLogger(this).warning("cannot write scene attribute=" + entry.getKey() + " [" + entry.getValue().getClass() + "] not supported.");
        }
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        JrScene ret = new JrScene();
        reader.moveDown();
        SceneGraphComponent root = (SceneGraphComponent)context.convertAnother(null, SceneGraphComponent.class);
        reader.moveUp();
        ret.setSceneRoot(root);
        reader.moveDown();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String pathName = reader.getAttribute("name");
            SceneGraphPath path = (SceneGraphPath)context.convertAnother(null, SceneGraphPath.class);
            reader.moveUp();
            ret.addPath(pathName, path);
        }
        reader.moveUp();
        reader.moveDown();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String attrName = reader.getAttribute("name");
            Object obj = XStreamFactory.readUnknown(reader, context, this.mapper);
            ret.addAttribute(attrName, obj);
        }
        reader.moveUp();
        return ret;
    }
}

