/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.io.jrs;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import de.jreality.shader.ImageData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

class ImageDataConverter
implements Converter {
    Mapper mapper;

    public ImageDataConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public boolean canConvert(Class type) {
        return type == ImageData.class;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        ImageData id = (ImageData)source;
        byte[] data = id.getByteArray();
        writer.addAttribute("width", "" + id.getWidth());
        writer.addAttribute("height", "" + id.getHeight());
        context.convertAnother((Object)ImageDataConverter.compress(data));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        int w = -1;
        int h = -1;
        byte[] data = null;
        if (reader.getAttributeCount() > 0) {
            w = Integer.parseInt(reader.getAttribute("width"));
            h = Integer.parseInt(reader.getAttribute("height"));
            data = (byte[])context.convertAnother(null, byte[].class);
            data = ImageDataConverter.uncompress(data);
        } else {
            reader.moveDown();
            data = (byte[])context.convertAnother(null, byte[].class);
            reader.moveUp();
            reader.moveDown();
            w = (Integer)context.convertAnother(null, Integer.TYPE);
            reader.moveUp();
            reader.moveDown();
            h = (Integer)context.convertAnother(null, Integer.TYPE);
            reader.moveUp();
        }
        return new ImageData(data, w, h);
    }

    private static byte[] uncompress(byte[] data) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        byte[] buf = new byte[0x100000];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {}
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    private static byte[] compress(byte[] data) {
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(data);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length / 2);
        byte[] buf = new byte[0x100000];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] compressedData = bos.toByteArray();
        return compressedData;
    }
}

