/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.io.jrs;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.awt.Font;

class FontConverter
implements Converter {
    Mapper mapper;

    public FontConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public boolean canConvert(Class type) {
        return type == Font.class;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Font f = (Font)source;
        writer.addAttribute("size", "" + f.getSize());
        writer.addAttribute("family", "" + f.getFamily());
        writer.addAttribute("name", "" + f.getName());
        writer.addAttribute("bold", "" + f.isBold());
        writer.addAttribute("italic", "" + f.isItalic());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        int size = Integer.parseInt(reader.getAttribute("size"));
        String family = reader.getAttribute("family");
        String name = reader.getAttribute("name");
        boolean bold = Boolean.valueOf(reader.getAttribute("bold"));
        boolean italic = Boolean.valueOf(reader.getAttribute("italic"));
        int style = 0;
        if (bold) {
            style = 1;
        }
        if (italic) {
            style |= 2;
        }
        return new Font(name, style, size);
    }
}

