/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.io.jrs;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.StringTokenizer;

class DoubleArrayConverter
implements Converter {
    Mapper mapper;

    public DoubleArrayConverter(Mapper mapper) {
        this.mapper = mapper;
    }

    public boolean canConvert(Class type) {
        return type == double[].class;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        double[] data = (double[])source;
        StringBuffer sb = new StringBuffer();
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            sb.append(data[i]).append(' ');
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        writer.setValue(sb.toString());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        StringTokenizer st = new StringTokenizer(reader.getValue());
        double[] data = new double[st.countTokens()];
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            data[i] = Double.parseDouble(st.nextToken());
        }
        return data;
    }
}

