/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.io.jrs;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import de.jreality.io.jrs.AbstractConverter;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.data.StringArray;
import de.jreality.scene.data.StringArrayArray;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class DataListConverter
extends AbstractConverter {
    Pattern arrayPattern = Pattern.compile("[^\\[\\]]*\\[\\]");
    Pattern arrayArrayPattern = Pattern.compile("[^\\[\\]]*\\[\\]\\[\\]");
    Pattern arrayArrayInlinedPattern = Pattern.compile("[^\\[\\]]*\\[\\]\\[([0-9])+\\]");

    public DataListConverter(Mapper mapper, double version) {
        super(mapper, version);
    }

    public boolean canConvert(Class type) {
        return DataList.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        DataList dl = (DataList)source;
        String sm = dl.getStorageModel().toString();
        writer.addAttribute("data", sm);
        Object dst = null;
        if (sm.startsWith("double")) {
            if (this.isArray(sm) || this.isInlined(sm)) {
                double[] data;
                dst = data = dl.toDoubleArray(null);
            } else if (this.isArrayArray(sm)) {
                double[][] data = dl.toDoubleArrayArray(null);
                dst = data;
            }
        } else if (sm.startsWith("int")) {
            if (this.isArray(sm) || this.isInlined(sm)) {
                int[] data = dl.toIntArray(null);
                dst = data;
            } else if (this.isArrayArray(sm)) {
                int[][] data = dl.toIntArrayArray(null);
                dst = data;
            }
        } else if (sm.startsWith("String")) {
            if (this.isArray(sm) || this.isInlined(sm)) {
                String[] data = dl.toStringArray(null);
                dst = data;
            } else if (this.isArrayArray(sm)) {
                String[][] data = dl.toStringArrayArray(null);
                dst = data;
            }
        } else {
            throw new UnsupportedOperationException("cannot write: " + sm);
        }
        if (this.version < 0.2) {
            writer.startNode(this.mapper.serializedClass(DataList.class));
        }
        context.convertAnother(dst);
        if (this.version < 0.2) {
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String sm = reader.getAttribute("data");
        DataList ret = null;
        if (this.version < 0.2) {
            reader.moveDown();
        }
        if (sm.startsWith("double")) {
            if (this.isArray(sm)) {
                double[] data = (double[])context.convertAnother(null, double[].class);
                ret = new DoubleArray(data);
            } else if (this.isInlined(sm)) {
                double[] data = (double[])context.convertAnother(null, double[].class);
                ret = new DoubleArrayArray.Inlined(data, this.slotLength(sm));
            } else if (this.isArrayArray(sm)) {
                double[][] data = (double[][])context.convertAnother(null, double[][].class);
                ret = new DoubleArrayArray.Array(data);
            }
        } else if (sm.startsWith("int")) {
            if (this.isArray(sm)) {
                int[] data = (int[])context.convertAnother(null, int[].class);
                ret = new IntArray(data);
            } else if (this.isInlined(sm)) {
                int[] data = (int[])context.convertAnother(null, int[].class);
                ret = new IntArrayArray.Inlined(data, this.slotLength(sm));
            } else if (this.isArrayArray(sm)) {
                int[][] data = (int[][])context.convertAnother(null, int[][].class);
                ret = new IntArrayArray.Array(data);
            }
        } else if (sm.startsWith("String")) {
            if (this.isArray(sm)) {
                String[] data = (String[])context.convertAnother(null, String[].class);
                ret = new StringArray(data);
            } else if (this.isInlined(sm)) {
                String[] data = (String[])context.convertAnother(null, String[].class);
                ret = new StringArrayArray.Inlined(data, this.slotLength(sm));
            } else if (this.isArrayArray(sm)) {
                String[][] data = (String[][])context.convertAnother(null, String[][].class);
                ret = new StringArrayArray.Array(data);
            }
        } else {
            throw new UnsupportedOperationException("cannot read: " + sm);
        }
        if (this.version < 0.2) {
            reader.moveUp();
        }
        return ret;
    }

    private int slotLength(String sm) {
        Matcher m = this.arrayArrayInlinedPattern.matcher(sm);
        if (!m.find()) {
            throw new IllegalArgumentException("no length!");
        }
        return Integer.parseInt(m.group(1));
    }

    private boolean isArrayArray(String sm) {
        return this.arrayArrayPattern.matcher(sm).matches();
    }

    private boolean isInlined(String sm) {
        return this.arrayArrayInlinedPattern.matcher(sm).matches();
    }

    private boolean isArray(String sm) {
        return this.arrayPattern.matcher(sm).matches();
    }
}

