/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.io;

import de.jreality.io.JrScene;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Camera;
import de.jreality.scene.DirectionalLight;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Transformation;
import de.jreality.scene.tool.Tool;
import de.jreality.shader.ShaderUtility;
import de.jreality.tools.ClickWheelCameraZoomTool;
import de.jreality.tools.DraggingTool;
import de.jreality.tools.EncompassTool;
import de.jreality.tools.PickShowTool;
import de.jreality.tools.PointerDisplayTool;
import de.jreality.tools.RotateTool;
import java.awt.Color;

public class JrSceneFactory {
    public static JrScene getDefaultPortalScene() {
        return JrSceneFactory.getDefaultPortalScene(false);
    }

    public static JrScene getDefaultPortalRemoteScene() {
        return JrSceneFactory.getDefaultPortalScene(true);
    }

    private static JrScene getDefaultPortalScene(boolean remote) {
        SceneGraphComponent sceneRoot = new SceneGraphComponent("root");
        Appearance rootAppearance = new Appearance();
        sceneRoot.addTool(new PickShowTool());
        sceneRoot.setAppearance(rootAppearance);
        DirectionalLight light = new DirectionalLight();
        light.setIntensity(0.4);
        SceneGraphComponent lightNode1 = new SceneGraphComponent("light 1");
        lightNode1.setLight(light);
        MatrixBuilder.euclidean().rotateFromTo(new double[]{0.0, 0.0, 1.0}, new double[]{-1.0, 1.0, -1.0}).assignTo(lightNode1);
        sceneRoot.addChild(lightNode1);
        SceneGraphComponent lightNode2 = new SceneGraphComponent("light 2");
        lightNode2.setLight(light);
        MatrixBuilder.euclidean().rotateFromTo(new double[]{0.0, 0.0, 1.0}, new double[]{1.0, 1.0, -1.0}).assignTo(lightNode2);
        sceneRoot.addChild(lightNode2);
        SceneGraphComponent lightNode3 = new SceneGraphComponent("light 3");
        lightNode3.setLight(light);
        MatrixBuilder.euclidean().rotateFromTo(new double[]{0.0, 0.0, 1.0}, new double[]{1.0, 1.0, 1.0}).assignTo(lightNode3);
        sceneRoot.addChild(lightNode3);
        SceneGraphComponent lightNode4 = new SceneGraphComponent("light 4");
        lightNode4.setLight(light);
        MatrixBuilder.euclidean().rotateFromTo(new double[]{0.0, 0.0, 1.0}, new double[]{-1.0, 1.0, 1.0}).assignTo(lightNode3);
        sceneRoot.addChild(lightNode4);
        SceneGraphComponent sceneNode = new SceneGraphComponent("scene");
        sceneRoot.addChild(sceneNode);
        RotateTool rotateTool = new RotateTool();
        rotateTool.setFixOrigin(false);
        rotateTool.setMoveChildren(false);
        rotateTool.setUpdateCenter(false);
        rotateTool.setAnimTimeMin(250.0);
        rotateTool.setAnimTimeMax(750.0);
        sceneNode.addTool(rotateTool);
        DraggingTool draggingTool = new DraggingTool();
        draggingTool.setMoveChildren(false);
        sceneNode.addTool(draggingTool);
        SceneGraphComponent avatarNode = new SceneGraphComponent("avatar");
        avatarNode.addTool(new PointerDisplayTool());
        sceneRoot.addChild(avatarNode);
        SceneGraphComponent camNode = new SceneGraphComponent("camNode");
        MatrixBuilder.euclidean().translate(0.0, 1.7, 0.0).assignTo(camNode);
        Camera cam = new Camera();
        cam.setNear(0.01);
        cam.setFar(1500.0);
        cam.setOnAxis(false);
        cam.setStereo(true);
        camNode.setCamera(cam);
        String headMoveTool = remote ? "de.jreality.tools.RemotePortalHeadMoveTool" : "de.jreality.tools.PortalHeadMoveTool";
        try {
            Tool t = (Tool)Class.forName(headMoveTool).newInstance();
            camNode.addTool(t);
        }
        catch (Throwable t) {
            System.err.println("crating headMoveTool failed");
        }
        avatarNode.addChild(camNode);
        SceneGraphPath cameraPath = new SceneGraphPath();
        cameraPath.push(sceneRoot);
        SceneGraphPath emptyPickPath = cameraPath.pushNew(sceneNode);
        cameraPath.push(avatarNode);
        cameraPath.push(camNode);
        SceneGraphPath avatarPath = cameraPath.popNew();
        cameraPath.push(cam);
        JrScene scene = new JrScene(sceneRoot);
        scene.addPath("avatarPath", avatarPath);
        scene.addPath("cameraPath", cameraPath);
        scene.addPath("emptyPickPath", emptyPickPath);
        return scene;
    }

    public static JrScene getDefaultDesktopScene() {
        JrScene scene = JrSceneFactory.getDefaultDesktopSceneWithoutTools();
        SceneGraphComponent sceneNode = scene.getPath("emptyPickPath").getLastComponent();
        EncompassTool encompassTool = new EncompassTool();
        sceneNode.addTool(encompassTool);
        RotateTool rotateTool = new RotateTool();
        rotateTool.setFixOrigin(false);
        rotateTool.setMoveChildren(false);
        rotateTool.setUpdateCenter(false);
        rotateTool.setAnimTimeMin(250.0);
        rotateTool.setAnimTimeMax(750.0);
        sceneNode.addTool(rotateTool);
        DraggingTool draggingTool = new DraggingTool();
        draggingTool.setMoveChildren(false);
        sceneNode.addTool(draggingTool);
        scene.getSceneRoot().addTool(new ClickWheelCameraZoomTool());
        return scene;
    }

    public static JrScene getDefaultDesktopSceneWithoutTools() {
        SceneGraphComponent sceneRoot = new SceneGraphComponent("root");
        sceneRoot.setVisible(true);
        Appearance app = new Appearance("root appearance");
        ShaderUtility.createRootAppearance(app);
        sceneRoot.setAppearance(app);
        SceneGraphComponent scene = new SceneGraphComponent("scene");
        scene.setTransformation(new Transformation("scene trafo"));
        sceneRoot.addChild(scene);
        SceneGraphComponent lightNode = new SceneGraphComponent("lightNode");
        lightNode.setVisible(true);
        double[] trafoMatrix = new double[]{0.8535533905932737, 0.14644660940672619, -0.4999999999999999, 0.0, 0.14644660940672619, 0.8535533905932737, 0.4999999999999999, 0.0, 0.4999999999999999, -0.4999999999999999, 0.7071067811865476, 0.0, 0.0, 0.0, 0.0, 1.0};
        Transformation trafo = new Transformation(trafoMatrix);
        trafo.setName("lightNode trafo");
        lightNode.setTransformation(trafo);
        DirectionalLight light = new DirectionalLight("light");
        light.setColor(new Color(255, 255, 255, 255));
        light.setIntensity(0.75);
        lightNode.setLight(light);
        sceneRoot.addChild(lightNode);
        SceneGraphComponent avatar = new SceneGraphComponent("avatar");
        avatar.setVisible(true);
        trafoMatrix = Rn.identityMatrix(4);
        trafoMatrix[11] = 16.0;
        trafo = new Transformation(trafoMatrix);
        trafo.setName("avatar trafo");
        avatar.setTransformation(trafo);
        sceneRoot.addChild(avatar);
        SceneGraphComponent cameraNode = new SceneGraphComponent("cameraNode");
        cameraNode.setVisible(true);
        trafoMatrix = Rn.identityMatrix(4);
        trafo = new Transformation(trafoMatrix);
        trafo.setName("camera trafo");
        cameraNode.setTransformation(trafo);
        Camera camera = new Camera("camera");
        camera.setFar(50.0);
        camera.setFieldOfView(30.0);
        camera.setFocus(3.0);
        camera.setNear(3.0);
        camera.setOnAxis(true);
        camera.setStereo(false);
        cameraNode.setCamera(camera);
        light = new DirectionalLight("camera light");
        light.setColor(new Color(255, 255, 255, 255));
        light.setIntensity(0.75);
        cameraNode.setLight(light);
        avatar.addChild(cameraNode);
        JrScene defaultScene = new JrScene(sceneRoot);
        SceneGraphPath cameraPath = new SceneGraphPath();
        cameraPath.push(sceneRoot);
        cameraPath.push(avatar);
        cameraPath.push(cameraNode);
        cameraPath.push(camera);
        defaultScene.addPath("cameraPath", cameraPath);
        SceneGraphPath avatarPath = new SceneGraphPath();
        avatarPath.push(sceneRoot);
        avatarPath.push(avatar);
        defaultScene.addPath("avatarPath", avatarPath);
        SceneGraphPath emptyPickPath = new SceneGraphPath();
        emptyPickPath.push(sceneRoot);
        emptyPickPath.push(scene);
        defaultScene.addPath("emptyPickPath", emptyPickPath);
        return defaultScene;
    }
}

