/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.BallAndStickFactory;
import de.jreality.geometry.FrameFieldType;
import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.geometry.IndexedLineSetUtility;
import de.jreality.geometry.TubeUtility;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.P3;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.util.LoggingSystem;
import java.awt.Color;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TubeFactory {
    static int debug = 0;
    static Logger theLogger = LoggingSystem.getLogger(TubeFactory.class);
    public double[][] theCurve;
    public double[][] userTangents = null;
    public double[][] userBinormals = null;
    public double[][] vertexColors;
    public double[][] edgeColors;
    public double[][] crossSection = TubeUtility.octagonalCrossSection;
    public double[] radii = null;
    public double radius = 0.05;
    public FrameFieldType frameFieldType = FrameFieldType.PARALLEL;
    public int metric = 0;
    public int twists = 0;
    public boolean generateTextureCoordinates = false;
    boolean arcLengthTextureCoordinates = false;
    boolean generateEdges = false;
    boolean matchClosedTwist = false;
    public boolean extendAtEnds = false;
    boolean removeDuplicates = false;
    boolean duplicatesRemoved = false;
    public boolean framesDirty = true;
    protected TubeUtility.FrameInfo[] frames = null;
    protected TubeUtility.FrameInfo[] userFrames = null;
    protected double[] radiiField = null;
    public boolean closedCurve = false;
    public boolean vertexColorsEnabled = false;
    static double[] px1 = new double[]{0.0, 0.0, -0.5, 1.0};
    static double[] px2 = new double[]{0.0, 0.0, 0.5, 1.0};
    private double[][] tangentField;
    private double[][] frenetNormalField;
    private double[][] parallelNormalField;
    private double[][] binormalField;
    private TubeUtility.FrameInfo[] frameInfo;
    static double[] B = new double[]{Math.random(), Math.random(), Math.random(), 1.0};
    static double[][] axes = new double[][]{{0.0, 0.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    static int[][] axesIndices = new int[][]{{0, 1}, {0, 2}, {0, 3}};
    static Color[] axesColors = new Color[]{Color.red, Color.green, Color.blue};

    public TubeFactory() {
        this(null);
    }

    public TubeFactory(double[][] curve) {
        this.theCurve = curve;
    }

    public void updateFrames() {
    }

    public TubeUtility.FrameInfo[] getFrameField() {
        return this.frames;
    }

    public void setClosed(boolean closedCurve) {
        this.closedCurve = closedCurve;
        this.framesDirty = true;
    }

    public void setCrossSection(double[][] crossSection) {
        this.crossSection = crossSection;
    }

    public double[][] getTangents() {
        return this.userTangents;
    }

    public void setTangents(double[][] tangents) {
        this.userTangents = tangents;
    }

    public double[][] getUserBinormals() {
        return this.userBinormals;
    }

    public void setUserBinormals(double[][] userBinormals) {
        this.userBinormals = userBinormals;
    }

    public void setFrameField(TubeUtility.FrameInfo[] frames) {
        this.userFrames = frames;
    }

    public void setFrameFieldType(FrameFieldType frameFieldType) {
        this.frameFieldType = frameFieldType;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void setRadii(double[] radii) {
        this.radii = radii;
    }

    public void setMetric(int metric) {
        this.metric = metric;
        this.framesDirty = true;
    }

    public void setTwists(int twists) {
        this.twists = twists;
    }

    public void setVertexColorsEnabled(boolean vertexColorsEnabled) {
        this.vertexColorsEnabled = vertexColorsEnabled;
    }

    public void setEdgeColors(double[][] edgeColors) {
        this.edgeColors = edgeColors;
    }

    public void setVertexColors(double[][] vertexColors) {
        this.vertexColors = vertexColors;
    }

    public boolean isGenerateTextureCoordinates() {
        return this.generateTextureCoordinates;
    }

    public void setGenerateTextureCoordinates(boolean generateTextureCoordinates) {
        this.generateTextureCoordinates = generateTextureCoordinates;
    }

    public boolean isArcLengthTextureCoordinates() {
        return this.arcLengthTextureCoordinates;
    }

    public void setArcLengthTextureCoordinates(boolean arcLengthTextureCoordinates) {
        this.arcLengthTextureCoordinates = arcLengthTextureCoordinates;
    }

    public boolean isExtendAtEnds() {
        return this.extendAtEnds;
    }

    public void setExtendAtEnds(boolean extendAtEnds) {
        this.extendAtEnds = extendAtEnds;
        this.framesDirty = true;
    }

    public boolean isRemoveDuplicates() {
        return this.removeDuplicates;
    }

    public void setRemoveDuplicates(boolean removeDuplicates) {
        this.removeDuplicates = removeDuplicates;
    }

    public boolean isGenerateEdges() {
        return this.generateEdges;
    }

    public void setGenerateEdges(boolean generateEdges) {
        this.generateEdges = generateEdges;
    }

    public boolean isMatchClosedTwist() {
        return this.matchClosedTwist;
    }

    public void setMatchClosedTwist(boolean matchClosedTwist) {
        this.matchClosedTwist = matchClosedTwist;
    }

    public SceneGraphComponent getFramesSceneGraphRepresentation() {
        return TubeFactory.getSceneGraphRepresentation(this.frames);
    }

    public void update() {
        if (this.removeDuplicates && !this.duplicatesRemoved) {
            this.theCurve = TubeFactory.removeDuplicates(this.theCurve);
            this.duplicatesRemoved = true;
        }
    }

    protected static double[][] removeDuplicates(double[][] cc) {
        int n = cc.length;
        Vector<double[]> v = new Vector<double[]>();
        double[] currentPoint = cc[0];
        v.add(currentPoint);
        int i = 1;
        while (true) {
            double[] nextPoint;
            double d;
            if ((d = Rn.euclideanDistance(currentPoint, nextPoint = cc[i])) < 1.0E-15 && ++i < n) {
                continue;
            }
            if (i == n) break;
            currentPoint = nextPoint;
            v.add(currentPoint);
            if (i >= n) break;
        }
        double[][] newcurve = new double[v.size()][];
        v.toArray((T[])newcurve);
        return newcurve;
    }

    public TubeUtility.FrameInfo[] makeFrameField(double[][] polygon, FrameFieldType type, int metric) {
        int i;
        double[][] polygonh;
        if (this.frames != null && !this.framesDirty) {
            return this.frames;
        }
        int numberJoints = polygon.length;
        if (polygon[0].length == 3) {
            polygonh = Pn.homogenize((double[][])null, polygon);
            Pn.normalize(polygonh, polygonh, metric);
        } else if (polygon[0].length == 4) {
            polygonh = Pn.normalize((double[][])null, polygon, metric);
        } else {
            throw new IllegalArgumentException("Points must have dimension 4");
        }
        if ((debug & 1) != 0) {
            theLogger.log(Level.FINER, "Generating frame field for metric " + metric);
        }
        if (this.tangentField == null || this.tangentField.length != numberJoints - 2) {
            this.tangentField = new double[numberJoints - 2][4];
            this.frenetNormalField = new double[numberJoints - 2][4];
            this.parallelNormalField = new double[numberJoints - 2][4];
            this.binormalField = new double[numberJoints - 2][4];
        }
        this.frameInfo = new TubeUtility.FrameInfo[numberJoints - 2];
        double[] d = new double[numberJoints - 2];
        if ((debug & 0x20) != 0) {
            for (int i2 = 0; i2 < numberJoints; ++i2) {
                theLogger.log(Level.FINER, "Vertex " + i2 + " : " + Rn.toString(polygonh[i2]));
            }
        }
        double[] frame = new double[16];
        double totalLength = 0.0;
        for (i = 1; i < numberJoints - 1; ++i) {
            d[i - 1] = totalLength += Pn.distanceBetween(polygonh[i - 1], polygonh[i], metric);
        }
        totalLength = 1.0 / totalLength;
        for (i = 1; i < numberJoints - 1; ++i) {
            int n = i - 1;
            d[n] = d[n] * totalLength;
        }
        for (i = 1; i < numberJoints - 1; ++i) {
            double[] osculatingPlane;
            double size;
            double theta = 0.0;
            double phi = 0.0;
            boolean collinear = false;
            double[] polarPlane = Pn.polarizePoint(null, polygonh[i], metric);
            if ((debug & 2) != 0) {
                theLogger.log(Level.FINER, "Polar plane is: " + Rn.toString(polarPlane));
            }
            if ((size = Rn.euclideanNormSquared(osculatingPlane = P3.planeFromPoints(null, polygonh[i - 1], polygonh[i], polygonh[i + 1]))) < 1.0E-15) {
                collinear = true;
                if ((debug & 2) != 0) {
                    theLogger.log(Level.FINER, "degenerate binormal");
                }
                if (i == 1) {
                    this.binormalField[i - 1] = TubeFactory.getInitialBinormal(polygonh, metric);
                } else {
                    Pn.projectToTangentSpace(this.binormalField[i - 1], polygonh[i], this.binormalField[i - 2], metric);
                }
            } else {
                Pn.polarizePlane(this.binormalField[i - 1], osculatingPlane, metric);
            }
            if (this.userBinormals != null) {
                System.arraycopy(this.userBinormals[i - 1], 0, this.binormalField[i - 1], 0, this.userBinormals[i - 1].length);
            }
            Pn.setToLength(this.binormalField[i - 1], this.binormalField[i - 1], 1.0, metric);
            if ((debug & 2) != 0) {
                theLogger.log(Level.FINER, "Binormal is " + Rn.toString(this.binormalField[i - 1]));
            }
            double[] midPlane = null;
            double[] plane1 = null;
            double[] plane2 = null;
            if (!collinear) {
                plane1 = P3.planeFromPoints(null, this.binormalField[i - 1], polygonh[i], polygonh[i - 1]);
                plane2 = P3.planeFromPoints(null, this.binormalField[i - 1], polygonh[i], polygonh[i + 1]);
                midPlane = Pn.midPlane(null, plane1, plane2, metric);
                size = Rn.euclideanNormSquared(midPlane);
                if ((debug & 2) != 0) {
                    theLogger.log(Level.FINER, "tangent norm squared is " + size);
                }
                theta = Pn.angleBetween(plane1, plane2, metric);
            }
            if (collinear || size < 1.0E-15) {
                if ((debug & 2) != 0) {
                    theLogger.log(Level.FINER, "degenerate Tangent vector");
                }
                double[] pseudoT = P3.lineIntersectPlane(null, polygonh[i - 1], polygonh[i + 1], polarPlane);
                if ((debug & 2) != 0) {
                    theLogger.log(Level.FINE, "pseudo-Tangent vector is " + Rn.toString(pseudoT));
                }
                if (metric != 0) {
                    midPlane = Pn.polarizePoint(null, pseudoT, metric);
                } else {
                    midPlane = pseudoT;
                    midPlane[3] = -Rn.innerProduct(midPlane, polygonh[i], 3);
                }
                theta = Math.PI;
            }
            if ((debug & 2) != 0) {
                theLogger.log(Level.FINE, "Midplane is " + Rn.toString(midPlane));
            }
            Pn.polarizePlane(this.tangentField[i - 1], midPlane, metric);
            if (this.userTangents != null) {
                System.arraycopy(this.userTangents[i - 1], 0, this.tangentField[i - 1], 0, this.userTangents[i - 1].length);
                midPlane = Rn.planeParallelToPassingThrough(null, this.userTangents[i - 1], polygonh[i]);
                theta = i > 1 ? Pn.angleBetween(this.userTangents[i - 2], this.userTangents[i - 1], metric) : 0.0;
            }
            double[] diff = Rn.subtract(null, polygonh[i], polygonh[i - 1]);
            if (Rn.innerProduct(diff, this.tangentField[i - 1]) < 0.0) {
                Rn.times(this.tangentField[i - 1], -1.0, this.tangentField[i - 1]);
            }
            Pn.setToLength(this.tangentField[i - 1], this.tangentField[i - 1], 1.0, metric);
            Pn.polarizePlane(this.frenetNormalField[i - 1], P3.planeFromPoints(null, this.binormalField[i - 1], this.tangentField[i - 1], polygonh[i]), metric);
            Pn.setToLength(this.frenetNormalField[i - 1], this.frenetNormalField[i - 1], 1.0, metric);
            if ((debug & 2) != 0) {
                theLogger.log(Level.FINE, "frenet normal is " + Rn.toString(this.frenetNormalField[i - 1]));
            }
            if (type == FrameFieldType.PARALLEL) {
                if (i == 1) {
                    System.arraycopy(this.frenetNormalField[0], 0, this.parallelNormalField[0], 0, 4);
                } else {
                    double[] nPlane = P3.planeFromPoints(null, polygonh[i], polygonh[i - 1], this.parallelNormalField[i - 2]);
                    double[] projectedN = P3.pointFromPlanes(null, nPlane, midPlane, polarPlane);
                    if (Rn.euclideanNormSquared(projectedN) < 1.0E-15) {
                        theLogger.log(Level.FINE, "degenerate normal");
                        projectedN = this.parallelNormalField[i - 2];
                    }
                    this.parallelNormalField[i - 1] = Pn.normalizePlane(null, projectedN, metric);
                    if ((debug & 0x80) != 0) {
                        theLogger.log(Level.FINE, "Parallel normal is " + Rn.toString(this.parallelNormalField[i - 1]));
                    }
                }
                if (this.parallelNormalField[i - 1] == null) {
                    this.parallelNormalField[i - 1] = this.parallelNormalField[i - 2];
                } else {
                    Pn.setToLength(this.parallelNormalField[i - 1], this.parallelNormalField[i - 1], 1.0, metric);
                }
                phi = Pn.angleBetween(this.frenetNormalField[i - 1], this.parallelNormalField[i - 1], metric);
                double a = Pn.angleBetween(this.parallelNormalField[i - 1], this.binormalField[i - 1], metric);
                if (a > 1.5707963267948966) {
                    phi = -phi;
                }
            } else {
                phi = 0.0;
            }
            System.arraycopy(this.frenetNormalField[i - 1], 0, frame, 0, 4);
            System.arraycopy(this.binormalField[i - 1], 0, frame, 4, 4);
            System.arraycopy(this.tangentField[i - 1], 0, frame, 8, 4);
            System.arraycopy(polygonh[i], 0, frame, 12, 4);
            if ((debug & 4) != 0) {
                theLogger.log(Level.FINE, "determinant is:\n" + Rn.determinant(frame));
            }
            this.frameInfo[i - 1] = new TubeUtility.FrameInfo(Rn.transpose(null, frame), d[i - 1], theta, phi);
            if ((debug & 0x10) == 0) continue;
            theLogger.log(Level.FINE, "Frame " + (i - 1) + ": " + this.frameInfo[i - 1].toString());
        }
        this.framesDirty = false;
        return this.frameInfo;
    }

    protected static double[] getInitialBinormal(double[][] polygon, int metric) {
        int n = polygon.length;
        for (int i = 1; i < n - 1; ++i) {
            double[] bloop = Pn.polarize(null, P3.planeFromPoints(null, polygon[i - 1], polygon[i], polygon[i + 1]), metric);
            if (!(Rn.euclideanNormSquared(bloop) > 1.0E-15)) continue;
            Pn.dehomogenize(bloop, bloop);
            boolean flip = false;
            if (bloop[0] < 0.0) {
                flip = true;
            } else if (bloop[0] == 0.0 && bloop[1] < 0.0) {
                flip = true;
            } else if (bloop[1] == 0.0 && bloop[2] < 0.0) {
                flip = true;
            }
            if (flip) {
                for (int j = 0; j < 3; ++j) {
                    bloop[j] = -bloop[j];
                }
            }
            return bloop;
        }
        return Pn.polarizePlane(null, P3.planeFromPoints(null, B, polygon[1], polygon[2]), metric);
    }

    public static SceneGraphComponent getSceneGraphRepresentation(TubeUtility.FrameInfo[] frames) {
        SceneGraphComponent result = new SceneGraphComponent();
        SceneGraphComponent geometry = TubeFactory.getXYZAxes();
        MatrixBuilder.euclidean().scale(0.2).assignTo(geometry);
        double[][] verts = new double[frames.length][];
        int i = 0;
        for (TubeUtility.FrameInfo f : frames) {
            SceneGraphComponent foo = new SceneGraphComponent();
            Transformation t = new Transformation(f.frame);
            foo.setTransformation(t);
            foo.addChild(geometry);
            result.addChild(foo);
            verts[i++] = new Matrix(f.frame).getColumn(3);
        }
        SceneGraphComponent sgc = new SceneGraphComponent();
        Appearance ap = new Appearance();
        ap.setAttribute("lineShader.tubeRadius", 0.005);
        ap.setAttribute("lineShader.tubeDraw", false);
        ap.setAttribute("lineShader.diffuseColor", new Color(100, 200, 200));
        ap.setAttribute("lineShader.polygonShader.diffuseColor", new Color(100, 200, 200));
        sgc.setAppearance(ap);
        IndexedLineSet ils = IndexedLineSetUtility.createCurveFromPoints(verts, false);
        sgc.setGeometry(ils);
        result.addChild(sgc);
        return result;
    }

    public static SceneGraphComponent getXYZAxes() {
        IndexedLineSetFactory ilsf = new IndexedLineSetFactory();
        ilsf.setVertexCount(4);
        ilsf.setVertexCoordinates(axes);
        ilsf.setEdgeCount(3);
        ilsf.setEdgeIndices(axesIndices);
        ilsf.setEdgeColors(axesColors);
        ilsf.update();
        IndexedLineSet ils = ilsf.getIndexedLineSet();
        BallAndStickFactory basf = new BallAndStickFactory(ils);
        basf.setShowArrows(true);
        basf.setArrowPosition(1.0);
        basf.setStickRadius(0.05);
        basf.setArrowScale(0.15);
        basf.setArrowSlope(2.0);
        basf.setShowBalls(false);
        basf.setShowSticks(true);
        basf.update();
        SceneGraphComponent geometry = basf.getSceneGraphComponent();
        return geometry;
    }
}

