/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.AbstractQuadMeshFactory;
import de.jreality.geometry.GeometryUtility;
import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.geometry.Primitives;
import de.jreality.math.Rn;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.StorageModel;
import de.jreality.util.ColorGradient;
import de.jreality.util.LoggingSystem;
import de.jreality.util.Rectangle3D;
import java.awt.Color;

public class SphereUtility {
    protected static int numberOfTessellatedCubes = 16;
    protected static int numberOfTessellatedIcosahedra = 8;
    protected static IndexedFaceSet[] tessellatedIcosahedra = new IndexedFaceSet[numberOfTessellatedIcosahedra];
    protected static SceneGraphComponent[] tessellatedCubes = new SceneGraphComponent[numberOfTessellatedCubes];
    public static int SPHERE_COARSE = 0;
    public static int SPHERE_FINE = 1;
    public static int SPHERE_FINER = 2;
    public static int SPHERE_FINEST = 3;
    public static int SPHERE_SUPERFINE = 4;
    public static int SPHERE_WAYFINE = 5;
    protected static IndexedFaceSet SPHERE_BOUND;
    protected static Rectangle3D sphereBB;
    protected static Transformation[] cubeSyms;
    protected static IndexedFaceSet[] cubePanels;

    protected SphereUtility() {
    }

    public static void dispose() {
        int i;
        for (i = 0; i < tessellatedIcosahedra.length; ++i) {
            SphereUtility.tessellatedIcosahedra[i] = null;
        }
        for (i = 0; i < tessellatedCubes.length; ++i) {
            tessellatedCubes[i].setGeometry(null);
            SphereUtility.tessellatedCubes[i] = null;
        }
        for (i = 0; i < cubePanels.length; ++i) {
            SphereUtility.cubePanels[i] = null;
        }
    }

    public static IndexedFaceSet tessellatedIcosahedronSphere(int i) {
        return SphereUtility.tessellatedIcosahedronSphere(i, false);
    }

    public static IndexedFaceSet tessellatedIcosahedronSphere(int i, boolean sharedInstance) {
        if (i < 0 || i >= numberOfTessellatedIcosahedra) {
            LoggingSystem.getLogger(SphereUtility.class).warning("Invalid index");
            i = i < 0 ? 0 : numberOfTessellatedIcosahedra - 1;
        }
        if (tessellatedIcosahedra[i] == null) {
            if (i == 0) {
                SphereUtility.tessellatedIcosahedra[i] = Primitives.icosahedron();
            } else {
                SphereUtility.tessellatedIcosahedra[i] = IndexedFaceSetUtility.binaryRefine(SphereUtility.tessellatedIcosahedronSphere(i - 1, true));
                double[][] verts = tessellatedIcosahedra[i].getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
                int vlength = GeometryUtility.getVectorLength(tessellatedIcosahedra[i]);
                Rn.normalize(verts, verts);
                tessellatedIcosahedra[i].setVertexAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(vlength).createReadOnly(verts));
            }
            tessellatedIcosahedra[i].setVertexAttributes(Attribute.NORMALS, tessellatedIcosahedra[i].getVertexAttributes(Attribute.COORDINATES));
            IndexedFaceSetUtility.calculateAndSetFaceNormals(tessellatedIcosahedra[i]);
            IndexedFaceSetUtility.calculateAndSetEdgesFromFaces(tessellatedIcosahedra[i]);
        }
        if (sharedInstance) {
            return tessellatedIcosahedra[i];
        }
        IndexedFaceSet ifs = tessellatedIcosahedra[i];
        IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
        ifsf.setFaceCount(ifs.getNumFaces());
        ifsf.setFaceIndices(ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray(null));
        ifsf.setVertexCount(ifs.getNumPoints());
        ifsf.setVertexCoordinates(ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null));
        ifsf.setVertexNormals(ifs.getVertexAttributes(Attribute.NORMALS).toDoubleArrayArray(null));
        ifsf.setGenerateEdgesFromFaces(true);
        ifsf.setGenerateFaceNormals(true);
        ifsf.update();
        return ifsf.getIndexedFaceSet();
    }

    public static SceneGraphComponent tessellatedCubeSphere(int i) {
        return SphereUtility.tessellatedCubeSphere(i, false);
    }

    public static SceneGraphComponent tessellatedCubeSphere(int i, boolean sharedInstance) {
        if (sharedInstance && (i < 0 || i >= numberOfTessellatedCubes)) {
            LoggingSystem.getLogger(SphereUtility.class).warning("Invalid index");
            i = i < 0 ? 0 : numberOfTessellatedCubes - 1;
        }
        if (cubeSyms == null) {
            cubeSyms = new Transformation[2];
            SphereUtility.cubeSyms[0] = new Transformation();
            SphereUtility.cubeSyms[1] = new Transformation(new double[]{-1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0});
        }
        if (sharedInstance && tessellatedCubes[i] != null) {
            return tessellatedCubes[i];
        }
        IndexedFaceSet hemisphere = SphereUtility.oneHalfSphere(2 * i + 2);
        SceneGraphComponent parent = new SceneGraphComponent();
        for (int j = 0; j < 2; ++j) {
            SceneGraphComponent sgc = new SceneGraphComponent();
            sgc.setTransformation(cubeSyms[j]);
            sgc.setGeometry(hemisphere);
            parent.addChild(sgc);
        }
        if (sharedInstance) {
            SphereUtility.cubePanels[i] = hemisphere;
            SphereUtility.tessellatedCubes[i] = parent;
        }
        return parent;
    }

    public static Rectangle3D getSphereBoundingBox() {
        if (sphereBB == null) {
            double[][] bnds = new double[][]{{-1.0, -1.0, -1.0}, {1.0, 1.0, 1.0}};
            sphereBB = new Rectangle3D();
            sphereBB.setBounds(bnds);
        }
        return sphereBB;
    }

    public static IndexedFaceSet sphericalPatch(double cU, double cV, double uSize, double vSize, int xDetail, int yDetail, double radius) {
        double factor = Math.PI / 180;
        double uH = uSize / 2.0;
        double vH = vSize / 2.0;
        double umin = factor * (cU - uH);
        double umax = factor * (cU + uH);
        double vmin = factor * (cV - vH);
        double vmax = factor * (cV + vH);
        AbstractQuadMeshFactory qmf = new AbstractQuadMeshFactory(xDetail, yDetail, false, false);
        double du = umax - umin;
        double dv = vmax - vmin;
        du /= (double)xDetail - 1.0;
        dv /= (double)yDetail - 1.0;
        double[] points = new double[xDetail * yDetail * 3];
        for (int i = 0; i < yDetail; ++i) {
            double y = vmin + (double)i * dv;
            for (int j = 0; j < xDetail; ++j) {
                int index = 3 * (i * xDetail + j);
                double x = umin + (double)j * du;
                double cu = Math.cos(x);
                double su = Math.sin(x);
                double cv = Math.cos(-y);
                double sv = Math.sin(-y);
                points[index] = radius * cu * cv;
                points[index + 1] = radius * su * cv;
                points[index + 2] = radius * sv;
            }
        }
        qmf.setVertexCoordinates(points);
        qmf.setVertexNormals(points);
        qmf.setGenerateEdgesFromFaces(true);
        qmf.setGenerateFaceNormals(true);
        qmf.setGenerateTextureCoordinates(true);
        qmf.update();
        return qmf.getIndexedFaceSet();
    }

    static IndexedFaceSet oneHalfSphere(int n) {
        AbstractQuadMeshFactory qmf = new AbstractQuadMeshFactory(3 * n - 2, n, false, false);
        double[][] verts = new double[n * (3 * n - 2)][3];
        for (int i = 0; i < n; ++i) {
            double y = 1.0 - 2.0 * ((double)i / ((double)n - 1.0));
            for (int j = 0; j < n; ++j) {
                double x = -1.0 + 2.0 * ((double)j / ((double)n - 1.0));
                double[] v = new double[]{x, y, 1.0};
                Rn.normalize(v, v);
                System.arraycopy(v, 0, verts[i * (3 * n - 2) + j], 0, 3);
                double tmp = v[2];
                v[2] = -v[0];
                v[0] = tmp;
                System.arraycopy(v, 0, verts[i * (3 * n - 2) + j + (n - 1)], 0, 3);
                tmp = v[2];
                v[2] = -v[0];
                v[0] = tmp;
                System.arraycopy(v, 0, verts[i * (3 * n - 2) + j + (2 * n - 2)], 0, 3);
            }
        }
        qmf.setVertexCoordinates(verts);
        qmf.setVertexNormals(verts);
        qmf.setGenerateEdgesFromFaces(true);
        qmf.setGenerateFaceNormals(true);
        qmf.setGenerateTextureCoordinates(true);
        qmf.update();
        return qmf.getIndexedFaceSet();
    }

    public static void colorizeSphere(PointSet ps, double[] center, ColorGradient cg) {
        double n;
        int i;
        if (cg == null) {
            cg = new ColorGradient();
        }
        double[][] colors = ps.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
        double min = Double.MAX_VALUE;
        double max = 0.0;
        for (i = 0; i < colors.length; ++i) {
            if (center != null) {
                Rn.subtract(colors[i], colors[i], center);
            }
            if ((n = Rn.euclideanNorm(colors[i])) < min) {
                min = n;
            }
            if (!(n > max)) continue;
            max = n;
        }
        for (i = 0; i < colors.length; ++i) {
            n = Rn.euclideanNorm(colors[i]);
            double cc = (n - min) / (max - min);
            Color c = cg.getColor(cc);
            colors[i][0] = (double)c.getRed() / 255.0;
            colors[i][1] = (double)c.getGreen() / 255.0;
            colors[i][2] = (double)c.getBlue() / 255.0;
        }
        ps.setVertexAttributes(Attribute.COLORS, new DoubleArrayArray.Array(colors));
    }

    public static void assignSphericalUVs(PointSet ps, double[] center) {
        double[][] points = ps.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
        double[] tc = new double[2 * points.length];
        int i = 0;
        for (double[] p : points) {
            if (center != null) {
                Rn.subtract(p, p, center);
            }
            Rn.normalize(p, p);
            tc[i++] = 0.5 + Math.atan2(p[1], p[0]) / (Math.PI * 2);
            tc[i++] = Math.acos(p[2]) / Math.PI;
        }
        ps.setVertexAttributes(Attribute.TEXTURE_COORDINATES, new DoubleArrayArray.Inlined(tc, 2));
    }

    static {
        sphereBB = null;
        cubeSyms = null;
        cubePanels = new IndexedFaceSet[numberOfTessellatedCubes];
    }
}

