/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.GeometryUtility;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.StorageModel;
import java.awt.Dimension;

public class QuadMeshUtility {
    private QuadMeshUtility() {
    }

    public static double[][] extractUParameterCurve(double[][] curve, IndexedFaceSet ifs, int which) {
        return QuadMeshUtility.extractParameterCurve(curve, ifs, which, 0);
    }

    public static double[][] extractVParameterCurve(double[][] curve, IndexedFaceSet ifs, int which) {
        Dimension dim = (Dimension)ifs.getGeometryAttributes(GeometryUtility.QUAD_MESH_SHAPE);
        return QuadMeshUtility.extractParameterCurve(curve, ifs, which, 1);
    }

    public static double[][] extractParameterCurve(double[][] curve, IndexedFaceSet ifs, int which, int type) {
        int modulo;
        Object foo = ifs.getGeometryAttributes(GeometryUtility.QUAD_MESH_SHAPE);
        if (foo == null) {
            throw new IllegalArgumentException("Not a quad mesh");
        }
        Dimension dim = (Dimension)foo;
        int uSize = dim.width;
        int vSize = dim.height;
        DataList verts = ifs.getVertexAttributes(Attribute.COORDINATES);
        boolean closedU = false;
        boolean closedV = false;
        int numverts = uSize * vSize;
        int lim = 0;
        int begin = 0;
        int stride = 0;
        if (type == 0) {
            lim = closedV ? vSize + 1 : vSize;
            begin = which;
            stride = uSize;
            modulo = numverts;
        } else {
            lim = closedU ? uSize + 1 : uSize;
            begin = which * uSize;
            stride = 1;
            modulo = uSize;
        }
        int n = GeometryUtility.getVectorLength(verts);
        if (curve == null || curve.length != lim || curve[0].length != n) {
            curve = new double[lim][n];
        }
        int i = 0;
        int m = 0;
        while (i < lim) {
            int xx = begin + m % modulo;
            DoubleArray da = verts.item(xx).toDoubleArray();
            for (int j = 0; j < n; ++j) {
                curve[i][j] = da.getValueAt(j);
            }
            ++i;
            m += stride;
        }
        return curve;
    }

    public static void generateAndSetEdgesFromQuadMesh(IndexedFaceSet qm) {
        int j;
        int i;
        int vLineCount;
        Object obj = qm.getGeometryAttributes(GeometryUtility.QUAD_MESH_SHAPE);
        if (obj == null || !(obj instanceof Dimension)) {
            throw new IllegalStateException("Not a quad mesh");
        }
        int uLineCount = ((Dimension)obj).width;
        int sizeUCurve = vLineCount = ((Dimension)obj).height;
        int sizeVCurve = uLineCount;
        int numVerts = uLineCount * vLineCount;
        int[][] indices = new int[uLineCount + vLineCount][];
        for (i = 0; i < uLineCount; ++i) {
            indices[i] = new int[sizeUCurve];
            for (j = 0; j < sizeUCurve; ++j) {
                indices[i][j] = (j * uLineCount + i % uLineCount) % numVerts;
            }
        }
        for (i = 0; i < vLineCount; ++i) {
            indices[i + uLineCount] = new int[sizeVCurve];
            for (j = 0; j < sizeVCurve; ++j) {
                indices[i + uLineCount][j] = (i * uLineCount + j % uLineCount) % numVerts;
            }
        }
        qm.setEdgeCountAndAttributes(Attribute.INDICES, StorageModel.INT_ARRAY_ARRAY.createReadOnly(indices));
    }
}

