/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.FrameFieldType;
import de.jreality.geometry.IndexedLineSetUtility;
import de.jreality.geometry.QuadMeshFactory;
import de.jreality.geometry.TubeFactory;
import de.jreality.math.P3;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.util.LoggingSystem;
import java.util.logging.Level;

public class PolygonalTubeFactory
extends TubeFactory {
    IndexedFaceSet theTube;
    QuadMeshFactory qmf;
    double[][] theTubeVertices;
    private double[][] polygon2;
    private double[][] vals;

    public PolygonalTubeFactory(double[][] curve) {
        super(curve);
    }

    public PolygonalTubeFactory(IndexedLineSet ils, int whichCurve) {
        this(IndexedLineSetUtility.extractCurve(null, ils, whichCurve));
    }

    protected double[][] makeTube(double[][] curve, double[] radii, double[][] xsec, FrameFieldType type, boolean closed, int metric, int twists) {
        int usedVerts;
        int n = curve.length;
        int vl = xsec[0].length;
        boolean autoClosed = false;
        double d = Rn.euclideanDistance(curve[0], curve[n - 1]);
        boolean bl = autoClosed = d < 1.0E-7;
        if (autoClosed) {
            closed = true;
            --n;
        }
        int realLength = (closed ? n + 1 : n) * xsec.length;
        if (this.vals == null || this.vals.length != realLength || this.vals[0].length != vl) {
            this.vals = new double[realLength][vl];
        }
        if (n <= 1) {
            throw new IllegalArgumentException("Can't tube a vertex list of length less than 2");
        }
        double[] radii2 = null;
        boolean hasRadii = radii.length > 1;
        int n2 = usedVerts = closed ? n + 3 : n + 2;
        if (this.polygon2 == null || this.polygon2.length != usedVerts) {
            this.polygon2 = new double[usedVerts][];
            if (hasRadii) {
                radii2 = new double[usedVerts];
            }
        }
        for (int i = 0; i < n; ++i) {
            this.polygon2[i + 1] = curve[i];
            if (!hasRadii) continue;
            radii2[i + 1] = radii[i];
        }
        if (closed) {
            this.polygon2[0] = curve[n - 1];
            this.polygon2[n + 1] = curve[0];
            this.polygon2[n + 2] = curve[1];
            if (hasRadii) {
                radii2[0] = radii[n - 1];
                radii2[n + 1] = radii[0];
                radii2[n + 2] = radii[1];
            }
        } else {
            this.polygon2[0] = Rn.add(null, curve[0], Rn.subtract(null, curve[0], curve[1]));
            this.polygon2[n + 1] = Rn.add(null, curve[n - 1], Rn.subtract(null, curve[n - 1], curve[n - 2]));
            if (hasRadii) {
                radii2[0] = radii2[1];
                radii2[n + 1] = radii2[n];
            }
        }
        this.frames = this.makeFrameField(this.polygon2, type, metric);
        LoggingSystem.getLogger(PolygonalTubeFactory.class).fine("Last phi is " + this.frames[this.frames.length - 1].phi);
        if (this.frames == null) {
            throw new NullPointerException("No frames!");
        }
        double[] rad = Rn.identityMatrix(4);
        int nn = this.frames.length;
        double lastphi = this.frames[this.frames.length - 1].phi;
        double correction = closed && this.matchClosedTwist ? (lastphi > Math.PI ? Math.PI * 2 - lastphi : -lastphi) / (double)nn : 0.0;
        for (int i = 0; i < nn; ++i) {
            double sangle = Math.sin(this.frames[i].theta / 2.0);
            double factor = 1.0;
            if (sangle != 0.0) {
                factor = 1.0 / sangle;
            }
            double r = hasRadii ? radii2[i] : radii[0];
            rad[0] = r * factor;
            rad[5] = r;
            this.frames[i].phi = this.frames[i].phi + (double)i * correction + (double)(twists * 2) * Math.PI * this.frames[i].length;
            double[] zrot = P3.makeRotationMatrixZ(null, this.frames[i].phi);
            double[] scaledFrame = Rn.times(null, this.frames[i].frame, Rn.times(null, rad, zrot));
            int m = xsec.length;
            for (int j = 0; j < m; ++j) {
                int p = j;
                Rn.matrixTimesVector(this.vals[i * m + j], scaledFrame, xsec[p]);
            }
        }
        if (closed && this.matchClosedTwist) {
            System.err.println("Closing the tube");
            int m = xsec.length;
            for (int j = 0; j < m; ++j) {
                int p = j;
                this.vals[(nn - 1) * m + j] = this.vals[j];
            }
        }
        return this.vals;
    }

    public void update() {
        super.update();
        if (this.radii == null) {
            this.radii = new double[1];
        }
        if (this.radii.length == 1) {
            this.radii[0] = this.radius;
        }
        this.theTubeVertices = this.makeTube(this.theCurve, this.radii, this.crossSection, this.frameFieldType, this.closedCurve, this.metric, this.twists);
        this.qmf = new QuadMeshFactory();
        this.qmf.setMetric(this.metric);
        this.qmf.setGenerateTextureCoordinates(this.generateTextureCoordinates && !this.arcLengthTextureCoordinates);
        this.qmf.setULineCount(this.crossSection.length);
        this.qmf.setVLineCount(this.theTubeVertices.length / this.crossSection.length);
        boolean closedInU = Rn.euclideanDistance(this.crossSection[0], this.crossSection[this.crossSection.length - 1]) < 1.0E-7;
        this.qmf.setClosedInUDirection(closedInU);
        this.qmf.setClosedInVDirection(this.closedCurve);
        this.qmf.setVertexCoordinates(this.theTubeVertices);
        this.qmf.setGenerateFaceNormals(true);
        this.qmf.setGenerateVertexNormals(true);
        this.qmf.setEdgeFromQuadMesh(true);
        this.qmf.setGenerateEdgesFromFaces(this.generateEdges);
        this.qmf.update();
        this.theTube = this.qmf.getIndexedFaceSet();
        if (this.generateTextureCoordinates) {
            if (!this.arcLengthTextureCoordinates) {
                this.qmf.setGenerateTextureCoordinates(true);
            } else {
                this.qmf.setVertexTextureCoordinates(this.arcLengthTextureCoordinates(this.theCurve, this.crossSection, this.metric));
            }
        }
        if (this.vertexColors != null || this.edgeColors != null) {
            int m;
            int k;
            int j;
            int colorLength;
            int numVerts = this.theTube.getNumPoints();
            int numFaces = this.theTube.getNumFaces();
            int xsLength = this.crossSection.length;
            if (this.edgeColors != null) {
                colorLength = this.edgeColors[0].length;
                double[][] faceColors = new double[numFaces][colorLength];
                int lim = numFaces / this.crossSection.length;
                for (j = 0; j < lim; ++j) {
                    for (k = 0; k < xsLength; ++k) {
                        for (m = 0; m < colorLength; ++m) {
                            faceColors[j * xsLength + k][m] = this.edgeColors[j % this.edgeColors.length][m];
                        }
                    }
                }
                theLogger.log(Level.FINER, "Setting Face colors");
                this.qmf.setFaceColors(faceColors);
            }
            if (this.vertexColorsEnabled && this.vertexColors != null) {
                colorLength = this.vertexColors[0].length;
                double[][] vertColors = new double[numVerts][colorLength];
                int realNumVerts = numVerts / xsLength;
                for (j = 0; j < realNumVerts; ++j) {
                    for (k = 0; k < xsLength; ++k) {
                        for (m = 0; m < colorLength; ++m) {
                            vertColors[j * xsLength + k][m] = this.vertexColors[j % this.vertexColors.length][m];
                        }
                    }
                }
                theLogger.log(Level.FINER, "Setting vertex colors");
                this.qmf.setVertexColors(vertColors);
            }
        }
        this.qmf.update();
        this.theTube = this.qmf.getIndexedFaceSet();
    }

    private double[][] arcLengthTextureCoordinates(double[][] theCurve, double[][] crossSection, int metric) {
        int vLineCount = theCurve.length;
        int uLineCount = crossSection.length;
        double[][] textureCoordinates = new double[uLineCount * vLineCount][2];
        int vLength = theCurve[0].length;
        double[] lengths = new double[vLineCount];
        lengths[0] = 0.0;
        for (int i = 1; i < vLineCount; ++i) {
            lengths[i] = vLength == 3 ? lengths[i - 1] + Rn.euclideanDistance(theCurve[i], theCurve[i - 1]) : lengths[i - 1] + Pn.distanceBetween(theCurve[i], theCurve[i - 1], metric);
        }
        double du = 1.0 / (double)(uLineCount - 1);
        double curveLength = lengths[vLineCount - 1];
        int iv = 0;
        int firstIndexInULine = 0;
        while (iv < vLineCount) {
            double u = 0.0;
            int iu = 0;
            while (iu < uLineCount) {
                int indexOfUV = firstIndexInULine + iu;
                textureCoordinates[indexOfUV][0] = u;
                textureCoordinates[indexOfUV][1] = lengths[iv] / curveLength;
                ++iu;
                u += du;
            }
            ++iv;
            firstIndexInULine += uLineCount;
        }
        return textureCoordinates;
    }

    public IndexedFaceSet getTube() {
        return this.theTube;
    }

    public void updateFrames() {
    }
}

