/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.data.Attribute;

public class PointSetUtility {
    public static SceneGraphComponent displayVertexNormals(PointSet ps, double scale, int metric) {
        SceneGraphComponent sgc = new SceneGraphComponent("displayFaceNormals()");
        Appearance ap = new Appearance();
        ap.setAttribute("showLines", true);
        ap.setAttribute("lineShader.tubeDraw", false);
        ap.setAttribute("showFaces", false);
        ap.setAttribute("showPoints", false);
        sgc.setAppearance(ap);
        int n = ps.getNumPoints();
        int[][] edges = new int[n][2];
        double[][] verts = ps.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
        int fiberlength = verts[0].length;
        double[][] normals = null;
        double[][] nvectors = new double[2 * n][fiberlength];
        normals = ps.getVertexAttributes(Attribute.NORMALS).toDoubleArrayArray(null);
        if (normals == null) {
            throw new IllegalStateException("must have vertex normals");
        }
        for (int i = 0; i < n; ++i) {
            nvectors[i] = verts[i];
            if (metric == 0) {
                Rn.add(nvectors[i + n], nvectors[i], Rn.times(null, scale, normals[i]));
            } else {
                Pn.dragTowards(nvectors[i + n], nvectors[i], normals[i], scale, metric);
            }
            if (fiberlength == 4) {
                if (metric == 0) {
                    nvectors[i + n][3] = 1.0;
                } else {
                    Pn.dehomogenize(nvectors[i + n], nvectors[i + n]);
                }
            }
            edges[i][0] = i;
            edges[i][1] = i + n;
        }
        IndexedLineSetFactory ilsf = new IndexedLineSetFactory();
        ilsf.setVertexCount(2 * n);
        ilsf.setVertexCoordinates(nvectors);
        ilsf.setEdgeCount(n);
        ilsf.setEdgeIndices(edges);
        ilsf.update();
        sgc.setGeometry(ilsf.getIndexedLineSet());
        return sgc;
    }
}

