/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.AbstractQuadMeshFactory;
import de.jreality.geometry.OoNode;
import de.jreality.scene.data.Attribute;

public class ParametricSurfaceFactory
extends AbstractQuadMeshFactory {
    final OoNode uMin = this.node(new Double(0.0), "uMin");
    final OoNode uMax = this.node(new Double(1.0), "uMax");
    final OoNode vMin = this.node(new Double(0.0), "vMin");
    final OoNode vMax = this.node(new Double(1.0), "vMax");
    final OoNode immersion = this.node("immersion");

    ParametricSurfaceFactory(Immersion immersion, double uMin, double uMax, double vMin, double vMax) {
        this.vertexCoordinates.addIngr(this.vLineCount);
        this.vertexCoordinates.addIngr(this.uLineCount);
        this.vertexCoordinates.addIngr(this.uMin);
        this.vertexCoordinates.addIngr(this.uMax);
        this.vertexCoordinates.addIngr(this.vMin);
        this.vertexCoordinates.addIngr(this.vMax);
        this.vertexCoordinates.addIngr(this.immersion);
        this.vertexCoordinates.setUpdateMethod(new OoNode.UpdateMethod(){

            public Object update(Object object) {
                return ParametricSurfaceFactory.this.generateVertexCoordinates((double[][])object);
            }
        });
        this.setUMin(uMin);
        this.setUMax(uMax);
        this.setVMin(vMin);
        this.setVMax(vMax);
        this.setImmersion(immersion);
        this.vertexCoordinates.setGenerate(true);
    }

    public ParametricSurfaceFactory(Immersion immersion) {
        this(immersion, 0.0, 1.0, 0.0, 1.0);
    }

    public ParametricSurfaceFactory() {
        this(new Immersion(){

            public int getDimensionOfAmbientSpace() {
                return 3;
            }

            public void evaluate(double u, double v, double[] xyz, int index) {
                xyz[index + 0] = u;
                xyz[index + 1] = v;
            }

            public boolean isImmutable() {
                return true;
            }
        });
    }

    double[][] generateVertexCoordinates(double[][] vertexCoordinates) {
        double vMin;
        this.log("compute", Attribute.COORDINATES, "vertex ");
        Immersion immersion = this.getImmersion();
        if (vertexCoordinates == null || vertexCoordinates.length != this.nov()) {
            vertexCoordinates = new double[this.nov()][immersion.getDimensionOfAmbientSpace()];
        }
        int vLineCount = this.getVLineCount();
        int uLineCount = this.getULineCount();
        double dv = (this.getVMax() - this.getVMin()) / (double)(vLineCount - 1);
        double du = (this.getUMax() - this.getUMin()) / (double)(uLineCount - 1);
        double uMin = this.getUMin();
        double v = vMin = this.getVMin();
        int iv = 0;
        int firstIndexInULine = 0;
        while (iv < vLineCount) {
            double u = uMin;
            int iu = 0;
            while (iu < uLineCount) {
                int indexOfUV = firstIndexInULine + iu;
                immersion.evaluate(u, v, vertexCoordinates[uLineCount * iv + iu], 0);
                ++iu;
                u += du;
            }
            ++iv;
            v += dv;
            firstIndexInULine += uLineCount;
        }
        return vertexCoordinates;
    }

    public double[][] getDomainVertices(double[][] uvpoints) {
        return this.getDomainVertices(uvpoints, false);
    }

    public double[][] getDomainVertices(double[][] uvpoints, boolean offset) {
        double vMin;
        if (uvpoints == null || uvpoints.length != this.nov() || uvpoints[0].length != 2) {
            uvpoints = new double[this.nov()][2];
        }
        int vLineCount = this.getVLineCount();
        int uLineCount = this.getULineCount();
        double dv = (this.getVMax() - this.getVMin()) / (double)(vLineCount - 1);
        double du = (this.getUMax() - this.getUMin()) / (double)(uLineCount - 1);
        double uMin = this.getUMin();
        double v = vMin = this.getVMin();
        int iv = 0;
        int firstIndexInULine = 0;
        while (iv < vLineCount) {
            double u = uMin + (iv % 2 == 1 && offset ? du / 2.0 : 0.0);
            int iu = 0;
            while (iu < uLineCount) {
                int i = uLineCount * iv + iu;
                uvpoints[i][0] = u;
                uvpoints[i][1] = v;
                ++iu;
                u += du;
            }
            ++iv;
            v += dv;
            firstIndexInULine += uLineCount;
        }
        return uvpoints;
    }

    public Immersion getImmersion() {
        return (Immersion)this.immersion.getObject();
    }

    public void setImmersion(Immersion f) {
        if (f == null) {
            throw new IllegalArgumentException("Immersion cannot set to null.");
        }
        this.immersion.setObject(f);
    }

    public double getUMax() {
        return (Double)this.uMax.getObject();
    }

    public void setUMax(double max) {
        this.uMax.setObject(new Double(max));
    }

    public double getUMin() {
        return (Double)this.uMin.getObject();
    }

    public void setUMin(double min) {
        this.uMin.setObject(new Double(min));
    }

    public double getVMax() {
        return (Double)this.vMax.getObject();
    }

    public void setVMax(double max) {
        this.vMax.setObject(new Double(max));
    }

    public double getVMin() {
        return (Double)this.vMin.getObject();
    }

    public void setVMin(double min) {
        this.vMin.setObject(new Double(min));
    }

    void recompute() {
        if (!this.getImmersion().isImmutable()) {
            this.immersion.outdate();
        }
        super.recompute();
        this.vertexCoordinates.update();
    }

    protected void updateImpl() {
        super.updateImpl();
        this.vertexCoordinates.updateArray();
    }

    public static abstract class DefaultImmersion
    implements Immersion {
        protected double x;
        protected double y;
        protected double z;

        public boolean isImmutable() {
            return false;
        }

        public int getDimensionOfAmbientSpace() {
            return 3;
        }

        public void evaluate(double u, double v, double[] xyz, int index) {
            this.evaluate(u, v);
            xyz[3 * index + 0] = this.x;
            xyz[3 * index + 1] = this.y;
            xyz[3 * index + 2] = this.z;
        }

        public abstract void evaluate(double var1, double var3);
    }

    public static interface Immersion {
        public boolean isImmutable();

        public int getDimensionOfAmbientSpace();

        public void evaluate(double var1, double var3, double[] var5, int var6);
    }
}

