/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.scene.data.DataList;
import de.jreality.scene.data.StorageModel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class OoNode {
    private IsUpdateCounter updateCounter;
    private Set ingr = new HashSet();
    private Set deps = new HashSet();
    private Object object;
    private Class type;
    private String name;
    private long counterOfLastUpdate = -1L;
    private boolean currentlyUpdating = false;
    private boolean currentlyOutdating = false;
    private boolean outOfDate = true;
    UpdateMethod updateMethod = null;

    public OoNode(String name, IsUpdateCounter updateCounter) {
        this(name, (Class)null, updateCounter);
    }

    public OoNode(String name, Class type, IsUpdateCounter updateCounter) {
        this.updateCounter = updateCounter;
        this.setObject(this.object);
        this.type = type;
        this.setName(name);
    }

    public OoNode(Object object, String name, IsUpdateCounter updateCounter) {
        this(object, object.getClass(), name, updateCounter);
    }

    public OoNode(Object object, Class type, String name, IsUpdateCounter updateCounter) {
        this.updateCounter = updateCounter;
        this.setObject(object);
        this.type = type;
        this.setName(name);
    }

    public Object getObject() {
        this.update();
        return this.object;
    }

    public void setObject(Object object) {
        if (object != null && this.type != null && !this.type.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("object of incompatible type");
        }
        if (this.object == object) {
            return;
        }
        this.object = object;
        this.outdate();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addIngr(OoNode node) {
        node.addDeps(this);
    }

    public void removeIngr(OoNode node) {
        node.removeDeps(this);
    }

    public void addDeps(OoNode node) {
        if (node == this) {
            throw new IllegalArgumentException("node must not equal this");
        }
        this.deps.add(node);
        if (this.isOutOfDate()) {
            node.outdate();
        }
        node.ingr.add(this);
    }

    public void removeDeps(OoNode node) {
        if (node == this) {
            throw new IllegalArgumentException("node must not equal this");
        }
        this.deps.remove(node);
        node.ingr.remove(this);
    }

    void outdateDeps() {
        Iterator iter = this.deps.iterator();
        while (iter.hasNext()) {
            ((OoNode)iter.next()).outdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outdate() {
        if (this.currentlyOutdating) {
            throw new IllegalStateException("encounterd loop in update graph: " + this.name);
        }
        this.currentlyOutdating = true;
        try {
            this.outOfDate = true;
            this.outdateDeps();
        }
        finally {
            this.currentlyOutdating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if (!this.outOfDate) {
            return;
        }
        if (this.currentlyUpdating) {
            throw new IllegalStateException("encounterd loop in update graph: " + this.name);
        }
        this.currentlyUpdating = true;
        try {
            Iterator iter = this.ingr.iterator();
            while (iter.hasNext()) {
                ((OoNode)iter.next()).update();
            }
            if (this.updateMethod != null) {
                Object newObject;
                this.object = newObject = this.updateMethod.update(this.object);
            }
        }
        finally {
            this.currentlyUpdating = false;
        }
        this.outOfDate = false;
        this.counterOfLastUpdate = this.updateCounter.getUpdateCount();
    }

    public void fire() {
        this.outdate();
        this.update();
    }

    public boolean isOutOfDate() {
        return this.outOfDate;
    }

    public void setUpdateMethod(UpdateMethod method) {
        if (method == this.updateMethod) {
            return;
        }
        this.updateMethod = method;
        this.outdate();
    }

    public long getCounterOfLastUpdate() {
        return this.counterOfLastUpdate;
    }

    DataList createDataList() {
        Object currentObject = this.getObject();
        if (currentObject == null) {
            return null;
        }
        if (this.type.equals(int[][].class)) {
            int[][] array = (int[][])currentObject;
            return StorageModel.INT_ARRAY_ARRAY.createReadOnly(array);
        }
        if (this.type == double[].class) {
            double[] array = (double[])currentObject;
            return StorageModel.DOUBLE_ARRAY.createReadOnly(array);
        }
        if (this.type == double[][].class) {
            double[][] array = (double[][])currentObject;
            return StorageModel.DOUBLE_ARRAY_ARRAY.createReadOnly(array);
        }
        if (this.type.equals(String[].class)) {
            String[] array = (String[])currentObject;
            return StorageModel.STRING_ARRAY.createReadOnly(array);
        }
        throw new IllegalStateException("do not support type " + this.type);
    }

    Object converteDataListToArray(DataList dl) {
        if (this.type.equals(int[][].class)) {
            return dl.toIntArrayArray(null);
        }
        if (this.type == double[][].class) {
            return dl.toDoubleArrayArray(null);
        }
        if (this.type.equals(String[].class)) {
            return dl.toStringArray(null);
        }
        throw new IllegalStateException("do not support type " + this.type);
    }

    public static interface UpdateMethod {
        public Object update(Object var1);
    }

    static interface IsUpdateCounter {
        public long getUpdateCount();
    }
}

