/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.GeometryUtility;
import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.math.P3;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.Scene;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DataListSet;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.data.StorageModel;
import de.jreality.scene.data.StringArray;
import de.jreality.util.LoggingSystem;
import de.jreality.util.Rectangle3D;
import de.jreality.util.SceneGraphUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedFaceSetUtility {
    private static int[][] boxIndices = new int[][]{{0, 1, 3, 2}, {1, 0, 4, 5}, {3, 1, 5, 7}, {5, 4, 6, 7}, {2, 3, 7, 6}, {0, 2, 6, 4}};
    private static double EPS = 1.0E-7;

    private IndexedFaceSetUtility() {
    }

    public static IndexedFaceSet binaryRefine(IndexedFaceSet ifs) {
        double[][] nvd;
        int[][] indices = ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray().toIntArrayArray(null);
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i].length == 3) continue;
            throw new IllegalArgumentException("Indexed face set must consist of triangles");
        }
        int[][] eindices = ifs.getEdgeAttributes(Attribute.INDICES).toIntArrayArray().toIntArrayArray(null);
        for (int i = 0; i < eindices.length; ++i) {
            if (eindices[i].length == 2) continue;
            throw new IllegalArgumentException("Indexed face set edges must all be line segments (no curves)");
        }
        Hashtable<Integer, Integer> edgeVals = new Hashtable<Integer, Integer>();
        int numVerts = ifs.getNumPoints();
        int numFaces = ifs.getNumFaces();
        int numEdges = ifs.getNumEdges();
        int vLength = GeometryUtility.getVectorLength(ifs);
        int newSize = numVerts + numEdges;
        double[][] newpptr = nvd = new double[newSize][vLength];
        double[][] oldpptr = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
        System.arraycopy(oldpptr, 0, newpptr, 0, numVerts);
        int[][] newIndices = new int[4 * numFaces][3];
        int[] index = new int[3];
        int nV = numVerts;
        int nF = 0;
        for (int i = 0; i < numFaces; ++i) {
            for (int j = 0; j < 3; ++j) {
                int v1 = indices[i][(j + 1) % 3];
                int v2 = indices[i][(j + 2) % 3];
                int kk = v1 > v2 ? (v1 << 15) + v2 : (v2 << 15) + v1;
                Integer key = new Integer(kk);
                Integer value = (Integer)edgeVals.get(key);
                if (value != null) {
                    index[j] = value;
                    continue;
                }
                index[j] = nV;
                Rn.add(newpptr[nV], oldpptr[v1], oldpptr[v2]);
                Rn.times(newpptr[nV], 0.5, newpptr[nV]);
                edgeVals.put(key, new Integer(nV));
                if (++nV <= newSize) continue;
                return null;
            }
            for (int k = 0; k < 3; ++k) {
                newIndices[nF][k] = index[k];
            }
            newIndices[++nF][0] = indices[i][0];
            newIndices[nF][1] = index[2];
            newIndices[nF][2] = index[1];
            newIndices[++nF][0] = indices[i][1];
            newIndices[nF][1] = index[0];
            newIndices[nF][2] = index[2];
            newIndices[++nF][0] = indices[i][2];
            newIndices[nF][1] = index[1];
            newIndices[nF][2] = index[0];
            ++nF;
        }
        IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
        ifsf.setVertexCount(newpptr.length);
        ifsf.setVertexCoordinates(newpptr);
        ifsf.setFaceCount(newIndices.length);
        ifsf.setFaceIndices(newIndices);
        ifsf.setGenerateEdgesFromFaces(true);
        ifsf.update();
        return ifsf.getIndexedFaceSet();
    }

    public static void calculateAndSetEdgesFromFaces(IndexedFaceSet ifs) {
        IntArrayArray faces = ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray();
        ifs.setEdgeCountAndAttributes(Attribute.INDICES, IndexedFaceSetUtility.edgesFromFaces(faces));
    }

    public static IndexedFaceSet constructPolygon(double[][] points) {
        return IndexedFaceSetUtility.constructPolygon(null, points);
    }

    public static IndexedFaceSet constructPolygon(IndexedFaceSet ifs, double[][] points) {
        return IndexedFaceSetUtility.constructPolygon(ifs, points, 0);
    }

    public static IndexedFaceSet constructPolygon(IndexedFaceSet ifs, double[][] points, int sig) {
        int[][] ind = new int[1][points.length];
        for (int i = 0; i < points.length; ++i) {
            ind[0][i] = i;
        }
        if (ifs == null) {
            ifs = new IndexedFaceSet();
        }
        IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
        ifsf.setMetric(sig);
        ifsf.setGenerateFaceNormals(true);
        ifsf.setVertexCount(points.length);
        ifsf.setFaceCount(1);
        ifsf.setVertexCoordinates(points);
        ifsf.setFaceIndices(new int[][]{new int[0]});
        ifsf.setFaceIndices(ind);
        ifsf.setEdgeCount(1);
        ind = new int[1][points.length + 1];
        for (int i = 0; i <= points.length; ++i) {
            ind[0][i] = i % points.length;
        }
        ifsf.setEdgeIndices(ind);
        ifsf.update();
        return ifsf.getIndexedFaceSet();
    }

    public static IntArrayArray edgesFromFaces(int[][] faces) {
        return IndexedFaceSetUtility.edgesFromFaces(new IntArrayArray.Array(faces));
    }

    public static IntArrayArray edgesFromFaces(IntArrayArray faces) {
        HashSet<Pair> set = new HashSet<Pair>();
        for (int i = 0; i < faces.getLength(); ++i) {
            IntArray f = faces.getValueAt(i);
            for (int j = 0; j < f.getLength() - 1; ++j) {
                set.add(new Pair(f.getValueAt(j), f.getValueAt(j + 1)));
            }
            set.add(new Pair(f.getValueAt(f.getLength() - 1), f.getValueAt(0)));
        }
        int num = set.size();
        int[] edge = new int[num * 2];
        int count = 0;
        for (Pair p : set) {
            edge[count] = p.l;
            edge[count + 1] = p.h;
            count += 2;
        }
        return new IntArrayArray.Inlined(edge, 2);
    }

    public static double[][] extractEdge(double[][] curve, IndexedFaceSet ifs, int which) {
        DataList verts = ifs.getVertexAttributes(Attribute.COORDINATES);
        int[] indices = ifs.getEdgeAttributes(Attribute.INDICES).item(which).toIntArray(null);
        int n = indices.length;
        int m = GeometryUtility.getVectorLength(verts);
        if (curve == null || curve.length != n || curve[0].length != m) {
            curve = new double[n][m];
        }
        for (int i = 0; i < n; ++i) {
            DoubleArray da = verts.item(i).toDoubleArray();
            for (int j = 0; j < n; ++j) {
                curve[i][j] = da.getValueAt(j);
            }
        }
        return curve;
    }

    public static IndexedFaceSet extractFace(IndexedFaceSet ifs, int which) {
        IndexedFaceSet ifs2 = SceneGraphUtility.copy(ifs);
        ifs2.setName(ifs.getName() + "ExtractFace" + which);
        int[][] indices = ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray(null);
        int[][] newIndices = new int[][]{indices[which]};
        ifs2.setFaceCountAndAttributes(Attribute.INDICES, StorageModel.INT_ARRAY.array().createReadOnly(newIndices));
        DataList colors = ifs.getFaceAttributes(Attribute.COLORS);
        if (colors != null) {
            double[][] cc = colors.toDoubleArrayArray(null);
            double[][] newc = new double[][]{cc[which]};
            ifs2.setFaceAttributes(Attribute.COLORS, StorageModel.DOUBLE_ARRAY.array().createReadOnly(newc));
        }
        IndexedFaceSetUtility.calculateAndSetFaceNormals(ifs2);
        IndexedFaceSetUtility.calculateAndSetEdgesFromFaces(ifs2);
        return ifs2;
    }

    private static double[][] getMinMax(int[] indices, double[][] array2d) {
        int f = array2d[0].length;
        double[][] minmax = new double[2][f];
        System.arraycopy(array2d[indices[0]], 0, minmax[0], 0, f);
        System.arraycopy(array2d[indices[0]], 0, minmax[1], 0, f);
        for (int i = 1; i < indices.length; ++i) {
            Rn.min(minmax[0], minmax[0], array2d[indices[i]]);
            Rn.max(minmax[1], minmax[1], array2d[indices[i]]);
        }
        return minmax;
    }

    public static IndexedFaceSet implode(IndexedFaceSet ifs, double factor) {
        IndexedFaceSet imploded;
        Object newind;
        double implode;
        boolean makeEdges = ifs.getEdgeAttributes().containsAttribute(Attribute.INDICES);
        int vertcount = 0;
        int[][] ind = ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray(null);
        for (int i = 0; i < ind.length; ++i) {
            vertcount += ind[i].length;
        }
        double[][] oldverts = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
        int vectorLength = oldverts[0].length;
        if (vectorLength != 3) {
            double[][] oldverts2 = new double[oldverts.length][3];
            Pn.dehomogenize(oldverts2, oldverts);
            oldverts = oldverts2;
            vectorLength = 3;
        }
        if ((implode = -factor) > 0.0) {
            newind = new int[ind.length][];
            double[][] newverts = new double[vertcount][vectorLength];
            int count = 0;
            for (int i = 0; i < ind.length; ++i) {
                int[] thisf = ind[i];
                newind[i] = new int[thisf.length];
                double[] center = new double[3];
                for (int j = 0; j < thisf.length; ++j) {
                    Rn.add(center, oldverts[ind[i][j]], center);
                    newind[i][j] = count + j;
                }
                Rn.times(center, 1.0 / (double)thisf.length, center);
                double[] diff = new double[vectorLength];
                for (int j = 0; j < thisf.length; ++j) {
                    Rn.subtract(diff, oldverts[ind[i][j]], center);
                    Rn.times(diff, implode, diff);
                    Rn.add(newverts[count + j], center, diff);
                }
                count += thisf.length;
            }
            double[][] fn = null;
            double[][] fc = null;
            fn = ifs.getFaceAttributes(Attribute.NORMALS) != null ? ifs.getFaceAttributes(Attribute.NORMALS).toDoubleArrayArray(null) : IndexedFaceSetUtility.calculateFaceNormals(ifs);
            if (ifs.getFaceAttributes(Attribute.COLORS) != null) {
                fc = ifs.getFaceAttributes(Attribute.COLORS).toDoubleArrayArray(null);
            }
            IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
            ifsf.setVertexCount(vertcount);
            ifsf.setFaceCount(ind.length);
            ifsf.setVertexCoordinates(newverts);
            ifsf.setFaceIndices((int[][])newind);
            if (fn != null) {
                ifsf.setFaceNormals(fn);
            } else {
                ifsf.setGenerateFaceNormals(true);
            }
            if (fc != null) {
                ifsf.setFaceColors(fc);
            }
            ifsf.setGenerateEdgesFromFaces(makeEdges);
            ifsf.update();
            imploded = ifsf.getIndexedFaceSet();
        } else {
            int i;
            int oldcount = oldverts.length;
            newind = new int[vertcount][4];
            double[][] newverts = new double[vertcount + oldcount][vectorLength];
            for (i = 0; i < oldcount; ++i) {
                Rn.copy(newverts[i], oldverts[i]);
            }
            int count = 0;
            for (i = 0; i < ind.length; ++i) {
                int[] thisf = ind[i];
                double[] center = new double[3];
                for (int j = 0; j < thisf.length; ++j) {
                    Rn.add(center, oldverts[ind[i][j]], center);
                    newind[count + j][0] = ind[i][j];
                    newind[count + j][1] = ind[i][(j + 1) % thisf.length];
                    newind[count + j][2] = oldcount + count + (j + 1) % thisf.length;
                    newind[count + j][3] = oldcount + count + j;
                }
                Rn.times(center, 1.0 / (double)thisf.length, center);
                double[] diff = new double[vectorLength];
                for (int j = 0; j < thisf.length; ++j) {
                    Rn.subtract(diff, center, oldverts[ind[i][j]]);
                    Rn.times(diff, -implode, diff);
                    Rn.add(newverts[oldcount + count + j], oldverts[ind[i][j]], diff);
                }
                count += thisf.length;
            }
            IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
            ifsf.setVertexCount(vertcount + oldcount);
            ifsf.setFaceCount(vertcount);
            ifsf.setVertexCoordinates(newverts);
            ifsf.setFaceIndices((int[][])newind);
            ifsf.setGenerateFaceNormals(true);
            ifsf.setGenerateEdgesFromFaces(makeEdges);
            ifsf.update();
            imploded = ifsf.getIndexedFaceSet();
        }
        return imploded;
    }

    public static IndexedFaceSet removeTextureCoordinateJumps(IndexedFaceSet src, double jumpSize) {
        int np = src.getNumPoints();
        int nf = src.getNumFaces();
        double[][] textureCoords = src.getVertexAttributes(Attribute.TEXTURE_COORDINATES).toDoubleArrayArray(null);
        int[][] indices = src.getFaceAttributes(Attribute.INDICES).toIntArrayArray(null);
        int newVerts = 0;
        double[][][] minmax = new double[nf][][];
        boolean[][] textureJumps = new boolean[nf][2];
        for (int i = 0; i < nf; ++i) {
            minmax[i] = IndexedFaceSetUtility.getMinMax(indices[i], textureCoords);
            if (minmax[i][1][0] - minmax[i][0][0] > jumpSize) {
                textureJumps[i][0] = true;
            }
            if (minmax[i][1][1] - minmax[i][0][1] > jumpSize) {
                textureJumps[i][1] = true;
            }
            if (!textureJumps[i][0] && !textureJumps[i][1]) continue;
            newVerts += indices[i].length;
        }
        LoggingSystem.getLogger(GeometryUtility.class).log(Level.FINE, "Adding " + newVerts + " vertices");
        double[][] oldVerts = src.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
        double[][] on = null;
        double[][] nn = null;
        int nl = 0;
        if (src.getVertexAttributes(Attribute.NORMALS) != null) {
            on = src.getVertexAttributes(Attribute.NORMALS).toDoubleArrayArray(null);
            nl = on[0].length;
            nn = new double[newVerts + np][nl];
        }
        double[][] nverts = new double[newVerts + np][oldVerts[0].length];
        double[][] ntex = new double[newVerts + np][textureCoords[0].length];
        int l = oldVerts[0].length;
        for (int i = 0; i < np; ++i) {
            System.arraycopy(oldVerts[i], 0, nverts[i], 0, l);
            System.arraycopy(textureCoords[i], 0, ntex[i], 0, 2);
            if (on == null) continue;
            System.arraycopy(on[i], 0, nn[i], 0, nl);
        }
        int outcount = np;
        for (int i = 0; i < nf; ++i) {
            if (!textureJumps[i][0] && !textureJumps[i][1]) continue;
            LoggingSystem.getLogger(GeometryUtility.class).log(Level.INFO, "Face " + i);
            for (int j = 0; j < indices[i].length; ++j) {
                int which = indices[i][j];
                System.arraycopy(oldVerts[which], 0, nverts[outcount], 0, l);
                System.arraycopy(textureCoords[which], 0, ntex[outcount], 0, 2);
                if (on != null) {
                    System.arraycopy(on[which], 0, nn[outcount], 0, nl);
                }
                for (int k = 0; k < 2; ++k) {
                    if (!textureJumps[i][k]) continue;
                    if (ntex[outcount][k] < 0.5) {
                        double[] dArray = ntex[outcount];
                        int n = k;
                        dArray[n] = dArray[n] + 1.0;
                    }
                    LoggingSystem.getLogger(GeometryUtility.class).log(Level.INFO, "Setting texture coordinate to " + ntex[outcount][k] + "from " + textureCoords[which][k]);
                }
                indices[i][j] = outcount++;
            }
        }
        IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
        ifsf.setVertexCount(nverts.length);
        ifsf.setVertexCoordinates(nverts);
        ifsf.setFaceCount(indices.length);
        if (nn != null) {
            ifsf.setVertexNormals(nn);
        }
        ifsf.setVertexTextureCoordinates(ntex);
        ifsf.setFaceIndices(indices);
        if (src.getFaceAttributes(Attribute.NORMALS) != null) {
            ifsf.setFaceNormals(src.getFaceAttributes(Attribute.NORMALS));
        }
        if (src.getFaceAttributes(Attribute.COLORS) != null) {
            ifsf.setFaceColors(src.getFaceAttributes(Attribute.COLORS));
        }
        ifsf.update();
        return ifsf.getIndexedFaceSet();
    }

    public static IndexedFaceSet representAsSceneGraph(final IndexedFaceSet exists, Rectangle3D box) {
        if (exists == null) {
            return IndexedFaceSetUtility.representAsSceneGraph(box);
        }
        final double[][] verts = new double[8][3];
        double[][] bnds = box.getBounds();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    verts[4 * i + 2 * j + k][0] = bnds[i][0];
                    verts[4 * i + 2 * j + k][1] = bnds[j][1];
                    verts[4 * i + 2 * j + k][2] = bnds[k][2];
                }
            }
        }
        Scene.executeWriter(exists, new Runnable(){

            public void run() {
                exists.setVertexAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(3).createReadOnly(verts));
            }
        });
        return exists;
    }

    public static IndexedFaceSet representAsSceneGraph(Rectangle3D box) {
        double[][] verts = new double[8][3];
        double[][] bnds = box.getBounds();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    verts[4 * i + 2 * j + k][0] = bnds[i][0];
                    verts[4 * i + 2 * j + k][1] = bnds[j][1];
                    verts[4 * i + 2 * j + k][2] = bnds[k][2];
                }
            }
        }
        IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
        ifsf.setVertexCount(8);
        ifsf.setFaceCount(6);
        ifsf.setVertexCoordinates(verts);
        ifsf.setFaceIndices(boxIndices);
        ifsf.setGenerateEdgesFromFaces(true);
        ifsf.update();
        return ifsf.getIndexedFaceSet();
    }

    private static int rotationIndex(double[] normal, DoubleArray[] pts) {
        int i;
        int numPts = pts.length;
        double[] pt0 = pts[0].toDoubleArray(null);
        double[] pt1 = pts[1].toDoubleArray(null);
        double[] dir1 = Rn.subtract(null, pt1, pt0);
        Rn.normalize(dir1, dir1);
        double[] dir0 = new double[dir1.length];
        double angle = 0.0;
        for (i = 0; i < numPts; ++i) {
            double[] tmp = dir0;
            dir0 = dir1;
            pt0 = pts[(i + 1) % numPts].toDoubleArray(null);
            pt1 = pts[(i + 2) % numPts].toDoubleArray(null);
            dir1 = Rn.subtract(tmp, pt1, pt0);
            Rn.normalize(dir1, dir1);
            angle += Math.asin(Rn.innerProduct(normal, Rn.crossProduct(null, dir1, dir0)));
        }
        i = (int)Math.round(angle /= Math.PI * 2);
        return i;
    }

    public static IndexedFaceSet[] splitIfsToPrimitiveFaces(IndexedFaceSet ifs) {
        int num = ifs.getNumFaces();
        IndexedFaceSet[] parts = new IndexedFaceSet[num];
        for (int i = 0; i < num; ++i) {
            parts[i] = new IndexedFaceSet();
            parts[i].setNumFaces(1);
            parts[i].setNumPoints(ifs.getNumPoints());
            parts[i].setVertexAttributes(ifs.getVertexAttributes());
            int[][] oldIndizeesArray = null;
            String[] oldLabelsArray = null;
            double[][] oldNormalsArray = null;
            double[][] oldTextureCoordsArray = null;
            int[][] newIndizeesArray = new int[1][];
            String[] newLabelsArray = new String[1];
            double[][] newNormalsArray = new double[1][];
            double[][] newTextureCoordsArray = new double[1][];
            DataList temp = ifs.getFaceAttributes(Attribute.INDICES);
            if (temp != null) {
                oldIndizeesArray = temp.toIntArrayArray(null);
                newIndizeesArray[0] = oldIndizeesArray[i];
                parts[i].setFaceAttributes(Attribute.INDICES, new IntArrayArray.Array(newIndizeesArray));
            }
            if ((temp = ifs.getVertexAttributes(Attribute.LABELS)) != null) {
                oldLabelsArray = temp.toStringArray(null);
                newLabelsArray[0] = oldLabelsArray[i];
                parts[i].setFaceAttributes(Attribute.LABELS, new StringArray(newLabelsArray));
            }
            if ((temp = ifs.getVertexAttributes(Attribute.NORMALS)) != null) {
                oldNormalsArray = temp.toDoubleArrayArray(null);
                newNormalsArray[0] = oldNormalsArray[i];
                parts[i].setFaceAttributes(Attribute.NORMALS, new DoubleArrayArray.Array(newNormalsArray));
            }
            if ((temp = ifs.getFaceAttributes(Attribute.NORMALS)) != null) {
                oldNormalsArray = temp.toDoubleArrayArray(null);
                newNormalsArray[0] = oldNormalsArray[i];
                parts[i].setFaceAttributes(Attribute.NORMALS, new DoubleArrayArray.Array(newNormalsArray));
            }
            if ((temp = ifs.getVertexAttributes(Attribute.TEXTURE_COORDINATES)) == null) continue;
            oldTextureCoordsArray = temp.toDoubleArrayArray(null);
            newTextureCoordsArray[0] = oldTextureCoordsArray[i];
            parts[i].setFaceAttributes(Attribute.TEXTURE_COORDINATES, new DoubleArrayArray.Array(newTextureCoordsArray));
        }
        return parts;
    }

    @Deprecated
    public static IndexedFaceSet triangulate(IndexedFaceSet fs) {
        IndexedFaceSet ts = new IndexedFaceSet();
        DataListSet vertexData = fs.getVertexAttributes();
        ts.setVertexCountAndAttributes(vertexData);
        DataListSet edgeData = fs.getEdgeAttributes();
        ts.setEdgeCountAndAttributes(edgeData);
        int n = fs.getNumFaces();
        DataList faceDL = fs.getFaceAttributes(Attribute.INDICES);
        DataList pointDL = fs.getVertexAttributes(Attribute.COORDINATES);
        DataList fNormalDL = fs.getFaceAttributes(Attribute.NORMALS);
        if (fNormalDL == null) {
            double[][] fn = IndexedFaceSetUtility.calculateFaceNormals(fs);
            fNormalDL = StorageModel.DOUBLE_ARRAY_ARRAY.createReadOnly(fn);
        }
        ArrayList<int[]> triangles = new ArrayList<int[]>();
        for (int i = 0; i < n; ++i) {
            int numPts;
            int[] faceIndices = faceDL.item(i).toIntArray(null);
            DoubleArray[] pts = new DoubleArray[faceIndices.length];
            for (int j = 0; j < faceIndices.length; ++j) {
                pts[j] = pointDL.item(faceIndices[j]).toDoubleArray();
            }
            double[] normal = fNormalDL.item(i).toDoubleArray(null);
            int rotationIndex = IndexedFaceSetUtility.rotationIndex(normal = Rn.normalize(null, normal), pts);
            if (rotationIndex < 0) {
                Rn.times(normal, -1.0, normal);
            }
            int remainingPts = numPts = faceIndices.length;
            int first = 0;
            int second = 0;
            int third = 0;
            while (remainingPts > 3) {
                first %= numPts;
                while (pts[first] == null) {
                    first = (first + 1) % numPts;
                }
                second = (first + 1) % numPts;
                while (pts[second] == null) {
                    second = (second + 1) % numPts;
                }
                third = (second + 1) % numPts;
                while (pts[third] == null) {
                    third = (third + 1) % numPts;
                }
                double[] p1 = pts[first].toDoubleArray(null);
                double[] p2 = pts[second].toDoubleArray(null);
                double[] p3 = pts[third].toDoubleArray(null);
                double[] e1 = Rn.subtract(null, p2, p1);
                double[] e2 = Rn.subtract(null, p3, p2);
                double[] e3 = Rn.subtract(null, p1, p3);
                double[] cnormal = Rn.crossProduct(null, e2, e1);
                double d = Rn.innerProduct(normal, cnormal);
                if (Math.abs(d) < EPS) {
                    System.out.println("Warning degenerate triangle in triangulate... dropping " + second);
                    System.out.println(" ->" + first + " " + second + " " + third);
                    pts[second] = null;
                    --remainingPts;
                    first = second;
                    continue;
                }
                if (d < 0.0) {
                    ++first;
                    continue;
                }
                boolean allOutside = true;
                for (int k = 0; k < numPts; ++k) {
                    if (pts[k] == null || k == first || k == second || k == third) continue;
                    double[] p4 = pts[k].toDoubleArray(null);
                    double[] dir = Rn.subtract(null, p4, p1);
                    double s1 = Rn.innerProduct(normal, Rn.crossProduct(null, e1, dir));
                    dir = Rn.subtract(dir, p4, p2);
                    double s2 = Rn.innerProduct(normal, Rn.crossProduct(null, e2, dir));
                    dir = Rn.subtract(dir, p4, p3);
                    double s3 = Rn.innerProduct(normal, Rn.crossProduct(null, e3, dir));
                    if (!(s1 < 0.0) || !(s2 < 0.0) || !(s3 < 0.0)) continue;
                    allOutside = false;
                    break;
                }
                if (!allOutside) {
                    ++first;
                    continue;
                }
                triangles.add(new int[]{faceIndices[first], faceIndices[second], faceIndices[third]});
                pts[second] = null;
                --remainingPts;
                ++first;
            }
            while (pts[first] == null) {
                first = (first + 1) % numPts;
            }
            second = (first + 1) % numPts;
            while (pts[second] == null) {
                second = (second + 1) % numPts;
            }
            third = (second + 1) % numPts;
            while (pts[third] == null) {
                third = (third + 1) % numPts;
            }
            triangles.add(new int[]{faceIndices[first], faceIndices[second], faceIndices[third]});
        }
        Object faces = new int[triangles.size()][];
        faces = (int[][])triangles.toArray((T[])faces);
        ts.setFaceCountAndAttributes(Attribute.INDICES, StorageModel.INT_ARRAY_ARRAY.createReadOnly(faces));
        IndexedFaceSetUtility.calculateAndSetNormals(ts);
        return ts;
    }

    public static void simpleTriangulate(IndexedFaceSet ifs) {
        int triCount = 0;
        int n = ifs.getNumFaces();
        int[][] oldIndices = ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray(null);
        for (int i = 0; i < n; ++i) {
            if (oldIndices[i].length < 3) continue;
            triCount += oldIndices[i].length - 2;
        }
        int[][] newIndices = new int[triCount][3];
        triCount = 0;
        for (int i = 0; i < n; ++i) {
            int[] oldFace = oldIndices[i];
            if (oldFace.length < 3) continue;
            for (int j = 0; j < oldFace.length - 2; ++j) {
                newIndices[triCount][0] = oldFace[0];
                newIndices[triCount][1] = oldFace[j + 1];
                newIndices[triCount][2] = oldFace[j + 2];
                ++triCount;
            }
        }
        boolean hasFaceNormals = ifs.getFaceAttributes(Attribute.NORMALS) != null;
        ifs.setFaceCountAndAttributes(Attribute.INDICES, StorageModel.INT_ARRAY.array(3).createReadOnly(newIndices));
        if (ifs.getEdgeAttributes(Attribute.INDICES) != null) {
            IndexedFaceSetUtility.calculateAndSetEdgesFromFaces(ifs);
        }
        if (hasFaceNormals) {
            IndexedFaceSetUtility.calculateAndSetFaceNormals(ifs);
        }
    }

    public static IndexedFaceSet truncate(IndexedFaceSet ifs) {
        int vertcount = 0;
        int[][] ind = ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray().toIntArrayArray(null);
        for (int i = 0; i < ind.length; ++i) {
            vertcount += ind[i].length;
        }
        double[][] oldverts = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
        int vectorLength = oldverts[0].length;
        if (vectorLength != 3 && vectorLength != 4) {
            throw new IllegalArgumentException("Vector length must be 3 or 4");
        }
        double[][] oldverts3 = vectorLength == 4 ? Pn.dehomogenize((double[][])null, oldverts) : oldverts;
        vectorLength = 3;
        int[][] newind = new int[ind.length][];
        double[][] newverts = new double[vertcount][vectorLength];
        int count = 0;
        for (int i = 0; i < ind.length; ++i) {
            int[] thisf = ind[i];
            newind[i] = new int[thisf.length];
            for (int j = 0; j < thisf.length; ++j) {
                int k = (j + 1) % thisf.length;
                Rn.add(newverts[count + j], oldverts3[ind[i][j]], oldverts3[ind[i][k]]);
                Rn.times(newverts[count + j], 0.5, newverts[count + j]);
                newind[i][j] = count + j;
            }
            count += thisf.length;
        }
        double[][] fn = null;
        double[][] fc = null;
        if (ifs.getFaceAttributes(Attribute.NORMALS) != null) {
            fn = ifs.getFaceAttributes(Attribute.NORMALS).toDoubleArrayArray(null);
        }
        if (ifs.getFaceAttributes(Attribute.COLORS) != null) {
            fc = ifs.getFaceAttributes(Attribute.COLORS).toDoubleArrayArray(null);
        }
        IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
        ifsf.setVertexCount(vertcount);
        ifsf.setFaceCount(ind.length);
        ifsf.setVertexCoordinates(newverts);
        ifsf.setFaceIndices(newind);
        if (fn != null) {
            ifsf.setFaceNormals(fn);
        } else {
            ifsf.setGenerateFaceNormals(true);
        }
        if (fc != null) {
            ifsf.setFaceColors(fc);
        }
        ifsf.setGenerateEdgesFromFaces(true);
        ifsf.update();
        return ifsf.getIndexedFaceSet();
    }

    public static void assignVertexTangents(IndexedFaceSet ifs) {
        double[][] tangents = IndexedFaceSetUtility.calculateVertexTangents(ifs.getVertexAttributes(Attribute.TEXTURE_COORDINATES).toDoubleArrayArray(), ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(), ifs.getVertexAttributes(Attribute.NORMALS).toDoubleArrayArray(), ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray());
        ifs.setVertexAttributes(Attribute.attributeForName("TANGENTS"), new DoubleArrayArray.Array(tangents, 4));
    }

    public static double[][] calculateVertexTangents(DoubleArrayArray texCoords, DoubleArrayArray vertexCoordinates, DoubleArrayArray vertexNormals, IntArrayArray faceIndices) {
        double[][] ret = new double[texCoords.getLength()][4];
        double[][] tan1 = new double[texCoords.getLength()][3];
        double[][] tan2 = new double[texCoords.getLength()][3];
        for (int i = 0; i < faceIndices.getLength(); ++i) {
            IntArray face = faceIndices.getValueAt(i);
            int n = face.getLength() - 2;
            for (int j = 0; j < n; ++j) {
                int i1 = face.getValueAt(0);
                int i2 = face.getValueAt(j + 1);
                int i3 = face.getValueAt(j + 2);
                double[] v1 = vertexCoordinates.getValueAt(i1).toDoubleArray(null);
                double[] v2 = vertexCoordinates.getValueAt(i2).toDoubleArray(null);
                double[] v3 = vertexCoordinates.getValueAt(i3).toDoubleArray(null);
                double[] w1 = texCoords.getValueAt(i1).toDoubleArray(null);
                double[] w2 = texCoords.getValueAt(i2).toDoubleArray(null);
                double[] w3 = texCoords.getValueAt(i3).toDoubleArray(null);
                w1[1] = w1[1] * -1.0;
                w2[1] = w2[1] * -1.0;
                w3[1] = w3[1] * -1.0;
                double x1 = v2[0] - v1[0];
                double x2 = v3[0] - v1[0];
                double y1 = v2[1] - v1[1];
                double y2 = v3[1] - v1[1];
                double z1 = v2[2] - v1[2];
                double z2 = v3[2] - v1[2];
                double s1 = w2[0] - w1[0];
                double s2 = w3[0] - w1[0];
                double t1 = w2[1] - w1[1];
                double t2 = w3[1] - w1[1];
                double r = 1.0 / (s1 * t2 - s2 * t1);
                double[] sdir = new double[]{(t2 * x1 - t1 * x2) * r, (t2 * y1 - t1 * y2) * r, (t2 * z1 - t1 * z2) * r};
                double[] tdir = new double[]{(s1 * x2 - s2 * x1) * r, (s1 * y2 - s2 * y1) * r, (s1 * z2 - s2 * z1) * r};
                Rn.add(tan1[i1], tan1[i1], sdir);
                Rn.add(tan1[i2], tan1[i2], sdir);
                Rn.add(tan1[i3], tan1[i3], sdir);
                Rn.add(tan2[i1], tan2[i1], tdir);
                Rn.add(tan2[i2], tan2[i2], tdir);
                Rn.add(tan2[i3], tan2[i3], tdir);
            }
        }
        for (int a = 0; a < texCoords.getLength(); ++a) {
            double[] n = vertexNormals.getValueAt(a).toDoubleArray(null);
            double[] t = tan1[a];
            double l = Rn.innerProduct(n, t);
            ret[a][0] = t[0] - l * n[0];
            ret[a][1] = t[1] - l * n[1];
            ret[a][2] = t[2] - l * n[2];
            Rn.normalize(ret[a], ret[a]);
            ret[a][3] = Rn.innerProduct(Rn.crossProduct(null, n, t), tan2[a]) < 0.0 ? -1.0 : 1.0;
        }
        return ret;
    }

    public static void assignSmoothVertexNormals(IndexedFaceSet ifs, double maxAngle, int digits) {
        IndexedFaceSetUtility.assignSmoothVertexNormals(ifs, true, maxAngle, digits);
    }

    public static void assignSmoothVertexNormals(IndexedFaceSet ifs, int digits) {
        IndexedFaceSetUtility.assignSmoothVertexNormals(ifs, false, -1.0, digits);
    }

    private static void assignSmoothVertexNormals(IndexedFaceSet ifs, boolean flipNormals, double maxAngle, int digits) {
        double cos = Math.cos(maxAngle * Math.PI / 180.0);
        HashSet<Integer> written = new HashSet<Integer>();
        HashMap<Point, LinkedList<Integer>> table = new HashMap<Point, LinkedList<Integer>>(){

            @Override
            public LinkedList<Integer> get(Object key) {
                LinkedList ll = (LinkedList)super.get(key);
                if (ll == null) {
                    ll = new LinkedList();
                    super.put((Point)key, ll);
                }
                return ll;
            }
        };
        DoubleArrayArray points = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
        int n = points.getLength();
        for (int i = 0; i < n; ++i) {
            ((LinkedList)table.get(digits > 0 ? new Point(points.getValueAt(i), digits) : new Point(points.getValueAt(i)))).add(i);
        }
        if (ifs.getVertexAttributes(Attribute.NORMALS) == null) {
            IndexedFaceSetUtility.calculateAndSetVertexNormals(ifs);
        }
        DoubleArrayArray normals = ifs.getVertexAttributes(Attribute.NORMALS).toDoubleArrayArray();
        double[][] na = normals.toDoubleArrayArray(null);
        int total = 0;
        for (LinkedList inds : table.values()) {
            if (inds.size() == 1) continue;
            if (inds.size() > 2) {
                System.out.println(inds.size() + "-fold point");
            }
            LinkedList indices = inds;
            while (indices.size() > 1) {
                int cnt = 1;
                LinkedList remaining = new LinkedList();
                double[] n2 = normals.getValueAt((Integer)indices.get(0)).toDoubleArray(null);
                Rn.normalize(n2, n2);
                double[] target = (double[])n2.clone();
                LinkedList flips = new LinkedList();
                int m = indices.size();
                for (int j = 1; j < m; ++j) {
                    double[] n22 = normals.getValueAt((Integer)indices.get(j)).toDoubleArray(null);
                    Rn.normalize(n22, n22);
                    if (flipNormals && Rn.innerProduct(n2, n22) < 0.0) {
                        Rn.times(n22, -1.0, n22);
                        flips.add(indices.get(j));
                    }
                    if (flipNormals && Rn.innerProduct(n22, n2) < cos) {
                        remaining.add(indices.get(j));
                        continue;
                    }
                    Rn.add(target, target, n22);
                    ++cnt;
                    ++total;
                }
                Rn.normalize(target, target);
                Iterator i$ = indices.iterator();
                while (i$.hasNext()) {
                    int i = (Integer)i$.next();
                    if (remaining.contains(i)) continue;
                    if (flips.contains(i)) {
                        Rn.times(na[i], -1.0, target);
                    } else {
                        Rn.copy(na[i], target);
                    }
                    if (written.add(i)) continue;
                    throw new RuntimeException();
                }
                if (Rn.innerProduct(n2, target) < 0.0) {
                    throw new RuntimeException();
                }
                indices = remaining;
            }
        }
        ifs.setVertexAttributes(Attribute.NORMALS, new DoubleArrayArray.Array(na, na[0].length));
    }

    public static void triangulateBarycentric(IndexedFaceSet ifs) {
        int[][] f = ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray(null);
        DoubleArrayArray points = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray();
        LinkedList<double[]> barycenters = new LinkedList<double[]>();
        int pc = points.size();
        LinkedList faces = new LinkedList();
        LinkedList<int[]> tris = new LinkedList<int[]>();
        faces.addAll(Arrays.asList(f));
        int fiberLength = points.getLengthAt(0);
        double[] tmp = new double[fiberLength];
        for (int[] face : faces) {
            if (face.length == 3) {
                tris.add(face);
                continue;
            }
            double[] barycenter = new double[fiberLength];
            for (int i : face) {
                points.getValueAt(i).toDoubleArray(tmp);
                Rn.add(barycenter, barycenter, tmp);
            }
            Rn.times(barycenter, 1.0 / (double)face.length, barycenter);
            int n = face.length;
            for (int i = 0; i < n; ++i) {
                int[] tri = new int[]{pc + barycenters.size(), face[i], face[(i + 1) % n]};
                tris.add(tri);
            }
            barycenters.add(barycenter);
        }
        if (!barycenters.isEmpty()) {
            double[][] newPoints = points.toDoubleArrayArray(new double[pc + barycenters.size()][]);
            for (int i = pc; i < newPoints.length; ++i) {
                newPoints[i] = (double[])barycenters.removeFirst();
            }
            ifs.setVertexCountAndAttributes(Attribute.COORDINATES, new DoubleArrayArray.Array(newPoints));
        }
        if (tris.size() > faces.size()) {
            int[][] newFaces = (int[][])tris.toArray((T[])new int[0][]);
            ifs.setFaceCountAndAttributes(Attribute.INDICES, new IntArrayArray.Array(newFaces));
        }
        IndexedFaceSetUtility.calculateAndSetEdgesFromFaces(ifs);
    }

    public static IndexedFaceSet triangulateRectangularPatch(double[][][] levels) {
        double dTheta = 1.0 / (double)(levels.length - 1);
        LinkedList<double[]> points = new LinkedList<double[]>();
        LinkedList<double[]> texCoords = new LinkedList<double[]>();
        LinkedList<int[]> tris = new LinkedList<int[]>();
        LinkedList<Integer> associatedPoints = new LinkedList<Integer>();
        int lastCnt = 0;
        int lastIndex = 0;
        int i = 0;
        for (double[][] level : levels) {
            int cnt = level.length - 1;
            double theta = dTheta * (double)i;
            double dPhi = 1.0 / (double)cnt;
            for (int k = 0; k <= cnt; ++k) {
                texCoords.add(new double[]{theta, (double)k * dPhi});
            }
            associatedPoints.add(points.size());
            for (double[] p : level) {
                points.add(p);
            }
            associatedPoints.add(points.size() - 1);
            if (i > 0) {
                tris.addAll(IndexedFaceSetUtility.calculateTris(lastCnt, cnt, lastIndex, points.size() - cnt - 1));
            }
            ++i;
            lastCnt = cnt;
            lastIndex = points.size() - cnt - 1;
        }
        IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
        ifsf.setVertexCount(points.size());
        ifsf.setFaceCount(tris.size());
        ifsf.setGenerateVertexNormals(true);
        ifsf.setGenerateFaceNormals(true);
        ifsf.setVertexCoordinates((double[][])points.toArray((T[])new double[0][]));
        ifsf.setVertexTextureCoordinates((double[][])texCoords.toArray((T[])new double[0][]));
        ifsf.setFaceIndices((int[][])tris.toArray((T[])new int[0][]));
        ifsf.update();
        double[][] normals = ifsf.getIndexedFaceSet().getVertexAttributes(Attribute.NORMALS).toDoubleArrayArray(null);
        while (!associatedPoints.isEmpty()) {
            int p1 = (Integer)associatedPoints.removeFirst();
            int p2 = (Integer)associatedPoints.removeFirst();
            normals[p2] = Rn.times(normals[p1], 0.5, Rn.add(normals[p1], normals[p1], normals[p2]));
            normals[p1] = normals[p2];
        }
        ifsf.getIndexedFaceSet().setVertexAttributes(Attribute.NORMALS, new DoubleArrayArray.Array(normals));
        return ifsf.getIndexedFaceSet();
    }

    private static List<int[]> calculateTris(int cntInner, int cntOuter, int iInner, int iOuter) {
        LinkedList<int[]> tris;
        block3: {
            int i = 0;
            int j = 0;
            double phi1 = 0.0;
            double phi2 = 0.0;
            double dp1 = Math.PI * 2 / (double)cntInner;
            double dp2 = Math.PI * 2 / (double)cntOuter;
            tris = new LinkedList<int[]>();
            do {
                if (Math.abs(phi1 + dp1 - phi2) > Math.abs(phi2 + dp2 - phi1)) {
                    tris.add(new int[]{iInner + i, iOuter + j, iOuter + j + 1});
                    ++j;
                    phi2 += dp2;
                } else {
                    tris.add(new int[]{iInner + i, iOuter + j, iInner + i + 1});
                    ++i;
                    phi1 += dp1;
                }
                if (i != cntInner || j != cntOuter - 1) continue;
                tris.add(new int[]{iInner + i, iOuter + j, iOuter + j + 1});
                break block3;
            } while (j != cntOuter || i != cntInner - 1);
            tris.add(new int[]{iInner + i, iOuter + j, iInner + i + 1});
        }
        return tris;
    }

    public static boolean makeConsistentOrientation(IndexedFaceSet ifs) {
        int[][] fIndis = ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray(null);
        if (fIndis == null) {
            return false;
        }
        int numV = ifs.getNumPoints();
        if (IndexedFaceSetUtility._makeConsistentOrientation(numV, fIndis)) {
            ifs.setFaceAttributes(Attribute.INDICES, new IntArrayArray.Array(fIndis));
            return true;
        }
        return false;
    }

    private static int[][] collectVertxFaces(int numV, int[][] faces) {
        int i;
        Object[] a = new Object[numV];
        for (i = 0; i < numV; ++i) {
            a[i] = new LinkedList();
        }
        for (i = 0; i < faces.length; ++i) {
            int[] face = faces[i];
            for (int j = 0; j < face.length; ++j) {
                ((LinkedList)a[face[j]]).add(i);
            }
        }
        int[][] facesOfVert = new int[numV][];
        for (int i2 = 0; i2 < numV; ++i2) {
            LinkedList list = (LinkedList)a[i2];
            int len = list.size();
            int l = 0;
            facesOfVert[i2] = new int[len];
            for (Integer in : list) {
                facesOfVert[i2][l] = in;
                ++l;
            }
        }
        return facesOfVert;
    }

    private static boolean _makeConsistentOrientation(int numVertices, int[][] faces) {
        int numV = numVertices;
        int numF = faces.length;
        int[][] facesOfVert = IndexedFaceSetUtility.collectVertxFaces(numV, faces);
        boolean[] doneFace = new boolean[numF];
        for (int i = 0; i < numF; ++i) {
            doneFace[i] = false;
        }
        boolean[] unfinishedFace = new boolean[numF];
        for (int i = 0; i < numF; ++i) {
            unfinishedFace[i] = false;
        }
        int numDone = 0;
        int numUnf = 0;
        while (numDone < numF) {
            unfinishedFace[IndexedFaceSetUtility.getFirst((boolean[])doneFace, (boolean)false)] = true;
            ++numUnf;
            while (numUnf > 0) {
                ++numDone;
                int currNum = IndexedFaceSetUtility.getFirst(unfinishedFace, true);
                int[] currFace = faces[currNum];
                int len = currFace.length;
                unfinishedFace[currNum] = false;
                --numUnf;
                doneFace[currNum] = true;
                for (int i = 0; i < len; ++i) {
                    int p1 = currFace[i];
                    int p2 = currFace[(i + 1) % len];
                    List<Integer> neighbor = IndexedFaceSetUtility.getTouchingFaces(p1, p2, facesOfVert, currNum);
                    if (neighbor.size() < 1) continue;
                    if (neighbor.size() > 1) {
                        return false;
                    }
                    int neighb = neighbor.get(0);
                    boolean welloriented = IndexedFaceSetUtility.haveSameOrientation(p1, p2, currFace, faces[neighb]);
                    if (!welloriented) {
                        if (doneFace[neighb] | unfinishedFace[neighb]) {
                            return false;
                        }
                        IndexedFaceSetUtility.invertOrientation(faces[neighb]);
                        unfinishedFace[neighb] = true;
                        ++numUnf;
                        continue;
                    }
                    if (doneFace[neighb] | unfinishedFace[neighb]) continue;
                    unfinishedFace[neighb] = true;
                    ++numUnf;
                }
            }
        }
        return true;
    }

    private static int getFirst(boolean[] done, boolean searchFor) {
        for (int i = 0; i < done.length; ++i) {
            if (done[i] != searchFor) continue;
            return i;
        }
        return -1;
    }

    private static List<Integer> getTouchingFaces(int p1, int p2, int[][] facesOfVerts, int me) {
        int[] faces1 = facesOfVerts[p1];
        int[] faces2 = facesOfVerts[p2];
        LinkedList<Integer> facesInBoth = new LinkedList<Integer>();
        for (int i = 0; i < faces1.length; ++i) {
            for (int j = 0; j < faces2.length; ++j) {
                if (faces1[i] != faces2[j] || faces1[i] == me) continue;
                facesInBoth.add(faces1[i]);
            }
        }
        return facesInBoth;
    }

    private static void invertOrientation(int[] face) {
        int[] result = new int[face.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = face[face.length - i - 1];
        }
        System.arraycopy(result, 0, face, 0, face.length);
    }

    private static boolean haveSameOrientation(int p1, int p2, int[] face1, int[] face2) {
        boolean orient2;
        boolean orient1 = IndexedFaceSetUtility.posOrientatet(p1, p2, face1);
        return orient1 == (orient2 = IndexedFaceSetUtility.posOrientatet(p2, p1, face2));
    }

    private static boolean posOrientatet(int p1, int p2, int[] face) {
        for (int i = 0; i < face.length; ++i) {
            if (face[i] != p1) continue;
            return i + 1 < face.length ? face[i + 1] == p2 : face[0] == p2;
        }
        return false;
    }

    public static SceneGraphComponent displayFaceNormals(IndexedFaceSet ifs, double scale, int metric) {
        SceneGraphComponent sgc = new SceneGraphComponent("displayFaceNormals()");
        System.err.println("display face normals metric = " + metric);
        Appearance ap = new Appearance();
        ap.setAttribute("showLines", true);
        ap.setAttribute("lineShader.tubeDraw", false);
        ap.setAttribute("showFaces", false);
        ap.setAttribute("showPoints", false);
        sgc.setAppearance(ap);
        int[][] faces = ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray(null);
        int n = faces.length;
        int[][] edges = new int[n][2];
        double[][] verts = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
        int fiberlength = verts[0].length;
        double[][] normals = null;
        double[][] nvectors = new double[2 * n][fiberlength];
        normals = ifs.getFaceAttributes(Attribute.NORMALS) != null ? ifs.getFaceAttributes(Attribute.NORMALS).toDoubleArrayArray(null) : IndexedFaceSetUtility.calculateFaceNormals(ifs);
        for (int i = 0; i < n; ++i) {
            for (int k = 0; k < faces[i].length; ++k) {
                Rn.add(nvectors[i], verts[faces[i][k]], nvectors[i]);
            }
            double xx = 1.0 / (double)faces[i].length;
            if (metric == 0) {
                Rn.times(nvectors[i], xx, nvectors[i]);
                Rn.add(nvectors[i + n], nvectors[i], Rn.times(null, scale, normals[i]));
            } else {
                Pn.dragTowards(nvectors[i + n], nvectors[i], normals[i], scale, metric);
            }
            if (fiberlength == 4) {
                if (metric == 0) {
                    nvectors[i + n][3] = 1.0;
                } else {
                    Pn.dehomogenize(nvectors[i + n], nvectors[i + n]);
                }
            }
            edges[i][0] = i;
            edges[i][1] = i + n;
        }
        IndexedLineSetFactory ilsf = new IndexedLineSetFactory();
        ilsf.setVertexCount(2 * n);
        ilsf.setVertexCoordinates(nvectors);
        ilsf.setEdgeCount(n);
        ilsf.setEdgeIndices(edges);
        ilsf.update();
        sgc.setGeometry(ilsf.getIndexedLineSet());
        return sgc;
    }

    public static void calculateAndSetFaceNormals(IndexedFaceSet ifs) {
        Object sigO = ifs.getGeometryAttributes(GeometryUtility.METRIC);
        int sig = 0;
        if (sigO != null && sigO instanceof Integer) {
            sig = (Integer)sigO;
            LoggingSystem.getLogger(GeometryUtility.class).log(Level.FINER, "Calculating normals with metric " + sig);
        }
        IndexedFaceSetUtility.calculateAndSetFaceNormals(ifs, sig);
    }

    public static void calculateAndSetFaceNormals(IndexedFaceSet ifs, int metric) {
        if (ifs.getNumFaces() == 0) {
            return;
        }
        double[][] fn = IndexedFaceSetUtility.calculateFaceNormals(ifs, metric);
        ifs.setFaceAttributes(Attribute.NORMALS, null);
        ifs.setFaceAttributes(Attribute.NORMALS, StorageModel.DOUBLE_ARRAY.array(fn[0].length).createReadOnly(fn));
    }

    public static void calculateAndSetNormals(IndexedFaceSet ifs) {
        IndexedFaceSetUtility.calculateAndSetFaceNormals(ifs);
        IndexedFaceSetUtility.calculateAndSetVertexNormals(ifs);
    }

    public static void calculateAndSetVertexNormals(IndexedFaceSet ifs) {
        if (ifs.getNumFaces() == 0) {
            return;
        }
        double[][] vn = IndexedFaceSetUtility.calculateVertexNormals(ifs);
        ifs.setVertexAttributes(Attribute.NORMALS, StorageModel.DOUBLE_ARRAY.array(vn[0].length).createReadOnly(vn));
    }

    public static double[][] calculateFaceNormals(IndexedFaceSet ifs) {
        Object sigO = ifs.getGeometryAttributes(GeometryUtility.METRIC);
        int sig = 0;
        if (sigO != null && sigO instanceof Integer) {
            sig = (Integer)sigO;
            LoggingSystem.getLogger(GeometryUtility.class).log(Level.FINER, "Calculating normals with metric " + sig);
        }
        return IndexedFaceSetUtility.calculateFaceNormals(ifs, sig);
    }

    public static double[][] calculateFaceNormals(IndexedFaceSet ifs, int metric) {
        int[][] indices = ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray(null);
        double[][] verts = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
        return IndexedFaceSetUtility.calculateFaceNormals(indices, verts, metric);
    }

    public static double[][] calculateFaceNormals(int[][] indices, double[][] verts, int metric) {
        if (indices == null) {
            return null;
        }
        int normalLength = 4;
        if (metric == 0) {
            normalLength = 3;
        }
        double[][] fn = new double[indices.length][normalLength];
        if (metric == 0 && verts[0].length == 4) {
            Pn.dehomogenize(verts, verts);
        }
        for (int i = 0; i < indices.length; ++i) {
            int n = indices[i].length;
            if (n < 3) continue;
            if (metric == 0) {
                int count = 1;
                double[] v1 = null;
                while (Rn.euclideanNorm(v1 = Rn.subtract(null, verts[indices[i][count++]], verts[indices[i][0]])) < 1.0E-15 && count < n - 1) {
                }
                double[] v2 = null;
                while (Rn.euclideanNorm(v2 = Rn.subtract(null, verts[indices[i][count++]], verts[indices[i][0]])) < 1.0E-15 && count < n) {
                }
                if (count > n) continue;
                Rn.crossProduct(fn[i], v1, v2);
                Rn.normalize(fn[i], fn[i]);
                continue;
            }
            double[] osculatingPlane = P3.planeFromPoints(null, verts[indices[i][0]], verts[indices[i][1]], verts[indices[i][2]]);
            double[] normal = Pn.polarizePlane(null, osculatingPlane, metric);
            Pn.setToLength(normal, normal, -1.0, metric);
            for (int j = 0; j < 3; ++j) {
                double[] point = verts[indices[i][j]].length == 3 ? Pn.homogenize(null, verts[indices[i][j]]) : verts[indices[i][j]];
            }
            System.arraycopy(normal, 0, fn[i], 0, normalLength);
        }
        return fn;
    }

    public static void calculateFaceNormals(SceneGraphComponent c) {
        final HashMap map = new HashMap();
        SceneGraphVisitor v = new SceneGraphVisitor(){

            public void visit(IndexedFaceSet i) {
                if (i.getFaceAttributes(Attribute.NORMALS) == null) {
                    double[][] n = IndexedFaceSetUtility.calculateFaceNormals(i);
                    map.put(i, n);
                }
                super.visit(i);
            }

            public void visit(SceneGraphComponent c) {
                c.childrenAccept(this);
            }
        };
        v.visit(c);
        Set keys = map.keySet();
        for (IndexedFaceSet i : keys) {
            double[][] n = (double[][])map.get(i);
            int nLength = n[0].length;
            i.setFaceAttributes(Attribute.NORMALS, StorageModel.DOUBLE_ARRAY.array(nLength).createWritableDataList(n));
        }
    }

    public static double[][] calculateVertexNormals(IndexedFaceSet ifs) {
        Object sigO = ifs.getGeometryAttributes(GeometryUtility.METRIC);
        int sig = 0;
        if (sigO != null && sigO instanceof Integer) {
            sig = (Integer)sigO;
        }
        return IndexedFaceSetUtility.calculateVertexNormals(ifs, sig);
    }

    public static double[][] calculateVertexNormals(IndexedFaceSet ifs, int metric) {
        int[][] indices = ifs.getFaceAttributes(Attribute.INDICES).toIntArrayArray(null);
        if (indices == null) {
            return null;
        }
        double[][] fn = null;
        fn = ifs.getFaceAttributes(Attribute.NORMALS) == null ? IndexedFaceSetUtility.calculateFaceNormals(ifs, metric) : ifs.getFaceAttributes(Attribute.NORMALS).toDoubleArrayArray(null);
        double[][] vertsAs2D = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
        return IndexedFaceSetUtility.calculateVertexNormals(indices, vertsAs2D, fn, metric);
    }

    public static double[][] calculateVertexNormals(int[][] indices, double[][] vertsAs2D, double[][] fn, int metric) {
        int n = fn[0].length;
        double[][] nvn = new double[vertsAs2D.length][n];
        for (int j = 0; j < indices.length; ++j) {
            for (int k = 0; k < indices[j].length; ++k) {
                int m = indices[j][k];
                Rn.add(nvn[m], fn[j], nvn[m]);
            }
        }
        if (metric == 0) {
            Rn.normalize(nvn, nvn);
        } else {
            Pn.normalize(nvn, nvn, metric);
        }
        return nvn;
    }

    public static void calculateVertexNormals(SceneGraphComponent c) {
        final HashMap map = new HashMap();
        SceneGraphVisitor v = new SceneGraphVisitor(){

            public void visit(IndexedFaceSet i) {
                if (i.getVertexAttributes(Attribute.NORMALS) == null) {
                    double[][] n = IndexedFaceSetUtility.calculateVertexNormals(i);
                    map.put(i, n);
                }
                super.visit(i);
            }

            public void visit(SceneGraphComponent c) {
                c.childrenAccept(this);
            }
        };
        v.visit(c);
        Set keys = map.keySet();
        for (IndexedFaceSet i : keys) {
            double[][] n = (double[][])map.get(i);
            int nLength = n[0].length;
            i.setVertexAttributes(Attribute.NORMALS, StorageModel.DOUBLE_ARRAY.array(nLength).createWritableDataList(n));
        }
    }

    private static class Point {
        double x;
        double y;
        double z;
        double w;

        Point(DoubleArray da, int digits) {
            double r = Math.pow(10.0, digits);
            this.x = (double)Math.round(r * da.getValueAt(0)) / r;
            this.y = (double)Math.round(r * da.getValueAt(1)) / r;
            this.z = (double)Math.round(r * da.getValueAt(2)) / r;
            if (da.getLength() > 3) {
                this.w = (double)Math.round(r * da.getValueAt(3)) / r;
            }
        }

        Point(DoubleArray da) {
            this.x = da.getValueAt(0);
            this.y = da.getValueAt(1);
            this.z = da.getValueAt(2);
            if (da.getLength() > 3) {
                this.w = da.getValueAt(3);
            }
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            long temp = Double.doubleToLongBits(this.w);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.x);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.y);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.z);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Point other = (Point)obj;
            if (Double.doubleToLongBits(this.w) != Double.doubleToLongBits(other.w)) {
                return false;
            }
            if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
                return false;
            }
            if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
                return false;
            }
            return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
        }
    }

    private static final class Pair {
        final int l;
        final int h;

        Pair(int a, int b) {
            if (a <= b) {
                this.l = a;
                this.h = b;
            } else {
                this.h = a;
                this.l = b;
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            try {
                Pair p = (Pair)obj;
                return this.l == p.l && this.h == p.h;
            }
            catch (ClassCastException ex) {
                return false;
            }
        }

        public int hashCode() {
            return this.l << 16 ^ this.h;
        }
    }
}

