/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.math.Matrix;
import de.jreality.math.P3;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DataListSet;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.data.StorageModel;
import de.jreality.shader.DefaultGeometryShader;
import de.jreality.shader.DefaultLineShader;
import de.jreality.shader.DefaultPointShader;
import de.jreality.shader.DefaultPolygonShader;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.shader.ShaderUtility;
import de.jreality.util.CopyVisitor;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeometryMergeFactory {
    private boolean respectFaces = true;
    private boolean respectEdges = true;
    private boolean respectVertices = true;
    private boolean respectFacesIntern = true;
    private boolean respectEdgesIntern = true;
    private boolean respectVerticesIntern = true;
    private boolean generateFaceNormals = true;
    private boolean generateVertexNormals = true;
    private boolean hasFaceColors = true;
    private boolean hasVertexColors = true;
    private boolean hasEdgeColors = true;
    private List<Attribute> defaultFaceAttributes = new LinkedList<Attribute>();
    private List<List<double[]>> defaultFaceAttributeValues = new LinkedList<List<double[]>>();
    private List<Attribute> defaultEdgeAttributes = new LinkedList<Attribute>();
    private List<List<double[]>> defaultEdgeAttributeValues = new LinkedList<List<double[]>>();
    private List<Attribute> defaultVertexAttributes = new LinkedList<Attribute>();
    private List<List<double[]>> defaultVertexAttributeValues = new LinkedList<List<double[]>>();
    private final int FACE_ATTR = 2;
    private final int EDGE_ATTR = 1;
    private final int VERT_ATTR = 0;
    private List<Attribute> importantFaceDefaultAttributes = new LinkedList<Attribute>();
    private List<Attribute> importantEdgeDefaultAttributes = new LinkedList<Attribute>();
    private List<Attribute> importantVertexDefaultAttributes = new LinkedList<Attribute>();
    private static DefaultGeometryShader dgs;
    private static DefaultPolygonShader dps;
    private static DefaultLineShader dls;
    private static DefaultPointShader dvs;

    public GeometryMergeFactory() {
        this.importantFaceDefaultAttributes.add(Attribute.COLORS);
        this.importantEdgeDefaultAttributes.add(Attribute.COLORS);
        this.importantVertexDefaultAttributes.add(Attribute.COLORS);
    }

    private static List<Attribute> collectAttributes(List<List<Attribute>> atLists, List<Attribute> defAtt, List<Attribute> impAtt) {
        LinkedList<Attribute> badDefaults = new LinkedList<Attribute>();
        if (defAtt != null) {
            for (Attribute defa : defAtt) {
                boolean hit = false;
                for (List<Attribute> list : atLists) {
                    if (!list.contains(defa)) continue;
                    hit = true;
                }
                if (hit) continue;
                badDefaults.add(defa);
            }
        }
        LinkedList<Attribute> goodAttr = new LinkedList<Attribute>();
        List<Object> firstList = new LinkedList();
        if (atLists.size() > 0) {
            firstList = atLists.get(0);
        }
        for (Attribute firstA : firstList) {
            boolean hitAll = true;
            if (atLists != null) {
                for (List<Attribute> list : atLists) {
                    boolean hit = false;
                    if (list != null) {
                        if (list.contains(firstA)) {
                            hit = true;
                        }
                    } else {
                        hitAll = false;
                    }
                    if (hit) continue;
                    hitAll = false;
                    break;
                }
            } else {
                hitAll = false;
            }
            if (!hitAll) continue;
            goodAttr.add(firstA);
        }
        if (defAtt != null) {
            for (Attribute dAt : defAtt) {
                boolean isIn = false;
                if (goodAttr.contains(dAt)) {
                    isIn = true;
                    break;
                }
                if (isIn) continue;
                goodAttr.add(dAt);
            }
        }
        for (Attribute bad : badDefaults) {
            goodAttr.remove(bad);
        }
        for (Attribute imp : impAtt) {
            if (goodAttr.contains(imp) || !defAtt.contains(imp)) continue;
            goodAttr.add(imp);
        }
        return goodAttr;
    }

    private void mergeDoubleArrayArrayAttributes(PointSet result, List<Attribute> defaultAttributes, List<List<double[]>> defaultAttributeValues, List<Attribute> impAtts, DataListSet[] dls, int typ) {
        LinkedList<List<Attribute>> Atts = new LinkedList<List<Attribute>>();
        for (int i = 0; i < dls.length; ++i) {
            if (dls[i] == null || dls[i].getListLength() <= 0) continue;
            Object[] o = dls[i].storedAttributes().toArray();
            LinkedList<Attribute> list = new LinkedList<Attribute>();
            if (o != null) {
                for (Object oo : o) {
                    list.add((Attribute)oo);
                }
            }
            Atts.add(list);
        }
        List<Attribute> Attr = GeometryMergeFactory.collectAttributes(Atts, defaultAttributes, impAtts);
        for (Attribute at : Attr) {
            try {
                DoubleArrayArray.Array dataList;
                int k = -1;
                if (defaultAttributes != null) {
                    k = defaultAttributes.indexOf(at);
                }
                if ((dataList = k >= 0 ? new DoubleArrayArray.Array(GeometryMergeFactory.mergeDoubleArrayArrayAttribute(dls, at, defaultAttributeValues.get(k))) : new DoubleArrayArray.Array(GeometryMergeFactory.mergeDoubleArrayArrayAttribute(dls, at, null))) == null) continue;
                if (typ == 0) {
                    if (result.getVertexAttributes().getListLength() == 0) {
                        result.setVertexCountAndAttributes(at, dataList);
                    } else {
                        result.setVertexAttributes(at, dataList);
                    }
                }
                if (typ == 1) {
                    ((IndexedLineSet)result).setEdgeAttributes(at, dataList);
                }
                if (typ != 2) continue;
                ((IndexedFaceSet)result).setFaceAttributes(at, dataList);
            }
            catch (Exception e) {}
        }
    }

    private static double[][] mergeDoubleArrayArrayAttribute(DataListSet[] list, Attribute attr, List<double[]> defaults) {
        int totalLen = 0;
        for (int i = 0; i < list.length; ++i) {
            totalLen += list[i].getListLength();
        }
        double[][] result = new double[totalLen][];
        int n = 0;
        for (int i = 0; i < list.length; ++i) {
            Object values;
            if (list[i].getListLength() <= 0) continue;
            if (list[i].getList(attr) == null && (defaults == null || defaults.size() == 0)) {
                return null;
            }
            DataList l = list[i].getList(attr);
            if (l == null) {
                values = new double[list[i].getListLength()][];
                double[] d = defaults.size() > i ? defaults.get(i) : defaults.get(0);
                for (int j = 0; j < ((double[][])values).length; ++j) {
                    values[j] = d;
                }
            } else {
                if (!(l instanceof DoubleArrayArray)) {
                    return null;
                }
                values = l.toDoubleArrayArray(null);
            }
            System.arraycopy(values, 0, result, n, ((double[][])values).length);
            n += list[i].getListLength();
        }
        return result;
    }

    private static int[][] mergeIntArrayArrayAttribute(DataListSet[] dls, Attribute attr) {
        int totalLen = 0;
        for (int i = 0; i < dls.length; ++i) {
            if (dls[i] == null) continue;
            totalLen += dls[i].getListLength();
        }
        int[][] result = new int[totalLen][];
        int n = 0;
        for (int i = 0; i < dls.length; ++i) {
            if (dls[i] == null || dls[i].getList(attr) == null) continue;
            int[][] values = dls[i].getList(attr).toIntArrayArray(null);
            System.arraycopy(values, 0, result, n, values.length);
            n += dls[i].getListLength();
        }
        return result;
    }

    private void assignTransformation(IndexedFaceSet ifs, double[] matrix) {
        double[] flipit = P3.makeStretchMatrix(null, new double[]{-1.0, 0.0, -1.0, 0.0, -1.0});
        if (ifs.getVertexAttributes(Attribute.COORDINATES) == null) {
            return;
        }
        double[][] v = ifs.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
        double[][] nv = Rn.matrixTimesVector((double[][])null, matrix, v);
        ifs.setVertexAttributes(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(nv[0].length).createWritableDataList(nv));
        double[] mat = Rn.transpose(null, matrix);
        mat[14] = 0.0;
        mat[13] = 0.0;
        mat[12] = 0.0;
        Rn.inverse(mat, mat);
        if (this.respectFacesIntern && ifs.getNumFaces() > 0) {
            if (ifs.getFaceAttributes(Attribute.NORMALS) != null) {
                v = ifs.getFaceAttributes(Attribute.NORMALS).toDoubleArrayArray(null);
                nv = Rn.matrixTimesVector((double[][])null, mat, v);
                if (Rn.determinant(matrix) < 0.0) {
                    nv = Rn.matrixTimesVector((double[][])null, flipit, nv);
                }
                ifs.setFaceAttributes(Attribute.NORMALS, StorageModel.DOUBLE_ARRAY.array(nv[0].length).createWritableDataList(nv));
            } else if (this.generateFaceNormals) {
                IndexedFaceSetUtility.calculateAndSetFaceNormals(ifs);
            }
        }
        if (this.respectVerticesIntern && ifs.getNumPoints() > 0) {
            if (ifs.getVertexAttributes(Attribute.NORMALS) != null) {
                v = ifs.getVertexAttributes(Attribute.NORMALS).toDoubleArrayArray(null);
                nv = Rn.matrixTimesVector((double[][])null, mat, v);
                if (Rn.determinant(matrix) < 0.0) {
                    nv = Rn.matrixTimesVector((double[][])null, flipit, nv);
                }
                ifs.setVertexAttributes(Attribute.NORMALS, StorageModel.DOUBLE_ARRAY.array(nv[0].length).createWritableDataList(nv));
            } else if (this.generateVertexNormals) {
                IndexedFaceSetUtility.calculateAndSetVertexNormals(ifs);
                if (!this.defaultVertexAttributes.contains(Attribute.NORMALS)) {
                    this.defaultVertexAttributes.add(Attribute.NORMALS);
                    LinkedList<double[]> zeroNormals = new LinkedList<double[]>();
                    zeroNormals.add(new double[]{0.0, 0.0, 0.0});
                    this.defaultVertexAttributeValues.add(zeroNormals);
                }
            }
        }
    }

    private void collectMergeData(List<IndexedFaceSet> g, List<double[]> tra, List<double[]> fCol, List<double[]> eCol, List<double[]> vCol, SceneGraphComponent cmp, SceneGraphPath p, EffectiveAppearance parentEA) {
        Appearance app = cmp.getAppearance();
        EffectiveAppearance eApp = parentEA;
        if (app != null) {
            eApp = parentEA.create(app);
        }
        p.push(cmp);
        GeometryMergeFactory.updateShaders(eApp);
        Geometry myG = cmp.getGeometry();
        if (myG != null && myG instanceof PointSet) {
            Color c;
            IndexedFaceSet myface;
            PointSet myPs = (PointSet)myG;
            if (myPs instanceof IndexedLineSet) {
                IndexedLineSet myLSet = (IndexedLineSet)myPs;
                myface = myPs instanceof IndexedFaceSet ? (IndexedFaceSet)myPs : GeometryMergeFactory.indexedLineSetToIndexedFaceSet(myLSet);
            } else {
                myface = GeometryMergeFactory.pointSetToIndexedFaceSet(myPs);
            }
            g.add(myface);
            this.checkColorNeed(eApp, myface);
            Color Mycol = dps.getDiffuseColor();
            fCol.add(new double[]{(double)Mycol.getRed() / 255.0, (double)Mycol.getGreen() / 255.0, (double)Mycol.getBlue() / 255.0, (double)Mycol.getAlpha() / 255.0});
            Mycol = dls.getDiffuseColor();
            if (dls.getTubeDraw().booleanValue()) {
                try {
                    c = ((DefaultPolygonShader)dls.getPolygonShader()).getDiffuseColor();
                    if (c != null) {
                        Mycol = c;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            eCol.add(new double[]{(double)Mycol.getRed() / 255.0, (double)Mycol.getGreen() / 255.0, (double)Mycol.getBlue() / 255.0, (double)Mycol.getAlpha() / 255.0});
            Mycol = dvs.getDiffuseColor();
            if (dvs.getSpheresDraw().booleanValue()) {
                try {
                    c = ((DefaultPolygonShader)dvs.getPolygonShader()).getDiffuseColor();
                    if (c != null) {
                        Mycol = c;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            vCol.add(new double[]{(double)Mycol.getRed() / 255.0, (double)Mycol.getGreen() / 255.0, (double)Mycol.getBlue() / 255.0, (double)Mycol.getAlpha() / 255.0});
            double[] mat = p.getMatrix(new Matrix().getArray());
            tra.add(mat);
        }
        for (SceneGraphComponent child : cmp.getChildComponents()) {
            this.collectMergeData(g, tra, fCol, eCol, vCol, child, p, eApp);
        }
        p.pop();
    }

    private static void updateShaders(EffectiveAppearance eap) {
        dgs = ShaderUtility.createDefaultGeometryShader(eap);
        dvs = dgs.getPointShader() instanceof DefaultPointShader ? (DefaultPointShader)dgs.getPointShader() : null;
        dls = dgs.getLineShader() instanceof DefaultLineShader ? (DefaultLineShader)dgs.getLineShader() : null;
        dps = dgs.getPolygonShader() instanceof DefaultPolygonShader ? (DefaultPolygonShader)dgs.getPolygonShader() : null;
    }

    private void checkColorNeed(EffectiveAppearance eApp, IndexedFaceSet ifs) {
        if (eApp.getAttribute("diffuseColor", Appearance.INHERITED) != Appearance.INHERITED) {
            this.hasEdgeColors = true;
            this.hasFaceColors = true;
            this.hasVertexColors = true;
        }
        if (eApp.getAttribute("polygonShader.diffuseColor", Appearance.INHERITED) != Appearance.INHERITED) {
            this.hasFaceColors = true;
        }
        if (eApp.getAttribute("lineShader.diffuseColor", Appearance.INHERITED) != Appearance.INHERITED || eApp.getAttribute("lineShader.polygonShader.diffuseColor", Appearance.INHERITED) != Appearance.INHERITED) {
            this.hasEdgeColors = true;
        }
        if (eApp.getAttribute("vertexShader.diffuseColor", Appearance.INHERITED) != Appearance.INHERITED || eApp.getAttribute("vertexShader.polygonShader.diffuseColor", Appearance.INHERITED) != Appearance.INHERITED) {
            this.hasVertexColors = true;
        }
        if (ifs.getVertexAttributes(Attribute.COLORS) != null) {
            this.hasVertexColors = true;
        }
        if (ifs.getEdgeAttributes(Attribute.COLORS) != null) {
            this.hasEdgeColors = true;
        }
        if (ifs.getFaceAttributes(Attribute.COLORS) != null) {
            this.hasFaceColors = true;
        }
    }

    public IndexedFaceSet mergeGeometrySets(SceneGraphComponent cmp) {
        Appearance app = cmp.getAppearance();
        if (app == null) {
            app = new Appearance();
        }
        EffectiveAppearance eApp = EffectiveAppearance.create();
        eApp = eApp.create(app);
        LinkedList<IndexedFaceSet> geos = new LinkedList<IndexedFaceSet>();
        LinkedList<double[]> fCol = new LinkedList<double[]>();
        LinkedList<double[]> eCol = new LinkedList<double[]>();
        LinkedList<double[]> vCol = new LinkedList<double[]>();
        LinkedList<double[]> trafos = new LinkedList<double[]>();
        this.hasEdgeColors = false;
        this.hasFaceColors = false;
        this.hasVertexColors = false;
        this.collectMergeData(geos, trafos, fCol, eCol, vCol, cmp, new SceneGraphPath(), eApp);
        int num = geos.size();
        PointSet[] faces = new IndexedFaceSet[num];
        int i = 0;
        Iterator iter = geos.iterator();
        while (iter.hasNext()) {
            faces[i] = (IndexedFaceSet)iter.next();
            CopyVisitor cv = new CopyVisitor();
            cv.visit(faces[i]);
            faces[i] = (IndexedFaceSet)cv.getCopy();
            ++i;
        }
        i = 0;
        for (double[] m : trafos) {
            this.assignTransformation(faces[i], m);
            ++i;
        }
        IndexedFaceSet f = new IndexedFaceSet();
        if (this.hasFaceColors && this.respectFacesIntern) {
            if (!this.defaultFaceAttributes.contains(Attribute.COLORS)) {
                this.defaultFaceAttributes.add(Attribute.COLORS);
                this.defaultFaceAttributeValues.add(fCol);
            } else {
                this.defaultFaceAttributeValues.set(this.defaultFaceAttributes.indexOf(Attribute.COLORS), fCol);
            }
        }
        if (this.hasEdgeColors && this.respectEdgesIntern) {
            if (!this.defaultEdgeAttributes.contains(Attribute.COLORS)) {
                this.defaultEdgeAttributes.add(Attribute.COLORS);
                this.defaultEdgeAttributeValues.add(eCol);
            } else {
                this.defaultEdgeAttributeValues.set(this.defaultEdgeAttributes.indexOf(Attribute.COLORS), eCol);
            }
        }
        if (this.hasVertexColors) {
            if (!this.defaultVertexAttributes.contains(Attribute.COLORS)) {
                this.defaultVertexAttributes.add(Attribute.COLORS);
                this.defaultVertexAttributeValues.add(vCol);
            } else {
                this.defaultVertexAttributeValues.set(this.defaultVertexAttributes.indexOf(Attribute.COLORS), vCol);
            }
        }
        f = this.mergeIndexedFaceSets(faces);
        return f;
    }

    public IndexedFaceSet mergeIndexedFaceSets(PointSet[] geo) {
        int j;
        int f;
        int i;
        int k;
        int n;
        if (geo == null) {
            return null;
        }
        if (geo.length == 0) {
            return null;
        }
        IndexedFaceSet[] ifs = new IndexedFaceSet[geo.length];
        for (int i2 = 0; i2 < geo.length; ++i2) {
            ifs[i2] = GeometryMergeFactory.pointSetToIndexedFaceSet(geo[i2]);
            if (this.generateFaceNormals && ifs[i2].getNumFaces() > 0 && ifs[i2].getVertexAttributes(Attribute.NORMALS) == null) {
                IndexedFaceSetUtility.calculateAndSetFaceNormals(ifs[i2]);
            }
            if (!this.generateFaceNormals || ifs[i2].getNumFaces() <= 0 || ifs[i2].getFaceAttributes(Attribute.NORMALS) != null) continue;
            IndexedFaceSetUtility.calculateAndSetVertexNormals(ifs[i2]);
        }
        GeometryMergeFactory.indexedFaceSetTo4DColorNormalsAndCoords(ifs);
        IndexedFaceSet result = new IndexedFaceSet();
        DataListSet[] faceDls = new DataListSet[ifs.length];
        DataListSet[] edgeDls = new DataListSet[ifs.length];
        DataListSet[] vertDls = new DataListSet[ifs.length];
        if (this.respectFacesIntern) {
            for (int j2 = 0; j2 < faceDls.length; ++j2) {
                faceDls[j2] = ifs[j2].getFaceAttributes();
            }
            int[][] faceIndices = GeometryMergeFactory.mergeIntArrayArrayAttribute(faceDls, Attribute.INDICES);
            n = ifs[0].getNumPoints();
            k = ifs[0].getNumFaces();
            for (i = 1; i < ifs.length; ++i) {
                for (f = 0; f < ifs[i].getNumFaces(); ++f) {
                    int[] face = faceIndices[k];
                    j = 0;
                    while (j < face.length) {
                        int n2 = j++;
                        face[n2] = face[n2] + n;
                    }
                    ++k;
                }
                n += ifs[i].getNumPoints();
            }
            if (faceIndices == null) {
                this.respectFacesIntern = false;
            } else {
                result.setFaceCountAndAttributes(Attribute.INDICES, new IntArrayArray.Array(faceIndices));
            }
        }
        if (this.respectEdgesIntern) {
            for (int j3 = 0; j3 < edgeDls.length; ++j3) {
                edgeDls[j3] = ifs[j3].getEdgeAttributes();
            }
            int[][] edgeIndices = GeometryMergeFactory.mergeIntArrayArrayAttribute(edgeDls, Attribute.INDICES);
            n = ifs[0].getNumPoints();
            k = ifs[0].getNumEdges();
            for (i = 1; i < ifs.length; ++i) {
                for (f = 0; f < ifs[i].getNumEdges(); ++f) {
                    int[] edge = edgeIndices[k];
                    j = 0;
                    while (j < edge.length) {
                        int n3 = j++;
                        edge[n3] = edge[n3] + n;
                    }
                    ++k;
                }
                n += ifs[i].getNumPoints();
            }
            if (edgeIndices == null) {
                this.respectEdgesIntern = false;
            } else {
                result.setEdgeCountAndAttributes(Attribute.INDICES, new IntArrayArray.Array(edgeIndices));
            }
        }
        for (int j4 = 0; j4 < vertDls.length; ++j4) {
            vertDls[j4] = ifs[j4].getVertexAttributes();
        }
        this.mergeDoubleArrayArrayAttributes(result, this.defaultVertexAttributes, this.defaultVertexAttributeValues, this.importantVertexDefaultAttributes, vertDls, 0);
        if (this.respectEdgesIntern) {
            this.mergeDoubleArrayArrayAttributes(result, this.defaultEdgeAttributes, this.defaultEdgeAttributeValues, this.importantEdgeDefaultAttributes, edgeDls, 1);
        }
        if (this.respectFacesIntern) {
            this.mergeDoubleArrayArrayAttributes(result, this.defaultFaceAttributes, this.defaultFaceAttributeValues, this.importantFaceDefaultAttributes, faceDls, 2);
        }
        this.respectEdgesIntern = this.respectEdges;
        this.respectFacesIntern = this.respectFaces;
        return result;
    }

    public IndexedLineSet mergeIndexedLineSets(IndexedLineSet[] ils) {
        this.respectFacesIntern = false;
        IndexedFaceSet f = this.mergeIndexedFaceSets(ils);
        IndexedLineSet l = GeometryMergeFactory.indexedFaceSetToIndexedLineSet(f);
        return l;
    }

    public PointSet mergePointSets(PointSet[] ps) {
        this.respectFacesIntern = false;
        this.respectEdgesIntern = false;
        IndexedFaceSet f = this.mergeIndexedFaceSets(ps);
        PointSet p = GeometryMergeFactory.indexedFaceSetToPointSet(f);
        return p;
    }

    public IndexedFaceSet mergeIndexedFaceSets(SceneGraphComponent cmp) {
        IndexedFaceSet f = this.mergeGeometrySets(cmp);
        return f;
    }

    public IndexedLineSet mergeIndexedLineSets(SceneGraphComponent cmp) {
        this.respectFacesIntern = false;
        IndexedLineSet l = GeometryMergeFactory.indexedFaceSetToIndexedLineSet(this.mergeGeometrySets(cmp));
        return l;
    }

    public PointSet mergePointSets(SceneGraphComponent cmp) {
        this.respectFacesIntern = false;
        this.respectEdgesIntern = false;
        PointSet p = GeometryMergeFactory.indexedFaceSetToPointSet(this.mergeGeometrySets(cmp));
        return p;
    }

    public void setDefaultFaceAttributes(List<Attribute> defaultAttributes, List<List<double[]>> defaultAttributeValues) {
        this.defaultFaceAttributeValues = defaultAttributeValues;
        this.defaultFaceAttributes = defaultAttributes;
    }

    public void setDefaultEdgeAttributes(List<Attribute> defaultAttributes, List<List<double[]>> defaultAttributeValues) {
        this.defaultFaceAttributeValues = defaultAttributeValues;
        this.defaultFaceAttributes = defaultAttributes;
    }

    public void setDefaultVertexAttributes(List<Attribute> defaultAttributes, List<List<double[]>> defaultAttributeValues) {
        this.defaultFaceAttributeValues = defaultAttributeValues;
        this.defaultFaceAttributes = defaultAttributes;
    }

    public void setImportantFaceDefaultAttributes(List<Attribute> importantFaceDefaultAttributes) {
        this.importantFaceDefaultAttributes = importantFaceDefaultAttributes;
    }

    public void setImportantEdgeDefaultAttributes(List<Attribute> importantEdgeDefaultAttributes) {
        this.importantEdgeDefaultAttributes = importantEdgeDefaultAttributes;
    }

    public void setImportantVertexDefaultAttributes(List<Attribute> importantVertexDefaultAttributes) {
        this.importantVertexDefaultAttributes = importantVertexDefaultAttributes;
    }

    public void setGenerateFaceNormals(boolean generateFaceNormals) {
        this.generateFaceNormals = generateFaceNormals;
    }

    public void setGenerateVertexNormals(boolean generateVertexNormals) {
        this.generateVertexNormals = generateVertexNormals;
    }

    public void setRespectEdges(boolean respectEdges) {
        this.respectEdges = respectEdges;
        this.respectEdgesIntern = respectEdges;
    }

    public void setRespectFaces(boolean respectFaces) {
        this.respectFaces = respectFaces;
        this.respectFacesIntern = respectFaces;
    }

    public void setRespectVertices(boolean respectVertices) {
        this.respectVertices = respectVertices;
        this.respectVerticesIntern = respectVertices;
    }

    public List<Attribute> getDefaultEdgeAttributes() {
        return this.defaultEdgeAttributes;
    }

    public List<List<double[]>> getDefaultEdgeAttributeValues() {
        return this.defaultEdgeAttributeValues;
    }

    public List<Attribute> getDefaultFaceAttributes() {
        return this.defaultFaceAttributes;
    }

    public List<List<double[]>> getDefaultFaceAttributeValues() {
        return this.defaultFaceAttributeValues;
    }

    public List<Attribute> getDefaultVertexAttributes() {
        return this.defaultVertexAttributes;
    }

    public List<List<double[]>> getDefaultVertexAttributeValues() {
        return this.defaultVertexAttributeValues;
    }

    public List<Attribute> getImportantFaceDefaultAttributes() {
        return this.importantFaceDefaultAttributes;
    }

    public List<Attribute> getImportantEdgeDefaultAttributes() {
        return this.importantEdgeDefaultAttributes;
    }

    public List<Attribute> getImportantVertexDefaultAttributes() {
        return this.importantVertexDefaultAttributes;
    }

    public boolean isGenerateFaceNormals() {
        return this.generateFaceNormals;
    }

    public boolean isGenerateVertexNormals() {
        return this.generateVertexNormals;
    }

    public boolean isRespectEdges() {
        return this.respectEdges;
    }

    public boolean isRespectFaces() {
        return this.respectFaces;
    }

    public boolean isRespectVertices() {
        return this.respectVertices;
    }

    private static void indexedFaceSetTo4DColorNormalsAndCoords(IndexedFaceSet[] list) {
        for (IndexedFaceSet ifs : list) {
            double[][] ds;
            DataList d = ifs.getFaceAttributes(Attribute.NORMALS);
            d = ifs.getFaceAttributes(Attribute.COLORS);
            if (d != null) {
                ds = d.toDoubleArrayArray(null);
                GeometryMergeFactory.equalizeTo4D(ds);
                ifs.setFaceAttributes(Attribute.COLORS, null);
                ifs.setFaceAttributes(Attribute.COLORS, new DoubleArrayArray.Array(ds));
            }
            if ((d = ifs.getEdgeAttributes(Attribute.COLORS)) != null) {
                ds = d.toDoubleArrayArray(null);
                GeometryMergeFactory.equalizeTo4D(ds);
                ifs.setEdgeAttributes(Attribute.COLORS, null);
                ifs.setEdgeAttributes(Attribute.COLORS, new DoubleArrayArray.Array(ds));
            }
            if ((d = ifs.getVertexAttributes(Attribute.COLORS)) != null) {
                ds = d.toDoubleArrayArray(null);
                GeometryMergeFactory.equalizeTo4D(ds);
                ifs.setVertexAttributes(Attribute.COLORS, null);
                ifs.setVertexAttributes(Attribute.COLORS, new DoubleArrayArray.Array(ds));
            }
            if ((d = ifs.getVertexAttributes(Attribute.COORDINATES)) == null) continue;
            ds = d.toDoubleArrayArray(null);
            GeometryMergeFactory.equalizeTo4D(ds);
            ifs.setVertexAttributes(Attribute.COORDINATES, null);
            ifs.setVertexAttributes(Attribute.COORDINATES, new DoubleArrayArray.Array(ds));
        }
    }

    private static void equalizeTo4D(double[][] d) {
        for (int i = 0; i < d.length; ++i) {
            if (d[i].length != 3) continue;
            d[i] = new double[]{d[i][0], d[i][1], d[i][2], 1.0};
        }
    }

    private static PointSet indexedLineSetToPointSet(IndexedLineSet l) {
        PointSet p = new PointSet(l.getNumPoints());
        p.setGeometryAttributes(l.getGeometryAttributes());
        p.setVertexAttributes(l.getVertexAttributes());
        return p;
    }

    private static IndexedLineSet pointSetToIndexedLineSet(PointSet p) {
        if (p instanceof IndexedLineSet) {
            return (IndexedLineSet)p;
        }
        IndexedLineSet l = new IndexedLineSet(p.getNumPoints(), 0);
        l.setGeometryAttributes(p.getGeometryAttributes());
        l.setVertexAttributes(p.getVertexAttributes());
        return l;
    }

    private static PointSet indexedFaceSetToPointSet(IndexedFaceSet f) {
        PointSet p = new PointSet(f.getNumPoints());
        p.setGeometryAttributes(f.getGeometryAttributes());
        p.setVertexAttributes(f.getVertexAttributes());
        return p;
    }

    private static IndexedLineSet indexedFaceSetToIndexedLineSet(IndexedFaceSet f) {
        IndexedLineSet l = new IndexedLineSet(f.getNumPoints(), f.getNumEdges());
        l.setGeometryAttributes(f.getGeometryAttributes());
        l.setVertexAttributes(f.getVertexAttributes());
        l.setEdgeAttributes(f.getEdgeAttributes());
        return l;
    }

    private static IndexedFaceSet indexedLineSetToIndexedFaceSet(IndexedLineSet l) {
        if (l instanceof IndexedFaceSet) {
            return (IndexedFaceSet)l;
        }
        IndexedFaceSet f = new IndexedFaceSet(l.getNumPoints(), 0);
        f.setGeometryAttributes(l.getGeometryAttributes());
        f.setVertexAttributes(l.getVertexAttributes());
        f.setEdgeCountAndAttributes(l.getEdgeAttributes());
        return f;
    }

    private static IndexedFaceSet pointSetToIndexedFaceSet(PointSet p) {
        if (p instanceof IndexedFaceSet) {
            return (IndexedFaceSet)p;
        }
        if (p instanceof IndexedLineSet) {
            return GeometryMergeFactory.indexedLineSetToIndexedFaceSet((IndexedLineSet)p);
        }
        IndexedFaceSet f = new IndexedFaceSet(p.getNumPoints(), 0);
        f.setGeometryAttributes(p.getGeometryAttributes());
        f.setVertexAttributes(p.getVertexAttributes());
        return f;
    }
}

