/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.AbstractGeometryFactory;
import de.jreality.geometry.OoNode;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DataListSet;
import de.jreality.scene.data.WritableDataList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class GeometryAttributeListSet {
    final AbstractGeometryFactory factory;
    final DataListSet DLS = new DataListSet(0);
    final HashMap attributeNode = new HashMap();
    private final HashSet<Attribute> blockAttribute = new HashSet();
    final String category;
    boolean blockAllAttributes = false;
    boolean blockAttributeCount = false;

    GeometryAttributeListSet(AbstractGeometryFactory factory, String cathegory) {
        this.factory = factory;
        this.category = cathegory;
    }

    int noa() {
        return this.DLS.getListLength();
    }

    int getCount() {
        return this.noa();
    }

    void setCount(int count) {
        if (count == this.noa()) {
            return;
        }
        if (this.blockAttributeCount) {
            throw new UnsupportedOperationException("The current state does not allow to change the count of the attribute category " + this.category);
        }
        this.DLS.reset(count);
    }

    private OoNode geometryAttributeNode(Map attributeNode, Attribute attr) {
        if (attributeNode.containsKey(attr)) {
            return (OoNode)attributeNode.get(attr);
        }
        OoNode node = this.factory.node(this.category + "." + attr);
        attributeNode.put(attr, node);
        return node;
    }

    OoNode attributeNode(Attribute attr) {
        return this.geometryAttributeNode(this.attributeNode, attr);
    }

    void updateAttributes() {
        for (Attribute attr : this.DLS.storedAttributes()) {
            this.attributeNode(attr).update();
        }
    }

    void setAttribute(Attribute attr, DataList data) {
        if (this.isBlockedAttribute(attr)) {
            throw new UnsupportedOperationException("cannot set attribute " + attr);
        }
        GeometryAttributeListSet.setAttrImpl(this.DLS, attr, data);
        this.attributeNode(attr).setObject(data);
    }

    boolean isBlockedAttribute(Attribute attr) {
        return this.blockAllAttributes || this.blockAttribute.contains(attr);
    }

    void setAttributes(DataListSet dls) {
        for (Attribute attr : dls.storedAttributes()) {
            if (!this.isBlockedAttribute(attr)) continue;
            throw new UnsupportedOperationException("cannot set attribute " + attr);
        }
        this.setAttrImpl(this.DLS, dls);
        for (Attribute attr : dls.storedAttributes()) {
            this.attributeNode(attr).setObject(this.DLS.getList(attr));
        }
    }

    final void setAttrImpl(DataListSet target, DataListSet data) {
        if (target.getListLength() != data.getListLength()) {
            target.reset(data.getListLength());
        }
        for (Attribute a : data.storedAttributes()) {
            GeometryAttributeListSet.setAttrImpl(target, a, data.getList(a));
        }
    }

    static final void setAttrImpl(DataListSet target, Attribute a, DataList d) {
        if (d == null) {
            target.remove(a);
        } else {
            WritableDataList w = target.getWritableList(a);
            if (w == null || a == Attribute.INDICES) {
                w = target.addWritable(a, d.getStorageModel());
            }
            d.copyTo(w);
        }
    }

    public void blockAttribute(Attribute attr) {
        this.blockAttribute.add(attr);
    }

    public void unblockAttribute(Attribute attr) {
        this.blockAttribute.remove(attr);
    }

    public boolean isBlockAllAttributes() {
        return this.blockAllAttributes;
    }

    public void setBlockAllAttributes(boolean blockAllAttributes) {
        this.blockAllAttributes = blockAllAttributes;
    }

    public boolean isBlockAttributeCount() {
        return this.blockAttributeCount;
    }

    public void setBlockAttributeCount(boolean blockAttributeCount) {
        this.blockAttributeCount = blockAttributeCount;
    }

    public boolean hasEntries() {
        return this.DLS.getNumAttributes() != 0;
    }
}

