/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.IndexedFaceSetFactory;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DataListSet;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.IntArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FatIndexedFaceSetFactory {
    private IndexedFaceSet inputIFS;
    private List<int[]> boundaryIndices = new ArrayList<int[]>();
    private double fatness = 0.05;
    private boolean generateBoundaryIndices = false;
    private final IndexedFaceSet topIFS;
    private final IndexedFaceSet bottomIFS;
    private final List<IndexedFaceSet> boundaryIFSs = new ArrayList<IndexedFaceSet>();
    private final IndexedFaceSetFactory topIFSF = new IndexedFaceSetFactory();
    private final IndexedFaceSetFactory bottomIFSF = new IndexedFaceSetFactory();
    private final List<IndexedFaceSetFactory> boundaryIFSFs = new ArrayList<IndexedFaceSetFactory>();
    private final SceneGraphComponent compoundSGC = new SceneGraphComponent();
    private final SceneGraphComponent topSGC = new SceneGraphComponent();
    private final SceneGraphComponent bottomSGC = new SceneGraphComponent();
    private final List<SceneGraphComponent> boundarySGCs = new ArrayList<SceneGraphComponent>();

    public FatIndexedFaceSetFactory() {
        this.topIFS = this.topIFSF.getIndexedFaceSet();
        this.topSGC.setGeometry(this.topIFS);
        this.bottomIFS = this.bottomIFSF.getIndexedFaceSet();
        this.bottomSGC.setGeometry(this.bottomIFS);
        this.compoundSGC.addChild(this.topSGC);
        this.compoundSGC.addChild(this.bottomSGC);
    }

    public IndexedFaceSet getInputIFS() {
        return this.inputIFS;
    }

    public void setInputIFS(IndexedFaceSet inputIFS) {
        this.inputIFS = inputIFS;
        this.compoundSGC.setName("fat " + inputIFS.getName());
        this.topIFS.setName("Top(" + inputIFS.getName() + ")");
        this.topSGC.setName(this.topIFS.getName());
        this.bottomIFS.setName("Bottom(" + inputIFS.getName() + ")");
        this.bottomSGC.setName(this.bottomIFS.getName());
    }

    public double getFatness() {
        return 2.0 * this.fatness;
    }

    public void setFatness(double fatness) {
        this.fatness = fatness / 2.0;
    }

    public boolean isGenerateBoundaryIndices() {
        return this.generateBoundaryIndices;
    }

    public void setGenerateBoundaryIndices(boolean generateBoundaryIndices) {
        this.generateBoundaryIndices = generateBoundaryIndices;
    }

    public List<int[]> getBoundaryIndices() {
        return this.boundaryIndices == null ? null : Collections.unmodifiableList(this.boundaryIndices);
    }

    public void setBoundaryIndices(List<int[]> boundaryIndices) {
        if (this.generateBoundaryIndices) {
            throw new IllegalStateException("You can not set the boundary indices when boundary indices are to be generated.");
        }
        this.setBoundaryIndicesImpl(boundaryIndices);
    }

    private void setBoundaryIndicesImpl(List<int[]> boundaryIndices) {
        if (this.boundaryIndices == boundaryIndices) {
            return;
        }
        boolean nbOfComponentsChanged = this.boundaryIndices == null || boundaryIndices == null || this.boundaryIndices.size() != boundaryIndices.size();
        this.boundaryIndices = boundaryIndices;
        if (nbOfComponentsChanged) {
            this.boundaryIFSs.clear();
            this.boundaryIFSFs.clear();
            for (SceneGraphComponent sgc : this.boundarySGCs) {
                this.compoundSGC.removeChild(sgc);
            }
            this.boundarySGCs.clear();
        }
        if (boundaryIndices == null) {
            return;
        }
        for (int i = 0; i < boundaryIndices.size(); ++i) {
            SceneGraphComponent sgc;
            IndexedFaceSet ifs;
            if (nbOfComponentsChanged) {
                IndexedFaceSetFactory ifsf = new IndexedFaceSetFactory();
                ifs = ifsf.getIndexedFaceSet();
                sgc = new SceneGraphComponent();
                this.boundaryIFSFs.add(ifsf);
                this.boundaryIFSs.add(ifs);
                this.compoundSGC.addChild(sgc);
                this.boundarySGCs.add(sgc);
                ifsf.setGenerateVertexNormals(true);
                sgc.setGeometry(ifs);
            } else {
                ifs = this.boundaryIFSs.get(i);
                sgc = this.boundarySGCs.get(i);
            }
            ifs.setName("Boundary(" + this.inputIFS.getName() + ")[" + i + "]");
            sgc.setName(ifs.getName());
        }
    }

    public void initBoundary(int expectedNbOfBoundaryComponents) {
        this.setBoundaryIndicesImpl(Arrays.asList(new int[expectedNbOfBoundaryComponents][]));
    }

    public IndexedFaceSet getTopIFS() {
        return this.topIFS;
    }

    public IndexedFaceSet getBottomIFS() {
        return this.bottomIFS;
    }

    public List<IndexedFaceSet> getBoundaryIFSs() {
        return this.boundaryIFSs;
    }

    public IndexedFaceSetFactory getTopIFSF() {
        return this.topIFSF;
    }

    public IndexedFaceSetFactory getBottomIFSF() {
        return this.bottomIFSF;
    }

    public List<IndexedFaceSetFactory> getBoundaryIFSFs() {
        return this.boundaryIFSFs;
    }

    public SceneGraphComponent getTopSGC() {
        return this.topSGC;
    }

    public SceneGraphComponent getBottomSGC() {
        return this.bottomSGC;
    }

    public List<SceneGraphComponent> getBoundarySGCs() {
        return this.boundarySGCs;
    }

    public SceneGraphComponent getAllInOneSceneGraphComponent() {
        return this.compoundSGC;
    }

    public void update() {
        if (this.inputIFS == null) {
            throw new UnsupportedOperationException("The input IndexedFaceSet needs to be set first.");
        }
        if (this.inputIFS.getFaceAttributes(Attribute.INDICES) == null) {
            throw new UnsupportedOperationException("The input IndexedFaceSet has no faces.");
        }
        if (this.inputIFS.getVertexAttributes(Attribute.NORMALS) == null) {
            throw new UnsupportedOperationException("The input IndexedFaceSet has no VertexNormals.");
        }
        this.updateImpl();
    }

    private void updateImpl() {
        this.copyAllAttributes(this.inputIFS, this.topIFSF, true, true, true);
        this.copyAllAttributes(this.inputIFS, this.bottomIFSF, true, true, true);
        this.setWithFlippedNormalsAndFaces();
        this.setMovedVertices(this.topIFSF, this.fatness);
        this.setMovedVertices(this.bottomIFSF, -this.fatness);
        this.topIFSF.update();
        this.bottomIFSF.update();
        if (this.generateBoundaryIndices) {
            this.generateBoundaryIndices();
        }
        if (this.boundaryIndices != null) {
            this.updateBoundaryFaces();
        }
        for (IndexedFaceSetFactory ifsf : this.boundaryIFSFs) {
            ifsf.update();
        }
    }

    private void copyAllAttributes(IndexedFaceSet from, IndexedFaceSetFactory to, boolean vertices, boolean edges, boolean faces) {
        if (vertices) {
            to.setVertexCount(from.getNumPoints());
            to.setVertexAttributes(from.getVertexAttributes());
        }
        if (faces) {
            to.setFaceCount(from.getNumFaces());
            to.setFaceAttributes(from.getFaceAttributes());
        }
        if (edges) {
            to.setEdgeCount(from.getNumEdges());
            DataListSet edgeAttributes = from.getEdgeAttributes();
            if (edgeAttributes != null) {
                for (Attribute attribute : edgeAttributes.storedAttributes()) {
                    to.setEdgeAttribute(attribute, from.getEdgeAttributes(attribute));
                }
            }
        }
    }

    private void setWithFlippedNormalsAndFaces() {
        double[][] normals = this.inputIFS.getVertexAttributes(Attribute.NORMALS).toDoubleArrayArray(null);
        for (int i = 0; i < normals.length; ++i) {
            for (int j = 0; j < normals[i].length; ++j) {
                normals[i][j] = -normals[i][j];
            }
        }
        this.bottomIFSF.setVertexNormals(normals);
        int[][] fIndices = this.inputIFS.getFaceAttributes(Attribute.INDICES).toIntArrayArray(null);
        for (int i = 0; i < fIndices.length; ++i) {
            for (int j = 0; j < fIndices[i].length / 2; ++j) {
                int d = fIndices[i][fIndices[i].length - 1 - j];
                fIndices[i][fIndices[i].length - 1 - j] = fIndices[i][j];
                fIndices[i][j] = d;
            }
        }
        this.bottomIFSF.setFaceIndices(fIndices);
    }

    private void setMovedVertices(IndexedFaceSetFactory ifsf, double epsilon) {
        double[][] coordinates = this.inputIFS.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
        DataList normals = this.inputIFS.getVertexAttributes(Attribute.NORMALS);
        for (int i = 0; i < coordinates.length; ++i) {
            DoubleArray normal = normals.item(i).toDoubleArray();
            for (int j = 0; j < coordinates[i].length; ++j) {
                coordinates[i][j] = coordinates[i][j] + epsilon * normal.getValueAt(j);
            }
        }
        ifsf.setVertexCoordinates(coordinates);
    }

    private void updateBoundaryFaces() {
        DataList topVertices = this.topIFS.getVertexAttributes(Attribute.COORDINATES);
        DataList bottomVertices = this.bottomIFS.getVertexAttributes(Attribute.COORDINATES);
        for (int i = 0; i < this.boundaryIndices.size(); ++i) {
            int[] bComp = this.boundaryIndices.get(i);
            IndexedFaceSetFactory ifsf = this.boundaryIFSFs.get(i);
            double[][] vertices = new double[2 * bComp.length][];
            int[][] faces = new int[bComp.length - 1][4];
            vertices[0] = topVertices.item(bComp[0]).toDoubleArray().toDoubleArray(null);
            vertices[bComp.length] = bottomVertices.item(bComp[0]).toDoubleArray().toDoubleArray(null);
            for (int j = 0; j < bComp.length - 1; ++j) {
                vertices[j + 1] = topVertices.item(bComp[j + 1]).toDoubleArray().toDoubleArray(null);
                vertices[j + bComp.length + 1] = bottomVertices.item(bComp[j + 1]).toDoubleArray().toDoubleArray(null);
                faces[j][0] = j + 1;
                faces[j][1] = j;
                faces[j][2] = bComp.length + j;
                faces[j][3] = bComp.length + j + 1;
            }
            ifsf.setVertexCount(vertices.length);
            ifsf.setVertexCoordinates(vertices);
            ifsf.setFaceCount(faces.length);
            ifsf.setFaceIndices(faces);
        }
    }

    private void generateBoundaryIndices() {
        Vector edgesAtVertex = new Vector(this.inputIFS.getNumPoints() + 1);
        edgesAtVertex.setSize(this.inputIFS.getNumPoints() + 1);
        boolean[] isOnlyOuterBoundaryVertex = new boolean[this.inputIFS.getNumPoints() + 1];
        Arrays.fill(isOnlyOuterBoundaryVertex, true);
        DataList faces = this.inputIFS.getFaceAttributes(Attribute.INDICES);
        for (int i = 0; i < faces.size(); ++i) {
            IntArray face = faces.item(i).toIntArray();
            for (int j = 0; j < face.getLength(); ++j) {
                int vertex1 = face.getValueAt(j) + 1;
                int vertex2 = face.getValueAt((j + 1) % face.getLength()) + 1;
                List<Integer> adjacentVertices = (LinkedList<Integer>)edgesAtVertex.get(vertex1);
                if (adjacentVertices == null) {
                    adjacentVertices = new LinkedList<Integer>();
                    edgesAtVertex.set(vertex1, adjacentVertices);
                }
                if (adjacentVertices.contains(-vertex2)) {
                    adjacentVertices.remove((Object)(-vertex2));
                    if (adjacentVertices.isEmpty()) {
                        edgesAtVertex.set(vertex1, null);
                    }
                    isOnlyOuterBoundaryVertex[vertex1] = false;
                } else {
                    adjacentVertices.add(vertex2);
                }
                adjacentVertices = (List)edgesAtVertex.get(vertex2);
                if (adjacentVertices == null) {
                    adjacentVertices = new LinkedList();
                    edgesAtVertex.set(vertex2, adjacentVertices);
                }
                if (adjacentVertices.contains(vertex1)) {
                    adjacentVertices.remove((Object)vertex1);
                    if (adjacentVertices.isEmpty()) {
                        edgesAtVertex.set(vertex2, null);
                    }
                    isOnlyOuterBoundaryVertex[vertex2] = false;
                    continue;
                }
                adjacentVertices.add(-vertex1);
            }
        }
        HashSet<Integer> boundaryVertices = new HashSet<Integer>();
        for (int i = 1; i < edgesAtVertex.size(); ++i) {
            if (edgesAtVertex.get(i) == null) continue;
            boundaryVertices.add(i);
        }
        if (boundaryVertices.isEmpty()) {
            return;
        }
        HashSet<Integer> outerBoundaryVertices = new HashSet<Integer>();
        for (int i = 1; i < isOnlyOuterBoundaryVertex.length; ++i) {
            if (!isOnlyOuterBoundaryVertex[i] || !boundaryVertices.contains(i)) continue;
            outerBoundaryVertices.add(i);
        }
        LinkedList<int[]> boundary = new LinkedList<int[]>();
        do {
            int vertex = outerBoundaryVertices.isEmpty() ? (Integer)boundaryVertices.iterator().next() : (Integer)outerBoundaryVertices.iterator().next();
            boundaryVertices.remove(vertex);
            outerBoundaryVertices.remove(vertex);
            LinkedHashSet<Integer> vertices = new LinkedHashSet<Integer>();
            vertices.add(vertex);
            boolean closed = false;
            do {
                Integer newVertex = 0;
                Iterator iterator = ((List)edgesAtVertex.get(vertex)).iterator();
                while (iterator.hasNext() && (newVertex = (Integer)iterator.next()) <= 0) {
                }
                if (newVertex <= 0) break;
                vertex = newVertex;
                if (!vertices.add(vertex)) {
                    closed = true;
                    break;
                }
                if (isOnlyOuterBoundaryVertex[vertex]) continue;
                boundaryVertices.remove(vertex);
            } while (!isOnlyOuterBoundaryVertex[vertex]);
            int[] verticesArray = new int[closed ? vertices.size() + 1 : vertices.size()];
            int i = 0;
            for (Integer v : vertices) {
                verticesArray[i++] = v - 1;
            }
            if (closed) {
                verticesArray[verticesArray.length - 1] = verticesArray[0];
            }
            boundary.add(verticesArray);
        } while (boundaryVertices.iterator().hasNext());
        this.setBoundaryIndicesImpl(boundary);
    }
}

