/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.BoundingBoxUtility;
import de.jreality.geometry.CoordinateSystemBeautifier;
import de.jreality.geometry.GeometryMergeFactory;
import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.geometry.PointSetFactory;
import de.jreality.geometry.Primitives;
import de.jreality.math.FactoredMatrix;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Quaternion;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;

public class CoordinateSystemFactory {
    private double[] boxMin;
    private double[] boxMax;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    private double[][][] axesVertices;
    private double[][][] boxVertices;
    private SceneGraphComponent coordinateSystem;
    private SceneGraphComponent component;
    private final String[] axesNames = new String[]{"x", "y", "z"};
    private double[][] octagonalCrossSection = new double[][]{{1.0, 0.0, 0.0}, {0.707, 0.707, 0.0}, {0.0, 1.0, 0.0}, {-0.707, 0.707, 0.0}, {-1.0, 0.0, 0.0}, {-0.707, -0.707, 0.0}, {0.0, -1.0, 0.0}, {0.707, -0.707, 0.0}, {1.0, 0.0, 0.0}};
    private final double arrowHeight = 3.0;
    private IndexedFaceSet urCone = Primitives.pyramid(this.octagonalCrossSection(-3.0), new double[]{0.0, 0.0, 0.0});
    private int currentClosestBoxVertex = -1;
    private HashMap<String, SceneGraphComponent> nodes = new HashMap();
    private CoordinateSystemBeautifier beautifier = new CoordinateSystemBeautifier(this);
    private double axisScale = 1.0;
    private double labelScale = 0.0035;
    private double arrowStretch = 16.0 * this.labelScale;
    private double tickStretch = 8.0 * this.labelScale;
    private boolean showAxes = false;
    private boolean showBox = false;
    private boolean showGrid = true;
    private boolean showAxesArrows = true;
    private boolean showBoxArrows = false;
    private boolean showLabels = true;
    private Color coordinateSystemColor = Color.BLACK;
    private Color gridColor = Color.GRAY;
    private Color boxColor = Color.BLACK;
    private Color labelColor = Color.BLACK;
    private Font labelFont = new Font("Sans Serif", 0, 48);
    private boolean beautify = true;
    double[][] axes = new double[][]{{0.0, 1.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, 0.0, 1.0}};
    double[] angles = new double[]{1.5707963267948966, -1.5707963267948966, 0.0};
    private boolean beautifyBoxLabels = false;

    public CoordinateSystemFactory(double extent, double axisScale) {
        this(new double[]{extent, extent, extent}, axisScale);
    }

    public CoordinateSystemFactory(double extent) {
        this(extent, 1.0);
    }

    public CoordinateSystemFactory(double[] extent, double axisScale) {
        if (extent.length != 3 || extent[0] <= 0.0 || extent[1] <= 0.0 || extent[2] <= 0.0 || axisScale <= 0.0) {
            throw new IllegalArgumentException("length of extent incorrect or negative values");
        }
        this.boxMin = new double[]{-extent[0], -extent[1], -extent[2]};
        this.boxMax = new double[]{extent[0], extent[1], extent[2]};
        this.axisScale = axisScale;
        this.coordinateSystem = this.createCoordinateSystem();
    }

    public CoordinateSystemFactory(double[] extent) {
        this(extent, 1.0);
    }

    public CoordinateSystemFactory(SceneGraphComponent component, double axisScale) {
        Transformation tmp = component.getTransformation();
        component.setTransformation(new Transformation());
        double[][] minMax = BoundingBoxUtility.calculateBoundingBox(component).getBounds();
        this.boxMin = minMax[0];
        this.boxMax = minMax[1];
        for (int axis = 0; axis <= 2; ++axis) {
            if (this.boxMin[axis] != this.boxMax[axis]) continue;
            int n = axis;
            this.boxMin[n] = this.boxMin[n] - 0.5;
            int n2 = axis;
            this.boxMax[n2] = this.boxMax[n2] + 0.5;
        }
        this.axisScale = axisScale;
        this.component = component;
        this.coordinateSystem = this.createCoordinateSystem();
        component.addChild(this.coordinateSystem);
        component.setTransformation(tmp);
    }

    public CoordinateSystemFactory(SceneGraphComponent component) {
        this(component, 1.0);
    }

    public void dispose() {
        if (this.component != null && this.component.isDirectAncestor(this.coordinateSystem)) {
            this.component.removeChild(this.coordinateSystem);
        }
    }

    private SceneGraphComponent createCoordinateSystem() {
        this.coordinateSystem = new SceneGraphComponent();
        this.coordinateSystem.setName("CoordinateSystem");
        this.coordinateSystem.setOwner(this);
        this.coordinateSystem.addChild(this.calculateBox());
        this.coordinateSystem.addChild(this.calculateAxes());
        Appearance app = new Appearance();
        app.setName("Appearance");
        app.setAttribute("showLines", true);
        app.setAttribute("spheresDraw", true);
        app.setAttribute("lineShader.tubeDraw", false);
        app.setAttribute("showPoints", this.showLabels);
        app.setAttribute("pointRadius", 0.001);
        app.setAttribute("pointShader.diffuseColor", this.labelColor);
        app.setAttribute("lineShader.diffuseColor", this.coordinateSystemColor);
        app.setAttribute("polygonShader.diffuseColor", this.coordinateSystemColor);
        app.setAttribute("depthFudgeFactor", 1.0);
        app.setAttribute("pointShader.font", this.labelFont);
        app.setAttribute("pointShader.scale", this.labelScale);
        app.setAttribute("pointShader.offset", new double[]{0.04, 0.0, 0.0});
        app.setAttribute("pointShader.alignment", 3);
        this.coordinateSystem.setAppearance(app);
        if (this.beautify) {
            this.beautify = false;
            this.beautify(true);
        }
        return this.coordinateSystem;
    }

    private SceneGraphComponent calculateBox() {
        this.calculateBoxVertices();
        SceneGraphComponent box = new SceneGraphComponent();
        box.setName("Box");
        for (int axis = 0; axis <= 2; ++axis) {
            SceneGraphComponent singleAxis = new SceneGraphComponent();
            singleAxis.setName(this.axesNames[axis] + "-axis");
            for (int k = 0; k <= 3; ++k) {
                SceneGraphComponent singleAxisK = new SceneGraphComponent();
                singleAxisK.setName(this.toBinaryString(k));
                this.nodes.put(this.axesNames[axis] + this.toBinaryString(k), singleAxisK);
                SceneGraphComponent line = this.getLine(axis, this.boxVertices[axis][2 * k], this.boxVertices[axis][2 * k + 1], true);
                this.nodes.put(this.axesNames[axis] + this.toBinaryString(k) + "label", line.getChildComponent(0));
                SceneGraphComponent arrow = this.getArrow(axis, this.boxVertices[axis][2 * k], this.boxVertices[axis][2 * k + 1]);
                arrow.setVisible(this.showBoxArrows);
                this.nodes.put(this.axesNames[axis] + this.toBinaryString(k) + "arrow", arrow);
                SceneGraphComponent ticks = this.getBoxTicks(axis, k, this.boxVertices[axis][2 * k], this.boxVertices[axis][2 * k + 1]);
                this.nodes.put(this.axesNames[axis] + this.toBinaryString(k) + "ticks", ticks);
                singleAxisK.addChild(line);
                singleAxisK.addChild(arrow);
                singleAxisK.addChild(ticks);
                singleAxis.addChild(singleAxisK);
            }
            box.addChild(singleAxis);
        }
        box.addChild(this.calculate2DGrid());
        Appearance app = new Appearance();
        app.setName("boxAppearance");
        app.setAttribute("lineShader.diffuseColor", this.boxColor);
        box.setAppearance(app);
        box.setVisible(this.showBox);
        this.nodes.put("box", box);
        return box;
    }

    private SceneGraphComponent calculateAxes() {
        this.calculateAxesVertices();
        SceneGraphComponent axes = new SceneGraphComponent();
        axes.setName("Axes");
        for (int axis = 0; axis <= 2; ++axis) {
            SceneGraphComponent singleAxis = new SceneGraphComponent();
            singleAxis.setName(this.axesNames[axis] + "-axis");
            this.nodes.put(this.axesNames[axis] + "Axis", singleAxis);
            SceneGraphComponent line = this.getLine(axis, this.axesVertices[axis][0], this.axesVertices[axis][1], false);
            SceneGraphComponent arrow = this.getArrow(axis, this.axesVertices[axis][0], this.axesVertices[axis][1]);
            arrow.setVisible(this.showAxesArrows);
            this.nodes.put(this.axesNames[axis] + "Arrow", arrow);
            SceneGraphComponent ticks = this.getAxesTicks(axis, this.axesVertices[axis][0], this.axesVertices[axis][1]);
            this.nodes.put(this.axesNames[axis] + "Ticks", ticks);
            singleAxis.addChild(line);
            singleAxis.addChild(arrow);
            singleAxis.addChild(ticks);
            axes.addChild(singleAxis);
        }
        axes.setVisible(this.showAxes);
        this.nodes.put("axes", axes);
        return axes;
    }

    private void calculateAxesVertices() {
        this.axesVertices = new double[][][]{new double[][]{{Math.min(this.boxMin[0] - 0.5, 0.0), 0.0, 0.0}, {Math.max(this.boxMax[0] + 0.5, 0.0), 0.0, 0.0}}, new double[][]{{0.0, Math.min(this.boxMin[1] - 0.5, 0.0), 0.0}, {0.0, Math.max(this.boxMax[1] + 0.5, 0.0), 0.0}}, new double[][]{{0.0, 0.0, Math.min(this.boxMin[2] - 0.5, 0.0)}, {0.0, 0.0, Math.max(this.boxMax[2] + 0.5, 0.0)}}};
    }

    private void calculateBoxVertices() {
        this.boxVertices = new double[][][]{new double[][]{this.boxMin, {this.boxMax[0], this.boxMin[1], this.boxMin[2]}, {this.boxMin[0], this.boxMin[1], this.boxMax[2]}, {this.boxMax[0], this.boxMin[1], this.boxMax[2]}, {this.boxMin[0], this.boxMax[1], this.boxMin[2]}, {this.boxMax[0], this.boxMax[1], this.boxMin[2]}, {this.boxMin[0], this.boxMax[1], this.boxMax[2]}, this.boxMax}, new double[][]{this.boxMin, {this.boxMin[0], this.boxMax[1], this.boxMin[2]}, {this.boxMin[0], this.boxMin[1], this.boxMax[2]}, {this.boxMin[0], this.boxMax[1], this.boxMax[2]}, {this.boxMax[0], this.boxMin[1], this.boxMin[2]}, {this.boxMax[0], this.boxMax[1], this.boxMin[2]}, {this.boxMax[0], this.boxMin[1], this.boxMax[2]}, this.boxMax}, new double[][]{this.boxMin, {this.boxMin[0], this.boxMin[1], this.boxMax[2]}, {this.boxMin[0], this.boxMax[1], this.boxMin[2]}, {this.boxMin[0], this.boxMax[1], this.boxMax[2]}, {this.boxMax[0], this.boxMin[1], this.boxMin[2]}, {this.boxMax[0], this.boxMin[1], this.boxMax[2]}, {this.boxMax[0], this.boxMax[1], this.boxMin[2]}, this.boxMax}};
    }

    private SceneGraphComponent getLine(int axis, double[] min, double[] max, boolean forBox) {
        IndexedLineSetFactory lineLSF = new IndexedLineSetFactory();
        lineLSF.setVertexCount(2);
        lineLSF.setEdgeCount(1);
        lineLSF.setVertexCoordinates(new double[][]{min, max});
        lineLSF.setEdgeIndices(new int[]{0, 1});
        lineLSF.update();
        PointSetFactory labelPSF = new PointSetFactory();
        labelPSF.setVertexCount(1);
        if (forBox) {
            double[] p = (double[])max.clone();
            p[axis] = min[axis] + (max[axis] - min[axis]) / 2.0;
            labelPSF.setVertexCoordinates(p);
        } else {
            labelPSF.setVertexCoordinates(max);
        }
        labelPSF.setVertexLabels(new String[]{this.axesNames[axis]});
        labelPSF.update();
        SceneGraphComponent label = new SceneGraphComponent();
        label.setName("label");
        PointSet geom = labelPSF.getPointSet();
        geom.setName("anchorPoint");
        label.setGeometry(geom);
        SceneGraphComponent line = new SceneGraphComponent();
        line.setName("line");
        line.addChild(label);
        Appearance app = new Appearance();
        app.setName("lineAppearance");
        app.setAttribute("pointShader.offset", new double[]{0.0, -0.2, 0.0});
        line.setAppearance(app);
        geom = lineLSF.getIndexedLineSet();
        geom.setName("line");
        line.setGeometry(geom);
        return line;
    }

    private SceneGraphComponent getArrow(int axis, double[] min, double[] max) {
        SceneGraphComponent arrow = new SceneGraphComponent();
        arrow.setName("arrow");
        IndexedFaceSet geom = this.urCone;
        geom.setName("arrow");
        arrow.setGeometry(geom);
        FactoredMatrix m = new FactoredMatrix();
        m.setRotation(this.getAxisRotation(axis));
        m.setStretch(this.arrowStretch);
        m.setTranslation(max);
        Transformation trans = new Transformation(m.getArray());
        trans.setName("arrowTransformation");
        trans.setReadOnly(true);
        arrow.setTransformation(trans);
        return arrow;
    }

    private SceneGraphComponent getAxesTicks(int axis, double[] min, double[] max) {
        double minLevel = this.round(this.axisScale * Math.ceil(min[axis] / this.axisScale));
        double maxLevel = this.round(this.axisScale * Math.floor((max[axis] - 3.0 * this.arrowStretch) / this.axisScale));
        SceneGraphComponent ticks = new SceneGraphComponent();
        ticks.setName("ticks");
        IndexedFaceSet ticksGeom = new IndexedFaceSet();
        int numOfTicks = 0;
        double level = this.round(minLevel);
        while (level <= maxLevel) {
            if (level != 0.0) {
                GeometryMergeFactory gMFac = new GeometryMergeFactory();
                ticksGeom = gMFac.mergeIndexedFaceSets(new PointSet[]{ticksGeom, Primitives.pyramid(this.octagonalCrossSection(level), new double[]{0.0, 0.0, level})});
                ++numOfTicks;
            }
            level = this.round(level + this.axisScale);
        }
        if (numOfTicks == 0) {
            return ticks;
        }
        PointSetFactory labelPSF = new PointSetFactory();
        labelPSF.setVertexCount(numOfTicks);
        double[][] labelPoints = new double[numOfTicks][];
        String[] labelStr = new String[numOfTicks];
        double level2 = minLevel;
        for (int i = 0; i < numOfTicks; ++i) {
            if (level2 == 0.0) {
                level2 += this.axisScale;
            }
            labelPoints[i] = new double[]{0.0, 0.0, level2};
            labelStr[i] = (double)Math.round(level2 * 1000.0) / 1000.0 + "";
            level2 = this.round(level2 + this.axisScale);
        }
        labelPSF.setVertexCoordinates(labelPoints);
        labelPSF.setVertexLabels(labelStr);
        labelPSF.update();
        SceneGraphComponent labels = new SceneGraphComponent();
        labels.setName("label");
        PointSet geom = labelPSF.getPointSet();
        geom.setName("anchorPoints");
        labels.setGeometry(geom);
        ticksGeom.setName("ticks");
        ticks.setGeometry(ticksGeom);
        FactoredMatrix m = new FactoredMatrix();
        m.setRotation(this.getAxisRotation(axis));
        double[] translation = (double[])min.clone();
        translation[axis] = 0.0;
        m.setTranslation(translation);
        m.setStretch(this.tickStretch, this.tickStretch, 1.0);
        MatrixBuilder.euclidean().translate(translation).rotate(this.angles[axis], this.axes[axis]).scale(this.tickStretch, this.tickStretch, 1.0).assignTo(ticks);
        ticks.addChild(labels);
        return ticks;
    }

    private SceneGraphComponent getBoxTicks(int axis, int k, double[] min, double[] max) {
        double minLevel = this.round(this.axisScale * Math.ceil((min[axis] + 0.05) / this.axisScale));
        double maxLevel = this.round(this.axisScale * Math.floor((max[axis] - 0.05) / this.axisScale));
        SceneGraphComponent ticks = new SceneGraphComponent();
        ticks.setName("ticks");
        if (minLevel > maxLevel) {
            return ticks;
        }
        IndexedLineSet ticksGeom = new IndexedLineSet();
        int numOfTicks = 0;
        double level = minLevel;
        while (level <= maxLevel) {
            IndexedLineSetFactory newTick = new IndexedLineSetFactory();
            newTick.setVertexCount(3);
            newTick.setEdgeCount(2);
            newTick.setVertexCoordinates(new double[][]{{5.0, 0.0, level}, {0.0, 0.0, level}, {0.0, 5.0, level}});
            newTick.setEdgeIndices(new int[][]{{0, 1}, {1, 2}});
            newTick.update();
            ticksGeom = this.mergeIndexedLineSets(ticksGeom, newTick.getIndexedLineSet());
            ++numOfTicks;
            level = this.round(level + this.axisScale);
        }
        PointSetFactory labelPSF = new PointSetFactory();
        labelPSF.setVertexCount(numOfTicks);
        double[][] labelPoints = new double[numOfTicks][];
        String[] labelStr = new String[numOfTicks];
        double level2 = minLevel;
        for (int i = 0; i < numOfTicks; ++i) {
            labelPoints[i] = new double[]{0.0, 0.0, level2};
            labelStr[i] = (double)Math.round(level2 * 1000.0) / 1000.0 + "";
            level2 = this.round(level2 + this.axisScale);
        }
        labelPSF.setVertexCoordinates(labelPoints);
        labelPSF.setVertexLabels(labelStr);
        labelPSF.update();
        SceneGraphComponent labels = new SceneGraphComponent();
        labels.setName("label");
        PointSet geom = labelPSF.getPointSet();
        geom.setName("anchorPoints");
        labels.setGeometry(geom);
        this.nodes.put(this.axesNames[axis] + this.toBinaryString(k) + "ticklabels", labels);
        ticksGeom.setName("ticks");
        ticks.setGeometry(ticksGeom);
        double[] translation = (double[])min.clone();
        translation[axis] = 0.0;
        double[] tickr = this.getTickRotation(axis, k);
        MatrixBuilder.euclidean().translate(translation).rotate(tickr[3], tickr[0], tickr[1], tickr[2]).rotate(this.angles[axis], this.axes[axis]).scale(this.tickStretch, this.tickStretch, 1.0).assignTo(ticks);
        ticks.addChild(labels);
        return ticks;
    }

    private SceneGraphComponent calculate2DGrid() {
        IndexedLineSet[] gridComp = new IndexedLineSet[6];
        for (int i = 0; i < gridComp.length; ++i) {
            gridComp[i] = new IndexedLineSet();
        }
        for (int axis = 0; axis <= 2; ++axis) {
            SceneGraphComponent ticks = this.nodes.get(this.axesNames[axis] + "00ticklabels");
            if (ticks == null) continue;
            int n = ((PointSet)ticks.getGeometry()).getNumPoints();
            for (int k = 0; k <= 3; ++k) {
                double[][] vertices = new double[2 * n][3];
                int[][] indices = new int[n][2];
                int next = (new int[]{1, 2, -2, -1})[k];
                for (int i = 0; i < n; ++i) {
                    for (int line = 0; line <= 1; ++line) {
                        PointSet ps = (PointSet)this.nodes.get(this.axesNames[axis] + this.toBinaryString(k + line * next) + "ticklabels").getGeometry();
                        double[] points = ps.getVertexAttributes(Attribute.COORDINATES).toDoubleArray(null);
                        double[] current = new double[]{points[3 * i], points[3 * i + 1], points[3 * i + 2], 0.0};
                        double[] translation = (double[])this.boxVertices[axis][2 * (k + line * next)].clone();
                        translation[axis] = 0.0;
                        FactoredMatrix trans = new FactoredMatrix(this.nodes.get(this.axesNames[axis] + this.toBinaryString(k + line * next) + "ticks").getTransformation());
                        double[] result = trans.multiplyVector(current);
                        vertices[n * line + i][0] = result[0] + translation[0];
                        vertices[n * line + i][1] = result[1] + translation[1];
                        vertices[n * line + i][2] = result[2] + translation[2];
                    }
                    indices[i] = new int[]{i, n + i};
                }
                IndexedLineSetFactory fac = new IndexedLineSetFactory();
                fac.setVertexCount(vertices.length);
                fac.setEdgeCount(indices.length);
                fac.setVertexCoordinates(vertices);
                fac.setEdgeIndices(indices);
                fac.update();
                int face = 0;
                switch (axis) {
                    case 0: {
                        face = (new int[]{2, 5, 4, 3})[k];
                        break;
                    }
                    case 1: {
                        face = (new int[]{0, 5, 4, 1})[k];
                        break;
                    }
                    case 2: {
                        face = (new int[]{0, 3, 2, 1})[k];
                    }
                }
                gridComp[face] = this.mergeIndexedLineSets(gridComp[face], fac.getIndexedLineSet());
            }
        }
        SceneGraphComponent grid = new SceneGraphComponent("grid");
        this.nodes.put("grid", grid);
        for (int i = 0; i < gridComp.length; ++i) {
            SceneGraphComponent face = new SceneGraphComponent();
            face.setName("face" + i);
            gridComp[i].setName("face");
            face.setGeometry(gridComp[i]);
            this.nodes.put("face" + i, face);
            grid.addChild(face);
        }
        Appearance app = new Appearance();
        app.setName("gridAppearance");
        app.setAttribute("lineShader.diffuseColor", this.gridColor);
        grid.setAppearance(app);
        grid.setVisible(this.showGrid);
        return grid;
    }

    private double[][] octagonalCrossSection(double level) {
        double[][] octagonalCrossSection = this.octagonalCrossSection;
        for (int i = 0; i < octagonalCrossSection.length; ++i) {
            octagonalCrossSection[i][2] = level;
        }
        return octagonalCrossSection;
    }

    private IndexedLineSet mergeIndexedLineSets(IndexedLineSet a, IndexedLineSet b) {
        GeometryMergeFactory gmf = new GeometryMergeFactory();
        return gmf.mergeIndexedLineSets(new IndexedLineSet[]{a, b});
    }

    private Quaternion getAxisRotation(int axis) {
        FactoredMatrix rot = new FactoredMatrix();
        switch (axis) {
            case 0: {
                rot.setRotation(1.5707963267948966, 0.0, 1.0, 0.0);
                break;
            }
            case 1: {
                rot.setRotation(-1.5707963267948966, 1.0, 0.0, 0.0);
            }
        }
        return Quaternion.rotationMatrixToQuaternion(new Quaternion(), rot.getArray());
    }

    private double[] getTickRotation(int axis, int k) {
        int c = (new int[]{0, 3, 1, 2})[k];
        switch (axis) {
            case 0: {
                ++c;
                break;
            }
            case 1: {
                c *= -1;
                --c;
            }
        }
        double[] retvalue = new double[4];
        retvalue[axis] = 1.0;
        retvalue[3] = (double)c * Math.PI / 2.0;
        return retvalue;
    }

    private String toBinaryString(int k) {
        if (k < 2) {
            return "0" + k;
        }
        return Integer.toBinaryString(k);
    }

    private double round(double d) {
        return (double)Math.round(d * 1000.0) / 1000.0;
    }

    private int getClosestBoxVertex(double[] dir) {
        double[] direction = dir.length == 3 ? dir : new double[]{dir[0] / dir[3], dir[1] / dir[3], dir[2] / dir[3]};
        int closest = 0;
        double tmp = Rn.innerProduct(this.boxVertices[0][closest], direction);
        for (int k = 1; k < 8; ++k) {
            if (!(Rn.innerProduct(this.boxVertices[0][k], direction) < tmp)) continue;
            closest = k;
            tmp = Rn.innerProduct(this.boxVertices[0][k], direction);
        }
        return closest;
    }

    public void updateBox(double[] cameraToObject) {
        double[] direction = new Matrix(cameraToObject).multiplyVector(new double[]{0.0, 0.0, -1.0, 0.0});
        direction[3] = 1.0;
        int index = this.getClosestBoxVertex(direction);
        if (this.currentClosestBoxVertex == index) {
            return;
        }
        for (int axis = 0; axis <= 2; ++axis) {
            for (int k = 0; k <= 3; ++k) {
                this.nodes.get(this.axesNames[axis] + this.toBinaryString(k)).setVisible(true);
            }
            this.nodes.get("face" + 2 * axis).setVisible(true);
            this.nodes.get("face" + (2 * axis + 1)).setVisible(true);
        }
        this.currentClosestBoxVertex = index;
        double[] closest = this.boxVertices[0][this.currentClosestBoxVertex];
        int[] edgeCriteria = new int[3];
        for (int axis = 0; axis <= 2; ++axis) {
            edgeCriteria[axis] = closest[axis] == this.boxMin[axis] ? 0 : 1;
        }
        int[] invisibleEdges = new int[3];
        if (direction[1] != 0.0 && direction[2] != 0.0) {
            this.nodes.get("x" + edgeCriteria[1] + edgeCriteria[2]).setVisible(false);
            invisibleEdges[0] = edgeCriteria[1] * 2 + edgeCriteria[2];
        }
        if (direction[0] != 0.0 && direction[2] != 0.0) {
            this.nodes.get("y" + edgeCriteria[0] + edgeCriteria[2]).setVisible(false);
            invisibleEdges[1] = edgeCriteria[0] * 2 + edgeCriteria[2];
        }
        if (direction[0] != 0.0 && direction[1] != 0.0) {
            this.nodes.get("z" + edgeCriteria[0] + edgeCriteria[1]).setVisible(false);
            invisibleEdges[2] = edgeCriteria[0] * 2 + edgeCriteria[1];
        }
        for (int axis = 0; axis <= 2; ++axis) {
            this.nodes.get("face" + (2 * axis + edgeCriteria[axis])).setVisible(false);
        }
        if (this.beautifyBoxLabels) {
            this.updateLabelsOfBoxEdges(cameraToObject, invisibleEdges);
        }
    }

    public SceneGraphComponent getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public void setAxisScale(double axisScale) {
        if (this.axisScale == axisScale) {
            return;
        }
        this.axisScale = axisScale;
        for (int axis = 0; axis <= 2; ++axis) {
            for (int k = 0; k <= 3; ++k) {
                SceneGraphComponent singleAxisK = this.nodes.get(this.axesNames[axis] + this.toBinaryString(k));
                singleAxisK.removeChild(this.nodes.get(this.axesNames[axis] + this.toBinaryString(k) + "ticks"));
                SceneGraphComponent ticks = this.getBoxTicks(axis, k, this.boxVertices[axis][2 * k], this.boxVertices[axis][2 * k + 1]);
                this.nodes.put(this.axesNames[axis] + this.toBinaryString(k) + "ticks", ticks);
                singleAxisK.addChild(ticks);
            }
            SceneGraphComponent singleAxis = this.nodes.get(this.axesNames[axis] + "Axis");
            singleAxis.removeChild(this.nodes.get(this.axesNames[axis] + "Ticks"));
            SceneGraphComponent ticks = this.getAxesTicks(axis, this.axesVertices[axis][0], this.axesVertices[axis][1]);
            this.nodes.put(this.axesNames[axis] + "Ticks", ticks);
            singleAxis.addChild(ticks);
        }
        this.nodes.get("box").removeChild(this.nodes.get("grid"));
        this.nodes.get("box").addChild(this.calculate2DGrid());
    }

    public double getAxisScale() {
        return this.axisScale;
    }

    public void setLabelScale(double labelScale) {
        if (this.labelScale == labelScale) {
            return;
        }
        this.labelScale = labelScale;
        this.coordinateSystem.getAppearance().setAttribute("pointShader.scale", labelScale);
        this.arrowStretch = 16.0 * labelScale;
        this.tickStretch = 8.0 * labelScale;
        for (int axis = 0; axis <= 2; ++axis) {
            SceneGraphComponent ticks;
            FactoredMatrix m;
            SceneGraphComponent arrow;
            for (int k = 0; k <= 3; ++k) {
                arrow = this.nodes.get(this.axesNames[axis] + this.toBinaryString(k) + "arrow");
                m = new FactoredMatrix(arrow.getTransformation());
                m.setStretch(this.arrowStretch);
                Transformation trans = new Transformation(m.getArray());
                trans.setName("arrowTransformation");
                trans.setReadOnly(true);
                arrow.setTransformation(trans);
                ticks = this.nodes.get(this.axesNames[axis] + this.toBinaryString(k) + "ticks");
                m = ticks.getTransformation() != null ? new FactoredMatrix(ticks.getTransformation()) : new FactoredMatrix();
                m.setStretch(this.tickStretch, this.tickStretch, 1.0);
                trans = new Transformation(m.getArray());
                trans.setName("tickTransformation");
                trans.setReadOnly(true);
                ticks.setTransformation(trans);
            }
            arrow = this.nodes.get(this.axesNames[axis] + "Arrow");
            m = new FactoredMatrix(arrow.getTransformation());
            m.setStretch(this.arrowStretch);
            Transformation trans = new Transformation(m.getArray());
            trans.setName("arrowTransformation");
            trans.setReadOnly(true);
            arrow.setTransformation(trans);
            ticks = this.nodes.get(this.axesNames[axis] + "Ticks");
            m = ticks.getTransformation() != null ? new FactoredMatrix(ticks.getTransformation()) : new FactoredMatrix();
            m.setStretch(this.tickStretch, this.tickStretch, 1.0);
            trans = new Transformation(m.getArray());
            trans.setName("tickTransformation");
            trans.setReadOnly(true);
            ticks.setTransformation(trans);
        }
    }

    public double getLabelScale() {
        return this.labelScale;
    }

    public void showAxes(boolean b) {
        this.showAxes = b;
        this.nodes.get("axes").setVisible(b);
    }

    public void showBox(boolean b) {
        this.showBox = b;
        this.nodes.get("box").setVisible(b);
    }

    public void showGrid(boolean b) {
        this.showGrid = b;
        this.nodes.get("grid").setVisible(b);
    }

    public void showAxesArrows(boolean b) {
        this.showAxesArrows = b;
        for (int axis = 0; axis <= 2; ++axis) {
            this.nodes.get(this.axesNames[axis] + "Arrow").setVisible(b);
        }
    }

    public void showBoxArrows(boolean b) {
        this.showBoxArrows = b;
        for (int axis = 0; axis <= 2; ++axis) {
            for (int k = 0; k <= 3; ++k) {
                this.nodes.get(this.axesNames[axis] + this.toBinaryString(k) + "arrow").setVisible(b);
            }
        }
    }

    public void showLabels(boolean b) {
        this.showLabels = b;
        this.coordinateSystem.getAppearance().setAttribute("showPoints", b);
    }

    public void setColor(Color c) {
        this.coordinateSystemColor = c;
        this.coordinateSystem.getAppearance().setAttribute("lineShader.diffuseColor", c);
        this.coordinateSystem.getAppearance().setAttribute("polygonShader.diffuseColor", c);
    }

    public Color getColor() {
        return this.coordinateSystemColor;
    }

    public void setGridColor(Color c) {
        this.gridColor = c;
        this.nodes.get("grid").getAppearance().setAttribute("lineShader.diffuseColor", c);
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setBoxColor(Color c) {
        this.boxColor = c;
        this.nodes.get("box").getAppearance().setAttribute("lineShader.diffuseColor", c);
    }

    public Color getBoxColor() {
        return this.boxColor;
    }

    public void setLabelColor(Color c) {
        this.labelColor = c;
        this.coordinateSystem.getAppearance().setAttribute("pointShader.diffuseColor", c);
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelFont(Font f) {
        this.labelFont = f;
        this.coordinateSystem.getAppearance().setAttribute("pointShader.font", f);
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void beautify(boolean b) {
        if (this.beautify == b) {
            return;
        }
        this.beautify = b;
        if (b) {
            this.coordinateSystem.addTool(this.beautifier);
        } else {
            this.coordinateSystem.removeTool(this.beautifier);
        }
    }

    public void setLabelBoxEdges(int[][] edges) {
        for (int axis = 0; axis <= 2; ++axis) {
            SceneGraphComponent labels;
            String a = edges[axis][0] == -1 ? "0" : "1";
            String b = edges[axis][1] == -1 ? "0" : "1";
            for (int k = 0; k <= 3 && (labels = this.nodes.get(this.axesNames[axis] + this.toBinaryString(k) + "ticklabels")) != null; ++k) {
                labels.setVisible(this.toBinaryString(k).equals(a + b));
            }
        }
    }

    private void updateLabelsOfBoxEdges(double[] cameraToObject, int[] invisibleEdges) {
        double[] tmp = new Matrix(cameraToObject).multiplyVector(new double[]{1.0, 0.0, 0.0, 0.0});
        double[] direction = new double[]{tmp[0], tmp[1], tmp[2]};
        int[][] neighbourEdges = new int[3][2];
        for (int axis = 0; axis <= 2; ++axis) {
            int[] nArray;
            if (invisibleEdges[axis] == 0 || invisibleEdges[axis] == 3) {
                int[] nArray2 = new int[2];
                nArray2[0] = 1;
                nArray = nArray2;
                nArray2[1] = 2;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = 0;
                nArray = nArray3;
                nArray3[1] = 3;
            }
            neighbourEdges[axis] = nArray;
        }
        int[] result = new int[3];
        for (int axis = 0; axis <= 2; ++axis) {
            PointSet ps = (PointSet)this.nodes.get(this.axesNames[axis] + this.toBinaryString(neighbourEdges[axis][0]) + "label").getGeometry();
            double[] first = ps.getVertexAttributes(Attribute.COORDINATES).toDoubleArray(null);
            ps = (PointSet)this.nodes.get(this.axesNames[axis] + this.toBinaryString(neighbourEdges[axis][1]) + "label").getGeometry();
            double[] second = ps.getVertexAttributes(Attribute.COORDINATES).toDoubleArray(null);
            result[axis] = Rn.innerProduct(second, direction) > Rn.innerProduct(first, direction) ? neighbourEdges[axis][1] : neighbourEdges[axis][0];
        }
        int[][] directive = new int[3][2];
        for (int axis = 0; axis <= 2; ++axis) {
            directive[axis][0] = this.toBinaryString(result[axis]).substring(0, 1).equals("0") ? -1 : 1;
            directive[axis][1] = this.toBinaryString(result[axis]).substring(1, 2).equals("0") ? -1 : 1;
        }
        this.setLabelBoxEdges(directive);
    }
}

