/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.CoordinateSystemFactory;
import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphPathObserver;
import de.jreality.scene.event.TransformationEvent;
import de.jreality.scene.event.TransformationListener;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;

class CoordinateSystemBeautifier
extends AbstractTool {
    private static InputSlot evolutionSlot = InputSlot.getDevice("SystemTime");
    private CoordinateSystemFactory factory = null;

    public CoordinateSystemBeautifier(CoordinateSystemFactory factory) {
        super(new InputSlot[0]);
        this.factory = factory;
        this.addCurrentSlot(evolutionSlot, "Need notification to add path listeners.");
    }

    public void perform(ToolContext tc) {
        final SceneGraphPath rootToToolPath = tc.getRootToToolComponent();
        final SceneGraphPath cameraToRootPath = tc.getViewer().getCameraPath();
        SceneGraphPathObserver opObserver = new SceneGraphPathObserver(rootToToolPath);
        opObserver.addTransformationListener(new TransformationListener(){

            public void transformationMatrixChanged(TransformationEvent ev) {
                double[] rootToTool = rootToToolPath.getInverseMatrix(null);
                double[] cameraToRoot = cameraToRootPath.getMatrix(null);
                double[] cameraToTool = Rn.times(null, rootToTool, cameraToRoot);
                CoordinateSystemBeautifier.this.factory.updateBox(cameraToTool);
            }
        });
        opObserver.transformationMatrixChanged(null);
        this.removeCurrentSlot(evolutionSlot);
    }

    public String getDescription() {
        return "CoordinateSystemBeautifier";
    }
}

