/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.GeometryUtility;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.ClippingPlane;
import de.jreality.scene.Cylinder;
import de.jreality.scene.Geometry;
import de.jreality.scene.PointSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Sphere;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.util.Rectangle3D;
import java.awt.geom.Rectangle2D;

public class BoundingBoxTraversal
extends SceneGraphVisitor {
    private Bound bound;
    private double[] tmpVec = new double[4];
    double[] initialTrafo;
    double[] currentTrafo;
    protected BoundingBoxTraversal reclaimableSubcontext;

    public BoundingBoxTraversal() {
        this.bound = new Bound();
    }

    protected BoundingBoxTraversal(BoundingBoxTraversal parentContext) {
        this.initializeFromParentContext(parentContext);
    }

    protected void initializeFromParentContext(BoundingBoxTraversal parentContext) {
        BoundingBoxTraversal p = parentContext;
        this.initialTrafo = parentContext.currentTrafo;
        this.currentTrafo = parentContext.currentTrafo;
        this.bound = parentContext.bound;
    }

    public void setInitialMatrix(double[] initialMatrix) {
        this.initialTrafo = initialMatrix;
    }

    BoundingBoxTraversal subContext() {
        if (this.reclaimableSubcontext != null) {
            this.reclaimableSubcontext.initializeFromParentContext(this);
            return this.reclaimableSubcontext;
        }
        this.reclaimableSubcontext = new BoundingBoxTraversal(this);
        return this.reclaimableSubcontext;
    }

    public void traverse(SceneGraphComponent root) {
        if (this.initialTrafo == null) {
            this.initialTrafo = new double[16];
            Rn.setIdentityMatrix(this.initialTrafo);
        }
        this.currentTrafo = this.initialTrafo;
        this.visit(root);
    }

    public void visit(SceneGraphComponent c) {
        Object obj;
        if (c.getAppearance() != null && (obj = c.getAppearance().getAttribute(GeometryUtility.BOUNDING_BOX)) != null && obj instanceof Rectangle3D) {
            Rectangle3D box = (Rectangle3D)obj;
            this.unionBox(box);
            return;
        }
        if (c.isVisible()) {
            c.childrenAccept(this.subContext());
        }
    }

    public void visit(Transformation t) {
        if (this.initialTrafo == this.currentTrafo) {
            this.currentTrafo = new double[16];
        }
        Rn.copy(this.currentTrafo, this.initialTrafo);
        if (!Rn.isNan(t.getMatrix())) {
            Rn.times(this.currentTrafo, this.currentTrafo, t.getMatrix());
        }
    }

    public void visit(Geometry g) {
        this.checkForBoundingBox(g);
    }

    public void visit(ClippingPlane p) {
    }

    public void visit(Cylinder c) {
        this.unionBox(Rectangle3D.unitCube);
    }

    private boolean checkForBoundingBox(Geometry g) {
        Object bbox = g.getGeometryAttributes(GeometryUtility.BOUNDING_BOX);
        if (bbox != null && bbox instanceof Rectangle3D) {
            Rectangle3D box = (Rectangle3D)bbox;
            if (box == Rectangle3D.EMPTY_BOX) {
                return true;
            }
            this.unionBox(box);
            return true;
        }
        return false;
    }

    public void visit(PointSet p) {
        if (this.checkForBoundingBox(p)) {
            return;
        }
        Object domain = p.getGeometryAttributes(GeometryUtility.HEIGHT_FIELD_SHAPE);
        if (domain != null && domain instanceof Rectangle2D) {
            Rectangle2D box = (Rectangle2D)domain;
            double[][] data = p.getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray(null);
            double[][] zbnds = new double[2][1];
            Rn.calculateBounds(zbnds, data);
            double[][] xyzbnds = new double[2][3];
            xyzbnds[0][0] = box.getMinX();
            xyzbnds[1][0] = box.getMaxX();
            xyzbnds[0][1] = box.getMinY();
            xyzbnds[1][1] = box.getMaxY();
            xyzbnds[0][2] = zbnds[0][0];
            xyzbnds[1][2] = zbnds[1][0];
            if (Double.isNaN(xyzbnds[0][0])) {
                throw new IllegalStateException("Nan");
            }
            Rectangle3D box3 = new Rectangle3D(xyzbnds);
            this.unionBox(box3);
            return;
        }
        DataList vv = p.getVertexAttributes(Attribute.COORDINATES);
        if (vv == null) {
            return;
        }
        this.unionVectors(vv);
    }

    public void visit(Sphere s) {
        this.unionBox(Rectangle3D.unitCube);
    }

    private final void unionVectors(DataList dl) {
        double[][] data = dl.toDoubleArrayArray(null);
        double[][] tmpVec = new double[2][3];
        int length = data.length;
        if (length == 0) {
            return;
        }
        int vectorLength = data[0].length;
        if (vectorLength < 3 || vectorLength > 4) {
            return;
        }
        Rn.matrixTimesVector(data, this.currentTrafo, data);
        try {
            if (vectorLength == 4) {
                Pn.calculateBounds(tmpVec, data);
            } else if (vectorLength == 3) {
                Rn.calculateBounds(tmpVec, data);
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        if (Rn.isNan(tmpVec[0]) || Rn.isNan(tmpVec[1])) {
            return;
        }
        this.bound.xmin = Math.min(this.bound.xmin, tmpVec[0][0]);
        this.bound.xmax = Math.max(this.bound.xmax, tmpVec[1][0]);
        this.bound.ymin = Math.min(this.bound.ymin, tmpVec[0][1]);
        this.bound.ymax = Math.max(this.bound.ymax, tmpVec[1][1]);
        this.bound.zmin = Math.min(this.bound.zmin, tmpVec[0][2]);
        this.bound.zmax = Math.max(this.bound.zmax, tmpVec[1][2]);
    }

    private final void unionBox(Rectangle3D bbox) {
        if (bbox.isEmpty()) {
            return;
        }
        Rectangle3D tbox = bbox.transformByMatrix(null, this.currentTrafo);
        double[][] bnds = tbox.getBounds();
        this.bound.xmin = Math.min(this.bound.xmin, bnds[0][0]);
        this.bound.xmax = Math.max(this.bound.xmax, bnds[1][0]);
        this.bound.ymin = Math.min(this.bound.ymin, bnds[0][1]);
        this.bound.ymax = Math.max(this.bound.ymax, bnds[1][1]);
        this.bound.zmin = Math.min(this.bound.zmin, bnds[0][2]);
        this.bound.zmax = Math.max(this.bound.zmax, bnds[1][2]);
    }

    public double getXmax() {
        return this.bound.xmax;
    }

    public double getXmin() {
        return this.bound.xmin;
    }

    public double getYmax() {
        return this.bound.ymax;
    }

    public double getYmin() {
        return this.bound.ymin;
    }

    public double getZmax() {
        return this.bound.zmax;
    }

    public double getZmin() {
        return this.bound.zmin;
    }

    public double[] getBoundingBoxCenter(double[] c) {
        if (c == null) {
            c = new double[]{(this.bound.xmin + this.bound.xmax) / 2.0, (this.bound.ymin + this.bound.ymax) / 2.0, (this.bound.zmin + this.bound.zmax) / 2.0};
        }
        return c;
    }

    public Rectangle3D getBoundingBox() {
        Rectangle3D rect3d = new Rectangle3D();
        double[][] bnds = rect3d.getBounds();
        bnds[0][0] = this.getXmin();
        bnds[1][0] = this.getXmax();
        bnds[0][1] = this.getYmin();
        bnds[1][1] = this.getYmax();
        bnds[0][2] = this.getZmin();
        bnds[1][2] = this.getZmax();
        rect3d.setBounds(bnds);
        if (Rn.isNan(bnds[0]) || Rn.isNan(bnds[1])) {
            return Rectangle3D.EMPTY_BOX;
        }
        return rect3d;
    }

    public static Rectangle3D getBoundingBox(double[] initialMatrix, SceneGraphComponent sgc) {
        BoundingBoxTraversal bt = new BoundingBoxTraversal();
        if (initialMatrix != null) {
            bt.setInitialMatrix(initialMatrix);
        }
        bt.traverse(sgc);
        return bt.getBoundingBox();
    }

    private class Bound {
        double xmin;
        double xmax = -1.7976931348623157E308;
        double ymin;
        double ymax = -1.7976931348623157E308;
        double zmin = Double.MAX_VALUE;
        double zmax = -1.7976931348623157E308;

        public Bound() {
            this.ymin = Double.MAX_VALUE;
            this.xmin = Double.MAX_VALUE;
        }
    }
}

