/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.geometry.Primitives;
import de.jreality.geometry.TubeUtility;
import de.jreality.math.FactoredMatrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Sphere;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;

public class BallAndStickFactory {
    IndexedLineSet ils;
    double stickRadius = 0.025;
    double ballRadius = 0.05;
    Color stickColor = Color.YELLOW;
    Color ballColor = Color.GREEN;
    Color arrowColor = Color.RED;
    int metric = 0;
    boolean showBalls = true;
    boolean showSticks = true;
    boolean realSpheres = true;
    boolean drawArrows = false;
    SceneGraphComponent theResult;
    double arrowPosition = 0.5;
    double arrowScale = 0.1;
    double arrowSlope = 1.0;
    Appearance ballsAp;
    Appearance sticksAp;
    Appearance arrowsAp;
    Appearance topAp;
    Geometry stickGeometry = null;
    Geometry ballGeometry = null;
    private static IndexedFaceSet urCone = null;
    double[][] crossSection = null;
    static double[][] octagonalCrossSection = new double[][]{{1.0, 0.0, 0.0}, {0.707, 0.707, 0.0}, {0.0, 1.0, 0.0}, {-0.707, 0.707, 0.0}, {-1.0, 0.0, 0.0}, {-0.707, -0.707, 0.0}, {0.0, -1.0, 0.0}, {0.707, -0.707, 0.0}};
    private SceneGraphComponent sticks;
    private SceneGraphComponent balls;
    private SceneGraphComponent arrow;

    public BallAndStickFactory(IndexedLineSet i) {
        this.ils = i;
        this.sticks = new SceneGraphComponent("sticks");
        this.balls = new SceneGraphComponent("balls");
        this.topAp = new Appearance();
        this.theResult = new SceneGraphComponent("BAS");
        this.theResult.setAppearance(this.topAp);
        this.sticksAp = new Appearance();
        this.sticksAp.setAttribute("showFaces", true);
        this.sticksAp.setAttribute("showLines", false);
        this.sticksAp.setAttribute("showPoints", false);
        this.sticks.setAppearance(this.sticksAp);
        this.ballsAp = new Appearance();
        this.balls.setAppearance(this.ballsAp);
        this.arrowsAp = new Appearance();
        this.theResult.addChild(this.sticks);
        this.theResult.addChild(this.balls);
    }

    public void update() {
        int i;
        int n;
        DataList vertices;
        this.topAp.setAttribute("metric", this.metric);
        this.sticks.setVisible(this.showSticks);
        this.balls.setVisible(this.showBalls);
        if (this.stickColor != null) {
            this.sticksAp.setAttribute("polygonShader.diffuseColor", this.stickColor);
        }
        if (this.arrowColor != null) {
            this.arrowsAp.setAttribute("polygonShader.diffuseColor", this.arrowColor);
        }
        if (this.showBalls) {
            if (!this.realSpheres) {
                this.balls.setGeometry(this.ils);
                this.ballsAp.setAttribute("pointShader.pointRadius", this.ballRadius);
                this.ballsAp.setAttribute("showFaces", false);
                this.ballsAp.setAttribute("showLines", false);
                this.ballsAp.setAttribute("showPoints", true);
                this.ballsAp.setAttribute("pointShader.spheresDraw", true);
                if (this.ballColor != null) {
                    this.ballsAp.setAttribute("pointShader.diffuseColor", this.ballColor);
                    this.ballsAp.setAttribute("pointShader.polygonShader.diffuseColor", this.ballColor);
                }
            } else {
                this.balls.setGeometry(null);
                this.ballsAp.setAttribute("showFaces", true);
                this.ballsAp.setAttribute("showLines", false);
                this.ballsAp.setAttribute("showPoints", false);
                if (this.ballColor != null) {
                    this.ballsAp.setAttribute("polygonShader.diffuseColor", this.ballColor);
                }
                vertices = this.ils.getVertexAttributes(Attribute.COORDINATES);
                DataList vertexColors = this.ils.getVertexAttributes(Attribute.COLORS);
                n = this.ils.getNumPoints();
                SceneGraphUtility.removeChildren(this.balls);
                for (i = 0; i < n; ++i) {
                    double[] p1 = vertices.item(i).toDoubleArray(null);
                    SceneGraphComponent cc = new SceneGraphComponent("ball" + i);
                    MatrixBuilder.init(null, this.metric).translate(p1).scale(this.ballRadius).assignTo(cc);
                    if (this.ballGeometry != null) {
                        cc.setGeometry(this.ballGeometry);
                    } else {
                        cc.setGeometry(new Sphere());
                    }
                    if (vertexColors != null) {
                        Color ccc = null;
                        double[] dcc = vertexColors.item(i).toDoubleArray(null);
                        ccc = dcc.length == 4 ? new Color((float)dcc[0], (float)dcc[1], (float)dcc[2], (float)dcc[3]) : new Color((float)dcc[0], (float)dcc[1], (float)dcc[2]);
                        Appearance ap = new Appearance();
                        ap.setAttribute("polygonShader.diffuseColor", ccc);
                        cc.setAppearance(ap);
                    }
                    this.balls.addChild(cc);
                }
            }
        }
        if (this.showSticks) {
            vertices = this.ils.getVertexAttributes(Attribute.COORDINATES);
            DataList edgeColors = this.ils.getEdgeAttributes(Attribute.COLORS);
            n = this.ils.getNumEdges();
            SceneGraphUtility.removeChildren(this.sticks);
            for (i = 0; i < n; ++i) {
                int[] ed = this.ils.getEdgeAttributes(Attribute.INDICES).item(i).toIntArray(null);
                int m = ed.length;
                for (int j = 0; j < m - 1; ++j) {
                    int k = ed[j];
                    double[] p1 = vertices.item(k).toDoubleArray(null);
                    k = ed[j + 1];
                    double[] p2 = vertices.item(k).toDoubleArray(null);
                    SceneGraphComponent cc = TubeUtility.tubeOneEdge(p1, p2, this.stickRadius, this.crossSection, this.metric);
                    if (this.stickGeometry != null) {
                        cc.setGeometry(this.stickGeometry);
                    }
                    if (edgeColors != null) {
                        Color ccc = null;
                        double[] dcc = edgeColors.item(i).toDoubleArray(null);
                        ccc = dcc.length == 4 ? new Color((float)dcc[0], (float)dcc[1], (float)dcc[2], (float)dcc[3]) : new Color((float)dcc[0], (float)dcc[1], (float)dcc[2]);
                        Appearance ap = new Appearance();
                        ap.setAttribute("polygonShader.diffuseColor", ccc);
                        cc.setAppearance(ap);
                    }
                    if (cc != null) {
                        this.sticks.addChild(cc);
                    }
                    if (!this.drawArrows) continue;
                    this.arrow = new SceneGraphComponent("Arrows");
                    FactoredMatrix arrowM = new FactoredMatrix(this.metric);
                    double d = p1.length == 3 ? Rn.euclideanDistance(p1, p2) : Pn.distanceBetween(p1, p2, this.metric);
                    double flatten = this.arrowSlope / d;
                    double stretch = this.arrowScale / this.stickRadius;
                    arrowM.setStretch(stretch, stretch, this.arrowScale * flatten);
                    arrowM.setTranslation(0.0, 0.0, this.arrowPosition - 0.5);
                    arrowM.update();
                    arrowM.assignTo(this.arrow);
                    this.arrow.setAppearance(this.arrowsAp);
                    this.arrow.setGeometry(urCone);
                    cc.addChild(this.arrow);
                }
            }
        }
    }

    public void setStickRadius(double r) {
        this.stickRadius = r;
    }

    public void setBallColor(Color ballColor) {
        this.ballColor = ballColor;
    }

    public void setBallRadius(double ballRadius) {
        this.ballRadius = ballRadius;
    }

    public void setStickColor(Color stickColor) {
        this.stickColor = stickColor;
    }

    public void setArrowColor(Color arrowColor) {
        this.arrowColor = arrowColor;
    }

    public void setMetric(int metric) {
        this.metric = metric;
    }

    public SceneGraphComponent getSceneGraphComponent() {
        return this.theResult;
    }

    protected static SceneGraphComponent sticks(IndexedLineSet ifs, double rad, int metric) {
        return BallAndStickFactory.sticks(null, ifs, rad, metric);
    }

    public static SceneGraphComponent sticks(SceneGraphComponent sgc, IndexedLineSet ifs, double rad, int metric) {
        if (sgc == null) {
            sgc = new SceneGraphComponent();
        }
        DataList vertices = ifs.getVertexAttributes(Attribute.COORDINATES);
        int n = ifs.getNumEdges();
        for (int i = 0; i < n; ++i) {
            int[] ed = ifs.getEdgeAttributes(Attribute.INDICES).item(i).toIntArray(null);
            int m = ed.length;
            for (int j = 0; j < m - 1; ++j) {
                double[] p2;
                int k = ed[j];
                double[] p1 = vertices.item(k).toDoubleArray(null);
                SceneGraphComponent cc = TubeUtility.tubeOneEdge(p1, p2 = vertices.item(k = ed[j + 1]).toDoubleArray(null), rad, null, metric);
                if (cc == null) continue;
                sgc.addChild(cc);
            }
        }
        return sgc;
    }

    public double getArrowPosition() {
        return this.arrowPosition;
    }

    public void setArrowPosition(double arrowPosition) {
        this.arrowPosition = arrowPosition;
    }

    public double getArrowScale() {
        return this.arrowScale;
    }

    public void setArrowScale(double arrowScale) {
        this.arrowScale = arrowScale;
    }

    public double getArrowSlope() {
        return this.arrowSlope;
    }

    public void setArrowSlope(double arrowSlope) {
        this.arrowSlope = arrowSlope;
    }

    public boolean isShowArrows() {
        return this.drawArrows;
    }

    public void setShowArrows(boolean drawArrows) {
        this.drawArrows = drawArrows;
    }

    public boolean isShowBalls() {
        return this.showBalls;
    }

    public void setShowBalls(boolean showBalls) {
        this.showBalls = showBalls;
    }

    public boolean isShowSticks() {
        return this.showSticks;
    }

    public void setShowSticks(boolean showSticks) {
        this.showSticks = showSticks;
    }

    public double[][] getCrossSection() {
        return this.crossSection;
    }

    public void setCrossSection(double[][] crossSection) {
        this.crossSection = crossSection;
    }

    public Geometry getBallGeometry() {
        return this.ballGeometry;
    }

    public void setBallGeometry(Geometry ballGeometry) {
        this.ballGeometry = ballGeometry;
    }

    public Geometry getStickGeometry() {
        return this.stickGeometry;
    }

    public void setStickGeometry(Geometry stickGeometry) {
        this.stickGeometry = stickGeometry;
    }

    static {
        urCone = Primitives.pyramid(octagonalCrossSection, new double[]{0.0, 0.0, 1.0});
        IndexedFaceSetUtility.calculateAndSetVertexNormals(urCone);
    }
}

