/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.AbstractGeometryFactory;
import de.jreality.geometry.GeometryAttributeListSet;
import de.jreality.geometry.OoNode;
import de.jreality.scene.PointSet;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DataListSet;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.StorageModel;
import de.jreality.scene.data.StringArray;
import java.awt.Color;

public class AbstractPointSetFactory
extends AbstractGeometryFactory {
    final PointSet ps;
    final GeometryAttributeListSet vertex = new GeometryAttributeListSet(this, "VERTEX");
    OoNode vertexCount = this.node("vertexCount", Integer.class, 0);
    AttributeGenerator vertexLabels = this.attributeGeneratorNode(this.vertex, String[].class, Attribute.LABELS);

    AbstractPointSetFactory(PointSet ps, int metric) {
        super(ps, metric);
        this.vertexLabels.addIngr(this.vertexCount);
        this.vertexLabels.setUpdateMethod(new OoNode.UpdateMethod(){

            public Object update(Object object) {
                return AbstractPointSetFactory.this.indexString(AbstractPointSetFactory.this.nov());
            }
        });
        this.ps = ps;
    }

    public AbstractPointSetFactory() {
        this(new PointSet(), 0);
    }

    int nov() {
        return (Integer)this.vertexCount.getObject();
    }

    public int getVertexCount() {
        return this.nov();
    }

    public void setVertexCount(int count) {
        this.vertex.setCount(count);
        this.vertexCount.setObject(new Integer(count));
    }

    protected void setVertexAttribute(Attribute attr, DataList data) {
        this.vertex.setAttribute(attr, data);
    }

    protected void setVertexAttribute(Attribute attr, double[] data) {
        if (data != null && (this.nov() == 0 && data.length != 0 || data.length % this.nov() != 0)) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setVertexAttribute(attr, data == null ? null : new DoubleArrayArray.Inlined(data, data.length / this.nov()));
    }

    protected void setVertexAttribute(Attribute attr, double[][] data) {
        this.setVertexAttribute(attr, StorageModel.DOUBLE_ARRAY.array(data[0].length).createReadOnly(data));
    }

    protected void setVertexAttributes(DataListSet dls) {
        this.vertex.setAttributes(dls);
    }

    protected void setVertexCoordinates(DataList data) {
        this.setVertexAttribute(Attribute.COORDINATES, data);
    }

    protected void setVertexCoordinates(double[] data) {
        if (data != null && (this.nov() == 0 && data.length != 0 || data.length % this.nov() != 0)) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setVertexAttribute(Attribute.COORDINATES, data == null ? null : new DoubleArrayArray.Inlined(data, data.length / this.nov()));
    }

    protected void setVertexCoordinates(double[][] data) {
        this.setVertexAttribute(Attribute.COORDINATES, StorageModel.DOUBLE_ARRAY.array(data[0].length).createReadOnly(data, 0, this.vertex.getCount()));
    }

    protected void setVertexNormals(DataList data) {
        this.setVertexAttribute(Attribute.NORMALS, data);
    }

    protected void setVertexNormals(double[] data) {
        if (data != null && data.length % this.nov() != 0) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setVertexAttribute(Attribute.NORMALS, data == null ? null : new DoubleArrayArray.Inlined(data, data.length / this.nov()));
    }

    protected void setVertexNormals(double[][] data) {
        this.setVertexAttribute(Attribute.NORMALS, new DoubleArrayArray.Array(data, data[0].length));
    }

    protected void setVertexColors(DataList data) {
        this.setVertexAttribute(Attribute.COLORS, data);
    }

    protected void setVertexColors(double[] data) {
        if (data != null && data.length % this.nov() != 0) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setVertexAttribute(Attribute.COLORS, data == null ? null : new DoubleArrayArray.Inlined(data, data.length / this.nov()));
    }

    protected void setVertexColors(Color[] data) {
        this.setVertexColors(AbstractPointSetFactory.toDoubleArray(data));
    }

    protected void setVertexColors(double[][] data) {
        this.setVertexAttribute(Attribute.COLORS, data == null ? null : new DoubleArrayArray.Array(data, data[0].length));
    }

    protected void setVertexTextureCoordinates(DataList data) {
        this.setVertexAttribute(Attribute.TEXTURE_COORDINATES, data);
    }

    protected void setVertexTextureCoordinates(double[] data) {
        if (data != null && data.length % this.nov() != 0) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setVertexAttribute(Attribute.TEXTURE_COORDINATES, data == null ? null : new DoubleArrayArray.Inlined(data, data.length / this.nov()));
    }

    protected void setVertexTextureCoordinates(double[][] data) {
        this.setVertexAttribute(Attribute.TEXTURE_COORDINATES, new DoubleArrayArray.Array(data, data[0].length));
    }

    protected void setVertexLabels(DataList data) {
        this.setVertexAttribute(Attribute.LABELS, data);
    }

    protected void setVertexLabels(String[] data) {
        if (data != null && data.length != this.nov()) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setVertexAttribute(Attribute.LABELS, data == null ? null : new StringArray(data));
    }

    protected void setVertexRelativeRadii(DataList data) {
        this.setVertexAttribute(Attribute.RELATIVE_RADII, data);
    }

    protected void setVertexRelativeRadii(double[] data) {
        if (data != null && data.length != this.nov()) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setVertexAttribute(Attribute.RELATIVE_RADII, data == null ? null : new DoubleArray(data));
    }

    String[] indexString(int nov) {
        if (nov == 0) {
            return null;
        }
        String[] labels = new String[nov];
        for (int i = 0; i < nov; ++i) {
            labels[i] = Integer.toString(i);
        }
        return labels;
    }

    void recompute() {
        super.recompute();
        this.vertexLabels.update();
    }

    void updateImpl() {
        super.updateImpl();
        if (this.ps.getNumPoints() != this.getVertexCount()) {
            this.ps.setNumPoints(this.getVertexCount());
        }
        this.updatePointSet();
    }

    void updatePointSet() {
        this.updateGeometryAttributeCathegory(this.vertex);
        this.vertexLabels.updateArray();
    }

    public PointSet getPointSet() {
        return this.ps;
    }

    public boolean isGenerateVertexLabels() {
        return this.vertexLabels.isGenerate();
    }

    public void setGenerateVertexLabels(boolean generateVertexLabels) {
        this.vertexLabels.setGenerate(generateVertexLabels);
    }

    OoNode node(String name, Class type, Object value) {
        OoNode node = new OoNode(name, type, (OoNode.IsUpdateCounter)this.update);
        node.setObject(value);
        return node;
    }

    OoNode node(String name, Class type) {
        return new OoNode(name, type, (OoNode.IsUpdateCounter)this.update);
    }

    AttributeGenerator attributeGeneratorNode(GeometryAttributeListSet gals, Class type, Attribute attr) {
        return new AttributeGenerator(gals, type, attr, this);
    }

    static double[] toDoubleArray(Color[] color) {
        float[] c = new float[5];
        double[] array = new double[color.length * 4];
        int i = 0;
        int j = 0;
        while (i < array.length) {
            color[j].getComponents(c);
            array[i + 0] = c[0];
            array[i + 1] = c[1];
            array[i + 2] = c[2];
            array[i + 3] = c[3];
            i += 4;
            ++j;
        }
        return array;
    }

    static class AttributeGenerator
    extends OoNode {
        final GeometryAttributeListSet gals;
        final Attribute attr;
        final AbstractGeometryFactory factory;
        boolean generate = false;

        AttributeGenerator(GeometryAttributeListSet gals, Class type, Attribute attr, AbstractGeometryFactory factory) {
            super(gals.category.toLowerCase() + "." + attr.getName(), type, (OoNode.IsUpdateCounter)factory.update);
            this.gals = gals;
            this.attr = attr;
            this.factory = factory;
            this.addIngr(this.gals.attributeNode(attr));
            this.setUpdateMethod(null);
        }

        public void updateArray() {
            this.factory.updateNode(this.gals, this.attr, this.generate, this);
        }

        public void update() {
            super.update();
        }

        public void setUpdateMethod(final OoNode.UpdateMethod method) {
            super.setUpdateMethod(new OoNode.UpdateMethod(){

                public Object update(Object object) {
                    if (AttributeGenerator.this.generate && method != null) {
                        return method.update(object);
                    }
                    DataList dl = AttributeGenerator.this.gals.DLS.getList(AttributeGenerator.this.attr);
                    return dl == null ? null : AttributeGenerator.this.converteDataListToArray(dl);
                }
            });
        }

        boolean isGenerate() {
            return this.generate;
        }

        void setGenerate(boolean generate) {
            if (this.generate == generate) {
                return;
            }
            this.outdate();
            this.generate = generate;
            if (generate) {
                if (this.gals.DLS.containsAttribute(this.attr)) {
                    throw new UnsupportedOperationException("you cannot not generate the attribute " + this.attr + "because it is explicitly set. Unset it first.");
                }
                this.gals.blockAttribute(this.attr);
            } else {
                this.gals.unblockAttribute(this.attr);
            }
        }
    }
}

