/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.AbstractIndexedLineSetFactory;
import de.jreality.geometry.AbstractPointSetFactory;
import de.jreality.geometry.GeometryAttributeListSet;
import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.geometry.OoNode;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import de.jreality.scene.data.DataListSet;
import de.jreality.scene.data.DoubleArrayArray;
import de.jreality.scene.data.IntArrayArray;
import de.jreality.scene.data.StorageModel;
import de.jreality.scene.data.StringArray;
import de.jreality.scene.pick.AABBTree;
import de.jreality.util.PickUtility;
import java.awt.Color;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractIndexedFaceSetFactory
extends AbstractIndexedLineSetFactory {
    final IndexedFaceSet ifs;
    GeometryAttributeListSet face = new GeometryAttributeListSet(this, "FACE");
    AbstractPointSetFactory.AttributeGenerator vertexCoordinates = this.attributeGeneratorNode(this.vertex, double[][].class, Attribute.COORDINATES);
    AbstractPointSetFactory.AttributeGenerator vertexNormals = this.attributeGeneratorNode(this.vertex, double[][].class, Attribute.NORMALS);
    AbstractPointSetFactory.AttributeGenerator edgeIndices = this.attributeGeneratorNode(this.edge, int[][].class, Attribute.INDICES);
    AbstractPointSetFactory.AttributeGenerator faceIndices = this.attributeGeneratorNode(this.face, int[][].class, Attribute.INDICES);
    AbstractPointSetFactory.AttributeGenerator faceLabels = this.attributeGeneratorNode(this.face, String[].class, Attribute.LABELS);
    AbstractPointSetFactory.AttributeGenerator faceNormals = this.attributeGeneratorNode(this.face, double[][].class, Attribute.NORMALS);
    OoNode faceCount = this.node("faceCount", Integer.class, 0);
    OoNode aabbTree = this.node("aabbTree", AABBTree.class, null);
    boolean generateAABBTree = false;
    OoNode unwrapFaceIndices = this.node("unwrapFaceIndices", int[][].class, null);
    OoNode actualVertexOfUnwrapVertex = this.node("actualVertexOfUnwrapVertex", int[].class, null);

    AbstractIndexedFaceSetFactory(IndexedFaceSet ifs, int metric, boolean generateEdgesFromFaces, boolean generateVertexNormals, boolean generateFaceNormals) {
        super(ifs, metric);
        this.actualVertexOfUnwrapVertex.addIngr(this.unwrapFaceIndices);
        this.actualVertexOfUnwrapVertex.addIngr(this.faceIndices);
        this.actualVertexOfUnwrapVertex.setUpdateMethod(new OoNode.UpdateMethod(){

            public Object update(Object object) {
                return AbstractIndexedFaceSetFactory.this.determineActualVertexOfUnwrapVertex((int[])object);
            }
        });
        this.faceLabels.addIngr(this.faceCount);
        this.faceLabels.setUpdateMethod(new OoNode.UpdateMethod(){

            public Object update(Object object) {
                return AbstractIndexedFaceSetFactory.this.indexString(AbstractIndexedFaceSetFactory.this.nof());
            }
        });
        this.aabbTree.addIngr(this.vertexCoordinates);
        this.aabbTree.addIngr(this.faceIndices);
        this.aabbTree.setUpdateMethod(new OoNode.UpdateMethod(){

            public Object update(Object object) {
                return AbstractIndexedFaceSetFactory.this.isGenerateAABBTree() ? AABBTree.construct((double[][])AbstractIndexedFaceSetFactory.this.vertexCoordinates.getObject(), (int[][])AbstractIndexedFaceSetFactory.this.faceIndices.getObject()) : null;
            }
        });
        this.edgeIndices.addIngr(this.faceIndices);
        if (this.isGenerateEdgesFromFaces()) {
            this.edgeIndices.addDeps(this.edgeCount);
        }
        this.edgeIndices.setUpdateMethod(new OoNode.UpdateMethod(){

            public Object update(Object object) {
                return AbstractIndexedFaceSetFactory.this.generateEdgeIndices();
            }
        });
        this.edgeCount.setUpdateMethod(new OoNode.UpdateMethod(){

            public Object update(Object object) {
                int count = AbstractIndexedFaceSetFactory.this.edgeIndices.isGenerate() ? ((int[][])AbstractIndexedFaceSetFactory.this.edgeIndices.getObject()).length : (AbstractIndexedFaceSetFactory.this.edge.DLS.containsAttribute(Attribute.INDICES) ? AbstractIndexedFaceSetFactory.this.edge.DLS.getListLength() : 0);
                return new Integer(count);
            }
        });
        this.faceNormals.addIngr(this.metric);
        this.faceNormals.addIngr(this.faceIndices);
        this.faceNormals.addIngr(this.vertexCoordinates);
        this.faceNormals.addIngr(this.actualVertexOfUnwrapVertex);
        this.faceNormals.setUpdateMethod(new OoNode.UpdateMethod(){

            public Object update(Object object) {
                return AbstractIndexedFaceSetFactory.this.generateFaceNormals((double[][])object);
            }
        });
        this.vertexNormals.addIngr(this.metric);
        this.vertexNormals.addIngr(this.faceNormals);
        this.vertexNormals.setUpdateMethod(new OoNode.UpdateMethod(){

            public Object update(Object object) {
                return AbstractIndexedFaceSetFactory.this.generateVertexNormals((double[][])object);
            }
        });
        this.ifs = ifs;
        this.setGenerateEdgesFromFaces(generateEdgesFromFaces);
        this.setGenerateFaceNormals(generateVertexNormals);
        this.setGenerateFaceNormals(generateFaceNormals);
    }

    AbstractIndexedFaceSetFactory(int metric, boolean generateEdgesFromFaces, boolean generateVertexNormals, boolean generateFaceNormals) {
        this(new IndexedFaceSet(0, 0), metric, generateEdgesFromFaces, generateVertexNormals, generateFaceNormals);
    }

    AbstractIndexedFaceSetFactory(IndexedFaceSet existing, int metric) {
        this(existing, metric, false, false, false);
    }

    AbstractIndexedFaceSetFactory(int metric) {
        this(metric, false, false, false);
    }

    AbstractIndexedFaceSetFactory(IndexedFaceSet existing) {
        this(existing, 0, false, false, false);
    }

    public AbstractIndexedFaceSetFactory() {
        this(0);
    }

    protected int nof() {
        return (Integer)this.faceCount.getObject();
    }

    protected int getFaceCount() {
        return this.nof();
    }

    void setFaceCount(int count) {
        this.face.setCount(count);
        this.faceCount.setObject(new Integer(count));
    }

    protected void setFaceAttribute(Attribute attr, DataList data) {
        this.face.setAttribute(attr, data);
    }

    protected void setFaceAttribute(Attribute attr, double[] data) {
        if (data != null && (this.nof() == 0 && data.length != 0 || data.length % this.nof() != 0)) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setFaceAttribute(attr, data == null ? null : new DoubleArrayArray.Inlined(data, data.length / this.nof()));
    }

    protected void setFaceAttribute(Attribute attr, double[][] data) {
        this.setFaceAttribute(attr, StorageModel.DOUBLE_ARRAY.array(data[0].length).createReadOnly(data));
    }

    protected void setFaceAttributes(DataListSet dls) {
        this.face.setAttributes(dls);
    }

    protected void setFaceIndices(DataList data) {
        this.setFaceAttribute(Attribute.INDICES, data);
    }

    protected void setFaceIndices(int[][] data) {
        this.setFaceAttribute(Attribute.INDICES, new IntArrayArray.Array(data));
    }

    protected void setFaceIndices(int[] data, int pointCountPerFace) {
        if (data != null && data.length != pointCountPerFace * this.nof()) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setFaceAttribute(Attribute.INDICES, data == null ? null : new IntArrayArray.Inlined(data, pointCountPerFace));
    }

    protected void setFaceIndices(int[] data) {
        this.setFaceIndices(data, 3);
    }

    protected void setUnwrapFaceIndices(DataList data) {
        if (data != null && data.size() != this.nof()) {
            throw new IllegalArgumentException("Data list of face indices for unwrap faces has wrong length.");
        }
        this.setUnwrapFaceIndices(data == null ? (int[][])null : data.toIntArrayArray(null));
    }

    protected void setUnwrapFaceIndices(int[][] data) {
        if (data != null && data.length != this.nof()) {
            throw new IllegalArgumentException("Array of face indices for unwrap faces has wrong length.");
        }
        this.unwrapFaceIndices.setObject(data);
    }

    protected void setUnwrapFaceIndices(int[] data, int pointCountPerFace) {
        if (data != null && data.length != pointCountPerFace * this.nof()) {
            throw new IllegalArgumentException("Array of indices for unwrap faces has wrong length.");
        }
        this.setUnwrapFaceIndices(data == null ? null : new IntArrayArray.Inlined(data, pointCountPerFace));
    }

    protected void setUnwrapFaceIndices(int[] data) {
        this.setUnwrapFaceIndices(data, 3);
    }

    protected void setFaceNormals(DataList data) {
        this.setFaceAttribute(Attribute.NORMALS, data);
    }

    protected void setFaceNormals(double[] data) {
        if (data != null && data.length % this.nof() != 0) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setFaceAttribute(Attribute.NORMALS, data != null ? new DoubleArrayArray.Inlined(data, data.length / this.nof()) : null);
    }

    protected void setFaceNormals(double[][] data) {
        this.setFaceAttribute(Attribute.NORMALS, new DoubleArrayArray.Array(data));
    }

    protected void setFaceColors(DataList data) {
        this.setFaceAttribute(Attribute.COLORS, data);
    }

    protected void setFaceColors(double[] data) {
        if (data != null && data.length % this.nof() != 0) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setFaceAttribute(Attribute.COLORS, data == null ? null : new DoubleArrayArray.Inlined(data, data.length / this.nof()));
    }

    protected void setFaceColors(Color[] colors) {
        double[] data = new double[colors.length * 4];
        float[] col = new float[4];
        for (int i = 0; i < colors.length; ++i) {
            colors[i].getRGBComponents(col);
            data[4 * i] = col[0];
            data[4 * i + 1] = col[1];
            data[4 * i + 2] = col[2];
            data[4 * i + 3] = col[3];
        }
        this.setFaceAttribute(Attribute.COLORS, new DoubleArrayArray.Inlined(data, 4));
    }

    protected void setFaceColors(double[][] data) {
        this.setFaceAttribute(Attribute.COLORS, new DoubleArrayArray.Array(data));
    }

    protected void setFaceLabels(DataList data) {
        if (data != null && data.size() != this.nof()) {
            throw new IllegalArgumentException("array has wrong length");
        }
        if (data instanceof StringArray) {
            throw new IllegalArgumentException("argument is not a de.jreality.scene.data.StringArray");
        }
        this.setVertexAttribute(Attribute.LABELS, data);
    }

    protected void setFaceLabels(String[] data) {
        if (data != null && data.length != this.nof()) {
            throw new IllegalArgumentException("array has wrong length");
        }
        this.setFaceAttribute(Attribute.LABELS, data == null ? null : new StringArray(data));
    }

    public IndexedFaceSet getIndexedFaceSet() {
        return this.ifs;
    }

    public boolean isGenerateEdgesFromFaces() {
        return this.edgeIndices.isGenerate();
    }

    public void setGenerateEdgesFromFaces(boolean generateEdgesFromFaces) {
        if (generateEdgesFromFaces && this.edge.hasEntries()) {
            throw new UnsupportedOperationException("You cannot generate edges form faces while edge attributes are set.Set them to null before.");
        }
        this.edgeIndices.setGenerate(generateEdgesFromFaces);
        if (this.isGenerateEdgesFromFaces()) {
            this.edgeIndices.addDeps(this.edgeCount);
        } else {
            this.edgeIndices.removeDeps(this.edgeCount);
        }
        this.edge.blockAttributeCount = generateEdgesFromFaces;
    }

    public boolean isGenerateVertexNormals() {
        return this.vertexNormals.isGenerate();
    }

    public void setGenerateVertexNormals(boolean generateVertexNormals) {
        this.vertexNormals.setGenerate(generateVertexNormals);
    }

    public boolean isGenerateFaceNormals() {
        return this.faceNormals.isGenerate();
    }

    public void setGenerateFaceNormals(boolean generateFaceNormals) {
        this.faceNormals.setGenerate(generateFaceNormals);
    }

    public boolean isGenerateFaceLabels() {
        return this.faceLabels.isGenerate();
    }

    public void setGenerateFaceLabels(boolean generateFaceLabels) {
        this.faceLabels.setGenerate(generateFaceLabels);
    }

    public boolean isGenerateAABBTree() {
        return this.generateAABBTree;
    }

    public void setGenerateAABBTree(boolean generate) {
        if (this.generateAABBTree == generate) {
            return;
        }
        this.aabbTree.outdate();
        this.generateAABBTree = generate;
    }

    int[] determineActualVertexOfUnwrapVertex(int[] actualVOUV) {
        int[][] fi = (int[][])this.faceIndices.getObject();
        int[][] unwrapFI = (int[][])this.unwrapFaceIndices.getObject();
        return AbstractIndexedFaceSetFactory.determineActualVertexOfUnwrapVertexImpl(fi, unwrapFI, actualVOUV, this.nov());
    }

    static int[] determineActualVertexOfUnwrapVertexImpl(int[][] fi, int[][] unwrapFI, int[] actualVOUV, int nv) {
        if (fi == null || unwrapFI == null) {
            return null;
        }
        if (actualVOUV == null || actualVOUV.length != nv) {
            actualVOUV = new int[nv];
        }
        for (int f = 0; f < fi.length; ++f) {
            for (int v = 0; v < fi[f].length; ++v) {
                actualVOUV[unwrapFI[f][v]] = fi[f][v];
            }
        }
        return actualVOUV;
    }

    int[][] generateEdgeIndices() {
        int[][] fi = (int[][])this.faceIndices.getObject();
        if (fi == null) {
            return null;
        }
        return IndexedFaceSetUtility.edgesFromFaces(fi).toIntArrayArray(null);
    }

    double[][] generateFaceNormals(double[][] faceNormals) {
        int[][] fi = (int[][])this.faceIndices.getObject();
        double[][] vc = (double[][])this.vertexCoordinates.getObject();
        if (fi == null || vc == null) {
            return null;
        }
        this.log("compute", Attribute.NORMALS, "face");
        return IndexedFaceSetUtility.calculateFaceNormals(fi, vc, this.getMetric());
    }

    double[][] generateVertexNormals(double[][] vertexNormals) {
        int[][] fi = (int[][])this.faceIndices.getObject();
        double[][] vc = (double[][])this.vertexCoordinates.getObject();
        double[][] fn = (double[][])this.faceNormals.getObject();
        if (fi == null || vc == null) {
            return null;
        }
        if (fn == null) {
            fn = IndexedFaceSetUtility.calculateFaceNormals(fi, vc, this.getMetric());
        }
        vertexNormals = IndexedFaceSetUtility.calculateVertexNormals(fi, vc, fn, this.getMetric());
        int[] translation = (int[])this.actualVertexOfUnwrapVertex.getObject();
        if (translation != null) {
            for (int i = 0; i < vertexNormals.length && i < translation.length; ++i) {
                if (i == translation[i]) continue;
                System.arraycopy(vertexNormals[translation[i]], 0, vertexNormals[i], 0, vertexNormals[translation[i]].length);
            }
        }
        return vertexNormals;
    }

    @Override
    void recompute() {
        super.recompute();
        this.aabbTree.update();
        this.actualVertexOfUnwrapVertex.update();
        this.faceLabels.update();
        this.edgeIndices.update();
        this.faceNormals.update();
        if (this.unwrapFaceIndices.getObject() == null && this.nodeWasUpdated(this.unwrapFaceIndices)) {
            this.vertexNormals.outdate();
        }
        this.vertexNormals.update();
    }

    @Override
    protected void updateImpl() {
        super.updateImpl();
        if (this.ifs.getNumFaces() != this.getFaceCount()) {
            this.ifs.setNumFaces(this.getFaceCount());
        }
        this.updateGeometryAttributeCathegory(this.face);
        if (this.nodeWasUpdated(this.aabbTree)) {
            this.ifs.setGeometryAttributes(PickUtility.AABB_TREE, this.aabbTree.getObject());
        }
        if (this.unwrapFaceIndices.getObject() != null) {
            this.ifs.setFaceAttributes(Attribute.INDICES, StorageModel.INT_ARRAY_ARRAY.createReadOnly((int[][])this.unwrapFaceIndices.getObject()));
        } else if (this.faceIndices.getObject() != null && this.nodeWasUpdated(this.unwrapFaceIndices)) {
            this.ifs.setFaceAttributes(Attribute.INDICES, StorageModel.INT_ARRAY_ARRAY.createReadOnly((int[][])this.faceIndices.getObject()));
        }
        this.edgeIndices.updateArray();
        this.faceLabels.updateArray();
        this.faceNormals.updateArray();
        this.vertexNormals.updateArray();
    }

    protected <E> E[] unwrapVertexAttributes(E[] data) {
        return (Object[])AbstractIndexedFaceSetFactory.unwrapVertexAttributes(data, data[0].getClass(), 1, this);
    }

    protected static <E> E[] unwrapVertexAttributes(E[] data, int[][] faceIndices, int[][] unwrapFaceIndices, int numberOfUnwrapVertices) {
        return (Object[])AbstractIndexedFaceSetFactory.unwrapVertexAttributes(data, data[0].getClass(), 1, faceIndices, unwrapFaceIndices, numberOfUnwrapVertices);
    }

    protected int[] unwrapVertexAttributes(int[] data, int entriesPerVertex) {
        return (int[])AbstractIndexedFaceSetFactory.unwrapVertexAttributes((Object)data, Integer.TYPE, entriesPerVertex, this);
    }

    protected static int[] unwrapVertexAttributes(int[] data, int entriesPerVertex, int[][] faceIndices, int[][] unwrapFaceIndices, int numberOfUnwrapVertices) {
        return (int[])AbstractIndexedFaceSetFactory.unwrapVertexAttributes(data, Integer.TYPE, entriesPerVertex, faceIndices, unwrapFaceIndices, numberOfUnwrapVertices);
    }

    protected boolean[] unwrapVertexAttributes(boolean[] data, int entriesPerVertex) {
        return (boolean[])AbstractIndexedFaceSetFactory.unwrapVertexAttributes((Object)data, Boolean.TYPE, entriesPerVertex, this);
    }

    protected static boolean[] unwrapVertexAttributes(boolean[] data, int entriesPerVertex, int[][] faceIndices, int[][] unwrapFaceIndices, int numberOfUnwrapVertices) {
        return (boolean[])AbstractIndexedFaceSetFactory.unwrapVertexAttributes(data, Boolean.TYPE, entriesPerVertex, faceIndices, unwrapFaceIndices, numberOfUnwrapVertices);
    }

    protected long[] unwrapVertexAttributes(long[] data, int entriesPerVertex) {
        if (data == null) {
            throw new NullPointerException();
        }
        return (long[])AbstractIndexedFaceSetFactory.unwrapVertexAttributes((Object)data, Long.TYPE, entriesPerVertex, this);
    }

    protected static long[] unwrapVertexAttributes(long[] data, int entriesPerVertex, int[][] faceIndices, int[][] unwrapFaceIndices, int numberOfUnwrapVertices) {
        return (long[])AbstractIndexedFaceSetFactory.unwrapVertexAttributes(data, Long.TYPE, entriesPerVertex, faceIndices, unwrapFaceIndices, numberOfUnwrapVertices);
    }

    protected float[] unwrapVertexAttributes(float[] data, int entriesPerVertex) {
        return (float[])AbstractIndexedFaceSetFactory.unwrapVertexAttributes((Object)data, Float.TYPE, entriesPerVertex, this);
    }

    protected static float[] unwrapVertexAttributes(float[] data, int entriesPerVertex, int[][] faceIndices, int[][] unwrapFaceIndices, int numberOfUnwrapVertices) {
        return (float[])AbstractIndexedFaceSetFactory.unwrapVertexAttributes(data, Float.TYPE, entriesPerVertex, faceIndices, unwrapFaceIndices, numberOfUnwrapVertices);
    }

    protected char[] unwrapVertexAttributes(char[] data, int entriesPerVertex) {
        return (char[])AbstractIndexedFaceSetFactory.unwrapVertexAttributes((Object)data, Character.TYPE, entriesPerVertex, this);
    }

    protected static char[] unwrapVertexAttributes(char[] data, int entriesPerVertex, int[][] faceIndices, int[][] unwrapFaceIndices, int numberOfUnwrapVertices) {
        return (char[])AbstractIndexedFaceSetFactory.unwrapVertexAttributes(data, Character.TYPE, entriesPerVertex, faceIndices, unwrapFaceIndices, numberOfUnwrapVertices);
    }

    protected double[] unwrapVertexAttributes(double[] data, int entriesPerVertex) {
        return (double[])AbstractIndexedFaceSetFactory.unwrapVertexAttributes((Object)data, Double.TYPE, entriesPerVertex, this);
    }

    protected static double[] unwrapVertexAttributes(double[] data, int entriesPerVertex, int[][] faceIndices, int[][] unwrapFaceIndices, int numberOfUnwrapVertices) {
        return (double[])AbstractIndexedFaceSetFactory.unwrapVertexAttributes(data, Double.TYPE, entriesPerVertex, faceIndices, unwrapFaceIndices, numberOfUnwrapVertices);
    }

    private static Object unwrapVertexAttributes(Object data, Class<?> clazz, int entriesPerVertex, AbstractIndexedFaceSetFactory ifsf) {
        if (ifsf.faceIndices.getObject() == null || ifsf.unwrapFaceIndices.getObject() == null) {
            throw new IllegalStateException("set faceIndices and unwrapFaceIndices first, or use the static method instead");
        }
        return AbstractIndexedFaceSetFactory.unwrapVertexAttributes(data, clazz, entriesPerVertex, (int[][])ifsf.faceIndices.getObject(), (int[][])ifsf.unwrapFaceIndices.getObject(), ifsf.nov());
    }

    private static Object unwrapVertexAttributes(Object data, Class<?> clazz, int entriesPerVertex, int[][] faceIndices, int[][] unwrapFaceIndices, int numberOfUnwrapVertices) {
        if (data == null || faceIndices == null || unwrapFaceIndices == null) {
            throw new NullPointerException();
        }
        if (entriesPerVertex < 1) {
            throw new IllegalArgumentException();
        }
        Object unwrapData = Array.newInstance(clazz, numberOfUnwrapVertices * entriesPerVertex);
        int[] translation = AbstractIndexedFaceSetFactory.determineActualVertexOfUnwrapVertexImpl(faceIndices, unwrapFaceIndices, null, numberOfUnwrapVertices);
        for (int i = 0; i < numberOfUnwrapVertices; ++i) {
            for (int j = 0; j < entriesPerVertex; ++j) {
                Array.set(unwrapData, i * entriesPerVertex + j, Array.get(data, translation[i] * entriesPerVertex + j));
            }
        }
        return unwrapData;
    }
}

