/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.geometry;

import de.jreality.geometry.GeometryAttributeListSet;
import de.jreality.geometry.GeometryFactory;
import de.jreality.geometry.GeometryUtility;
import de.jreality.geometry.OoNode;
import de.jreality.scene.Geometry;
import de.jreality.scene.Scene;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.data.DataList;
import java.util.Map;

public class AbstractGeometryFactory
implements GeometryFactory {
    final OoNode metric;
    UpdateCounter update = new UpdateCounter();
    static boolean storeFactory = false;
    final Geometry geometry;
    boolean debug = false;

    public static void setStoreFactory(boolean b) {
        storeFactory = b;
    }

    AbstractGeometryFactory(Geometry geometry, int metric) {
        this.metric = this.node(new Integer(metric), "metric");
        this.geometry = geometry;
        GeometryUtility.setMetric(geometry, metric);
        if (storeFactory) {
            geometry.setGeometryAttributes(GeometryUtility.FACTORY, this);
        }
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    OoNode node(String name) {
        return new OoNode(name, this.update);
    }

    OoNode node(Object object, String name) {
        return new OoNode(object, name, (OoNode.IsUpdateCounter)this.update);
    }

    OoNode geometryAttributeNode(Map attributeNode, String name, Attribute attr) {
        if (attributeNode.containsKey(attr)) {
            return (OoNode)attributeNode.get(attr);
        }
        OoNode node = this.node(name + "." + attr);
        attributeNode.put(attr, node);
        return node;
    }

    protected boolean nodeWasUpdated(OoNode node) {
        return node.getCounterOfLastUpdate() == this.update.getUpdateCount();
    }

    public int getMetric() {
        return (Integer)this.metric.getObject();
    }

    public void setMetric(int metric) {
        this.metric.setObject(new Integer(metric));
    }

    void recompute() {
    }

    public void update() {
        ++this.update.counter;
        this.recompute();
        Scene.executeWriter(this.geometry, new Runnable(){

            public void run() {
                AbstractGeometryFactory.this.updateImpl();
            }
        });
    }

    void updateImpl() {
        GeometryUtility.setMetric(this.geometry, this.getMetric());
    }

    void updateGeometryAttributeCathegory(GeometryAttributeListSet gals) {
        if (!gals.hasEntries()) {
            return;
        }
        Geometry geometry = gals.factory.geometry;
        String category = gals.category;
        if (geometry.getNumEntries(category) == gals.noa()) {
            for (Attribute attr : gals.DLS.storedAttributes()) {
                gals.attributeNode(attr).update();
                if (!this.nodeWasUpdated(gals.attributeNode(attr))) continue;
                this.log("set", attr, category);
                geometry.setAttributes(category, attr, gals.DLS.getWritableList(attr));
            }
        } else {
            gals.updateAttributes();
            geometry.setCountAndAttributes(category, gals.DLS);
        }
    }

    void updateNode(GeometryAttributeListSet gals, Attribute attr, boolean generate, OoNode node) {
        Geometry geometry = gals.factory.geometry;
        String category = gals.category;
        if (generate) {
            if (this.nodeWasUpdated(node)) {
                this.log("set", attr, category);
                DataList dl = node.createDataList();
                geometry.setAttributes(category, attr, dl);
            }
        } else if (!gals.DLS.containsAttribute(attr) && geometry.getAttributes(gals.category, attr) != null) {
            this.log("cancel", attr, category);
            geometry.setAttributes(category, attr, null);
        }
    }

    String logMessage(String action, String attr, String cathegory) {
        return action + " " + cathegory + " " + attr;
    }

    void log(String action, Attribute attr, String cathegory) {
        this.log(action, attr.getName(), cathegory);
    }

    void log(String action, String attr, String cathegory) {
        if (this.debug) {
            System.out.println(this.logMessage(action, attr, cathegory));
        }
    }

    static class UpdateCounter
    implements OoNode.IsUpdateCounter {
        long counter = 0L;

        UpdateCounter() {
        }

        public long getUpdateCount() {
            return this.counter;
        }
    }
}

