/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.backends.texture;

import de.jreality.backends.texture.SimpleTexture;
import de.jreality.backends.texture.Texture;
import de.jreality.shader.CubeMap;
import java.awt.Color;

public class EnvironmentTexture
implements Texture {
    private final Texture texture;
    private final SimpleTexture top;
    private final SimpleTexture bot;
    private final SimpleTexture front;
    private final SimpleTexture back;
    private final SimpleTexture left;
    private final SimpleTexture right;
    private int br;
    private int bg;
    private int bb;
    private int ba;

    public EnvironmentTexture(CubeMap cm, Texture texture2) {
        this.texture = texture2;
        this.top = new SimpleTexture(cm.getTop());
        this.bot = new SimpleTexture(cm.getBottom());
        this.left = new SimpleTexture(cm.getLeft());
        this.right = new SimpleTexture(cm.getRight());
        this.front = new SimpleTexture(cm.getFront());
        this.back = new SimpleTexture(cm.getBack());
        Color blend = cm.getBlendColor();
        this.br = blend.getRed();
        this.bg = blend.getGreen();
        this.bb = blend.getBlue();
        this.ba = blend.getAlpha();
    }

    public EnvironmentTexture(CubeMap cm, Texture texture2, Color blend) {
        this(cm, texture2);
        this.br = blend.getRed();
        this.bg = blend.getGreen();
        this.bb = blend.getBlue();
        this.ba = blend.getAlpha();
    }

    public void getColor(double u, double v, double nx, double ny, double nz, int x, int y, double[] color) {
        if (this.texture != null) {
            this.texture.getColor(u, v, nx, ny, nz, x, y, color);
        }
        if (this.ba == 0) {
            return;
        }
        double r = color[0];
        double g = color[1];
        double b = color[2];
        double a = color[3];
        color[0] = this.br;
        color[1] = this.bg;
        color[2] = this.bb;
        color[3] = this.ba;
        this.cubeMapColor(u, v, nx, ny, nz, color);
        double t = (double)this.ba / 255.0;
        double omt = 1.0 - t;
        color[0] = r * omt + t * color[0];
        color[1] = g * omt + t * color[1];
        color[2] = b * omt + t * color[2];
        color[3] = a;
    }

    private void cubeMapColor(double u, double v, double nx, double ny, double nz, double[] color) {
        int s = (int)Math.signum(nx);
        double p = (double)s * nx;
        int i = 1;
        if (p < Math.abs(ny)) {
            s = (int)Math.signum(ny);
            p = (double)s * ny;
            i = 2;
        }
        if (p < Math.abs(nz)) {
            s = (int)Math.signum(nz);
            i = 3;
        }
        switch (s * i) {
            case -3: {
                double xx = 0.5 * (1.0 + nx / nz);
                double yy = 0.5 * (1.0 + ny / nz);
                this.right.getColor(xx, yy, 0.0, 0.0, 0.0, 0, 0, color);
                return;
            }
            case -2: {
                double xx = 0.5 * (1.0 - nx / ny);
                double yy = 0.5 * (1.0 + nz / ny);
                this.top.getColor(xx, yy, 0.0, 0.0, 0.0, 0, 0, color);
                return;
            }
            case -1: {
                double xx = 0.5 * (1.0 - nz / nx);
                double yy = 0.5 * (1.0 + ny / nx);
                this.front.getColor(xx, yy, 0.0, 0.0, 0.0, 0, 0, color);
                return;
            }
            case 1: {
                double xx = 0.5 * (1.0 - nz / nx);
                double yy = 0.5 * (1.0 - ny / nx);
                this.back.getColor(xx, yy, 0.0, 0.0, 0.0, 0, 0, color);
                return;
            }
            case 2: {
                double xx = 0.5 * (1.0 + nx / ny);
                double yy = 0.5 * (1.0 + nz / ny);
                this.bot.getColor(xx, yy, 0.0, 0.0, 0.0, 0, 0, color);
                return;
            }
        }
        double xx = 0.5 * (1.0 + nx / nz);
        double yy = 0.5 * (1.0 - ny / nz);
        this.left.getColor(xx, yy, 0.0, 0.0, 0.0, 0, 0, color);
    }

    public boolean needsNormals() {
        return true;
    }

    public boolean isTransparent() {
        return this.texture == null || this.texture.isTransparent();
    }
}

