/*
 * Decompiled with CFR 0.152.
 */
package fable.python.actions;

import fable.framework.toolbox.FableUtils;
import fable.python.rcp.Activator;
import java.io.File;
import org.dawb.fabio.FableJep;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class RecordScriptAction
implements IWorkbenchWindowActionDelegate {
    private static final String ID = "fable.python.actions.recordAction";
    private String fileDirectory;
    private String[] filterExtension = new String[]{"*.py", "*.*"};
    private String[] filterName = new String[]{"*.py", "All(*.*)"};

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("pref_python_script_path")) {
                    RecordScriptAction.this.fileDirectory = Activator.getDefault().getPreferenceStore().getString("pref_python_script_path");
                }
            }
        };
        this.fileDirectory = Activator.getDefault().getPreferenceStore().getString("pref_python_script_path");
    }

    public void run(IAction iAction) {
        FileDialog fileDialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
        fileDialog.setFilterPath(this.fileDirectory);
        fileDialog.setFilterNames(this.filterName);
        fileDialog.setFilterExtensions(this.filterExtension);
        if (iAction.isChecked()) {
            String string = fileDialog.open();
            if (string != null && this.recordInThisFile(string)) {
                FableJep.record((boolean)true);
                try {
                    FableJep.getFableJep().setScriptFileName(string);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                iAction.setToolTipText("Stop recording python actions.");
            } else {
                iAction.setChecked(false);
                FableJep.record((boolean)false);
                iAction.setToolTipText("Record python actions in a script.");
            }
        } else {
            FableJep.record((boolean)false);
            iAction.setToolTipText("Record python actions in a script.");
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public static String getID() {
        return ID;
    }

    public boolean recordInThisFile(String string) {
        File file = new File(string);
        boolean bl = true;
        if (file.exists()) {
            bl = FableUtils.confirmMsg((Object)this, (String)(String.valueOf(string) + " already exists. \nDo you want to add your new records in it ?"));
        }
        return bl;
    }
}

