/*
 * Decompiled with CFR 0.152.
 */
package fable.python;

import fable.python.ISampleListener;
import fable.python.SampleEvent;
import fable.python.SampleException;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import org.dawb.fabio.FabioFile;
import org.dawb.fabio.FabioFileException;
import org.dawb.fabio.FableJep;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class Sample {
    private String parentDirectoryName;
    private String directoryName;
    private String directoryPath;
    private String[] currentFiles;
    private static String DEFAULT_SAMPLE_PATH = "\\data\\opid11\\inhouse\\";
    private Vector<FabioFile> fabioFiles = new Vector();
    private Vector<FabioFile> filteredfabiofiles = new Vector();
    private Vector<ISampleListener> listListener = new Vector();
    private String fileFormat = "";
    public boolean headersRead = false;
    private String ndigits = "4";
    private String peaksearchOutStem = "peaks";
    private ArrayList<IPropertyChangeListener> listeners = new ArrayList();
    private String[] keys = null;
    private int last = -1;
    int first = -1;
    private String filter = "";
    private boolean showInNavigator = true;
    private boolean isDirectory = true;
    private HashMap<String, double[]> headerValues = new HashMap();
    private HashMap<String, double[]> headerdiffValues = new HashMap();
    private FabioFile currentFabioFile;
    private boolean isValide = true;
    private FableJep fableJep;
    private String stem = null;

    public Sample(String string, String string2, String string3, String[] stringArray) throws FabioFileException {
        this.setDirectoryName(string2);
        this.setParentDirectoryName(string);
        this.setDirectoryPath(string3);
        this.fabioFiles = new Vector();
        this.filteredfabiofiles = (Vector)this.fabioFiles.clone();
        this.addFabioFiles(stringArray);
    }

    public Sample(String string, String string2, String string3) {
        this.setDirectoryName(string2);
        this.setParentDirectoryName(string);
        this.setDirectoryPath(string3);
    }

    public Sample(String string, String string2) {
        this.setDirectoryName(string2);
        this.setParentDirectoryName(string);
        String string3 = String.valueOf(DEFAULT_SAMPLE_PATH) + "\\" + string + "\\" + string2;
        this.setDirectoryPath(string3);
    }

    public Sample() {
    }

    public Sample(String string, File[] fileArray) throws FabioFileException {
        this.setDirectoryPath(string);
        this.fabioFiles = new Vector();
        this.filteredfabiofiles = (Vector)this.fabioFiles.clone();
        this.addFabioFiles(fileArray);
    }

    public Sample(String string, String string2, String string3, File[] fileArray) throws FabioFileException {
        this(string3, fileArray);
        this.setDirectoryName(string2);
        this.setParentDirectoryName(string);
    }

    private void addFabioFiles(File[] fileArray) throws FabioFileException {
        int n = 0;
        while (fileArray != null && n < fileArray.length) {
            this.addFabioFile(new FabioFile(fileArray[n].getAbsolutePath()));
            ++n;
        }
        this.currentFiles = new String[this.fabioFiles.size()];
        n = 0;
        while (this.fabioFiles != null && n < this.fabioFiles.size()) {
            this.currentFiles[n] = this.fabioFiles.elementAt(n).getFullFilename();
            ++n;
        }
        this.filteredfabiofiles = (Vector)this.fabioFiles.clone();
        this.fireSampleHasNewFiles();
    }

    public void addCurrentFiles(String[] stringArray) {
        this.currentFiles = stringArray;
        this.fireSampleHasNewFiles();
    }

    public void addFabioFiles(String[] stringArray) throws FabioFileException {
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            this.addFabioFile(new FabioFile(stringArray[n]));
            ++n;
        }
        this.currentFiles = new String[this.fabioFiles.size()];
        n = 0;
        while (this.fabioFiles != null && n < this.fabioFiles.size()) {
            this.currentFiles[n] = this.fabioFiles.elementAt(n).getFullFilename();
            ++n;
        }
        this.filteredfabiofiles = (Vector)this.fabioFiles.clone();
        this.fireSampleHasNewFiles();
    }

    public void updatefabioFiles(String[] stringArray) throws FabioFileException {
        this.fabioFiles.removeAllElements();
        int n = 0;
        while (stringArray != null && n < stringArray.length) {
            this.addFabioFile(new FabioFile(stringArray[n]));
            ++n;
        }
        this.currentFiles = new String[this.fabioFiles.size()];
        n = 0;
        while (this.fabioFiles != null && n < this.fabioFiles.size()) {
            this.currentFiles[n] = this.fabioFiles.elementAt(n).getFullFilename();
            ++n;
        }
        this.applyFilter();
        this.fireUpdatefiles();
    }

    public boolean addFabioFile(FabioFile fabioFile) throws FabioFileException {
        this.addPropertyChangeListener((IPropertyChangeListener)fabioFile);
        fabioFile.addIndex(this.fabioFiles.size());
        this.fabioFiles.add(fabioFile);
        this.filteredfabiofiles.add(fabioFile);
        return true;
    }

    public String[] getKeys() throws SampleException {
        if (this.fabioFiles != null && this.fabioFiles.size() > 0) {
            try {
                if (this.currentFabioFile != null) {
                    this.keys = this.currentFabioFile.getKeys();
                }
            }
            catch (FabioFileException fabioFileException) {
                throw new SampleException(this.getClass().getName(), "getKeys", "Header keys cannot be retrieved for current file ");
            }
            catch (Throwable throwable) {
                throw new SampleException(this.getClass().getName(), "getKeys", "Header keys cannot be retrieved for current file ");
            }
        }
        return this.keys;
    }

    public boolean isValide() {
        return this.isValide;
    }

    public boolean hasFile() {
        return this.currentFiles != null && this.currentFiles.length > 0;
    }

    public String getParentDirectoryName() {
        return this.parentDirectoryName;
    }

    public void setParentDirectoryName(String string) {
        if (string != null) {
            this.parentDirectoryName = string;
        }
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String string) {
        if (string != null) {
            this.directoryName = string;
        }
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String string) {
        this.directoryPath = string;
    }

    public String toString() {
        return "Experiment : " + this.getParentDirectoryName() + " Sample name: " + this.getDirectoryName() + " Directory: " + this.getDirectoryPath();
    }

    public String[] getFabioFilesToProcess(boolean bl) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (this.filteredfabiofiles != null && n < this.filteredfabiofiles.size() && this.filteredfabiofiles.elementAt(n).getFlag()) {
            vector.add(this.filteredfabiofiles.elementAt(n).getFullFilename());
            ++n;
        }
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            stringArray[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
        return stringArray;
    }

    public String[] getFiles() {
        return this.currentFiles;
    }

    public void setFiles(String[] stringArray) {
        this.currentFiles = stringArray;
    }

    public void setCurrentFilesFromFabio() {
        this.currentFiles = new String[this.fabioFiles.size()];
        int n = 0;
        while (this.fabioFiles != null && n < this.fabioFiles.size()) {
            this.currentFiles[n] = this.fabioFiles.elementAt(n).getFullFilename();
            ++n;
        }
        this.fireSampleHasNewFiles();
    }

    public Vector<FabioFile> getFabioFiles() {
        return this.fabioFiles;
    }

    public Vector<FabioFile> getFilteredfiles() {
        return this.filteredfabiofiles;
    }

    public void setComparator(String string, int n) {
        this.fireSetComparator(string);
        this.fireSetDirection(n);
    }

    public Vector<FabioFile> getSortedFiles() {
        Collections.sort(this.fabioFiles);
        return this.fabioFiles;
    }

    private void fireSetComparator(String string) {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "comparator", null, (Object)string));
        }
    }

    private void fireSetDirection(int n) {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "dir", null, (Object)n));
        }
    }

    private void fireUpdatefiles() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "updatefiles", null, (Object)this));
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.add(iPropertyChangeListener);
    }

    public void removePropertyrChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.remove(iPropertyChangeListener);
    }

    public void removeFiles() {
        if (this.hasFile()) {
            this.currentFiles = null;
            this.fabioFiles.removeAllElements();
            this.filteredfabiofiles.removeAllElements();
            this.fireSampleHasChanged();
        }
    }

    public void removeFileAt(int n) {
        if (this.hasFile()) {
            this.fabioFiles.removeElementAt(n);
            this.fireSampleHasChanged();
        }
    }

    public void removeFabioFile(FabioFile fabioFile) {
        if (this.hasFile() && fabioFile != null) {
            this.fabioFiles.removeElement(fabioFile);
            if (this.filteredfabiofiles != null && this.filteredfabiofiles.size() > 0) {
                this.filteredfabiofiles.remove(fabioFile);
            }
            this.fireSampleHasChanged();
        }
    }

    public void setFilter(String string) {
        this.filter = string;
        this.applyFilter();
    }

    private void applyFilter() {
        assert (this.fabioFiles != null);
        this.filteredfabiofiles = (Vector)this.fabioFiles.clone();
        if (this.filter != null && !this.filter.trim().equals("")) {
            for (FabioFile fabioFile : this.fabioFiles) {
                String string = fabioFile.getFileName();
                if (!string.contains(this.filter)) {
                    this.filteredfabiofiles.remove(fabioFile);
                    continue;
                }
                int n = this.filteredfabiofiles.indexOf(fabioFile);
                if (n < 0) continue;
                fabioFile.addHeaderInfo("#", String.valueOf(n));
            }
        } else {
            int n = 0;
            while (n < this.fabioFiles.size()) {
                this.fabioFiles.elementAt(n).addHeaderInfo("#", String.valueOf(n));
                ++n;
            }
        }
    }

    private void fireSampleHasNewFiles() {
        SampleEvent sampleEvent = new SampleEvent(this);
        Enumeration<ISampleListener> enumeration = this.listListener.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().newImages(sampleEvent);
        }
    }

    private void fireSampleHasChanged() {
        SampleEvent sampleEvent = new SampleEvent(this);
        Enumeration<ISampleListener> enumeration = this.listListener.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().sampleHasChanged(sampleEvent);
        }
    }

    public void fireSomeHeaderValuesLoaded() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "updateHeaderValues", null, null));
        }
    }

    public void addSampleListener(ISampleListener iSampleListener) {
        this.listListener.add(iSampleListener);
    }

    public void removeSampleListener(ISampleListener iSampleListener) {
        this.listListener.remove(iSampleListener);
    }

    public String getName() {
        return this.directoryName;
    }

    public int getFirst() {
        if (this.hasFile() && this.first == -1) {
            try {
                this.first = this.getFileNumber(this.fabioFiles.elementAt(0).getFileName());
            }
            catch (FabioFileException fabioFileException) {
                this.first = 0;
            }
        }
        return this.first;
    }

    public void setFirst(int n) {
        this.first = n;
    }

    public void setlast(int n) {
        this.last = n;
    }

    public int getLast() {
        if (this.hasFile() && this.last == -1) {
            try {
                this.last = this.getFileNumber(this.fabioFiles.lastElement().getFileName());
            }
            catch (FabioFileException fabioFileException) {
                this.last = 0;
            }
        }
        return this.last;
    }

    private int getFileNumber(String string) throws FabioFileException {
        String string2 = "";
        int n = -99;
        String string3 = this.getFileFormat();
        if (string3 != null) {
            if (string3.equals("bruker")) {
                string2 = string.substring(string.lastIndexOf("."));
            } else {
                int n2 = string.indexOf(".");
                if (n2 > 0 && (string = string.substring(0, n2)).length() - 4 > 0) {
                    string2 = string.substring(string.length() - 4, string.length());
                }
            }
            try {
                n = Integer.valueOf(string2);
            }
            catch (Exception exception) {
                throw new FabioFileException(this.getClass().getName(), "getFileNumber", "Sample can not get file number");
            }
        }
        return n;
    }

    public String getFileFormat() {
        String string;
        int n;
        if (this.hasFile() && this.fileFormat.equals("") && (n = (string = this.fabioFiles.elementAt(0).getFileName()).indexOf(".")) >= 0) {
            this.fileFormat = string.substring(n);
            try {
                Integer.valueOf(this.fileFormat);
                this.fileFormat = "bruker";
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this.fileFormat;
    }

    public void setFileFormat(String string) {
        this.fileFormat = string;
    }

    public void setNDigits(String string) {
        this.ndigits = string;
    }

    public String getNDigits() {
        return this.ndigits;
    }

    public void setPeaksearchOutfile(String string) {
        this.peaksearchOutStem = string;
    }

    public String getPeaksearchoutStem() {
        return this.peaksearchOutStem;
    }

    public double[] getHeaderValues(final String string) throws SampleException {
        int n = this.filteredfabiofiles.size();
        double[] dArray = this.headerValues.get(string);
        Job job = new Job("Get values for " + string){

            protected IStatus run(final IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("Wait while getting values for " + string + " in sample " + Sample.this.getDirectoryName(), Sample.this.filteredfabiofiles.size());
                if (Sample.this.hasFile()) {
                    int n = 0;
                    Iterator iterator = Sample.this.filteredfabiofiles.iterator();
                    while (iterator.hasNext()) {
                        if (iProgressMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        final FabioFile fabioFile = (FabioFile)iterator.next();
                        if (n >= ((double[])Sample.this.headerValues.get(string)).length) continue;
                        final int n2 = n++;
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                double[] dArray = (double[])Sample.this.headerValues.get(string);
                                try {
                                    if (string.toLowerCase().contains("date")) {
                                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy", Locale.UK);
                                        try {
                                            Date date = simpleDateFormat.parse(fabioFile.getValue(string));
                                            dArray[n2] = date.getTime();
                                        }
                                        catch (ParseException parseException) {}
                                    } else {
                                        dArray[n2] = Double.valueOf(fabioFile.getValue(string));
                                    }
                                    if (n2 % 10 == 0 && n2 > 0) {
                                        Sample.this.fireSomeHeaderValuesLoaded();
                                    } else if (n2 == dArray.length - 1) {
                                        Sample.this.fireSomeHeaderValuesLoaded();
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    iProgressMonitor.setCanceled(true);
                                }
                                catch (FabioFileException fabioFileException) {
                                    iProgressMonitor.setCanceled(true);
                                }
                            }
                        });
                        iProgressMonitor.worked(1);
                    }
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        if (dArray == null || dArray.length != n) {
            dArray = new double[n];
            this.headerValues.put(string, dArray);
            job.schedule();
        }
        return this.headerValues.get(string);
    }

    public void addHeaderValues(String string, double[] dArray) {
        this.headerValues.put(string, dArray);
    }

    public double[] getHeaderValuesDiff(final String string) throws SampleException {
        int n = this.filteredfabiofiles.size();
        double[] dArray = this.headerdiffValues.get(string);
        Job job = new Job("Get values for " + string){

            protected IStatus run(final IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("Wait while getting values for " + string + " in sample " + Sample.this.getDirectoryName(), Sample.this.filteredfabiofiles.size());
                if (Sample.this.hasFile()) {
                    int n = 0;
                    while (n < Sample.this.filteredfabiofiles.size()) {
                        if (iProgressMonitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        final FabioFile fabioFile = (FabioFile)Sample.this.filteredfabiofiles.elementAt(n);
                        if (n + 1 < Sample.this.filteredfabiofiles.size()) {
                            final FabioFile fabioFile2 = (FabioFile)Sample.this.filteredfabiofiles.elementAt(n + 1);
                            if (n < ((double[])Sample.this.headerdiffValues.get(string)).length) {
                                final int n2 = n;
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        double[] dArray = (double[])Sample.this.headerdiffValues.get(string);
                                        try {
                                            double d = Double.valueOf(fabioFile2.getValue(string));
                                            double d2 = Double.valueOf(fabioFile.getValue(string));
                                            dArray[n2] = d - d2;
                                            if (n2 % 10 == 0 && n2 > 0) {
                                                Sample.this.fireSomeHeaderValuesLoaded();
                                            } else if (n2 == dArray.length - 1) {
                                                Sample.this.fireSomeHeaderValuesLoaded();
                                            }
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            dArray[n2] = 0.0;
                                            if (n2 % 10 == 0 && n2 > 0) {
                                                Sample.this.fireSomeHeaderValuesLoaded();
                                            } else if (n2 == dArray.length - 1) {
                                                Sample.this.fireSomeHeaderValuesLoaded();
                                            }
                                        }
                                        catch (FabioFileException fabioFileException) {
                                            iProgressMonitor.setCanceled(true);
                                        }
                                    }
                                });
                                iProgressMonitor.worked(1);
                            }
                        }
                        ++n;
                    }
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        if (dArray == null || dArray.length != n) {
            dArray = new double[n];
            this.headerdiffValues.put(string, dArray);
            job.schedule();
        }
        return this.headerdiffValues.get(string);
    }

    public void setCurrentFile(FabioFile fabioFile) {
        this.currentFabioFile = fabioFile;
    }

    public FabioFile getCurrentFabioFile() {
        return this.currentFabioFile;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public void setDirectory(boolean bl) {
        this.isDirectory = bl;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isShowInNavigator() {
        return this.showInNavigator;
    }

    public void setShowInNavigator(boolean bl) {
        this.showInNavigator = bl;
    }

    public void setValide(boolean bl) {
        this.isValide = bl;
    }

    private boolean createFile_SeriesForPython() {
        boolean bl = true;
        if (this.fableJep == null) {
            try {
                this.fableJep = FableJep.getFableJep();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        try {
            FableJep.getFableJep().jepImportModules("sys");
            FableJep.getFableJep().jepImportModules("numpy");
            FableJep.getFableJep().jepImportModules("PIL");
            FableJep.getFableJep().jepImportModules("fabio.file_series");
            this.fableJep.eval("from fabio.file_series import file_series");
            this.fableJep.eval("fileList = []");
            int n = 0;
            while (n < this.filteredfabiofiles.size()) {
                this.fableJep.set("file", this.filteredfabiofiles.elementAt(n).getFullFilename());
                this.fableJep.eval("fileList.append(file)");
                ++n;
            }
            bl = this.fableJep.eval("fileseries = file_series(fileList)");
        }
        catch (Throwable throwable) {
            bl = false;
            throwable.printStackTrace();
        }
        return bl;
    }

    public String getStem() {
        int n;
        assert (this.filteredfabiofiles != null);
        if (this.stem == null && this.createFile_SeriesForPython() && (n = this.fableJep.getIntegerValue("len(fileseries)").intValue()) > 0) {
            this.stem = this.fableJep.getStringValue("fabio.deconstruct_filename(fileseries[0]).stem");
        }
        return this.stem;
    }

    public void updateFabioFiles(File[] fileArray) throws FabioFileException {
        Vector vector = (Vector)this.fabioFiles.clone();
        this.fabioFiles.removeAllElements();
        int n = 0;
        while (fileArray != null && n < fileArray.length) {
            boolean bl = false;
            int n2 = -1;
            int n3 = 0;
            while (n3 < this.currentFiles.length && !bl) {
                if (this.currentFiles[n3].equalsIgnoreCase(fileArray[n].getAbsolutePath()) && n3 < vector.size()) {
                    bl = true;
                    n2 = n3;
                }
                ++n3;
            }
            FabioFile fabioFile = !bl ? new FabioFile(fileArray[n].getAbsolutePath()) : (FabioFile)vector.elementAt(n2);
            this.addFabioFile(fabioFile);
            ++n;
        }
        this.currentFiles = new String[this.fabioFiles.size()];
        n = 0;
        while (this.fabioFiles != null && n < this.fabioFiles.size()) {
            this.currentFiles[n] = this.fabioFiles.elementAt(n).getFullFilename();
            ++n;
        }
        this.applyFilter();
        this.fireUpdatefiles();
    }

    public void setStem(String string) {
        this.stem = string;
    }
}

