/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.utils;

import com.isencia.passerelle.model.Flow;
import com.isencia.passerelle.model.FlowManager;
import com.isencia.passerelle.model.util.MoMLParser;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import com.isencia.passerelle.workbench.model.utils.PropUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.kernel.ComponentEntity;

public class SubModelUtils {
    private static Logger logger = LoggerFactory.getLogger(SubModelUtils.class);
    private static Map<String, Flow> modelMap;

    public static Map<String, Flow> getSubModels() throws Exception {
        if (modelMap == null) {
            modelMap = SubModelUtils.readSubModels();
            return modelMap;
        }
        return modelMap;
    }

    public static boolean isSubModel(String string) {
        return modelMap != null && modelMap.keySet().contains(string);
    }

    public static void addSubModel(Flow flow) throws Exception {
        MoMLParser.putActorClass((String)flow.getName(), (ComponentEntity)flow);
        SubModelUtils.registerSubModel(flow);
    }

    private static void registerSubModel(Flow flow) throws Exception {
        if (modelMap == null) {
            modelMap = SubModelUtils.getSubModels();
        }
        String string = flow.getName();
        modelMap.put(string, flow);
        IFile iFile = SubModelUtils.getModelStore();
        Properties properties = PropUtils.loadProperties(iFile.getContents());
        properties.put(string, "");
        PropUtils.storeProperties(properties, iFile.getLocation().toOSString());
        iFile.refreshLocal(1, null);
    }

    public static Map<String, Flow> readSubModels() throws Exception {
        IProject iProject = ModelUtils.getPasserelleProject();
        iProject.refreshLocal(2, null);
        Properties properties = PropUtils.loadProperties(SubModelUtils.getModelStore().getContents());
        TreeSet<Object> treeSet = new TreeSet<Object>();
        treeSet.addAll(properties.keySet());
        LinkedHashMap<String, Flow> linkedHashMap = new LinkedHashMap<String, Flow>();
        List<String> list = SubModelUtils.initializeSubmodels(treeSet, iProject);
        for (String string : list) {
            IFile iFile = iProject.getFile(String.valueOf(string) + ".moml");
            Flow flow = FlowManager.readMoml((Reader)new InputStreamReader(iFile.getContents()));
            if (!flow.isClassDefinition()) continue;
            MoMLParser.putActorClass((String)string, (ComponentEntity)flow);
            flow.setName(string);
            linkedHashMap.put(string, flow);
        }
        iProject.refreshLocal(2, null);
        return linkedHashMap;
    }

    private static List<String> initializeSubmodels(Set<Object> set, IProject iProject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : set) {
            String string = (String)object;
            if (string == null || "".equals(string)) continue;
            IFile iFile = iProject.getFile(String.valueOf(string) + ".moml");
            try {
                if (!iFile.exists()) continue;
                InputStreamReader inputStreamReader = new InputStreamReader(SubModelUtils.createEmptySubModel(string));
                try {
                    Flow flow = FlowManager.readMoml((Reader)inputStreamReader);
                    MoMLParser.putActorClass((String)string, (ComponentEntity)flow);
                }
                catch (Exception exception) {}
                arrayList.add(string);
            }
            catch (Exception exception) {
                logger.error("Cannot read moml file!", (Throwable)exception);
            }
        }
        return arrayList;
    }

    private static InputStream createEmptySubModel(String string) {
        String string2 = "<?xml version=\"1.0\" standalone=\"no\"?> \r\n<!DOCTYPE entity PUBLIC \"-//UC Berkeley//DTD MoML 1//EN\" \"http://ptolemy.eecs.berkeley.edu/xml/dtd/MoML_1.dtd\"> \r\n<class name=\"" + string + "\" extends=\"ptolemy.actor.TypedCompositeActor\"> </class>";
        return new ByteArrayInputStream(string2.getBytes());
    }

    private static IFile getModelStore() throws Exception {
        IFile iFile = ModelUtils.getPasserelleProject().getFile("submodels.properties");
        if (!iFile.exists()) {
            iFile.create((InputStream)new ByteArrayInputStream("# DAWB Properties".getBytes()), true, null);
        }
        return iFile;
    }

    public static void deleteSubModel(String string) throws Exception {
        if (modelMap == null) {
            modelMap = SubModelUtils.getSubModels();
        }
        modelMap.remove(string);
        IFile iFile = SubModelUtils.getModelStore();
        Properties properties = PropUtils.loadProperties(iFile.getContents());
        properties.remove(string);
        PropUtils.storeProperties(properties, iFile.getLocation().toOSString());
        iFile.refreshLocal(1, null);
    }
}

