/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.utils;

import com.isencia.passerelle.workbench.model.utils.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.util.Iterator;
import java.util.Properties;

public final class PropUtils {
    public static final Properties loadProperties(String string) throws IOException {
        File file = new File(string);
        return PropUtils.loadProperties(file);
    }

    public static final Properties loadProperties(File file) throws IOException {
        if (!file.exists()) {
            return new Properties();
        }
        return PropUtils.loadProperties(new FileInputStream(file));
    }

    public static final Properties loadProperties(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            properties.load(bufferedInputStream);
        }
        finally {
            inputStream.close();
        }
        return properties;
    }

    public static final Properties storeProperties(Properties properties, String string) throws IOException {
        File file = new File(string);
        return PropUtils.storeProperties(properties, file);
    }

    public static final Properties storeProperties(Properties properties, File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            properties.store(bufferedOutputStream, "DAWB Properties. Please do not edit this file.");
        }
        finally {
            IOUtils.close(bufferedOutputStream, "Storing properties for file " + IOUtils.fileInfo(file));
        }
        return properties;
    }

    public static final Properties storeKeys(Properties properties, File file) throws IOException {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file));
            Iterator<Object> iterator = properties.keySet().iterator();
            while (iterator.hasNext()) {
                printWriter.println((String)iterator.next());
            }
        }
        finally {
            IOUtils.close(printWriter, "Storing keys for file " + IOUtils.fileInfo(file));
        }
        return properties;
    }

    public static final Properties loadProperties(HttpURLConnection httpURLConnection) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        Properties properties = new Properties();
        try {
            InputStream inputStream = httpURLConnection.getInputStream();
            bufferedInputStream = new BufferedInputStream(inputStream);
            properties.load(bufferedInputStream);
        }
        catch (Throwable throwable) {
            if (bufferedInputStream != null) {
                IOUtils.close(bufferedInputStream, "Loading properties from URL");
                httpURLConnection.disconnect();
            }
            throw throwable;
        }
        if (bufferedInputStream != null) {
            IOUtils.close(bufferedInputStream, "Loading properties from URL");
            httpURLConnection.disconnect();
        }
        return properties;
    }

    public static String getPropertiesAsString(Properties properties) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            properties.store(byteArrayOutputStream, " DAWB output properties");
        }
        finally {
            byteArrayOutputStream.close();
        }
        return byteArrayOutputStream.toString("8859_1");
    }
}

