/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.digester.substitution.MultiVariableExpander;
import org.apache.commons.digester.substitution.VariableExpander;
import org.apache.commons.digester.substitution.VariableSubstitutor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.preference.PreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Actor;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.IOPort;
import ptolemy.actor.TypedCompositeActor;
import ptolemy.actor.TypedIOPort;
import ptolemy.kernel.ComponentEntity;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.InstantiableNamedObj;
import ptolemy.kernel.Port;
import ptolemy.kernel.Relation;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Locatable;
import ptolemy.kernel.util.Location;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.Nameable;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.Vertex;
import ptolemy.vergil.kernel.attributes.TextAttribute;

public class ModelUtils {
    public static Logger logger = LoggerFactory.getLogger(ModelUtils.class);
    private static PreferenceStore store;

    public static PreferenceStore getFavouritesStore() throws Exception {
        if (store == null) {
            store = new PreferenceStore();
            IProject iProject = ModelUtils.getPasserelleProject();
            store.setFilename(String.valueOf(iProject.getLocation().toOSString()) + "/favorites.properties");
            try {
                store.load();
            }
            catch (IOException iOException) {
                return store;
            }
        }
        return store;
    }

    public static boolean isClassDefinition(Object object) {
        if (object instanceof CompositeActor) {
            return ((CompositeActor)object).isClassDefinition();
        }
        return false;
    }

    public static final boolean isPort(String string) {
        return "com.isencia.passerelle.actor.general.InputIOPort".equals(string) || "com.isencia.passerelle.actor.general.OutputIOPort".equals(string);
    }

    public static final boolean isOutputPort(String string) {
        return "com.isencia.passerelle.actor.general.OutputIOPort".equals(string);
    }

    public static final boolean isInputPort(String string) {
        return "com.isencia.passerelle.actor.general.InputIOPort".equals(string);
    }

    public static Set<Relation> getConnectedRelations(Nameable nameable, ConnectionType connectionType) {
        return ModelUtils.getConnectedRelations(nameable, connectionType, false);
    }

    public static boolean containsVertex(Relation relation) {
        Enumeration enumeration = relation.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Vertex)) continue;
            return true;
        }
        return false;
    }

    public static Vertex getVertex(Relation relation) {
        Enumeration enumeration = relation.getAttributes();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof Vertex)) continue;
            return (Vertex)e;
        }
        return null;
    }

    public static List<IOPort> getPorts(Relation relation, NamedObj namedObj) {
        ArrayList<IOPort> arrayList = new ArrayList<IOPort>();
        for (Object e : relation.linkedPortList()) {
            if (!((Port)e).getContainer().equals(namedObj)) continue;
            arrayList.add((IOPort)e);
        }
        return arrayList;
    }

    public static Set<Relation> getConnectedRelations(Nameable nameable, ConnectionType connectionType, boolean bl) {
        HashSet<Relation> hashSet = new HashSet<Relation>();
        if (nameable.getContainer() == null || !(nameable.getContainer() instanceof CompositeEntity)) {
            return Collections.EMPTY_SET;
        }
        CompositeEntity compositeEntity = (CompositeEntity)nameable.getContainer();
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(compositeEntity.relationList());
        if (nameable instanceof TypedIOPort && bl && compositeEntity != null && compositeEntity.getContainer() != null) {
            arrayList.addAll(((CompositeEntity)compositeEntity.getContainer()).relationList());
        }
        if (arrayList == null || arrayList.size() == 0) {
            return Collections.EMPTY_SET;
        }
        for (Relation relation : arrayList) {
            List list = relation.linkedObjectsList();
            if (list == null || list.size() == 0) continue;
            for (Object e : list) {
                Port port;
                if (!(e instanceof Port) || !(port = (Port)e).getContainer().equals(nameable) && (!(nameable instanceof IOPort) || !port.equals((IOPort)nameable))) continue;
                if (connectionType.equals((Object)ConnectionType.SOURCE)) {
                    if ((!(port instanceof IOPort) || nameable instanceof IOPort || !((IOPort)port).isOutput()) && (!(nameable instanceof IOPort) || !((IOPort)port).isInput())) continue;
                    hashSet.add(relation);
                    continue;
                }
                if ((!(port instanceof IOPort) || nameable instanceof IOPort || !((IOPort)port).isInput()) && (!(nameable instanceof IOPort) || !((IOPort)port).isOutput())) continue;
                hashSet.add(relation);
            }
        }
        return hashSet;
    }

    public static List<Relation> getRelations(NamedObj namedObj) {
        new ArrayList();
        if (namedObj == null || !(namedObj instanceof CompositeEntity)) {
            return Collections.EMPTY_LIST;
        }
        List list = ((CompositeEntity)namedObj).relationList();
        return list;
    }

    public static double[] getLocation(NamedObj namedObj) {
        if (namedObj instanceof Locatable) {
            Locatable locatable = (Locatable)namedObj;
            return locatable.getLocation();
        }
        List list = namedObj.attributeList(Locatable.class);
        if (list == null || list.size() == 0) {
            return new double[]{0.0, 0.0};
        }
        Locatable locatable = (Locatable)list.get(0);
        return locatable.getLocation();
    }

    public static void setLocation(NamedObj namedObj, double[] dArray) {
        List list;
        if (namedObj instanceof Locatable) {
            try {
                ((Locatable)namedObj).setLocation(dArray);
                list = namedObj.getContainer();
                list.attributeChanged((Attribute)namedObj);
            }
            catch (IllegalActionException illegalActionException) {
                logger.error("Unable to change location of component", (Throwable)illegalActionException);
            }
        }
        if ((list = namedObj.attributeList(Locatable.class)) == null) {
            return;
        }
        if (list.size() > 0) {
            Locatable locatable = (Locatable)list.get(0);
            try {
                locatable.setLocation(dArray);
                namedObj.attributeChanged((Attribute)list.get(0));
            }
            catch (IllegalActionException illegalActionException) {
                logger.error("Unable to change location of component", (Throwable)illegalActionException);
            }
        } else {
            try {
                new Location(namedObj, "_location").setLocation(dArray);
            }
            catch (IllegalActionException illegalActionException) {
                logger.error("Unable to change location of component", (Throwable)illegalActionException);
            }
            catch (NameDuplicationException nameDuplicationException) {
                logger.error("Duplicate name encountered during change location of component", (Throwable)nameDuplicationException);
            }
        }
    }

    public static boolean isPortOfActor(IOPort iOPort, Actor actor) {
        for (Object e : actor.inputPortList()) {
            if (e != iOPort) continue;
            return true;
        }
        for (Object e : actor.outputPortList()) {
            if (e != iOPort) continue;
            return true;
        }
        return false;
    }

    public static String findUniqueActorName(CompositeEntity compositeEntity, String string) {
        String string2 = string;
        if (compositeEntity == null) {
            return string2;
        }
        List list = compositeEntity.entityList();
        if (list == null || list.size() == 0) {
            return string2;
        }
        ComponentEntity componentEntity = compositeEntity.getEntity(string2);
        int n = 1;
        while (componentEntity != null) {
            string2 = String.valueOf(string) + "(" + n++ + ")";
            componentEntity = compositeEntity.getEntity(string2);
        }
        return string2;
    }

    public static String getLegalName(String string) {
        String string2 = string;
        if (string.indexOf(46) > -1) {
            string2 = string2.substring(0, string2.lastIndexOf(46));
        }
        string2 = string2.replace('.', '_');
        return string2;
    }

    public static boolean isNameLegal(String string) {
        if (string == null) {
            return false;
        }
        if ("".equals(string)) {
            return false;
        }
        return string.indexOf(46) <= -1;
    }

    private static String generateUniqueTextAttributeName(String string, NamedObj namedObj, int n, Class clazz) {
        try {
            String string2;
            String string3 = string2 = n != 0 ? String.valueOf(string) + "(" + n + ")" : string;
            if (namedObj.getAttribute(string2, clazz) == null) {
                return string2;
            }
            return ModelUtils.generateUniqueTextAttributeName(string, namedObj, ++n, clazz);
        }
        catch (IllegalActionException illegalActionException) {
            return string;
        }
    }

    private static String generateUniqueVertexName(String string, NamedObj namedObj, int n, Class clazz) {
        return "Vertex" + System.currentTimeMillis();
    }

    private static String generateUniquePortName(String string, CompositeEntity compositeEntity, int n) {
        String string2 = n != 0 ? String.valueOf(string) + "(" + n + ")" : string;
        boolean bl = false;
        Enumeration enumeration = compositeEntity.getPorts();
        while (enumeration.hasMoreElements()) {
            String string3 = ((Port)enumeration.nextElement()).getName();
            if (!string2.equals(string3)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return string2;
        }
        return ModelUtils.generateUniquePortName(string, compositeEntity, ++n);
    }

    public static String findUniqueName(CompositeEntity compositeEntity, Class clazz, String string, String string2) {
        if (Vertex.class.isAssignableFrom(clazz)) {
            return ModelUtils.generateUniqueVertexName(clazz.getSimpleName(), (NamedObj)compositeEntity, 0, clazz);
        }
        if (TextAttribute.class.isAssignableFrom(clazz)) {
            return ModelUtils.generateUniqueTextAttributeName(clazz.getSimpleName(), (NamedObj)compositeEntity, 0, clazz);
        }
        if (TypedIOPort.class.isAssignableFrom(clazz)) {
            return ModelUtils.generateUniquePortName(string, compositeEntity, 0);
        }
        return ModelUtils.findUniqueActorName(compositeEntity, string2 != null ? string2 : clazz.getSimpleName());
    }

    public static ComponentEntity findEntityByName(CompositeActor compositeActor, String string) {
        ComponentEntity componentEntity = compositeActor.getEntity(string);
        if (componentEntity != null) {
            return componentEntity;
        }
        return null;
    }

    private static void printChildren(InstantiableNamedObj instantiableNamedObj) {
        if (instantiableNamedObj == null) {
            return;
        }
        List list = instantiableNamedObj.getChildren();
        if (list == null) {
            return;
        }
        for (Object e : list) {
            if (e instanceof NamedObj) {
                System.out.println(((NamedObj)e).getName());
            }
            if (!(e instanceof InstantiableNamedObj)) continue;
            ModelUtils.printChildren((InstantiableNamedObj)e);
        }
    }

    public static IFile getProjectFile(String string) {
        String string2 = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        String string3 = string.substring(string2.length());
        IFile iFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(string3);
        if (iFile == null) {
            string3 = string.substring(string2.length() + 2);
            iFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(string3);
        }
        return iFile;
    }

    public static IProject getProject(NamedObj namedObj) throws Exception {
        CompositeActor compositeActor = (CompositeActor)namedObj.getContainer();
        while (compositeActor.getContainer() != null) {
            compositeActor = (CompositeActor)compositeActor.getContainer();
        }
        IProject iProject = null;
        String string = compositeActor.workspace().getName();
        iProject = string == null || string.equals("") ? ModelUtils.getPasserelleProject() : (IProject)ResourcesPlugin.getWorkspace().getRoot().findMember(string);
        return iProject;
    }

    public static String substitute(String string, NamedObj namedObj) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("project_name", ModelUtils.getProject(namedObj).getName());
        hashMap.put("actor_name", namedObj.getName());
        MultiVariableExpander multiVariableExpander = new MultiVariableExpander();
        multiVariableExpander.addSource("$", hashMap);
        VariableSubstitutor variableSubstitutor = new VariableSubstitutor((VariableExpander)multiVariableExpander);
        try {
            VariablesPlugin.getDefault().getStringVariableManager().validateStringVariables(string);
            string = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(string, false);
        }
        catch (Throwable throwable) {}
        return variableSubstitutor.substitute(string);
    }

    public static InputStream getEmptyWorkflowStream(String string) {
        String string2 = "<?xml version=\"1.0\" standalone=\"no\"?> \r\n<!DOCTYPE entity PUBLIC \"-//UC Berkeley//DTD MoML 1//EN\" \"http://ptolemy.eecs.berkeley.edu/xml/dtd/MoML_1.dtd\"> \r\n<entity name=\"" + string.substring(0, string.length() - 5) + "\" class=\"ptolemy.actor.TypedCompositeActor\"> \r\n" + "   <property name=\"_createdBy\" class=\"ptolemy.kernel.attributes.VersionAttribute\" value=\"7.0.1\" /> \r\n" + "   <property name=\"_workbenchVersion\" class=\"ptolemy.kernel.attributes.VersionAttribute\" value=\"" + System.getProperty("passerelle.workbench.version") + "\" /> \r\n" + "   <property name=\"Director\" class=\"com.isencia.passerelle.domain.cap.Director\" > \r\n" + "      <property name=\"_location\" class=\"ptolemy.kernel.util.Location\" value=\"{20, 20}\" /> \r\n" + "   </property> \r\n" + "</entity>";
        return new ByteArrayInputStream(string2.getBytes());
    }

    public static InputStream getEmptyCompositeStream(String string) throws UnsupportedEncodingException {
        File file = new File(string);
        String string2 = file.getName();
        if (string2.toLowerCase().endsWith(".moml")) {
            string2 = string2.substring(0, string2.length() - 5);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" standalone=\"no\"?> \r\n");
        stringBuilder.append("<!DOCTYPE entity PUBLIC \"-//UC Berkeley//DTD MoML 1//EN\" \"http://ptolemy.eecs.berkeley.edu/xml/dtd/MoML_1.dtd\">\r\n");
        stringBuilder.append("<class name=\"" + string2 + "\" extends=\"" + TypedCompositeActor.class.getName() + "\" >\r\n");
        stringBuilder.append("<property name=\"_createdBy\" class=\"ptolemy.kernel.attributes.VersionAttribute\" value=\"7.0.1\"></property>\r\n");
        stringBuilder.append("<property name=\"_workbenchVersion\" class=\"ptolemy.kernel.attributes.VersionAttribute\" value=\"" + System.getProperty("passerelle.workbench.version") + "\"></property>\r\n");
        stringBuilder.append("<property name=\"_controllerFactory\" class=\"com.isencia.passerelle.actor.gui.PasserelleActorControllerFactory\"></property>\r\n");
        stringBuilder.append("<property name=\"_editorFactory\" class=\"com.isencia.passerelle.actor.gui.PasserelleEditorFactory\"></property>\r\n");
        stringBuilder.append("<property name=\"_editorPaneFactory\" class=\"com.isencia.passerelle.actor.gui.PasserelleEditorPaneFactory\"></property>\r\n");
        stringBuilder.append("</class>\r\n");
        return new ByteArrayInputStream(stringBuilder.toString().getBytes("UTF-8"));
    }

    public static IProject getPasserelleProject() throws Exception {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(".passerelle");
        if (!iProject.exists()) {
            iProject.create((IProgressMonitor)new NullProgressMonitor());
            try {
                iProject.setHidden(true);
            }
            catch (Exception exception) {}
        }
        if (!iProject.isOpen()) {
            iProject.open((IProgressMonitor)new NullProgressMonitor());
        }
        return iProject;
    }

    public static Workspace getWorkspace(String string) {
        IFile iFile = ModelUtils.getProjectFile(string);
        if (iFile != null) {
            logger.info("Running project file " + iFile);
            return new Workspace(iFile.getProject().getName());
        }
        String string2 = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        String string3 = string.substring(string2.length());
        iFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(string3);
        if (iFile != null) {
            logger.info("Running project file " + iFile);
            return new Workspace(iFile.getProject().getName());
        }
        if (string3.startsWith("/")) {
            string3 = string3.substring(1);
        }
        String string4 = string3.substring(0, string3.indexOf("/"));
        logger.info("Using project " + string4);
        return new Workspace(string4);
    }

    public static enum ConnectionType {
        SOURCE,
        TARGET;

    }
}

