/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.launch;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.domain.cap.Director;
import com.isencia.passerelle.ext.ErrorCollector;
import com.isencia.passerelle.workbench.model.jmx.RemoteManagerAgent;
import com.isencia.passerelle.workbench.model.launch.IModelListener;
import com.isencia.passerelle.workbench.model.utils.ModelUtils;
import com.isencia.passerelle.workbench.model.utils.SubModelUtils;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.CompositeActor;
import ptolemy.actor.Manager;
import ptolemy.kernel.util.Workspace;
import ptolemy.moml.MoMLParser;

public class ModelRunner
implements IApplication {
    private static Logger logger = LoggerFactory.getLogger(ModelRunner.class);
    private static ModelRunner currentInstance;
    private Manager manager;

    public static ModelRunner getRunningInstance() {
        return currentInstance;
    }

    public Object start(IApplicationContext iApplicationContext) throws Exception {
        String string = System.getProperty("model");
        this.runModel(string, "true".equals(System.getProperty("com.isencia.jmx.service.terminate")));
        return IApplication.EXIT_OK;
    }

    public void stop() {
        if (this.manager != null) {
            try {
                this.manager.stop();
            }
            catch (Throwable throwable) {
                logger.error("Cannot stop manager for model.", throwable);
            }
            this.manager = null;
        }
    }

    public void runModel(String string, boolean bl) throws Exception {
        if (!Platform.isRunning()) {
            throw new Exception("ModelRunner is designed to be used with an eclipse application!");
        }
        final ArrayList arrayList = new ArrayList(1);
        long l = System.currentTimeMillis();
        try {
            String string2 = System.getProperty("com.isencia.jmx.service.workspace");
            if (string2 == null) {
                string2 = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
            }
            System.setProperty("eclipse.workspace.home", string2);
            System.setProperty("be.isencia.home", string2);
            logger.info("Workspace folder set to: " + string2);
            Reader reader = null;
            RemoteManagerAgent remoteManagerAgent = null;
            CompositeActor compositeActor = null;
            try {
                currentInstance = this;
                SubModelUtils.readSubModels();
                if (string == null) {
                    throw new IllegalArgumentException("No model specified", null);
                }
                logger.info("Running model : " + string);
                if (System.getProperty("com.isencia.jmx.service.port") != null) {
                    logger.debug("The jmx port is set to : '" + System.getProperty("com.isencia.jmx.service.port") + "'");
                    remoteManagerAgent = new RemoteManagerAgent(this.manager);
                    remoteManagerAgent.start();
                }
                this.notifyModelChangeStart();
                reader = new FileReader(string);
                MoMLParser.purgeModelRecord((String)string);
                MoMLParser.purgeAllModelRecords();
                Workspace workspace = ModelUtils.getWorkspace(string);
                MoMLParser moMLParser = new MoMLParser(workspace);
                compositeActor = (CompositeActor)moMLParser.parse(null, reader);
                if (System.getProperty("com.isencia.require.file.source") != null) {
                    compositeActor.setSource(string);
                }
                this.manager = new Manager(compositeActor.workspace(), this.getUniqueName());
                this.manager.setPersistent(false);
                compositeActor.setManager(this.manager);
                Director director = (Director)compositeActor.getDirector();
                director.addErrorCollector(new ErrorCollector(){

                    public void acceptError(PasserelleException passerelleException) {
                        arrayList.add(passerelleException);
                        ModelRunner.this.manager.stop();
                    }
                });
                this.manager.execute();
                if (this.manager != null) {
                    while (this.manager.isExitingAfterWrapup()) {
                        logger.info("Waiting for manager to wrap up.");
                        Thread.sleep(100L);
                    }
                }
            }
            finally {
                this.notifyModelChangeEnd(0);
                if (remoteManagerAgent != null) {
                    remoteManagerAgent.stop();
                    logger.info("Closed model agent");
                }
                if (reader != null) {
                    reader.close();
                    logger.info("Closed reader");
                }
                this.manager = null;
                currentInstance = null;
                System.gc();
            }
        }
        finally {
            MoMLParser.purgeModelRecord((String)string);
            MoMLParser.purgeAllModelRecords();
            logger.info("End model : " + string);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            logger.info("Model completed in " + l3 / 60000L + "m " + l3 / 1000L % 60L + "s " + l3 % 1000L + "ms");
            if (bl) {
                logger.info("Passerelle shut down.");
                System.exit(1);
            }
            if (!arrayList.isEmpty()) {
                throw (Exception)arrayList.get(0);
            }
        }
    }

    private String getUniqueName() {
        return "Model_" + System.currentTimeMillis();
    }

    private void notifyModelChangeStart() {
        try {
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("com.isencia.passerelle.engine.model.listener");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                IModelListener iModelListener = (IModelListener)iConfigurationElement.createExecutableExtension("modelListener");
                iModelListener.executionStarted();
                ++n2;
            }
        }
        catch (Exception exception) {
            logger.error("Cannot notify model listeners");
        }
    }

    private void notifyModelChangeEnd(int n) {
        try {
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("com.isencia.passerelle.engine.model.listener");
            int n2 = iConfigurationElementArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n3];
                IModelListener iModelListener = (IModelListener)iConfigurationElement.createExecutableExtension("modelListener");
                iModelListener.executionTerminated(n);
                ++n3;
            }
        }
        catch (Exception exception) {
            logger.error("Cannot notify model listeners");
        }
    }

    public static void main(String[] stringArray) throws Throwable {
        String string = null;
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0 && "-model".equals(stringArray[n - 1])) {
                string = stringArray[n];
                break;
            }
            ++n;
        }
        ModelRunner modelRunner = new ModelRunner();
        modelRunner.runModel(string, true);
    }
}

