/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.jmx;

import com.isencia.passerelle.workbench.model.activator.Activator;
import com.isencia.passerelle.workbench.model.jmx.RemoteManager;
import com.isencia.passerelle.workbench.model.launch.ModelRunner;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Manager;

public class RemoteManagerAgent {
    public static ObjectName REMOTE_MANAGER;
    private static Logger logger;
    private RemoteManager remoteManager;
    private final JMXServiceURL serverUrl;

    static {
        logger = LoggerFactory.getLogger(RemoteManagerAgent.class);
        try {
            REMOTE_MANAGER = new ObjectName(String.valueOf(RemoteManager.class.getPackage().getName()) + ":type=RemoteManager");
        }
        catch (Exception exception) {
            logger.error("Cannot create ObjectName for remotemanager", (Throwable)exception);
        }
    }

    public RemoteManagerAgent(Manager manager) throws Exception {
        this.remoteManager = new RemoteManager(manager);
        int n = Integer.parseInt(System.getProperty("com.isencia.jmx.service.port"));
        String string = RemoteManagerAgent.getHostName();
        this.serverUrl = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + string + ":" + n + "/workflow");
        logger.debug("Workflow URI: " + this.serverUrl.getURLPath());
    }

    private static final String getHostName() throws UnknownHostException {
        String string = System.getProperty("org.dawb.workbench.jmx.host.name");
        if (string == null) {
            string = InetAddress.getLocalHost().getHostName();
        }
        if (string == null) {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        if (string == null) {
            string = "localhost";
        }
        return string;
    }

    public void start() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            try {
                this.stop(false);
            }
            catch (Exception exception) {}
            mBeanServer.registerMBean(this.remoteManager, REMOTE_MANAGER);
            JMXConnectorServer jMXConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this.serverUrl, null, mBeanServer);
            jMXConnectorServer.start();
            logger.debug("Workflow service started on " + this.serverUrl);
        }
        catch (Exception exception) {
            logger.error("Cannot connect manager agent to provide rmi access to ptolomy manager", (Throwable)exception);
            Activator.getDefault().getLog().log((IStatus)new Status(4, "com.isencia.passerelle.workbench.model", "The connection of the workflow service has failed to " + this.serverUrl + ". No workflows can be run!", (Throwable)exception));
            throw exception;
        }
    }

    public void stop() {
        this.stop(true);
    }

    protected void stop(boolean bl) {
        block10: {
            Object object;
            block9: {
                if (bl) {
                    if (this.remoteManager != null) {
                        this.remoteManager.sendNotification("ptolemy.actor.Manager.stop");
                    }
                    this.remoteManager = null;
                    logger.debug("Model runner asked to stop");
                    if (ModelRunner.getRunningInstance() != null) {
                        ModelRunner.getRunningInstance().stop();
                    }
                }
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                try {
                    object = mBeanServer.getObjectInstance(REMOTE_MANAGER);
                    if (object != null) {
                        mBeanServer.unregisterMBean(REMOTE_MANAGER);
                        logger.debug("Workflow service stopped on " + this.serverUrl);
                    }
                }
                catch (Exception exception) {
                    if (!bl) break block9;
                    logger.error("Cannot unregisterMBean " + REMOTE_MANAGER, (Throwable)exception);
                }
            }
            try {
                object = LocateRegistry.getRegistry(Integer.parseInt(System.getProperty("com.isencia.jmx.service.port")));
                if (object.lookup("workflow") != null) {
                    object.unbind("workflow");
                }
            }
            catch (Exception exception) {
                if (!bl) break block10;
                logger.error("Cannot unregisterMBean " + REMOTE_MANAGER, (Throwable)exception);
            }
        }
    }

    public static MBeanServerConnection getServerConnection(long l) throws Exception {
        if (System.getProperty("com.isencia.jmx.service.port") == null) {
            throw new Exception("You must start the registry before calling this method and set the property 'com.isencia.jmx.service.port'");
        }
        long l2 = 0L;
        MBeanServerConnection mBeanServerConnection = null;
        while (l > l2) {
            l2 += 100L;
            try {
                String string = RemoteManagerAgent.getHostName();
                int n = Integer.parseInt(System.getProperty("com.isencia.jmx.service.port"));
                JMXServiceURL jMXServiceURL = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + string + ":" + n + "/workflow");
                JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL);
                mBeanServerConnection = jMXConnector.getMBeanServerConnection();
                if (mBeanServerConnection != null) break;
                throw new NullPointerException("MBeanServerConnection is null");
            }
            catch (Throwable throwable) {
                if (l2 >= l) {
                    throw new Exception("Cannot get connection. Connection took longer than " + l, throwable);
                }
                Thread.sleep(100L);
            }
        }
        return mBeanServerConnection;
    }
}

