/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.workbench.model.jmx;

import com.isencia.passerelle.workbench.model.jmx.RemoteManagerMBean;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.StandardMBean;
import ptolemy.actor.Manager;

public class RemoteManager
extends StandardMBean
implements RemoteManagerMBean {
    protected static final String STOP_CODE = "ptolemy.actor.Manager.stop";
    protected static final String PAUSE_CODE = "ptolemy.actor.Manager.pause";
    protected static final String PAUSE_BREAK_CODE = "ptolemy.actor.Manager.pauseOnBreakpoint";
    private Manager manager;
    private NotificationBroadcasterSupport generalBroadcaster;

    public RemoteManager(Manager manager) throws NotCompliantMBeanException {
        super(RemoteManagerMBean.class);
        this.manager = manager;
    }

    protected Manager getManager() {
        return this.manager;
    }

    protected void setManager(Manager manager) {
        this.manager = manager;
    }

    @Override
    public void stop() {
        if (this.manager != null) {
            this.manager.stop();
            this.sendNotification(STOP_CODE);
        }
    }

    protected void sendNotification(String string) {
        this.sendNotification(string, null);
    }

    protected void sendNotification(String string, Object object) {
        if (this.generalBroadcaster != null) {
            Notification notification = new Notification(string, this, -1L);
            notification.setUserData(object);
            this.generalBroadcaster.sendNotification(notification);
        }
    }

    @Override
    public void pause() {
        if (this.manager != null) {
            this.manager.pause();
            this.sendNotification(PAUSE_CODE);
        }
    }

    @Override
    public void pauseOnBreakpoint(String string) {
        if (this.manager != null) {
            this.manager.pauseOnBreakpoint(string);
            this.sendNotification(PAUSE_BREAK_CODE, string);
        }
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        if (this.generalBroadcaster == null) {
            this.generalBroadcaster = new NotificationBroadcasterSupport();
        }
        this.generalBroadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{STOP_CODE, PAUSE_CODE, PAUSE_BREAK_CODE}, Notification.class.getName(), "User Notifications.")};
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        if (this.generalBroadcaster == null) {
            throw new ListenerNotFoundException("No notification listeners registered");
        }
        this.generalBroadcaster.removeNotificationListener(notificationListener);
    }
}

