/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.prettyprinterv2;

import java.io.IOException;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.parser.prettyprinterv2.IPrettyPrinterPrefs;
import org.python.pydev.parser.prettyprinterv2.IWriterEraser;

public class WriteStateV2
implements IWriterEraser {
    private IWriterEraser writer;
    private IPrettyPrinterPrefs prefs;
    private FastStringBuffer indentation = new FastStringBuffer(40);
    private boolean nextMustBeNewLineOrComment = false;
    private boolean nextMustBeNewLine = true;
    public static final int INITIAL_STATE = -1;
    public static final int LAST_STATE_NEW_LINE = 0;
    public static final int LAST_STATE_INDENT = 1;
    public static final int LAST_STATE_WRITE = 2;
    private int lastWrite = 0;
    int lastState = -1;

    public WriteStateV2(IWriterEraser writer, IPrettyPrinterPrefs prefs) {
        this.writer = writer;
        this.prefs = prefs;
    }

    public String getIndentString() {
        return this.indentation.toString();
    }

    public int getIndentLen() {
        return this.indentation.length();
    }

    public String getIndentChars(int numberOfChars) {
        return this.indentation.toString().substring(this.indentation.length() - numberOfChars);
    }

    public void indent() {
        this.indentation.append(this.prefs.getIndent());
    }

    public void dedent() {
        int len = this.indentation.length();
        int indentLen = this.prefs.getIndent().length();
        try {
            this.indentation.delete(len - indentLen, len);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        this.eraseIndent();
    }

    public void eraseIndent() {
        if (this.indentation.length() > 0) {
            this.writer.erase(this.prefs.getIndent());
        }
    }

    public void writeIndent() throws IOException {
        this.lastState = 1;
        this.writer.write(this.indentation.toString());
        ++this.lastWrite;
    }

    public void writeNewLine() throws IOException {
        this.writeNewLine(true);
    }

    public boolean writeNewLine(boolean force) throws IOException {
        if (force || this.lastState == 2) {
            FastStringBuffer buffer = this.writer.getBuffer();
            if (buffer.endsWith(": ")) {
                buffer.deleteLast();
            }
            if (this.lastState == 0) {
                this.writeIndent();
            }
            this.nextMustBeNewLineOrComment = false;
            this.nextMustBeNewLine = false;
            this.lastState = 0;
            this.writer.write(this.prefs.getNewLine());
            ++this.lastWrite;
            return true;
        }
        return false;
    }

    public void write(String o) throws IOException {
        FastStringBuffer buf;
        if ((this.nextMustBeNewLineOrComment || this.nextMustBeNewLine) && this.getBuffer().length() > 0 && this.lastState != 0 && this.lastState != 1) {
            if (this.nextMustBeNewLine) {
                this.writeNewLine();
            } else if (this.nextMustBeNewLineOrComment && !o.trim().startsWith("#")) {
                this.writeNewLine();
            }
        }
        this.nextMustBeNewLineOrComment = false;
        this.nextMustBeNewLine = false;
        if (this.lastState == 0) {
            this.writeIndent();
        }
        if ((buf = this.getBuffer()).endsWith("\r") || buf.endsWith("\n") || buf.endsWith(" ") || buf.endsWith("\t")) {
            this.writeRaw(StringUtils.leftTrim((String)o));
        } else {
            this.writeRaw(o);
        }
    }

    public void writeRaw(String o) throws IOException {
        this.lastState = 2;
        this.writer.write(o);
        ++this.lastWrite;
    }

    public void writeWithoutChangingState(String string) throws IOException {
        this.writer.write(string);
        ++this.lastWrite;
    }

    public void writeSpacesBeforeComment() throws IOException {
        if (this.lastState == 2 && !this.writer.endsWithSpace()) {
            this.writeRaw(this.prefs.getSpacesBeforeComment());
        }
    }

    public void erase(String o) {
        this.writer.erase(o);
    }

    public void pushTempBuffer() {
        this.writer.pushTempBuffer();
    }

    public String popTempBuffer() {
        return this.writer.popTempBuffer();
    }

    public boolean lastIsWrite() {
        return this.lastState == 2;
    }

    public boolean lastIsIndent() {
        return this.lastState == 1;
    }

    public boolean lastIsNewLine() {
        return this.lastState == 0;
    }

    public String toString() {
        return this.writer.toString();
    }

    public int getLastWrite() {
        return this.lastWrite;
    }

    public void requireNextNewLineOrComment() {
        this.nextMustBeNewLineOrComment = true;
    }

    public void requireNextNewLine() {
        this.nextMustBeNewLine = true;
    }

    public boolean endsWithSpace() {
        return this.writer.endsWithSpace();
    }

    public FastStringBuffer getBuffer() {
        return this.writer.getBuffer();
    }
}

