/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.prettyprinterv2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assert;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.AugAssign;
import org.python.pydev.parser.jython.ast.BinOp;
import org.python.pydev.parser.jython.ast.BoolOp;
import org.python.pydev.parser.jython.ast.Break;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Compare;
import org.python.pydev.parser.jython.ast.Comprehension;
import org.python.pydev.parser.jython.ast.Continue;
import org.python.pydev.parser.jython.ast.Delete;
import org.python.pydev.parser.jython.ast.Dict;
import org.python.pydev.parser.jython.ast.DictComp;
import org.python.pydev.parser.jython.ast.Ellipsis;
import org.python.pydev.parser.jython.ast.Exec;
import org.python.pydev.parser.jython.ast.For;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Global;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.IfExp;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Lambda;
import org.python.pydev.parser.jython.ast.ListComp;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Num;
import org.python.pydev.parser.jython.ast.Pass;
import org.python.pydev.parser.jython.ast.Print;
import org.python.pydev.parser.jython.ast.Raise;
import org.python.pydev.parser.jython.ast.Repr;
import org.python.pydev.parser.jython.ast.Return;
import org.python.pydev.parser.jython.ast.Set;
import org.python.pydev.parser.jython.ast.SetComp;
import org.python.pydev.parser.jython.ast.Slice;
import org.python.pydev.parser.jython.ast.Starred;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.StrJoin;
import org.python.pydev.parser.jython.ast.Subscript;
import org.python.pydev.parser.jython.ast.Suite;
import org.python.pydev.parser.jython.ast.TryExcept;
import org.python.pydev.parser.jython.ast.TryFinally;
import org.python.pydev.parser.jython.ast.Tuple;
import org.python.pydev.parser.jython.ast.UnaryOp;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.With;
import org.python.pydev.parser.jython.ast.WithItem;
import org.python.pydev.parser.jython.ast.Yield;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.commentType;
import org.python.pydev.parser.jython.ast.comprehensionType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.excepthandlerType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.keywordType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.jython.ast.suiteType;
import org.python.pydev.parser.prettyprinterv2.ILinePart;
import org.python.pydev.parser.prettyprinterv2.IPrettyPrinterPrefs;
import org.python.pydev.parser.prettyprinterv2.LinePartRequireMark;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterDocV2;
import org.python.pydev.parser.prettyprinterv2.PrettyPrinterUtilsV2;
import org.python.pydev.parser.visitors.NodeUtils;

public final class PrettyPrinterVisitorV2
extends PrettyPrinterUtilsV2 {
    private int tupleNeedsParens;

    public PrettyPrinterVisitorV2(IPrettyPrinterPrefs prefs, PrettyPrinterDocV2 doc) {
        super(prefs, doc);
    }

    public Object visitAssign(Assign node) throws Exception {
        this.beforeNode(node);
        int id = 0;
        List<ILinePart> recordChanges = null;
        org.python.pydev.core.Tuple<ILinePart, ILinePart> lowerAndHigher = null;
        int i = 0;
        while (i < node.targets.length) {
            exprType target = node.targets[i];
            if (i >= 1) {
                this.doc.add(((ILinePart)lowerAndHigher.o2).getLine(), ((ILinePart)lowerAndHigher.o2).getBeginCol(), this.prefs.getAssignPunctuation(), node);
            }
            id = this.doc.pushRecordChanges();
            target.accept(this);
            recordChanges = this.doc.popRecordChanges(id);
            lowerAndHigher = this.doc.getLowerAndHigerFound(recordChanges);
            ++i;
        }
        this.doc.add(((ILinePart)lowerAndHigher.o2).getLine(), ((ILinePart)lowerAndHigher.o2).getBeginCol(), this.prefs.getAssignPunctuation(), node);
        node.value.accept(this);
        this.afterNode(node);
        return null;
    }

    public Object visitAugAssign(AugAssign node) throws Exception {
        this.beforeNode(node);
        int id = this.doc.pushRecordChanges();
        node.target.accept(this);
        org.python.pydev.core.Tuple<ILinePart, ILinePart> lowerAndHigerFound = this.doc.getLowerAndHigerFound(this.doc.popRecordChanges(id));
        ILinePart lastPart = (ILinePart)lowerAndHigerFound.o2;
        this.doc.add(lastPart.getLine(), lastPart.getBeginCol(), this.prefs.getAugOperatorMapping(node.op), node);
        node.value.accept(this);
        this.afterNode(node);
        return null;
    }

    public Object visitBinOp(BinOp node) throws Exception {
        this.beforeNode(node);
        int id = this.doc.pushRecordChanges();
        this.pushTupleNeedsParens();
        node.left.accept(this);
        org.python.pydev.core.Tuple<ILinePart, ILinePart> lowerAndHigerFound = this.doc.getLowerAndHigerFound(this.doc.popRecordChanges(id));
        ILinePart lastPart = (ILinePart)lowerAndHigerFound.o2;
        this.doc.add(lastPart.getLine(), lastPart.getBeginCol(), this.prefs.getOperatorMapping(node.op), node);
        node.right.accept(this);
        this.popTupleNeedsParens();
        this.afterNode(node);
        return null;
    }

    public Object visitUnaryOp(UnaryOp node) throws Exception {
        this.beforeNode(node);
        this.doc.add(node.beginLine, node.beginColumn, this.prefs.getUnaryopOperatorMapping(node.op), node);
        node.operand.accept(this);
        this.afterNode(node);
        return null;
    }

    public Object visitBoolOp(BoolOp node) throws Exception {
        this.beforeNode(node);
        int i = 0;
        while (i < node.values.length - 1) {
            int id = this.doc.pushRecordChanges();
            node.values[i].accept(this);
            List<ILinePart> changes = this.doc.popRecordChanges(id);
            org.python.pydev.core.Tuple<ILinePart, ILinePart> lowerAndHigher = this.doc.getLowerAndHigerFound(changes);
            ILinePart lastPart = (ILinePart)lowerAndHigher.o2;
            this.doc.add(lastPart.getLine(), lastPart.getBeginCol(), this.prefs.getBoolOperatorMapping(node.op), this.lastNode);
            ++i;
        }
        node.values[node.values.length - 1].accept(this);
        this.afterNode(node);
        return null;
    }

    public Object visitCompare(Compare node) throws Exception {
        this.beforeNode(node);
        this.pushTupleNeedsParens();
        int id = this.doc.pushRecordChanges();
        node.left.accept(this);
        List<ILinePart> recordChanges = this.doc.popRecordChanges(id);
        org.python.pydev.core.Tuple<ILinePart, ILinePart> lowerAndHigher = this.doc.getLowerAndHigerFound(recordChanges);
        int i = 0;
        while (i < node.comparators.length) {
            ILinePart lastPart = (ILinePart)lowerAndHigher.o2;
            this.doc.add(lastPart.getLine(), lastPart.getBeginCol(), this.prefs.getCmpOp(node.ops[i]), this.lastNode);
            id = this.doc.pushRecordChanges();
            node.comparators[i].accept(this);
            recordChanges = this.doc.popRecordChanges(id);
            lowerAndHigher = this.doc.getLowerAndHigerFound(recordChanges);
            ++i;
        }
        this.popTupleNeedsParens();
        this.afterNode(node);
        return null;
    }

    public Object visitEllipsis(Ellipsis node) throws Exception {
        int id = this.doc.pushRecordChanges();
        this.beforeNode(node);
        List<ILinePart> changes = this.doc.popRecordChanges(id);
        org.python.pydev.core.Tuple<ILinePart, ILinePart> lowerAndHigerFound = this.doc.getLowerAndHigerFound(changes);
        if (lowerAndHigerFound != null) {
            this.doc.add(((ILinePart)lowerAndHigerFound.o2).getLine(), ((ILinePart)lowerAndHigerFound.o2).getBeginCol(), "...", node);
        } else {
            this.doc.add(node.beginLine, node.beginColumn, "...", node);
        }
        this.afterNode(node);
        return null;
    }

    public Object visitDict(Dict node) throws Exception {
        this.beforeNode(node);
        exprType[] keys = node.keys;
        exprType[] values = node.values;
        this.doc.addRequire("{", node);
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                this.doc.addRequire(",", this.lastNode);
            }
            this.pushTupleNeedsParens();
            keys[i].accept(this);
            this.popTupleNeedsParens();
            this.doc.addRequire(":", this.lastNode);
            this.pushTupleNeedsParens();
            values[i].accept(this);
            this.popTupleNeedsParens();
            ++i;
        }
        this.doc.addRequire("}", this.lastNode);
        this.afterNode(node);
        return null;
    }

    public Object visitTuple(Tuple node) throws Exception {
        this.beforeNode(node);
        if (node.elts != null && node.elts.length > 0) {
            if (this.tupleNeedsParens > 0) {
                this.doc.addRequire("(", node);
            }
            int id = this.doc.pushRecordChanges();
            this.pushTupleNeedsParens();
            this.visitCommaSeparated(node.elts, node.endsWithComma);
            this.popTupleNeedsParens();
            List<ILinePart> changes = this.doc.popRecordChanges(id);
            if (this.tupleNeedsParens == 0) {
                boolean foundComment = false;
                for (ILinePart iLinePart : changes) {
                    if (foundComment && iLinePart.getToken() instanceof SimpleNode) {
                        this.doc.addRequireBefore("(", changes.get(0));
                        this.doc.addRequireAfter(")", changes.get(changes.size() - 1));
                        break;
                    }
                    if (!(iLinePart.getToken() instanceof commentType)) continue;
                    foundComment = true;
                }
            }
            if (this.tupleNeedsParens > 0) {
                this.doc.addRequire(")", this.lastNode);
            }
        } else {
            this.doc.addRequire("(", node);
            this.doc.addRequire(")", node);
        }
        this.afterNode(node);
        return null;
    }

    private void visitCommaSeparated(exprType[] elts, boolean requireEndWithCommaSingleElement) throws Exception {
        if (elts != null) {
            int i = 0;
            while (i < elts.length) {
                if (elts[i] != null) {
                    if (i > 0) {
                        this.doc.addRequire(",", this.lastNode);
                    }
                    elts[i].accept(this);
                }
                ++i;
            }
            if (elts.length == 1 && requireEndWithCommaSingleElement) {
                this.doc.addRequire(",", this.lastNode);
            }
        }
    }

    public Object visitList(org.python.pydev.parser.jython.ast.List node) throws Exception {
        this.beforeNode(node);
        this.pushTupleNeedsParens();
        this.doc.addRequire("[", node);
        this.visitCommaSeparated(node.elts, false);
        this.doc.addRequire("]", this.lastNode);
        this.popTupleNeedsParens();
        this.afterNode(node);
        return null;
    }

    public Object visitListComp(ListComp node) throws Exception {
        this.beforeNode(node);
        switch (node.ctx) {
            case 1: {
                this.doc.addRequire("[", node);
                break;
            }
            case 2: {
                this.doc.addRequire("(", node);
            }
        }
        int id = this.doc.pushRecordChanges();
        this.pushTupleNeedsParens();
        node.elt.accept(this);
        this.popTupleNeedsParens();
        comprehensionType[] comprehensionTypeArray = node.generators;
        int n = node.generators.length;
        int n2 = 0;
        while (n2 < n) {
            comprehensionType c = comprehensionTypeArray[n2];
            this.doc.addRequire(" for ", this.lastNode);
            c.accept(this);
            ++n2;
        }
        List<ILinePart> recordedChanges = this.doc.popRecordChanges(id);
        this.doc.replaceRecorded(recordedChanges, "for", " for ", "if", " if ");
        switch (node.ctx) {
            case 1: {
                this.doc.addRequire("]", this.lastNode);
                break;
            }
            case 2: {
                this.doc.addRequire(")", this.lastNode);
            }
        }
        this.afterNode(node);
        return null;
    }

    public Object visitSetComp(SetComp node) throws Exception {
        this.beforeNode(node);
        this.doc.addRequire("{", node);
        int id = this.doc.pushRecordChanges();
        node.elt.accept(this);
        this.doc.addRequire(" for ", this.lastNode);
        comprehensionType[] comprehensionTypeArray = node.generators;
        int n = node.generators.length;
        int n2 = 0;
        while (n2 < n) {
            comprehensionType c = comprehensionTypeArray[n2];
            c.accept(this);
            ++n2;
        }
        this.doc.addRequire("}", this.lastNode);
        this.doc.replaceRecorded(this.doc.popRecordChanges(id), "for", " for ", "if", " if ");
        this.afterNode(node);
        return null;
    }

    public Object visitDictComp(DictComp node) throws Exception {
        this.beforeNode(node);
        int id = this.doc.pushRecordChanges();
        this.doc.addRequire("{", node);
        node.key.accept(this);
        this.doc.addRequire(":", this.lastNode);
        node.value.accept(this);
        this.doc.addRequire(" for ", this.lastNode);
        comprehensionType[] comprehensionTypeArray = node.generators;
        int n = node.generators.length;
        int n2 = 0;
        while (n2 < n) {
            comprehensionType c = comprehensionTypeArray[n2];
            c.accept(this);
            ++n2;
        }
        this.doc.replaceRecorded(this.doc.popRecordChanges(id), "for", " for ", "if", " if ");
        this.doc.addRequire("}", this.lastNode);
        this.afterNode(node);
        return null;
    }

    public Object visitSet(Set node) throws Exception {
        this.beforeNode(node);
        this.doc.addRequire("{", node.elts[0]);
        this.visitCommaSeparated(node.elts, false);
        this.doc.addRequire("}", this.lastNode);
        this.afterNode(node);
        return null;
    }

    private SimpleNode[] reverseNodeArray(SimpleNode[] expressions) {
        ArrayList<SimpleNode> ifs = new ArrayList<SimpleNode>(Arrays.asList(expressions));
        Collections.reverse(ifs);
        SimpleNode[] ifsInOrder = ifs.toArray(new SimpleNode[0]);
        return ifsInOrder;
    }

    public Object visitComprehension(Comprehension node) throws Exception {
        this.beforeNode(node);
        node.target.accept(this);
        this.doc.addRequire("in", this.lastNode);
        this.pushTupleNeedsParens();
        node.iter.accept(this);
        this.popTupleNeedsParens();
        SimpleNode[] simpleNodeArray = this.reverseNodeArray(node.ifs);
        int n = simpleNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleNode s = simpleNodeArray[n2];
            this.doc.addRequire(" if ", this.lastNode);
            s.accept(this);
            ++n2;
        }
        this.afterNode(node);
        return null;
    }

    public Object visitWhile(While node) throws Exception {
        this.startStatementPart();
        this.beforeNode(node);
        this.doc.addRequire("while", node);
        node.test.accept(this);
        this.doc.addRequire(":", this.lastNode);
        this.doc.addRequireIndent(":", this.lastNode);
        this.endStatementPart(node);
        stmtType[] stmtTypeArray = node.body;
        int n = node.body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType n3 = stmtTypeArray[n2];
            n3.accept(this);
            ++n2;
        }
        this.endSuiteWithOrElse(node.orelse);
        this.afterNode(node);
        return null;
    }

    public Object visitWith(With node) throws Exception {
        this.startStatementPart();
        this.beforeNode(node);
        this.doc.addRequire("with", node);
        if (node.with_item != null) {
            int i = 0;
            while (i < node.with_item.length) {
                if (i > 0) {
                    this.doc.addRequire(",", this.lastNode);
                }
                WithItem withItem = (WithItem)node.with_item[i];
                withItem.accept(this);
                ++i;
            }
        }
        this.doc.addRequire(":", this.lastNode);
        this.doc.addRequireIndent(":", this.lastNode);
        this.endStatementPart(node);
        if (node.body != null) {
            node.body.accept(this);
        }
        this.dedent();
        this.afterNode(node);
        return null;
    }

    public Object visitWithItem(WithItem node) throws Exception {
        this.beforeNode(node);
        node.context_expr.accept(this);
        exprType optional = node.optional_vars;
        if (optional != null && optional != null) {
            this.doc.addRequire("as", this.lastNode);
            optional.accept(this);
        }
        this.afterNode(node);
        return null;
    }

    public Object visitFor(For node) throws Exception {
        int id = this.doc.pushRecordChanges();
        this.startStatementPart();
        this.doc.addRequire("for ", node);
        this.beforeNode(node);
        node.target.accept(this);
        this.doc.replaceRecorded(this.doc.popRecordChanges(id), "for", "for ");
        this.doc.addRequire("in", this.lastNode);
        node.iter.accept(this);
        this.doc.addRequire(":", this.lastNode);
        this.doc.addRequireIndent(":", this.lastNode);
        this.endStatementPart(node);
        stmtType[] stmtTypeArray = node.body;
        int n = node.body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType n3 = stmtTypeArray[n2];
            n3.accept(this);
            ++n2;
        }
        suiteType orelse = node.orelse;
        this.endSuiteWithOrElse(orelse);
        this.afterNode(node);
        return null;
    }

    public void pushTupleNeedsParens() {
        ++this.tupleNeedsParens;
    }

    public void popTupleNeedsParens() {
        --this.tupleNeedsParens;
    }

    private void endSuiteWithOrElse(suiteType orelse) throws Exception {
        if (orelse == null) {
            this.dedent(this.prefs.getLinesAfterSuite());
        } else {
            this.dedent();
            this.visitOrElsePart(orelse, "else");
        }
    }

    public Object visitRepr(Repr node) throws Exception {
        int id = this.doc.pushRecordChanges();
        Object ret = super.visitRepr(node);
        List<ILinePart> changes = this.doc.popRecordChanges(id);
        org.python.pydev.core.Tuple<ILinePart, ILinePart> lowerAndHigerFound = this.doc.getLowerAndHigerFound(changes);
        this.doc.addBefore(((ILinePart)lowerAndHigerFound.o1).getLine(), ((ILinePart)lowerAndHigerFound.o1).getBeginCol(), "`", node);
        this.doc.add(((ILinePart)lowerAndHigerFound.o2).getLine(), ((ILinePart)lowerAndHigerFound.o2).getBeginCol(), "`", node);
        return ret;
    }

    public Object visitReturn(Return node) throws Exception {
        int id = this.doc.pushRecordChanges();
        this.beforeNode(node);
        String replaceToken = node.value != null ? "return " : "return";
        this.doc.addRequire(replaceToken, node);
        node.traverse(this);
        List<ILinePart> changes = this.doc.popRecordChanges(id);
        this.doc.replaceRecorded(changes, "return", replaceToken);
        this.afterNode(node);
        return null;
    }

    public Object visitDelete(Delete node) throws Exception {
        this.beforeNode(node);
        this.doc.addRequire("del", node);
        node.traverse(this);
        this.afterNode(node);
        return null;
    }

    public void visitTryPart(SimpleNode node, stmtType[] body) throws Exception {
        this.beforeNode(node);
        boolean indent = true;
        if (node instanceof TryFinally) {
            indent = false;
            if (node.specialsBefore != null && node.specialsBefore.size() > 0) {
                for (Object o : node.specialsBefore) {
                    if (!o.toString().equals("try")) continue;
                    indent = true;
                    break;
                }
            }
            if (!(indent || body != null && body.length == 1 && body[0] instanceof TryExcept)) {
                indent = true;
            }
        }
        if (indent) {
            this.doc.addRequire("try", node);
            this.doc.addRequire(":", node);
            this.doc.addRequireIndent(":", node);
        }
        stmtType[] stmtTypeArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType st = stmtTypeArray[n2];
            st.accept(this);
            ++n2;
        }
        if (indent) {
            this.dedent();
        }
        this.afterNode(node);
    }

    public void visitOrElsePart(suiteType orelse, String expectedToken) throws Exception {
        this.visitOrElsePart(orelse, expectedToken, this.prefs.getLinesAfterSuite());
    }

    public void visitOrElsePart(suiteType orelse, String expectedToken, int linesAfterSuite) throws Exception {
        if (orelse != null) {
            this.startStatementPart();
            this.beforeNode(orelse);
            this.doc.addRequire(expectedToken, orelse);
            this.doc.addRequire(":", orelse);
            this.doc.addRequireIndent(":", orelse);
            this.endStatementPart(orelse);
            stmtType[] stmtTypeArray = ((Suite)orelse).body;
            int n = ((Suite)orelse).body.length;
            int n2 = 0;
            while (n2 < n) {
                stmtType st = stmtTypeArray[n2];
                st.accept(this);
                ++n2;
            }
            this.dedent(linesAfterSuite);
            this.afterNode(orelse);
        }
    }

    public Object visitTryFinally(TryFinally node) throws Exception {
        this.visitTryPart(node, node.body);
        this.visitOrElsePart(node.finalbody, "finally");
        return null;
    }

    public Object visitTryExcept(TryExcept node) throws Exception {
        this.visitTryPart(node, node.body);
        excepthandlerType[] excepthandlerTypeArray = node.handlers;
        int n = node.handlers.length;
        int n2 = 0;
        while (n2 < n) {
            excepthandlerType h = excepthandlerTypeArray[n2];
            this.startStatementPart();
            this.beforeNode(h);
            this.doc.addRequire("except", this.lastNode);
            this.pushTupleNeedsParens();
            if (h.type != null || h.name != null) {
                this.doc.addRequire(" ", this.lastNode);
            }
            if (h.type != null) {
                h.type.accept(this);
            }
            if (h.name != null) {
                if (h.type != null) {
                    int grammarVersion = this.prefs.getGrammarVersion();
                    if (grammarVersion < 12) {
                        this.doc.addRequire(",", this.lastNode);
                    } else if (grammarVersion == 12 || grammarVersion == 13) {
                        this.doc.addRequireOneOf(this.lastNode, "as", ",");
                    } else {
                        this.doc.addRequire("as", this.lastNode);
                    }
                }
                h.name.accept(this);
            }
            this.afterNode(h);
            this.popTupleNeedsParens();
            this.doc.addRequire(":", this.lastNode);
            this.doc.addRequireIndent(":", this.lastNode);
            this.endStatementPart(this.lastNode);
            stmtType[] stmtTypeArray = h.body;
            int n3 = h.body.length;
            int n4 = 0;
            while (n4 < n3) {
                stmtType st = stmtTypeArray[n4];
                st.accept(this);
                ++n4;
            }
            this.dedent();
            ++n2;
        }
        this.visitOrElsePart(node.orelse, "else");
        return null;
    }

    public Object visitPrint(Print node) throws Exception {
        this.beforeNode(node);
        this.doc.add(node.beginLine, node.beginColumn, "print ", node);
        if (node.dest != null) {
            this.doc.add(node.beginLine, node.beginColumn, ">> ", node);
            node.dest.accept(this);
        }
        if (node.values != null) {
            int i = 0;
            while (i < node.values.length) {
                exprType value;
                if (i > 0 || node.dest != null) {
                    this.doc.addRequire(",", this.lastNode);
                }
                if ((value = node.values[i]) != null) {
                    value.accept(this);
                }
                ++i;
            }
        }
        this.afterNode(node);
        return null;
    }

    public Object visitYield(Yield node) throws Exception {
        int id = this.doc.pushRecordChanges();
        this.beforeNode(node);
        if (node.value != null) {
            this.doc.addRequire("yield ", node);
        } else {
            this.doc.addRequire("yield", node);
        }
        node.traverse(this);
        List<ILinePart> changes = this.doc.popRecordChanges(id);
        if (node.value != null) {
            this.doc.replaceRecorded(changes, "yield", "yield ");
        }
        this.afterNode(node);
        return null;
    }

    public Object visitAttribute(Attribute node) throws Exception {
        this.beforeNode(node);
        int id = this.doc.pushRecordChanges();
        node.value.accept(this);
        List<ILinePart> recordChanges = this.doc.popRecordChanges(id);
        org.python.pydev.core.Tuple<ILinePart, ILinePart> lowerAndHigerFound = this.doc.getLowerAndHigerFound(recordChanges);
        this.doc.add(((ILinePart)lowerAndHigerFound.o2).getLine(), ((ILinePart)lowerAndHigerFound.o2).getBeginCol(), ".", node.value);
        node.attr.accept(this);
        this.afterNode(node);
        return null;
    }

    public Object visitCall(Call node) throws Exception {
        this.beforeNode(node);
        node.func.accept(this);
        this.doc.addRequire("(", this.lastNode);
        this.pushTupleNeedsParens();
        this.handleArguments(node.args, node.keywords, node.starargs, node.kwargs);
        this.popTupleNeedsParens();
        this.doc.addRequire(")", this.lastNode);
        this.afterNode(node);
        return null;
    }

    public Object visitStarred(Starred node) throws Exception {
        this.unhandled_node(node);
        this.beforeNode(node);
        this.doc.addRequire("*", node);
        node.traverse(this);
        this.afterNode(node);
        return null;
    }

    public Object visitAssert(Assert node) throws Exception {
        this.unhandled_node(node);
        this.beforeNode(node);
        this.doc.addRequire("assert", node);
        if (node.test != null) {
            node.test.accept(this);
        }
        if (node.msg != null) {
            this.doc.addRequire(",", this.lastNode);
            this.pushTupleNeedsParens();
            node.msg.accept(this);
            this.popTupleNeedsParens();
        }
        this.afterNode(node);
        return null;
    }

    public Object visitStrJoin(StrJoin node) throws Exception {
        this.unhandled_node(node);
        this.beforeNode(node);
        exprType last = null;
        if (node.strs != null) {
            int i = 0;
            while (i < node.strs.length) {
                exprType str = node.strs[i];
                if (str != null) {
                    if (last != null && last.beginLine != str.beginLine) {
                        this.doc.addRequire("\\", last);
                    }
                    str.accept(this);
                    last = str;
                }
                ++i;
            }
        }
        this.afterNode(node);
        return null;
    }

    public Object visitGlobal(Global node) throws Exception {
        this.beforeNode(node);
        this.doc.addRequire("global", node);
        if (node.names != null) {
            int i = 0;
            while (i < node.names.length) {
                if (i > 0) {
                    this.doc.addRequire(",", this.lastNode);
                }
                if (node.names[i] != null) {
                    node.names[i].accept(this);
                }
                ++i;
            }
        }
        if (node.value != null) {
            this.doc.addRequire("=", this.lastNode);
            node.value.accept(this);
        }
        this.afterNode(node);
        return null;
    }

    public Object visitExec(Exec node) throws Exception {
        int id = this.doc.pushRecordChanges();
        this.beforeNode(node);
        this.doc.addRequire("exec ", node);
        if (node.body != null) {
            node.body.accept(this);
        }
        if (node.globals != null || node.locals != null) {
            this.doc.addRequire("in", this.lastNode);
        }
        if (node.globals != null) {
            node.globals.accept(this);
        }
        if (node.locals != null) {
            if (node.globals != null) {
                this.doc.addRequire(",", this.lastNode);
            }
            node.locals.accept(this);
        }
        this.doc.replaceRecorded(this.doc.popRecordChanges(id), "exec", "exec ");
        this.afterNode(node);
        return null;
    }

    public Object visitClassDef(ClassDef node) throws Exception {
        org.python.pydev.core.Tuple<ILinePart, ILinePart> found;
        if (node.decs != null) {
            decoratorsType[] decoratorsTypeArray = node.decs;
            int n = node.decs.length;
            int n2 = 0;
            while (n2 < n) {
                decoratorsType n3 = decoratorsTypeArray[n2];
                if (n3 != null) {
                    this.handleDecorator(n3);
                }
                ++n2;
            }
        }
        this.beforeNode(node);
        this.doc.add(node.name.beginLine, node.beginColumn, "class", node);
        node.name.accept(this);
        int id = this.doc.pushRecordChanges();
        this.pushTupleNeedsParens();
        this.handleArguments(node.bases, node.keywords, node.starargs, node.kwargs);
        this.popTupleNeedsParens();
        List<ILinePart> changes = this.doc.popRecordChanges(id);
        if (changes.size() > 0 && (found = this.doc.getLowerAndHigerFound(changes, true)) != null) {
            this.doc.addRequireBefore("(", (ILinePart)found.o1);
            this.doc.addRequire(")", this.lastNode);
        }
        this.doc.addRequire(":", this.lastNode);
        this.doc.addRequireIndent(":", this.lastNode);
        stmtType[] stmtTypeArray = node.body;
        int n = node.body.length;
        int n4 = 0;
        while (n4 < n) {
            stmtType n5 = stmtTypeArray[n4];
            n5.accept(this);
            ++n4;
        }
        this.dedent(this.prefs.getLinesAfterClass());
        this.afterNode(node);
        return null;
    }

    public boolean isFilled(SimpleNode[] nodes) {
        return nodes != null && nodes.length > 0;
    }

    private void handleDecorator(decoratorsType node) throws Exception {
        this.beforeNode(node);
        this.doc.addRequire("@", node);
        if (node.func != null) {
            node.func.accept(this);
        }
        this.pushTupleNeedsParens();
        if (node.args != null && node.args.length > 0 || node.keywords != null && node.keywords.length > 0 || node.starargs != null || node.kwargs != null) {
            this.doc.addRequire("(", this.lastNode);
            this.handleArguments(this.reverseNodeArray(node.args), this.reverseNodeArray(node.keywords), node.starargs, node.kwargs);
            this.doc.addRequire(")", this.lastNode);
        }
        this.popTupleNeedsParens();
        this.afterNode(node);
    }

    protected void handleArguments(argumentsType completeArgs) throws Exception {
        exprType[] args = completeArgs.args;
        exprType[] d = completeArgs.defaults;
        exprType[] anns = completeArgs.annotation;
        int argsLen = args == null ? 0 : args.length;
        int defaultsLen = d == null ? 0 : d.length;
        int diff = argsLen - defaultsLen;
        this.beforeNodeWithoutSettintgLastNode(completeArgs);
        boolean foundBefore = false;
        int i = 0;
        while (i < argsLen) {
            exprType defaulArgValue;
            exprType ann;
            foundBefore = true;
            if (i > 0) {
                this.doc.addRequire(",", this.lastNode);
            }
            exprType argName = args[i];
            argName.accept(this);
            if (anns != null && (ann = anns[i]) != null) {
                this.doc.addRequire(":", this.lastNode);
                ann.accept(this);
            }
            if (i >= diff && (defaulArgValue = d[i - diff]) != null) {
                this.doc.addRequire("=", this.lastNode);
                defaulArgValue.accept(this);
            }
            ++i;
        }
        if (completeArgs.vararg != null) {
            if (this.lastNode == null) {
                this.lastNode = completeArgs.vararg;
            }
            if (foundBefore) {
                this.doc.addRequire(",", this.lastNode);
            }
            this.doc.addRequire("*", this.lastNode);
            foundBefore = true;
            completeArgs.vararg.accept(this);
            if (completeArgs.varargannotation != null) {
                this.doc.addRequire(":", this.lastNode);
                completeArgs.varargannotation.accept(this);
            }
        } else if (completeArgs.kwonlyargs != null && completeArgs.kwonlyargs.length > 0 && completeArgs.kwonlyargs[0] != null) {
            if (foundBefore) {
                this.doc.addRequire(",", this.lastNode);
            }
            this.doc.addRequire("*", completeArgs.kwonlyargs[0]);
            this.doc.addRequire(",", completeArgs.kwonlyargs[0]);
            foundBefore = false;
        }
        if (completeArgs.kwonlyargs != null) {
            i = 0;
            while (i < completeArgs.kwonlyargs.length) {
                if (foundBefore) {
                    this.doc.addRequire(",", this.lastNode);
                }
                foundBefore = true;
                exprType kwonlyarg = completeArgs.kwonlyargs[i];
                if (kwonlyarg != null) {
                    kwonlyarg.accept(this);
                    if (completeArgs.kwonlyargannotation != null && completeArgs.kwonlyargannotation[i] != null) {
                        this.doc.addRequire(":", this.lastNode);
                        completeArgs.kwonlyargannotation[i].accept(this);
                    }
                    if (completeArgs.kw_defaults != null && completeArgs.kw_defaults[i] != null) {
                        this.doc.addRequire("=", this.lastNode);
                        completeArgs.kw_defaults[i].accept(this);
                    }
                }
                ++i;
            }
        }
        if (completeArgs.kwarg != null) {
            if (this.lastNode == null) {
                this.lastNode = completeArgs.kwarg;
            }
            if (foundBefore) {
                this.doc.addRequire(",", this.lastNode);
            }
            this.doc.addRequire("**", this.lastNode);
            completeArgs.kwarg.accept(this);
            if (completeArgs.kwargannotation != null) {
                this.doc.addRequire(":", this.lastNode);
                completeArgs.kwargannotation.accept(this);
            }
        }
        this.afterNode(completeArgs);
    }

    public Object visitFunctionDef(FunctionDef node) throws Exception {
        if (node.decs != null) {
            decoratorsType[] decoratorsTypeArray = node.decs;
            int n = node.decs.length;
            int n2 = 0;
            while (n2 < n) {
                decoratorsType n3 = decoratorsTypeArray[n2];
                if (n3 != null) {
                    this.handleDecorator(n3);
                }
                ++n2;
            }
        }
        this.beforeNode(node);
        this.doc.add(node.name.beginLine, node.beginColumn, "def", node);
        node.name.accept(this);
        this.doc.addRequire("(", this.lastNode);
        if (node.args != null) {
            this.pushTupleNeedsParens();
            this.handleArguments(node.args);
            this.popTupleNeedsParens();
        }
        this.doc.addRequire(")", this.lastNode);
        if (node.returns != null) {
            this.doc.addRequire("->", this.lastNode);
            node.returns.accept(this);
        }
        this.doc.addRequire(":", this.lastNode);
        this.doc.addRequireIndent(":", this.lastNode);
        if (node.body != null) {
            int length = node.body.length;
            int i = 0;
            while (i < length) {
                if (node.body[i] != null) {
                    node.body[i].accept(this);
                }
                ++i;
            }
        }
        this.dedent(this.prefs.getLinesAfterMethod());
        this.afterNode(node);
        return null;
    }

    public Object visitPass(Pass node) throws Exception {
        return this.handleSimpleNode(node, "pass");
    }

    public Object visitBreak(Break node) throws Exception {
        return this.handleSimpleNode(node, "break");
    }

    public Object visitContinue(Continue node) throws Exception {
        return this.handleSimpleNode(node, "continue");
    }

    private Object handleSimpleNode(SimpleNode node, String checkTokenAdded) throws Exception {
        this.beforeNode(node);
        node.traverse(this);
        this.doc.addRequire(checkTokenAdded, this.lastNode);
        this.afterNode(node);
        return null;
    }

    public Object visitIfExp(IfExp node) throws Exception {
        int id = this.doc.pushRecordChanges();
        this.beforeNode(node);
        node.body.accept(this);
        int id2 = 0;
        if (node.orelse != null) {
            id2 = this.doc.pushRecordChanges();
        }
        SimpleNode lastBeforeIf = this.lastNode;
        this.doc.addRequire(" if ", lastBeforeIf);
        node.test.accept(this);
        List<ILinePart> recordedChanges = this.doc.popRecordChanges(id);
        this.doc.replaceRecorded(recordedChanges, "if", " if ");
        if (node.orelse != null) {
            this.doc.addRequire(" else ", this.lastNode);
            recordedChanges = this.doc.popRecordChanges(id2);
            this.doc.replaceRecorded(recordedChanges, "else", " else ");
            node.orelse.accept(this);
        }
        this.afterNode(node);
        return null;
    }

    public Object visitName(Name node) throws Exception {
        this.beforeNode(node);
        this.doc.add(node.beginLine, node.beginColumn, node.id, node);
        this.afterNode(node);
        return null;
    }

    public Object visitNameTok(NameTok node) throws Exception {
        this.beforeNode(node);
        this.doc.add(node.beginLine, node.beginColumn, node.id, node);
        this.afterNode(node);
        return null;
    }

    public Object visitNum(Num node) throws Exception {
        this.beforeNode(node);
        this.doc.add(node.beginLine, node.beginColumn, node.num, node);
        this.afterNode(node);
        return null;
    }

    public Object visitSubscript(Subscript node) throws Exception {
        this.beforeNode(node);
        if (node.value != null) {
            node.value.accept(this);
        }
        this.doc.addRequire("[", this.lastNode);
        if (node.slice != null) {
            node.slice.accept(this);
        }
        this.doc.addRequire("]", this.lastNode);
        this.afterNode(node);
        return null;
    }

    public Object visitSlice(Slice node) throws Exception {
        this.beforeNode(node);
        if (node.lower != null) {
            node.lower.accept(this);
            this.doc.addRequire(":", this.lastNode);
        }
        if (node.upper != null) {
            if (node.lower == null) {
                this.doc.addRequire(":", this.lastNode);
            }
            node.upper.accept(this);
        }
        if (node.step != null) {
            this.doc.addRequire(":", this.lastNode);
            node.step.accept(this);
        }
        if (node.lower == null && node.upper == null && node.step == null) {
            this.doc.addRequire(":", this.lastNode);
        }
        this.afterNode(node);
        return null;
    }

    public Object visitStr(Str node) throws Exception {
        this.unhandled_node(node);
        this.beforeNode(node);
        this.doc.add(node.beginLine, node.beginColumn, NodeUtils.getStringToPrint(node), node);
        this.afterNode(node);
        return null;
    }

    public Object visitImport(Import node) throws Exception {
        int id = this.doc.pushRecordChanges();
        this.beforeNode(node);
        this.doc.addRequire("import ", node);
        int i = 0;
        while (i < node.names.length) {
            if (i > 0) {
                this.doc.addRequire(",", this.lastNode);
            }
            aliasType alias = node.names[i];
            this.handleAlias(alias);
            ++i;
        }
        this.afterNode(node);
        this.doc.replaceRecorded(this.doc.popRecordChanges(id), "import", "import ");
        return null;
    }

    public Object visitImportFrom(ImportFrom node) throws Exception {
        int id = this.doc.pushRecordChanges();
        boolean emptyModule = node.module == null || ((NameTok)node.module).id == null || ((NameTok)node.module).id.equals("");
        SimpleNode bindFromTo = emptyModule ? node.module : node;
        this.beforeNode(node);
        LinePartRequireMark mark = this.doc.addRequire("from ", bindFromTo);
        if (node.level > 0) {
            String s = new FastStringBuffer(node.level).appendN('.', node.level).toString();
            this.doc.addRequireAfter(s, mark);
        }
        if (!emptyModule) {
            node.module.accept(this);
        } else {
            this.beforeNode(node.module);
            this.afterNode(node.module);
        }
        this.doc.addRequire(" import ", this.lastNode);
        if (node.names.length == 0) {
            this.doc.addRequire("*", this.lastNode);
        } else {
            int i = 0;
            while (i < node.names.length) {
                aliasType alias = node.names[i];
                if (i > 0) {
                    this.doc.addRequire(",", this.lastNode);
                }
                this.handleAlias(alias);
                ++i;
            }
        }
        this.afterNode(node);
        List<ILinePart> recordChanges = this.doc.popRecordChanges(id);
        this.doc.replaceRecorded(recordChanges, "import", " import ", "from", "from ");
        return null;
    }

    private void handleAlias(aliasType alias) throws Exception {
        this.beforeNode(alias);
        if (alias.name != null) {
            alias.name.accept(this);
        }
        if (alias.asname != null) {
            this.doc.addRequire("as", this.lastNode);
            alias.asname.accept(this);
        }
        this.afterNode(alias);
    }

    public Object visitRaise(Raise node) throws Exception {
        int id = this.doc.pushRecordChanges();
        this.beforeNode(node);
        this.pushTupleNeedsParens();
        if (node.type != null) {
            this.doc.addRequire("raise ", node);
        } else {
            this.doc.addRequire("raise", node);
        }
        if (node.type != null) {
            node.type.accept(this);
        }
        if (node.inst != null) {
            this.doc.addRequire(",", this.lastNode);
            node.inst.accept(this);
        }
        if (node.tback != null) {
            this.doc.addRequire(",", this.lastNode);
            node.tback.accept(this);
        }
        if (node.cause != null) {
            this.doc.addRequire(" from ", this.lastNode);
            node.cause.accept(this);
        }
        List<ILinePart> recordChanges = this.doc.popRecordChanges(id);
        if (node.type != null) {
            this.doc.replaceRecorded(recordChanges, "raise", "raise ", "from", " from ");
        }
        this.popTupleNeedsParens();
        this.afterNode(node);
        return null;
    }

    public Object visitLambda(Lambda node) throws Exception {
        this.beforeNode(node);
        argumentsType arguments = node.args;
        String str = arguments == null || arguments.args == null || arguments.args.length == 0 ? "lambda" : "lambda ";
        this.doc.add(node.beginLine, node.beginColumn, str, node);
        this.handleArguments(node.args);
        this.doc.addRequire(":", this.lastNode);
        if (node.body != null) {
            node.body.accept(this);
        }
        this.afterNode(node);
        return null;
    }

    private void handleArguments(SimpleNode[] args, SimpleNode[] keywords, exprType starargs, exprType kwargs) throws Exception, IOException {
        boolean foundBefore = false;
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (foundBefore) {
                    this.doc.addRequire(",", this.lastNode);
                }
                if (args[i] != null) {
                    args[i].accept(this);
                    foundBefore = true;
                }
                ++i;
            }
        }
        ArrayList<keywordType> keywordsLater = new ArrayList<keywordType>();
        if (keywords != null) {
            int i = 0;
            while (i < keywords.length) {
                keywordType keyword = (keywordType)keywords[i];
                if (keyword != null) {
                    if (keyword.afterstarargs) {
                        keywordsLater.add(keyword);
                    } else {
                        if (foundBefore) {
                            this.doc.addRequire(",", this.lastNode);
                        }
                        foundBefore = true;
                        this.handleKeyword(keyword);
                    }
                }
                ++i;
            }
        }
        if (starargs != null) {
            if (foundBefore) {
                this.doc.addRequire(",", this.lastNode);
            }
            this.doc.addRequire("*", this.lastNode);
            starargs.accept(this);
            foundBefore = true;
        }
        for (keywordType keyword : keywordsLater) {
            if (foundBefore) {
                this.doc.addRequire(",", this.lastNode);
            }
            foundBefore = true;
            this.handleKeyword(keyword);
        }
        if (kwargs != null) {
            if (foundBefore) {
                this.doc.addRequire(",", this.lastNode);
            }
            this.doc.addRequire("**", this.lastNode);
            kwargs.accept(this);
        }
    }

    private void handleKeyword(keywordType keyword) throws Exception, IOException {
        this.beforeNode(keyword);
        if (keyword.arg != null) {
            keyword.arg.accept(this);
        }
        this.doc.addRequire("=", this.lastNode);
        if (keyword.value != null) {
            keyword.value.accept(this);
        }
        this.afterNode(keyword);
    }

    public Object visitIf(If node) throws Exception {
        this.visitIfPart(null, node, false);
        return null;
    }

    private void visitIfPart(suiteType orelse, If node, boolean isElif) throws Exception {
        this.startStatementPart();
        if (orelse != null) {
            this.beforeNode(orelse);
        }
        this.beforeNode(node);
        if (isElif) {
            this.doc.addRequire("elif", node);
        } else {
            this.doc.addRequire("if", node);
        }
        this.pushTupleNeedsParens();
        node.test.accept(this);
        this.popTupleNeedsParens();
        this.endStatementPart(node);
        this.doc.addRequire(":", this.lastNode);
        this.doc.addRequireIndent(":", this.lastNode);
        stmtType[] stmtTypeArray = node.body;
        int n = node.body.length;
        int n2 = 0;
        while (n2 < n) {
            stmtType n3 = stmtTypeArray[n2];
            n3.accept(this);
            ++n2;
        }
        this.dedent();
        this.afterNode(node);
        if (orelse != null) {
            this.afterNode(orelse);
        }
        if (node.orelse != null && node.orelse.body != null && node.orelse.body.length > 0) {
            if (node.orelse.body.length == 1 && node.orelse.body[0] instanceof If) {
                If if1 = (If)node.orelse.body[0];
                if (if1.test == null) {
                    this.visitOrElsePart(node.orelse, "else", 0);
                } else {
                    boolean foundIf = false;
                    if (if1.specialsBefore != null) {
                        for (Object o : if1.specialsBefore) {
                            if (!o.toString().equals("if")) continue;
                            foundIf = true;
                            break;
                        }
                    }
                    if (foundIf) {
                        this.doc.addRequire("else", if1);
                        this.doc.addRequire(":", if1);
                        this.indent(if1, true);
                        this.visitIfPart(node.orelse, if1, false);
                        this.dedent();
                    } else {
                        this.visitIfPart(node.orelse, if1, true);
                    }
                }
            } else {
                this.visitOrElsePart(node.orelse, "else", 0);
            }
        }
    }

    public String toString() {
        return "PrettyPrinterVisitorV2{\n" + this.doc + "\n}";
    }

    protected SimpleNode visitNode(SimpleNode node) throws Exception {
        if (node == null) {
            return null;
        }
        if (node instanceof decoratorsType) {
            this.handleDecorator((decoratorsType)node);
        } else if (node instanceof keywordType) {
            this.handleKeyword((keywordType)node);
        } else if (node instanceof argumentsType) {
            this.handleArguments((argumentsType)node);
        } else if (node instanceof aliasType) {
            this.handleAlias((aliasType)node);
        } else {
            node.accept(this);
        }
        return null;
    }
}

