/*
 * Decompiled with CFR 0.152.
 */
package name.pachler.nio.file.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import name.pachler.nio.file.ClosedWatchServiceException;
import name.pachler.nio.file.Path;
import name.pachler.nio.file.WatchEvent;
import name.pachler.nio.file.WatchKey;
import name.pachler.nio.file.ext.Bootstrapper;
import name.pachler.nio.file.ext.ExtendedWatchEventKind;
import name.pachler.nio.file.impl.PathImpl;
import name.pachler.nio.file.impl.PathWatchKey;
import name.pachler.nio.file.impl.PathWatchService;
import name.pachler.nio.file.impl.PollingPathWatchKey;
import name.pachler.nio.file.impl.VoidWatchEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PollingPathWatchService
extends PathWatchService {
    private Map<Path, PollingPathWatchKey> keys = new HashMap<Path, PollingPathWatchKey>();
    private Set<PathWatchKey> signalledKeys = new HashSet<PathWatchKey>();
    private Queue<PathWatchKey> pendingKeys = new LinkedList<PathWatchKey>();
    private final Object internalLock = new Object();
    private boolean closed = false;
    private long pollInterval = Bootstrapper.getDefaultPollingInterval();

    @Override
    public synchronized PathWatchKey register(Path path, WatchEvent.Kind<?>[] kinds, WatchEvent.Modifier[] modifiers) throws IOException {
        int supportedFlags;
        PathImpl pathImpl = this.checkAndCastToPathImpl(path);
        int flags = this.makeFlagMask(kinds, modifiers);
        if ((flags & ~(supportedFlags = 120)) != 0) {
            throw new UnsupportedOperationException("The given watch event kind or modifier is not supported by this WatchService");
        }
        PollingPathWatchKey key = this.keys.get(pathImpl);
        if (key == null) {
            key = new PollingPathWatchKey(this, path, flags);
            this.keys.put(path, key);
        } else {
            key.setFlags(flags);
        }
        key.poll();
        return key;
    }

    @Override
    synchronized void cancel(PathWatchKey pathWatchKey) {
        PathWatchKey key = this.keys.get(pathWatchKey.getPath());
        if (key != pathWatchKey) {
            return;
        }
        boolean eventAdded = this.cancelImpl(pathWatchKey);
        if (eventAdded) {
            this.queueKey(pathWatchKey);
        }
    }

    private boolean cancelImpl(PathWatchKey key) {
        this.keys.remove(key.getPath());
        key.invalidate();
        boolean eventAdded = false;
        if ((key.getFlags() & 0x40) != 0) {
            key.addWatchEvent(new VoidWatchEvent(ExtendedWatchEventKind.KEY_INVALID));
            eventAdded = true;
        }
        return eventAdded;
    }

    @Override
    public synchronized boolean reset(PathWatchKey pathWatchKey) {
        if (!pathWatchKey.isValid() || this.keys.get(pathWatchKey.getPath()) != pathWatchKey) {
            return false;
        }
        if (pathWatchKey.hasPendingWatchEvents()) {
            this.pendingKeys.add(pathWatchKey);
        } else {
            this.signalledKeys.remove(pathWatchKey);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        Object object = this.internalLock;
        synchronized (object) {
            this.closed = true;
            this.internalLock.notifyAll();
        }
    }

    @Override
    public synchronized WatchKey poll() throws InterruptedException, ClosedWatchServiceException {
        if (this.closed) {
            throw new ClosedWatchServiceException();
        }
        if (this.pendingKeys.size() > 0) {
            return this.pendingKeys.remove();
        }
        for (PollingPathWatchKey k : this.keys.values()) {
            try {
                k.poll();
            }
            catch (FileNotFoundException ex) {
                this.cancelImpl(k);
            }
            if (!k.hasPendingWatchEvents() || this.signalledKeys.contains(k.getPath())) continue;
            this.signalledKeys.add(k);
            this.pendingKeys.add(k);
        }
        return this.pendingKeys.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException, ClosedWatchServiceException {
        long startTime = System.currentTimeMillis();
        WatchKey key = this.poll();
        if (key != null) {
            return key;
        }
        Object object = this.internalLock;
        synchronized (object) {
            long pollDuration = System.currentTimeMillis() - startTime;
            long timeoutMillis = unit.toMillis(timeout);
            long millis = timeoutMillis - pollDuration;
            if (millis <= 0L) {
                return null;
            }
            this.internalLock.wait(millis);
        }
        return this.poll();
    }

    @Override
    public WatchKey take() throws InterruptedException, ClosedWatchServiceException {
        WatchKey key;
        while ((key = this.poll(this.pollInterval, TimeUnit.MILLISECONDS)) == null) {
        }
        return key;
    }

    private void queueKey(PathWatchKey key) {
        if (key.hasPendingWatchEvents() && !this.signalledKeys.contains(key)) {
            this.signalledKeys.add(key);
            this.pendingKeys.add(key);
        }
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(long pollInterval) {
        this.pollInterval = pollInterval;
    }
}

