/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.tree;

import diva.gui.toolbox.JContextMenu;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.TreePath;
import ptolemy.kernel.util.NamedObj;
import ptolemy.vergil.toolbox.MenuItemFactory;
import ptolemy.vergil.tree.PTree;

public class PTreeMenuCreator
extends MouseAdapter {
    private List _factoryList = new LinkedList();

    public void addMenuItemFactory(MenuItemFactory factory) {
        this._factoryList.add(factory);
    }

    public void mousePressed(MouseEvent e) {
        this._doEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this._doEvent(e);
    }

    public List menuItemFactoryList() {
        return Collections.unmodifiableList(this._factoryList);
    }

    public void removeMenuItemFactory(MenuItemFactory factory) {
        this._factoryList.remove(factory);
    }

    private void _doEvent(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        PTree tree = (PTree)e.getComponent();
        TreePath treePath = tree.getPathForLocation(e.getX(), e.getY());
        Object object = treePath.getLastPathComponent();
        if (object instanceof NamedObj) {
            NamedObj namedObj = (NamedObj)object;
            JContextMenu menu = new JContextMenu((Object)namedObj, namedObj.getFullName());
            for (MenuItemFactory factory : this.menuItemFactoryList()) {
                factory.create(menu, namedObj);
            }
            menu.show((Component)tree, e.getX(), e.getY());
            e.consume();
        }
    }
}

