/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.tree;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import ptolemy.kernel.util.NamedObj;
import ptolemy.moml.EntityLibrary;
import ptolemy.vergil.toolbox.PtolemyTransferable;
import ptolemy.vergil.tree.PtolemyTreeCellRenderer;

public class PTree
extends JTree {
    public PTree(TreeModel model) {
        super(model);
        this.setCellRenderer(new PtolemyTreeCellRenderer());
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 3, new PTreeDragGestureListener());
    }

    private static class PTreeDragGestureListener
    implements DragGestureListener {
        private PTreeDragGestureListener() {
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            DragSourceListener dsl = new DragSourceListener(){

                public void dragDropEnd(DragSourceDropEvent dsde) {
                }

                public void dragEnter(DragSourceDragEvent dsde) {
                    DragSourceContext context = dsde.getDragSourceContext();
                    int myaction = dsde.getDropAction();
                    if ((myaction & 3) != 0) {
                        context.setCursor(DragSource.DefaultCopyDrop);
                    } else {
                        context.setCursor(DragSource.DefaultCopyNoDrop);
                    }
                }

                public void dragExit(DragSourceEvent dse) {
                }

                public void dragOver(DragSourceDragEvent dsde) {
                }

                public void dropActionChanged(DragSourceDragEvent dsde) {
                }
            };
            Component source = e.getComponent();
            if (source instanceof JTree) {
                JTree tree = (JTree)source;
                Point sourcePoint = e.getDragOrigin();
                TreePath path = tree.getPathForLocation(sourcePoint.x, sourcePoint.y);
                if (path == null) {
                    return;
                }
                if (path.getLastPathComponent() instanceof EntityLibrary) {
                    return;
                }
                Object object = path.getLastPathComponent();
                if (object == null) {
                    return;
                }
                if (object instanceof NamedObj) {
                    PtolemyTransferable transferable = new PtolemyTransferable();
                    transferable.addObject((NamedObj)object);
                    e.startDrag(DragSource.DefaultCopyNoDrop, transferable, dsl);
                }
            }
        }
    }
}

