/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.tree;

import java.util.Collections;
import java.util.List;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.Entity;
import ptolemy.kernel.util.NamedObj;
import ptolemy.vergil.tree.ClassAndEntityTreeModel;

public class FullTreeModel
extends ClassAndEntityTreeModel {
    public FullTreeModel(CompositeEntity root) {
        super((NamedObj)root);
    }

    public Object getChild(Object parent, int index) {
        List relations;
        int numRelations;
        List ports;
        int numPorts;
        List attributes = this._attributes(parent);
        int numAttributes = attributes.size();
        if (index >= numAttributes + (numPorts = (ports = this._ports(parent)).size()) + (numRelations = (relations = this._relations(parent)).size())) {
            return super.getChild(parent, index - numAttributes - numPorts - numRelations);
        }
        if (index >= numAttributes + numPorts) {
            return relations.get(index - numAttributes - numPorts);
        }
        if (index >= numAttributes) {
            return ports.get(index - numAttributes);
        }
        if (index >= 0) {
            return attributes.get(index);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        List attributes = this._attributes(parent);
        int numAttributes = attributes.size();
        List ports = this._ports(parent);
        int numPorts = ports.size();
        List relations = this._relations(parent);
        int numRelations = relations.size();
        return numAttributes + numPorts + numRelations + super.getChildCount(parent);
    }

    public int getIndexOfChild(Object parent, Object child) {
        List attributes = this._attributes(parent);
        int index = attributes.indexOf(child);
        if (index >= 0) {
            return index;
        }
        List ports = this._ports(parent);
        index = ports.indexOf(child);
        int numAttributes = attributes.size();
        if (index >= 0) {
            return index + numAttributes;
        }
        List relations = this._relations(parent);
        index = relations.indexOf(child);
        int numPorts = ports.size();
        if (index >= 0) {
            return index + numAttributes + numPorts;
        }
        index = super.getIndexOfChild(parent, child);
        if (index >= 0) {
            int numRelations = relations.size();
            return index + numAttributes + numPorts + numRelations;
        }
        return -1;
    }

    public boolean isLeaf(Object object) {
        if (this._attributes(object).size() > 0) {
            return false;
        }
        if (this._ports(object).size() > 0) {
            return false;
        }
        if (this._relations(object).size() > 0) {
            return false;
        }
        return super.isLeaf(object);
    }

    protected List _attributes(Object object) {
        if (!(object instanceof NamedObj)) {
            return Collections.EMPTY_LIST;
        }
        return ((NamedObj)object).attributeList();
    }

    protected List _ports(Object object) {
        if (!(object instanceof Entity)) {
            return Collections.EMPTY_LIST;
        }
        return ((Entity)object).portList();
    }

    protected List _relations(Object object) {
        if (!(object instanceof CompositeEntity)) {
            return Collections.EMPTY_LIST;
        }
        return ((CompositeEntity)object).relationList();
    }
}

