/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.tree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import ptolemy.kernel.CompositeEntity;
import ptolemy.kernel.util.ChangeListener;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.NamedObj;

public class EntityTreeModel
implements TreeModel {
    protected NamedObj _root = null;
    private List _listenerList = new LinkedList();
    private ChangeListener _rootListener = new TreeUpdateListener();

    public EntityTreeModel(NamedObj root) {
        this.setRoot(root);
    }

    public void addTreeModelListener(TreeModelListener listener) {
        this._listenerList.add(listener);
    }

    public Object getChild(Object parent, int index) {
        if (index > this.getChildCount(parent)) {
            return null;
        }
        CompositeEntity entity = (CompositeEntity)parent;
        return entity.entityList().get(index);
    }

    public int getChildCount(Object parent) {
        if (!(parent instanceof CompositeEntity)) {
            return 0;
        }
        CompositeEntity entity = (CompositeEntity)parent;
        return entity.numberOfEntities();
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (!(parent instanceof CompositeEntity)) {
            return -1;
        }
        CompositeEntity entity = (CompositeEntity)parent;
        return entity.entityList().indexOf(child);
    }

    public Object getRoot() {
        return this._root;
    }

    public boolean isLeaf(Object object) {
        return !(object instanceof CompositeEntity);
    }

    public void setRoot(NamedObj root) {
        if (this._root != null) {
            this._root.removeChangeListener(this._rootListener);
        }
        this._root = root;
        if (this._root != null) {
            this._root.addChangeListener(this._rootListener);
        }
    }

    public void removeTreeModelListener(TreeModelListener listener) {
        this._listenerList.remove(listener);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        Iterator listeners = this._listenerList.iterator();
        TreeModelEvent event = new TreeModelEvent((Object)this, path);
        while (listeners.hasNext()) {
            TreeModelListener listener = (TreeModelListener)listeners.next();
            listener.treeStructureChanged(event);
        }
    }

    public class TreeUpdateListener
    implements ChangeListener {
        public void changeExecuted(final ChangeRequest change) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ArrayList<Object> path = new ArrayList<Object>();
                    Object root = EntityTreeModel.this.getRoot();
                    NamedObj locality = change.getLocality();
                    if (locality == null) {
                        path.add(0, root);
                    } else {
                        NamedObj container = locality;
                        while (container != root) {
                            if (container == null) {
                                path = new ArrayList();
                                path.add(0, root);
                                break;
                            }
                            path.add(0, container);
                            container = container.getContainer();
                        }
                    }
                    EntityTreeModel.this.valueForPathChanged(new TreePath(path.toArray()), locality);
                }
            });
        }

        public void changeFailed(ChangeRequest change, Exception exception) {
            this.changeExecuted(change);
        }
    }
}

