/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import ptolemy.actor.gui.EditorFactory;
import ptolemy.actor.gui.PtolemyQuery;
import ptolemy.gui.ComponentDialog;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.Settable;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.StringUtilities;

public class VisibleParameterEditorFactory
extends EditorFactory {
    String _oldExpression = "";

    public VisibleParameterEditorFactory(NamedObj container, String name) throws IllegalActionException, NameDuplicationException {
        super(container, name);
    }

    public void createEditor(final NamedObj object, Frame parent) {
        ComponentDialog dialog = new ComponentDialog(parent, "Edit Parameter " + object.getName(), this.createEditorPane());
        if (dialog.buttonPressed().equals("Cancel")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NamedObj parent = object.getContainer();
                    String moml = "<property name=\"" + object.getName() + "\" value=\"" + StringUtilities.escapeForXML((String)VisibleParameterEditorFactory.this._oldExpression) + "\"/>";
                    MoMLChangeRequest request = new MoMLChangeRequest((Object)this, parent, moml, null);
                    object.requestChange((ChangeRequest)request);
                }
            });
        }
    }

    public Component createEditorPane() {
        NamedObj object = this.getContainer();
        PtolemyQuery query = new PtolemyQuery(object);
        query.setTextWidth(25);
        if (object instanceof Settable) {
            Settable parameter = (Settable)object;
            this._oldExpression = parameter.getExpression();
            query.addStyledEntry(parameter);
            return query;
        }
        return new JLabel(String.valueOf(object.getName()) + " is not a settable attribute!");
    }
}

