/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import javax.swing.JOptionPane;
import ptolemy.actor.gui.TextEditor;
import ptolemy.kernel.util.ChangeRequest;
import ptolemy.kernel.util.NamedObj;
import ptolemy.kernel.util.StringAttribute;
import ptolemy.moml.MoMLChangeRequest;
import ptolemy.util.StringUtilities;
import ptolemy.vergil.toolbox.TextEditorFactory;

public class TextEditorForStringAttributes
extends TextEditor {
    private final TextEditorFactory _factory;
    private StringAttribute _attributeToEdit;

    public TextEditorForStringAttributes(TextEditorFactory factory, StringAttribute attributeToEdit, int rows, int columns, String title) {
        super(title);
        this._factory = factory;
        this._attributeToEdit = attributeToEdit;
        this.text.append(this._attributeToEdit.getExpression());
        this.text.setColumns(columns);
        this.text.setRows(rows);
        this.setModified(false);
    }

    public void adjustFileMenu() {
        this._fileMenuItems[3].setText("Apply");
        this._fileMenuItems[3].setMnemonic(65);
        this._fileMenu.remove(7);
        this._fileMenu.remove(5);
        this._fileMenu.remove(4);
        this._fileMenu.remove(2);
        this._fileMenu.remove(1);
        this._fileMenu.remove(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean _close() {
        boolean returnValue = true;
        if (this.isModified()) {
            if (!this._queryForApply()) return false;
            this.dispose();
        } else {
            this.dispose();
        }
        this._factory.clear();
        return returnValue;
    }

    protected boolean _save() {
        NamedObj context = this._attributeToEdit.getContainer();
        String request = "<property name=\"" + this._attributeToEdit.getName() + "\" value=\"" + StringUtilities.escapeForXML((String)this._factory.getText()) + "\"/>";
        context.requestChange((ChangeRequest)new MoMLChangeRequest((Object)this, context, request));
        this.setModified(false);
        return true;
    }

    private boolean _queryForApply() {
        Object[] options = new Object[]{"Apply", "Discard changes", "Cancel"};
        String query = "Apply changes to " + this._attributeToEdit.getFullName() + "?";
        int selected = JOptionPane.showOptionDialog(this, query, "Apply Changes?", 1, 3, null, options, options[0]);
        if (selected == 0) {
            return this._save();
        }
        return selected == 1;
    }
}

