/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import ptolemy.kernel.util.NamedObj;
import ptolemy.vergil.kernel.VergilUtilities;

public class PtolemyTransferable
implements Transferable,
Serializable {
    public static final DataFlavor namedObjFlavor = VergilUtilities.macOSLookAndFeel() ? new DataFlavor("application/x-java-jvm-local-objectref;class=ptolemy.kernel.util.NamedObj", "Named Object") : new DataFlavor("application/x-java-jvm-local-objectrefptolemy.kernel.util.NamedObj", "Named Object");
    private final DataFlavor[] _flavors = new DataFlavor[]{DataFlavor.plainTextFlavor, DataFlavor.stringFlavor, namedObjFlavor};
    private List _objectList = new LinkedList();

    public void addObject(NamedObj object) {
        if (!this._objectList.contains(object)) {
            this._objectList.add(object);
        }
    }

    public synchronized DataFlavor[] getTransferDataFlavors() {
        return this._flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        int i = 0;
        while (i < this._flavors.length) {
            if (this._flavors[i].equals(flavor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(DataFlavor.plainTextFlavor)) {
            return new StringReader(this._getMoML());
        }
        if (flavor.equals(namedObjFlavor)) {
            return this._objectList.iterator();
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this._getMoML();
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public void removeObject(NamedObj object) {
        if (this._objectList.contains(object)) {
            this._objectList.remove(object);
        }
    }

    public String _getMoML() throws IOException {
        StringWriter buffer = new StringWriter();
        buffer.write("<group>\n");
        for (NamedObj element : Collections.unmodifiableList(this._objectList)) {
            element.exportMoML((Writer)buffer, 1);
        }
        buffer.write("</group>\n");
        return buffer.toString();
    }
}

