/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.vergil.toolbox;

import diva.canvas.AbstractSite;
import diva.canvas.Figure;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import ptolemy.kernel.Port;

public class PortSite
extends AbstractSite {
    private int _count;
    private int _direction;
    private double _normal;
    private int _number;
    private Figure _parentFigure;
    private double _snap = 10.0;

    public PortSite(Figure figure, Port port, int number, int count, int direction) {
        this._parentFigure = figure;
        this._number = number;
        this._count = count;
        this._direction = direction;
        this._normal = this._getNormal();
    }

    public Figure getFigure() {
        return this._parentFigure;
    }

    public int getID() {
        return this._number;
    }

    public double getNormal() {
        return this._normal;
    }

    public double getX() {
        boolean skipOne;
        Rectangle bounds = this._parentFigure.getShape().getBounds();
        if (this._direction == 7) {
            return ((RectangularShape)bounds).getX();
        }
        if (this._direction == 3) {
            return ((RectangularShape)bounds).getX() + ((RectangularShape)bounds).getWidth();
        }
        double offset = ((RectangularShape)bounds).getWidth() / 2.0 - (double)(this._count / 2) * this._snap;
        boolean bl = skipOne = this._count / 2 * 2 == this._count;
        if (skipOne && this._number >= this._count / 2) {
            offset += this._snap;
        }
        return ((RectangularShape)bounds).getX() + this._snap * (double)this._number + offset;
    }

    public double getY() {
        boolean skipOne;
        Rectangle bounds = this._parentFigure.getShape().getBounds();
        if (this._direction == 5) {
            return ((RectangularShape)bounds).getY() + ((RectangularShape)bounds).getHeight();
        }
        if (this._direction == 1) {
            return ((RectangularShape)bounds).getY();
        }
        double offset = ((RectangularShape)bounds).getHeight() / 2.0 - (double)(this._count / 2) * this._snap;
        boolean bl = skipOne = this._count / 2 * 2 == this._count;
        if (offset < 0.0) {
            offset = 0.0;
            skipOne = false;
        }
        if (skipOne && this._number >= this._count / 2) {
            offset += this._snap;
        }
        return ((RectangularShape)bounds).getY() + this._snap * (double)this._number + offset;
    }

    public String toString() {
        return "BoundsSite[" + this.getX() + "," + this.getY() + "," + this.getNormal() + "]";
    }

    private double _getNormal() {
        if (this._direction == 1) {
            return -1.5707963267948966;
        }
        if (this._direction == 3) {
            return 0.0;
        }
        if (this._direction == 7) {
            return Math.PI;
        }
        return 1.5707963267948966;
    }
}

